# mandolin-python-client
Micro-service to analyze and convert files

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.2
- Package version: 1.0.2
- Build date: 2025-05-15T14:02:06.717172+02:00[Europe/Paris]
- Generator version: 7.11.0
- Build package: `org.openapitools.codegen.languages.PythonClientCodegen`

For more information, please visit [https://pts-project.org/](https://pts-project.org/)

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

The python package is hosted on [PyPi](https://pypi.org/project/mandolin-python-client/), you can install directly using:

```sh
pip install mandolin-python-client
```

Then import the package:
```python
import mandolin_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import mandolin_python_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import mandolin_python_client
from mandolin_python_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = mandolin_python_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with mandolin_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = mandolin_python_client.AnalyzersApi(api_client)
    file = None # bytearray | 

    try:
        # Analyze With Tika
        api_response = api_instance.analyze_with_tika_analyzer_tika_post(file)
        print("The response of AnalyzersApi->analyze_with_tika_analyzer_tika_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AnalyzersApi->analyze_with_tika_analyzer_tika_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnalyzersApi* | [**analyze_with_tika_analyzer_tika_post**](docs/AnalyzersApi.md#analyze_with_tika_analyzer_tika_post) | **POST** /analyzer/tika | Analyze With Tika
*AnalyzersApi* | [**analyze_with_yara_analyzer_yara_post**](docs/AnalyzersApi.md#analyze_with_yara_analyzer_yara_post) | **POST** /analyzer/yara | Analyze With Yara
*ConvertersApi* | [**generate_thumbnail_converter_thumbnail_post**](docs/ConvertersApi.md#generate_thumbnail_converter_thumbnail_post) | **POST** /converter/thumbnail | Generate Thumbnail
*DefaultApi* | [**root_get**](docs/DefaultApi.md#root_get) | **GET** / | Root


## Documentation For Models

 - [AnalysisTikaResult](docs/AnalysisTikaResult.md)
 - [AnalysisYaraResult](docs/AnalysisYaraResult.md)
 - [AnalyzerResultTikaResult](docs/AnalyzerResultTikaResult.md)
 - [AnalyzerResultYaraResult](docs/AnalyzerResultYaraResult.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [ThumbnailStrategy](docs/ThumbnailStrategy.md)
 - [TikaResult](docs/TikaResult.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [YaraMatch](docs/YaraMatch.md)
 - [YaraResult](docs/YaraResult.md)
 - [YaraString](docs/YaraString.md)
 - [YaraStringInstance](docs/YaraStringInstance.md)


