# Findings & Decisions
<!--
  WHAT: Your knowledge base for the task. Stores everything you discover.
  WHY: Context windows are limited. This file is your "external memory."
  WHEN: Update after ANY discovery, especially from research-agent output.
-->

## Requirements
<!--
  WHAT: What needs to be built, broken into specific requirements.
  WHY: Keeps requirements visible so you don't forget what you're building.
  WHEN: Fill this in during research phase.
-->
-

## Research Findings
<!--
  WHAT: Key discoveries from codebase exploration, web searches, documentation.
  WHY: Preserves knowledge that might be lost when context resets.
  WHEN: Update after research-agent returns, or after exploring code.
-->
-

## Technical Decisions
<!--
  WHAT: Architecture and implementation choices with reasoning.
  WHY: You'll forget why you chose an approach. This table preserves that.
  EXAMPLE:
    | Use existing auth library | Reduces complexity, tested code |
-->
| Decision | Rationale |
|----------|-----------|
|          |           |

## Key Files
<!--
  WHAT: Important files discovered during research.
  WHY: Quick reference for relevant code locations.
  EXAMPLE:
    - src/auth/jwt.ts: Token generation logic
    - src/middleware/auth.ts: Request validation
-->
-

## Issues Encountered
<!--
  WHAT: Problems encountered and how they were solved.
  WHY: Helps avoid repeating same mistakes.
-->
| Issue | Resolution |
|-------|------------|
|       |            |

## Resources
<!--
  WHAT: URLs, file paths, API references found useful.
  WHY: Easy reference for later.
-->
-

---
*Update after research-agent output or codebase exploration*
