# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['maplerad_python']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.31.0,<3.0.0']

setup_kwargs = {
    'name': 'maplerad-python',
    'version': '0.0.3',
    'description': 'Maplerad python API wrapper',
    'long_description': '# The Maplerad Python API Wrapper\n\nThe library follows an object-oriented approach\n\nThere are currently twelve (12) base categories namely:\n\n- Customer\n- Collections\n- Transfer\n- Bills\n- Wallets\n- Issuing\n- Identity\n- Transactions\n- Counterparty\n- Forex\n- Institutions\n- Misc\n\n#### Learn more from the [docs](https://maplerad.dev/reference)\n\n# Installation\n\n```shell\n $  pip install maplerad-python\n\n```\n\n# Authorization\n\nA secret key is needed for authorization. It can be gotten from the Maplerad dashboard\n\n# Environments\n\nMaplerad provides two environments to ensure a smooth and easy experience.\n\n- sandbox: for development\n- live: for production\n\n## Sandbox\n\nSandbox is your playground. You can credit your test wallets and use that to test your integrations, no real money will be debited or credited.\nEnsure to switch to Live when you are ready to launch.\n\n## Live\n\nAll method calls under Live will be charged and real money will be debited or credited.\nYou are advised to use this when you have fully tested your integrations and are ready to launch your product.\n\n# Usage\n\n```py\n# import the package\nfrom maplerad_python.auth import Authentication\n\n\nsecret_key = os.getenv("MAPLERAD_SECRET_KEY")\nenvironment = "DEVELOPMENT"\n\nauth = Authenticate(secret_key,environment)\n```\n\n## Customers\n\n```py\n\ncustomer = auth.customers()\n\n```\n\n### Create a Customer\n\n```py\npayload = {\n        "email": user.email,\n        "first_name": user.first_name,\n        "last_name": user.last_name,\n        "country": country_type\n        }\n\nresult = customer.create_customer(payload)\n\n\n```\n\n### Upgrade Customer tier 1\n\n```py\npayload = {\n                    "customer_id": customer_id,\n                    "phone": {\n                        "phone_number": phone_number,\n                        "phone_short_code": phone_short_code\n                    },\n                    "address": {\n                        "city": address.city,\n                        "country": address.country,\n                        "postal_code": address.postal_code,\n                        "state": address.state,\n                        "street": address.street,\n                        "street2": address.street2\n                    },\n                    "dob": dob,\n                    "identification_number": identification_number\n                }\n\nresult = customer.upgrade_customer_tier1(payload)\n\n\n\n```\n\n### Upgrade customer tier2\n\n```py\npayload = {\n                "customer_id": customer_id,\n                "identity": {\n                    "country": identity.country,\n                    "image": identity.image,\n                    "number": identity.number,\n                    "type": identity.type\n                }\n            }\n\nresult = customer.upgrade_customer_tier2(payload)\n\n\n```\n\n### Get a customer\n\n```py\nresult = customer.get_customer(customer_id)\n\n\n```\n\n### Get all Customers\n\n```py\nresult = customer.get_all_customers()\n\n```\n\n### Get customer cards\n\n```py\n\nresult = customer.get_customer_cards(customer_id)\n\n\n```\n\n### Get customer transactions\n\n```py\n\n\nresult = customer.get_customer_transactions(customer_id)\n\n\n```\n\n### Get customer virtual accounts\n\n```py\nresult = customer.get_customer_virtual_accounts(customer_id)\n\n```\n\n### Customer Card enrollment\n\n```py\n\nresult = customer.customer_card_enrollment(customer_id, brand)\n\n```\n\n### Update Customer\n\n```py\n\npayload = {\n                "customer_id": customer_id,\n                "photo": photo,\n                "phone": {\n                    "phone_number": phone.phone_number,\n                    "phone_country_code": phone.phone_country_code\n                },\n                "middle_name": middle_name,\n                "identity": {\n                    "country": identity.country,\n                    "image": identity.image,\n                    "number": identity.number,\n                    "type": identity.type\n                }\n            }\n\nresult = customer.update_customer(payload)\n\n```\n\n### Set customer Blacklist status\n\n<!-- <p>status can be True to blacklist the customer of False to remove the customer from blacklist</p> -->\n\n```py\n\nresult = customer.set_customer_blacklist_active(customer_id, status)\n\n```\n\n## Bills\n\n```py\n\nbills = auth.bills()\n\n```\n\n### Buy Airtime\n\n```py\n\npayload = {\n                "phone_number": phone_number,\n                "identifier": identifier,\n                "amount": amount\n            }\nresult = bills.buy_airtime(payload)\n\n```\n\n### Get airtime billers\n\n```py\n\nresult = bills.get_airtime_billers(country)\n\n\n```\n\n### Get airtime history\n\n```py\n\nresult = bills.get_airtime_history()\n\n\n\n```\n\n## Collections\n\n```py\ncollections = auth.collections()\n\n\n```\n\n### Create Virtual account\n\n```py\n\npayload = {\n                "customer_id": customer_id,\n                "currency": currency_type,\n                "preferred_bank": preferred_bank,\n                "deposit_account_id": deposit_account_id,\n                "meta": {\n                    "occupation": occupation,\n                    "utility_bill": utility_bill_url_or_file,\n                    "bank_statement": bank_statement_url_or_file,\n                    "identity_type": identity_type,\n                    "identity_image": identity_image_url_or_file,\n                    "identity_number": identity_number,\n                    "identity_issued_date": identity_issued_date,\n                    "identity_expiration": identity_expiration\n                }\n            }\n\nresult = collections.create_virtual_account(payload)\n\n\n\n```\n\n## Counterparty\n\n```py\ncounterparty = auth.counterparty()\n\n```\n\n### Blacklist a counterparty\n\n```py\nresult = counterparty.blacklist(counterpartyID, status)\n\n```\n\n### Get counterparty\n\n```py\nresult = counterparty.get_counterparty(counterpartyID)\n\n```\n\n### Get all counterparties\n\n```py\n\nresult = counterparty.get_all_counterparties()\n\n```\n\n## FX\n\n```py\nfx = auth.fx()\n\n```\n\n### Generate quote\n\n```py\npayload = {\n    "source_currency": "NGN",\n    "target_currency": "USD",\n    "amount": "500",\n}\nresult = fx.generate_quote(payload)\n\n\n```\n\n### Exchange currency\n\n```py\n\nresult = fx.exchange_currency(quote_reference)\n\n```\n\n### Get FX history\n\n```py\n\nresult = fx.get_fx_history()\n\n```\n\n## IDentity\n\n```py\nidentity = auth.identity()\n\n\n```\n\n### Verify Identity\n\n```py\n\nresult = identity.verify_identity(bvn)\n\n```\n\n## Institution\n\n```py\ninstitution = auth.institution()\n\n```\n\n### Get all institutions\n\n```py\nparams = {\n                "page": "1",\n                "pageSize": "10",\n                "type": "bank",\n                "country": "US"\n            }\nresult = institution.get_all_institutions(params)\n\n```\n\n### Resolve institution\n\n```py\n\npayload = {\n                "account_number": "1234567890",\n                "bank_code": "ABC123"\n            }\nresult = institution.resolve_institution(payload)\n\n```\n\n### Issuing\n\n```py\nissuing = auth.issuing()\n```\n\n### Create a Card\n\n```py\npayload = {\n    "customer_id": "123456789",\n    "type": "VIRTUAL",\n    "currency": "USD",\n    "auto_approve": True,\n    "brand": "VISA",\n    "amount": 1000,\n    "card_pin": 1234\n    }\nresult = issuing.create_card(payload)\n\n\n\n```\n\n### Create business card\n\n```py\npayload = {\n                "customer_id": "123456789",\n                "type": CardType.PHYSICAL.value,\n                "currency": "USD",\n                "auto_approve": True,\n                "brand": "MASTERCARD",\n                "amount": 2000,\n                "card_pin": 5678,\n                "name": "Business Card"\n            }\nresult = issuing.create_business_card(payload)\n\n```\n\n### Set Card pin\n\n```py\n\nresult = issuing.set_card_pin(cardID, pin)\n\n```\n\n### Get Card\n\n```py\n\nresult = issuing.get_card(cardID)\n```\n\n### Get all Cards\n\n```py\n\nresult = issuing.get_all_cards()\n\n```\n\n### Get card transactions\n\n```py\n\nparams = {\n                "page": "1",\n                "pageSize": "10",\n                "type": "purchase",\n                "status": "success"\n            }\nresult = issuing.get_card_transactions(cardID, params)\n\n\n```\n\n### Fund Card\n\n```py\namount = 1000\nresult = issuing.fund_card(cardID, amount)\n\n```\n\n### Withdraw from card\n\n```py\n\nresult = issuing.withdraw_from_card(cardID, amount)\n```\n\n### Freeze card\n\n```py\n\nresult = issuing.freeze_card(cardID)\n```\n\n### Unfreeze card\n\n```py\nresult = issuing.unfreeze_card(cardID)\n\n```\n\n## Misc\n\n```py\n\nmisc = auth.misc()\n```\n\n### Get currencies\n\n```py\n\nresult = misc.get_currencies()\n\n```\n\n### Get countries\n\n```py\nresult = misc.get_countries()\n\n```\n\n### Credit test wallet\n\n```py\npayload = {\n                "amount": "100",\n                "currency": "USD"\n            }\nresult = misc.credit_test_wallet(payload)\n\n```\n\n## Transactions\n\n```py\ntransactions = auth.transactions()\n\n\n```\n\n### Get all transactions\n\n```py\nresult = transactions.get_all_transactions()\n\n```\n\n### Get a transaction\n\n```py\nresult = transactions.get_transaction("transaction_id")\n\n```\n\n### Verify a collection transaction\n\n```py\n\nresult = transactions.verify_collection_transaction("transaction_id")\n\n\n```\n\n## Transfers\n\n```py\ntransfers = auth.transfer()\n\n```\n\n### Naira transfer\n\n```py\npayload = {\n    "account_number": "string",\n    "amount": 45454545,\n    "bank_code": "string",\n    "currency": "NGN",\n}\nresult = transfers.naira_transfer(payload)\n```\n\n### DOM transfer\n\n```py\npayload= {\n    "account_number": "1234567890",\n    "amount": 1000.0,\n    "bank_code": "ABC",\n    "currency": "USD",\n    "meta": {\n        "scheme": "DOM",\n        "sender": {\n            "first_name": "John",\n            "last_name": "Doe",\n            "phone_number": "1234567890",\n            "address": "123 Main Street",\n            "country": "USA"\n        },\n        "counterparty": {\n            "first_name": "Jane",\n            "last_name": "Smith",\n            "phone_number": "9876543210",\n            "address": "456 Elm Street",\n            "country": "Canada",\n            "identity": "12345"\n        }\n    },\n    "reason": "Payment",\n    "reference": "ABC123"\n}\nresult = transfers.dom_transfer(payload)\n\n\n```\n\n### Cash Pickup\n\n```py\npayload = {\n    "account_number": "1234567890",\n    "amount": 1000.0,\n    "bank_code": "ABC",\n    "currency": "USD",\n    "meta": {\n        "scheme": "CASHPICKUP",\n        "sender": {\n            "first_name": "John",\n            "last_name": "Doe",\n            "phone_number": "1234567890",\n            "address": "123 Main Street",\n            "country": "USA"\n        },\n        "counterparty": {\n            "first_name": "Jane",\n            "last_name": "Smith",\n            "phone_number": "9876543210",\n            "address": "456 Elm Street",\n            "country": "Canada",\n            "identity": "12345"\n        }\n    },\n    "reason": "Payment",\n    "reference": "ABC123"\n}\nresult = transfers.cash_pickup_transfer(payload)\n\n```\n\n### Get a transfer\n\n```py\n\nresult = transfers.get_transfer("transfer_id")\n\n```\n\n### Get all transfers\n\n```py\nresult = transfers.get_all_transfers()\n\n```\n\n## Wallet\n\n```py\nwallets = auth.wallet()\n\n```\n\n### Get wallets\n\n```py\nresult = wallets.get_wallets()\n\n```\n\n### Get wallet history\n\n```py\n\nresult = wallets.get_wallets_history()\n\n```\n\n### Get wallet history by currency\n\n```py\nresult = wallets.get_wallets_history_by_currency("USD")\n\n```\n\n# Contact Developer\n<p>Twitter: <a href="https://twitter.com/1madvirus"> 1madvirus </a> </p>\n<p>LinkedIN: <a href="https://linkedin.com/in/madvirus"> Edwin Beshel Ayabie </a> </p>\n<p>Email: <a href="mailto:edwinayabie1@gmail.com"> edwinayabie1@gmail.com </p>\n',
    'author': 'madvirus-ops',
    'author_email': 'edwinayabie1@gmail.com',
    'maintainer': 'madvirus-ops',
    'maintainer_email': 'edwinayabie1@gmail.com',
    'url': 'https://maplerad.com',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
