# coding: utf-8

"""
    Marquez

    Marquez is an open source **metadata service** for the **collection**, **aggregation**, and **visualization** of a data ecosystem's metadata.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from marquez_client.api_client import ApiClient


class DatasetsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def namespaces_namespace_datasets_get(self, namespace, **kwargs):  # noqa: E501
        """List all datasets  # noqa: E501

        Returns a list of datasets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_datasets_get(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :return: Datasets
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.namespaces_namespace_datasets_get_with_http_info(namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.namespaces_namespace_datasets_get_with_http_info(namespace, **kwargs)  # noqa: E501
            return data

    def namespaces_namespace_datasets_get_with_http_info(self, namespace, **kwargs):  # noqa: E501
        """List all datasets  # noqa: E501

        Returns a list of datasets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_datasets_get_with_http_info(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :return: Datasets
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method namespaces_namespace_datasets_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in local_var_params or
                local_var_params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `namespaces_namespace_datasets_get`")  # noqa: E501

        if ('namespace' in local_var_params and
                len(local_var_params['namespace']) > 1024):
            raise ValueError("Invalid value for parameter `namespace` when calling `namespaces_namespace_datasets_get`, length must be less than or equal to `1024`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'namespace' in local_var_params:
            path_params['namespace'] = local_var_params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/datasets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Datasets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
