# coding: utf-8

"""
    Marquez

    Marquez is an open source **metadata service** for the **collection**, **aggregation**, and **visualization** of a data ecosystem's metadata.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ICEBERG(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'Enum',
        'snapshot_id': 'int',
        'location': 'str',
        'description': 'str'
    }

    attribute_map = {
        'type': 'type',
        'snapshot_id': 'snapshotId',
        'location': 'location',
        'description': 'description'
    }

    def __init__(self, type=None, snapshot_id=None, location=None, description=None):  # noqa: E501
        """ICEBERG - a model defined in OpenAPI"""  # noqa: E501

        self._type = None
        self._snapshot_id = None
        self._location = None
        self._description = None
        self.discriminator = None

        self.type = type
        self.snapshot_id = snapshot_id
        self.location = location
        if description is not None:
            self.description = description

    @property
    def type(self):
        """Gets the type of this ICEBERG.  # noqa: E501

        The output dataset type.  # noqa: E501

        :return: The type of this ICEBERG.  # noqa: E501
        :rtype: Enum
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ICEBERG.

        The output dataset type.  # noqa: E501

        :param type: The type of this ICEBERG.  # noqa: E501
        :type: Enum
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def snapshot_id(self):
        """Gets the snapshot_id of this ICEBERG.  # noqa: E501

        The unique ID of the snapshot representing a list of files on the file system.  # noqa: E501

        :return: The snapshot_id of this ICEBERG.  # noqa: E501
        :rtype: int
        """
        return self._snapshot_id

    @snapshot_id.setter
    def snapshot_id(self, snapshot_id):
        """Sets the snapshot_id of this ICEBERG.

        The unique ID of the snapshot representing a list of files on the file system.  # noqa: E501

        :param snapshot_id: The snapshot_id of this ICEBERG.  # noqa: E501
        :type: int
        """
        if snapshot_id is None:
            raise ValueError("Invalid value for `snapshot_id`, must not be `None`")  # noqa: E501

        self._snapshot_id = snapshot_id

    @property
    def location(self):
        """Gets the location of this ICEBERG.  # noqa: E501

        The location on the file system where data files, manifest files, and table metadata files are stored.  # noqa: E501

        :return: The location of this ICEBERG.  # noqa: E501
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this ICEBERG.

        The location on the file system where data files, manifest files, and table metadata files are stored.  # noqa: E501

        :param location: The location of this ICEBERG.  # noqa: E501
        :type: str
        """
        if location is None:
            raise ValueError("Invalid value for `location`, must not be `None`")  # noqa: E501

        self._location = location

    @property
    def description(self):
        """Gets the description of this ICEBERG.  # noqa: E501

        The description of the output dataset.  # noqa: E501

        :return: The description of this ICEBERG.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ICEBERG.

        The description of the output dataset.  # noqa: E501

        :param description: The description of this ICEBERG.  # noqa: E501
        :type: str
        """

        self._description = description

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ICEBERG):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
