# coding: utf-8

"""
    Marquez

    Marquez is an open source **metadata service** for the **collection**, **aggregation**, and **visualization** of a data ecosystem's metadata.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from marquez_client.api_client import ApiClient


class JobsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def jobs_runs_id_abort_put(self, id, **kwargs):  # noqa: E501
        """Abort a job run  # noqa: E501

        Marks the job run as aborted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_abort_put(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.jobs_runs_id_abort_put_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.jobs_runs_id_abort_put_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def jobs_runs_id_abort_put_with_http_info(self, id, **kwargs):  # noqa: E501
        """Abort a job run  # noqa: E501

        Marks the job run as aborted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_abort_put_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_id_abort_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `jobs_runs_id_abort_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/jobs/runs/{id}/abort', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def jobs_runs_id_complete_put(self, id, **kwargs):  # noqa: E501
        """Complete a job run  # noqa: E501

        Marks the job run as completed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_complete_put(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.jobs_runs_id_complete_put_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.jobs_runs_id_complete_put_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def jobs_runs_id_complete_put_with_http_info(self, id, **kwargs):  # noqa: E501
        """Complete a job run  # noqa: E501

        Marks the job run as completed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_complete_put_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_id_complete_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `jobs_runs_id_complete_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/jobs/runs/{id}/complete', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def jobs_runs_id_fail_put(self, id, **kwargs):  # noqa: E501
        """Fail a job run  # noqa: E501

        Marks the job run as failed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_fail_put(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.jobs_runs_id_fail_put_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.jobs_runs_id_fail_put_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def jobs_runs_id_fail_put_with_http_info(self, id, **kwargs):  # noqa: E501
        """Fail a job run  # noqa: E501

        Marks the job run as failed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_fail_put_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_id_fail_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `jobs_runs_id_fail_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/jobs/runs/{id}/fail', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def jobs_runs_id_get(self, id, **kwargs):  # noqa: E501
        """Retrieve a job run  # noqa: E501

        Retrieve a job run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :return: JobRun
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.jobs_runs_id_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.jobs_runs_id_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def jobs_runs_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Retrieve a job run  # noqa: E501

        Retrieve a job run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :return: JobRun
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `jobs_runs_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/jobs/runs/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobRun',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def jobs_runs_id_outputs_get(self, id, **kwargs):  # noqa: E501
        """List all job run outputs  # noqa: E501

        Returns a list job run outputs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_outputs_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :return: Datasets
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.jobs_runs_id_outputs_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.jobs_runs_id_outputs_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def jobs_runs_id_outputs_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """List all job run outputs  # noqa: E501

        Returns a list job run outputs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_outputs_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :return: Datasets
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_id_outputs_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `jobs_runs_id_outputs_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/jobs/runs/{id}/outputs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Datasets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def jobs_runs_id_outputs_put(self, id, **kwargs):  # noqa: E501
        """Create multiple output datasets  # noqa: E501

        Creates a multiple output dataset objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_outputs_put(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :param JobRunOutputs job_run_outputs:
        :return: Datasets
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.jobs_runs_id_outputs_put_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.jobs_runs_id_outputs_put_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def jobs_runs_id_outputs_put_with_http_info(self, id, **kwargs):  # noqa: E501
        """Create multiple output datasets  # noqa: E501

        Creates a multiple output dataset objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_outputs_put_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :param JobRunOutputs job_run_outputs:
        :return: Datasets
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'job_run_outputs']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_id_outputs_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `jobs_runs_id_outputs_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'job_run_outputs' in local_var_params:
            body_params = local_var_params['job_run_outputs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/jobs/runs/{id}/outputs', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Datasets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def jobs_runs_id_run_put(self, id, **kwargs):  # noqa: E501
        """Start a job run  # noqa: E501

        Marks the job run as running.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_run_put(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.jobs_runs_id_run_put_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.jobs_runs_id_run_put_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def jobs_runs_id_run_put_with_http_info(self, id, **kwargs):  # noqa: E501
        """Start a job run  # noqa: E501

        Marks the job run as running.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jobs_runs_id_run_put_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The unique ID of the job run. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_id_run_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `jobs_runs_id_run_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/jobs/runs/{id}/run', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def namespaces_namespace_jobs_get(self, namespace, **kwargs):  # noqa: E501
        """List all jobs  # noqa: E501

        Returns a list of jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_jobs_get(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :return: Jobs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.namespaces_namespace_jobs_get_with_http_info(namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.namespaces_namespace_jobs_get_with_http_info(namespace, **kwargs)  # noqa: E501
            return data

    def namespaces_namespace_jobs_get_with_http_info(self, namespace, **kwargs):  # noqa: E501
        """List all jobs  # noqa: E501

        Returns a list of jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_jobs_get_with_http_info(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :return: Jobs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method namespaces_namespace_jobs_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in local_var_params or
                local_var_params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `namespaces_namespace_jobs_get`")  # noqa: E501

        if ('namespace' in local_var_params and
                len(local_var_params['namespace']) > 1024):
            raise ValueError("Invalid value for parameter `namespace` when calling `namespaces_namespace_jobs_get`, length must be less than or equal to `1024`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'namespace' in local_var_params:
            path_params['namespace'] = local_var_params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Jobs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def namespaces_namespace_jobs_job_get(self, namespace, job, **kwargs):  # noqa: E501
        """Retrieve a job  # noqa: E501

        Retrieve a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_jobs_job_get(namespace, job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :param str job: The name of the job. (required)
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.namespaces_namespace_jobs_job_get_with_http_info(namespace, job, **kwargs)  # noqa: E501
        else:
            (data) = self.namespaces_namespace_jobs_job_get_with_http_info(namespace, job, **kwargs)  # noqa: E501
            return data

    def namespaces_namespace_jobs_job_get_with_http_info(self, namespace, job, **kwargs):  # noqa: E501
        """Retrieve a job  # noqa: E501

        Retrieve a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_jobs_job_get_with_http_info(namespace, job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :param str job: The name of the job. (required)
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['namespace', 'job']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method namespaces_namespace_jobs_job_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in local_var_params or
                local_var_params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `namespaces_namespace_jobs_job_get`")  # noqa: E501
        # verify the required parameter 'job' is set
        if ('job' not in local_var_params or
                local_var_params['job'] is None):
            raise ValueError("Missing the required parameter `job` when calling `namespaces_namespace_jobs_job_get`")  # noqa: E501

        if ('namespace' in local_var_params and
                len(local_var_params['namespace']) > 1024):
            raise ValueError("Invalid value for parameter `namespace` when calling `namespaces_namespace_jobs_job_get`, length must be less than or equal to `1024`")  # noqa: E501
        if ('job' in local_var_params and
                len(local_var_params['job']) > 1024):
            raise ValueError("Invalid value for parameter `job` when calling `namespaces_namespace_jobs_job_get`, length must be less than or equal to `1024`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'namespace' in local_var_params:
            path_params['namespace'] = local_var_params['namespace']  # noqa: E501
        if 'job' in local_var_params:
            path_params['job'] = local_var_params['job']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/jobs/{job}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def namespaces_namespace_jobs_job_put(self, namespace, job, **kwargs):  # noqa: E501
        """Create a job  # noqa: E501

        Creates a new job object. All job objects are immutable and are uniquely identified by a generated ID. Marquez will create a version of a job each time the contents of the object is modified. For example, the `location` of a job may change over time resulting in new versions. The accumulated versions can be listed, used to rerun a specific job version or possibly help debug a failed job run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_jobs_job_put(namespace, job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :param str job: The name of the job. (required)
        :param CreateJob create_job:
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.namespaces_namespace_jobs_job_put_with_http_info(namespace, job, **kwargs)  # noqa: E501
        else:
            (data) = self.namespaces_namespace_jobs_job_put_with_http_info(namespace, job, **kwargs)  # noqa: E501
            return data

    def namespaces_namespace_jobs_job_put_with_http_info(self, namespace, job, **kwargs):  # noqa: E501
        """Create a job  # noqa: E501

        Creates a new job object. All job objects are immutable and are uniquely identified by a generated ID. Marquez will create a version of a job each time the contents of the object is modified. For example, the `location` of a job may change over time resulting in new versions. The accumulated versions can be listed, used to rerun a specific job version or possibly help debug a failed job run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_jobs_job_put_with_http_info(namespace, job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :param str job: The name of the job. (required)
        :param CreateJob create_job:
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['namespace', 'job', 'create_job']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method namespaces_namespace_jobs_job_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in local_var_params or
                local_var_params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `namespaces_namespace_jobs_job_put`")  # noqa: E501
        # verify the required parameter 'job' is set
        if ('job' not in local_var_params or
                local_var_params['job'] is None):
            raise ValueError("Missing the required parameter `job` when calling `namespaces_namespace_jobs_job_put`")  # noqa: E501

        if ('namespace' in local_var_params and
                len(local_var_params['namespace']) > 1024):
            raise ValueError("Invalid value for parameter `namespace` when calling `namespaces_namespace_jobs_job_put`, length must be less than or equal to `1024`")  # noqa: E501
        if ('job' in local_var_params and
                len(local_var_params['job']) > 1024):
            raise ValueError("Invalid value for parameter `job` when calling `namespaces_namespace_jobs_job_put`, length must be less than or equal to `1024`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'namespace' in local_var_params:
            path_params['namespace'] = local_var_params['namespace']  # noqa: E501
        if 'job' in local_var_params:
            path_params['job'] = local_var_params['job']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_job' in local_var_params:
            body_params = local_var_params['create_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/jobs/{job}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def namespaces_namespace_jobs_job_runs_get(self, namespace, job, **kwargs):  # noqa: E501
        """List all job runs  # noqa: E501

        Returns a list of job runs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_jobs_job_runs_get(namespace, job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :param str job: The name of the job. (required)
        :return: JobRuns
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.namespaces_namespace_jobs_job_runs_get_with_http_info(namespace, job, **kwargs)  # noqa: E501
        else:
            (data) = self.namespaces_namespace_jobs_job_runs_get_with_http_info(namespace, job, **kwargs)  # noqa: E501
            return data

    def namespaces_namespace_jobs_job_runs_get_with_http_info(self, namespace, job, **kwargs):  # noqa: E501
        """List all job runs  # noqa: E501

        Returns a list of job runs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_jobs_job_runs_get_with_http_info(namespace, job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :param str job: The name of the job. (required)
        :return: JobRuns
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['namespace', 'job']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method namespaces_namespace_jobs_job_runs_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in local_var_params or
                local_var_params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `namespaces_namespace_jobs_job_runs_get`")  # noqa: E501
        # verify the required parameter 'job' is set
        if ('job' not in local_var_params or
                local_var_params['job'] is None):
            raise ValueError("Missing the required parameter `job` when calling `namespaces_namespace_jobs_job_runs_get`")  # noqa: E501

        if ('namespace' in local_var_params and
                len(local_var_params['namespace']) > 1024):
            raise ValueError("Invalid value for parameter `namespace` when calling `namespaces_namespace_jobs_job_runs_get`, length must be less than or equal to `1024`")  # noqa: E501
        if ('job' in local_var_params and
                len(local_var_params['job']) > 1024):
            raise ValueError("Invalid value for parameter `job` when calling `namespaces_namespace_jobs_job_runs_get`, length must be less than or equal to `1024`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'namespace' in local_var_params:
            path_params['namespace'] = local_var_params['namespace']  # noqa: E501
        if 'job' in local_var_params:
            path_params['job'] = local_var_params['job']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/jobs/{job}/runs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobRuns',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def namespaces_namespace_jobs_job_runs_post(self, namespace, job, **kwargs):  # noqa: E501
        """Create a job run  # noqa: E501

        Creates a new job run object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_jobs_job_runs_post(namespace, job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :param str job: The name of the job. (required)
        :param CreateJobRun create_job_run:
        :return: JobRunId
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.namespaces_namespace_jobs_job_runs_post_with_http_info(namespace, job, **kwargs)  # noqa: E501
        else:
            (data) = self.namespaces_namespace_jobs_job_runs_post_with_http_info(namespace, job, **kwargs)  # noqa: E501
            return data

    def namespaces_namespace_jobs_job_runs_post_with_http_info(self, namespace, job, **kwargs):  # noqa: E501
        """Create a job run  # noqa: E501

        Creates a new job run object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_jobs_job_runs_post_with_http_info(namespace, job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :param str job: The name of the job. (required)
        :param CreateJobRun create_job_run:
        :return: JobRunId
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['namespace', 'job', 'create_job_run']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method namespaces_namespace_jobs_job_runs_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in local_var_params or
                local_var_params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `namespaces_namespace_jobs_job_runs_post`")  # noqa: E501
        # verify the required parameter 'job' is set
        if ('job' not in local_var_params or
                local_var_params['job'] is None):
            raise ValueError("Missing the required parameter `job` when calling `namespaces_namespace_jobs_job_runs_post`")  # noqa: E501

        if ('namespace' in local_var_params and
                len(local_var_params['namespace']) > 1024):
            raise ValueError("Invalid value for parameter `namespace` when calling `namespaces_namespace_jobs_job_runs_post`, length must be less than or equal to `1024`")  # noqa: E501
        if ('job' in local_var_params and
                len(local_var_params['job']) > 1024):
            raise ValueError("Invalid value for parameter `job` when calling `namespaces_namespace_jobs_job_runs_post`, length must be less than or equal to `1024`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'namespace' in local_var_params:
            path_params['namespace'] = local_var_params['namespace']  # noqa: E501
        if 'job' in local_var_params:
            path_params['job'] = local_var_params['job']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_job_run' in local_var_params:
            body_params = local_var_params['create_job_run']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/jobs/{job}/runs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobRunId',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def namespaces_namespace_jobs_job_versions_get(self, namespace, job, **kwargs):  # noqa: E501
        """List all job versions  # noqa: E501

        Returns a list of job versions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_jobs_job_versions_get(namespace, job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :param str job: The name of the job. (required)
        :return: JobVersions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.namespaces_namespace_jobs_job_versions_get_with_http_info(namespace, job, **kwargs)  # noqa: E501
        else:
            (data) = self.namespaces_namespace_jobs_job_versions_get_with_http_info(namespace, job, **kwargs)  # noqa: E501
            return data

    def namespaces_namespace_jobs_job_versions_get_with_http_info(self, namespace, job, **kwargs):  # noqa: E501
        """List all job versions  # noqa: E501

        Returns a list of job versions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.namespaces_namespace_jobs_job_versions_get_with_http_info(namespace, job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: The name of the namespace. (required)
        :param str job: The name of the job. (required)
        :return: JobVersions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['namespace', 'job']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method namespaces_namespace_jobs_job_versions_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in local_var_params or
                local_var_params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `namespaces_namespace_jobs_job_versions_get`")  # noqa: E501
        # verify the required parameter 'job' is set
        if ('job' not in local_var_params or
                local_var_params['job'] is None):
            raise ValueError("Missing the required parameter `job` when calling `namespaces_namespace_jobs_job_versions_get`")  # noqa: E501

        if ('namespace' in local_var_params and
                len(local_var_params['namespace']) > 1024):
            raise ValueError("Invalid value for parameter `namespace` when calling `namespaces_namespace_jobs_job_versions_get`, length must be less than or equal to `1024`")  # noqa: E501
        if ('job' in local_var_params and
                len(local_var_params['job']) > 1024):
            raise ValueError("Invalid value for parameter `job` when calling `namespaces_namespace_jobs_job_versions_get`, length must be less than or equal to `1024`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'namespace' in local_var_params:
            path_params['namespace'] = local_var_params['namespace']  # noqa: E501
        if 'job' in local_var_params:
            path_params['job'] = local_var_params['job']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/jobs/{job}/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobVersions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
