# coding: utf-8

"""
    Marquez

    Marquez is an open source **metadata service** for the **collection**, **aggregation**, and **visualization** of a data ecosystem's metadata.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class JobVersion(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'version': 'str',
        'created_at': 'datetime',
        'location': 'str'
    }

    attribute_map = {
        'version': 'version',
        'created_at': 'createdAt',
        'location': 'location'
    }

    def __init__(self, version=None, created_at=None, location=None):  # noqa: E501
        """JobVersion - a model defined in OpenAPI"""  # noqa: E501

        self._version = None
        self._created_at = None
        self._location = None
        self.discriminator = None

        if version is not None:
            self.version = version
        if created_at is not None:
            self.created_at = created_at
        if location is not None:
            self.location = location

    @property
    def version(self):
        """Gets the version of this JobVersion.  # noqa: E501

        The version of the job.  # noqa: E501

        :return: The version of this JobVersion.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this JobVersion.

        The version of the job.  # noqa: E501

        :param version: The version of this JobVersion.  # noqa: E501
        :type: str
        """

        self._version = version

    @property
    def created_at(self):
        """Gets the created_at of this JobVersion.  # noqa: E501

        An [ISO-8601](https://en.wikipedia.org/wiki/ISO_8601) timestamp representing the date/time the job version was created.  # noqa: E501

        :return: The created_at of this JobVersion.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this JobVersion.

        An [ISO-8601](https://en.wikipedia.org/wiki/ISO_8601) timestamp representing the date/time the job version was created.  # noqa: E501

        :param created_at: The created_at of this JobVersion.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def location(self):
        """Gets the location of this JobVersion.  # noqa: E501

        The URI of the job source or artifact.  # noqa: E501

        :return: The location of this JobVersion.  # noqa: E501
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this JobVersion.

        The URI of the job source or artifact.  # noqa: E501

        :param location: The location of this JobVersion.  # noqa: E501
        :type: str
        """

        self._location = location

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobVersion):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
