from collections.abc import Callable, Iterator
from typing import Any

from django.contrib.admin.options import ModelAdmin
from django.core.handlers.wsgi import WSGIRequest
from django.db.models.base import Model
from django.db.models.fields import Field
from django.db.models.fields.related import RelatedField
from django.db.models.query import QuerySet

class ListFilter:
    title: Any = ...
    template: str = ...
    used_parameters: Any = ...
    def __init__(
        self,
        request: WSGIRequest,
        params: dict[str, str],
        model: type[Model],
        model_admin: ModelAdmin[Any],
    ) -> None: ...
    def has_output(self) -> bool: ...
    def choices(self, changelist: Any) -> Iterator[dict[str, Any]] | None: ...
    def queryset(
        self, request: Any, queryset: QuerySet[Any]
    ) -> QuerySet[Any] | None: ...
    def expected_parameters(self) -> list[str] | None: ...

class SimpleListFilter(ListFilter):
    parameter_name: Any = ...
    lookup_choices: Any = ...
    def value(self) -> str | None: ...
    def lookups(self, request: Any, model_admin: Any) -> list[tuple[Any, str]]: ...

class FieldListFilter(ListFilter):
    field: Field[Any, Any] = ...
    field_path: Any = ...
    title: Any = ...
    def __init__(
        self,
        field: Field[Any, Any],
        request: WSGIRequest,
        params: dict[str, str],
        model: type[Model],
        model_admin: ModelAdmin[Any],
        field_path: str,
    ) -> None: ...
    @classmethod
    def register(
        cls,
        test: Callable[..., Any],
        list_filter_class: type[FieldListFilter],
        take_priority: bool = ...,
    ) -> None: ...
    @classmethod
    def create(
        cls,
        field: Field[Any, Any],
        request: WSGIRequest,
        params: dict[str, str],
        model: type[Model],
        model_admin: ModelAdmin[Any],
        field_path: str,
    ) -> FieldListFilter: ...

class RelatedFieldListFilter(FieldListFilter):
    used_parameters: dict[Any, Any]
    lookup_kwarg: str = ...
    lookup_kwarg_isnull: str = ...
    lookup_val: None = ...
    lookup_val_isnull: None = ...
    lookup_choices: Any = ...
    lookup_title: Any = ...
    title: str = ...
    empty_value_display: Any = ...
    @property
    def include_empty_choice(self) -> bool: ...
    def field_choices(
        self,
        field: RelatedField[Any, Any],
        request: WSGIRequest,
        model_admin: ModelAdmin[Any],
    ) -> list[tuple[str, str]]: ...

class BooleanFieldListFilter(FieldListFilter):
    lookup_kwarg: Any = ...
    lookup_kwarg2: Any = ...
    lookup_val: Any = ...
    lookup_val2: Any = ...
    def choices(self, changelist: Any) -> None: ...

class ChoicesFieldListFilter(FieldListFilter):
    title: str
    used_parameters: dict[Any, Any]
    lookup_kwarg: str = ...
    lookup_kwarg_isnull: str = ...
    lookup_val: None = ...
    lookup_val_isnull: None = ...

class DateFieldListFilter(FieldListFilter):
    field_generic: Any = ...
    date_params: Any = ...
    lookup_kwarg_since: Any = ...
    lookup_kwarg_until: Any = ...
    links: Any = ...
    lookup_kwarg_isnull: Any = ...

class AllValuesFieldListFilter(FieldListFilter):
    title: str
    used_parameters: dict[Any, Any]
    lookup_kwarg: str = ...
    lookup_kwarg_isnull: str = ...
    lookup_val: None = ...
    lookup_val_isnull: None = ...
    empty_value_display: str = ...
    lookup_choices: QuerySet[Any] = ...

class RelatedOnlyFieldListFilter(RelatedFieldListFilter):
    lookup_kwarg: str
    lookup_kwarg_isnull: str
    lookup_val: None
    lookup_val_isnull: None
    title: str
    used_parameters: dict[Any, Any]

class EmptyFieldListFilter(FieldListFilter):
    lookup_kwarg: str
    lookup_val: Any
    def choices(self, changelist: Any) -> Iterator[dict[str, Any]]: ...
