from collections.abc import Callable, Iterable
from typing import Any

from django.apps.config import AppConfig
from django.contrib.admin.options import ModelAdmin
from django.core.handlers.wsgi import WSGIRequest
from django.db.models.base import Model
from django.http.response import HttpResponse
from django.template.response import TemplateResponse
from django.urls.resolvers import URLResolver
from django.utils.functional import LazyObject

all_sites: Any

class AlreadyRegistered(Exception): ...
class NotRegistered(Exception): ...

class AdminSite:
    site_title: Any = ...
    site_header: Any = ...
    index_title: Any = ...
    site_url: str = ...
    login_form: Any = ...
    index_template: Any = ...
    app_index_template: Any = ...
    login_template: Any = ...
    logout_template: Any = ...
    password_change_template: Any = ...
    password_change_done_template: Any = ...
    name: str = ...
    enable_nav_sidebar: bool = ...
    _registry: dict[type[Model], ModelAdmin[Any]]
    def __init__(self, name: str = ...) -> None: ...
    def check(self, app_configs: Iterable[AppConfig] | None) -> list[Any]: ...
    def register(
        self,
        model_or_iterable: type[Model] | Iterable[type[Model]],
        admin_class: type[ModelAdmin[Any]] | None = ...,
        **options: Any
    ) -> None: ...
    def unregister(
        self, model_or_iterable: type[Model] | Iterable[type[Model]]
    ) -> None: ...
    def is_registered(self, model: type[Model]) -> bool: ...
    def add_action(
        self, action: Callable[..., Any], name: str | None = ...
    ) -> None: ...
    def disable_action(self, name: str) -> None: ...
    def get_action(self, name: str) -> Callable[..., Any]: ...
    @property
    def actions(self) -> Any: ...
    @property
    def empty_value_display(self) -> Any: ...
    @empty_value_display.setter
    def empty_value_display(self, empty_value_display: Any) -> None: ...
    def has_permission(self, request: WSGIRequest) -> bool: ...
    def admin_view(
        self, view: Callable[..., Any], cacheable: bool = ...
    ) -> Callable[..., Any]: ...
    def get_urls(self) -> list[URLResolver]: ...
    @property
    def urls(self) -> tuple[list[URLResolver], str, str]: ...
    def each_context(self, request: Any) -> Any: ...
    def password_change(
        self, request: WSGIRequest, extra_context: dict[str, Any] | None = ...
    ) -> TemplateResponse: ...
    def password_change_done(
        self, request: WSGIRequest, extra_context: dict[str, Any] | None = ...
    ) -> TemplateResponse: ...
    def i18n_javascript(
        self, request: WSGIRequest, extra_context: dict[Any, Any] | None = ...
    ) -> HttpResponse: ...
    def logout(
        self, request: WSGIRequest, extra_context: dict[str, Any] | None = ...
    ) -> TemplateResponse: ...
    def login(
        self, request: WSGIRequest, extra_context: dict[str, Any] | None = ...
    ) -> HttpResponse: ...
    def _build_app_dict(
        self, request: WSGIRequest, label: str | None = ...
    ) -> dict[str, Any]: ...
    def get_app_list(self, request: WSGIRequest) -> list[Any]: ...
    def index(
        self, request: WSGIRequest, extra_context: dict[str, Any] | None = ...
    ) -> TemplateResponse: ...
    def app_index(
        self,
        request: WSGIRequest,
        app_label: str,
        extra_context: dict[str, Any] | None = ...,
    ) -> TemplateResponse: ...

class DefaultAdminSite(LazyObject): ...

site: AdminSite
