from collections import OrderedDict
from collections.abc import Callable
from typing import Any

from django.contrib.admin.filters import ListFilter, SimpleListFilter
from django.contrib.admin.options import IS_POPUP_VAR as IS_POPUP_VAR  # noqa: F401
from django.contrib.admin.options import TO_FIELD_VAR as TO_FIELD_VAR
from django.contrib.admin.options import ModelAdmin
from django.core.handlers.wsgi import WSGIRequest
from django.db.models.base import Model
from django.db.models.expressions import Combinable, CombinedExpression, OrderBy
from django.db.models.options import Options
from django.db.models.query import QuerySet
from django.forms.formsets import BaseFormSet

ALL_VAR: str
ORDER_VAR: str
ORDER_TYPE_VAR: str
PAGE_VAR: str
SEARCH_VAR: str
ERROR_FLAG: str
IGNORED_PARAMS: Any

class ChangeList:
    model: type[Model] = ...
    opts: Options[Any] = ...
    lookup_opts: Options[Any] = ...
    root_queryset: QuerySet[Any] = ...
    list_display: list[str] = ...
    list_display_links: list[str] = ...
    list_filter: tuple[Any, ...] = ...
    date_hierarchy: None = ...
    search_fields: tuple[Any, ...] = ...
    list_select_related: bool = ...
    list_per_page: int = ...
    list_max_show_all: int = ...
    model_admin: ModelAdmin[Any] = ...
    preserved_filters: str = ...
    sortable_by: tuple[str] = ...
    page_num: int = ...
    show_all: bool = ...
    is_popup: bool = ...
    to_field: None = ...
    params: dict[Any, Any] = ...
    list_editable: tuple[Any, ...] = ...
    query: str = ...
    queryset: Any = ...
    title: Any = ...
    pk_attname: Any = ...
    formset: BaseFormSet | None
    def __init__(
        self,
        request: WSGIRequest,
        model: type[Model],
        list_display: list[Callable[..., Any] | str] | tuple[str],
        list_display_links: list[Callable[..., Any]] | list[str] | tuple[str] | None,
        list_filter: list[type[SimpleListFilter]] | list[str] | tuple[Any, ...],
        date_hierarchy: str | None,
        search_fields: list[str] | tuple[Any, ...],
        list_select_related: tuple[Any, ...] | bool,
        list_per_page: int,
        list_max_show_all: int,
        list_editable: list[str] | tuple[Any, ...],
        model_admin: ModelAdmin[Any],
        sortable_by: list[Callable[..., Any]] | list[str] | tuple[Any, ...],
    ) -> None: ...
    def get_filters_params(self, params: None = ...) -> dict[str, str]: ...
    def get_filters(
        self, request: WSGIRequest
    ) -> tuple[list[ListFilter], bool, dict[str, bool | str], bool]: ...
    def get_query_string(
        self,
        new_params: dict[str, None] | None = ...,
        remove: list[str] | None = ...,
    ) -> str: ...
    result_count: Any = ...
    show_full_result_count: Any = ...
    show_admin_actions: Any = ...
    full_result_count: Any = ...
    result_list: Any = ...
    can_show_all: Any = ...
    multi_page: Any = ...
    paginator: Any = ...
    def get_results(self, request: WSGIRequest) -> None: ...
    def get_ordering_field(
        self, field_name: Callable[..., Any] | str
    ) -> CombinedExpression | str | None: ...
    def get_ordering(
        self, request: WSGIRequest, queryset: QuerySet[Any]
    ) -> list[OrderBy | Combinable | str]: ...
    def get_ordering_field_columns(self) -> OrderedDict[Any, Any]: ...
    def get_queryset(self, request: WSGIRequest) -> QuerySet[Any]: ...
    def apply_select_related(self, qs: QuerySet[Any]) -> QuerySet[Any]: ...
    def has_related_field_in_list_display(self) -> bool: ...
    def url_for_result(self, result: Model) -> str: ...
