from enum import IntEnum
from typing import Any

from django.contrib.gis.gdal.base import GDALBase as GDALBase

class AxisOrder(IntEnum):
    TRADITIONAL: int
    AUTHORITY: int

class SpatialReference(GDALBase):
    destructor: Any = ...
    axis_order: Any = ...
    ptr: Any = ...
    def __init__(
        self, srs_input: str = ..., srs_type: str = ..., axis_order: Any | None = ...
    ) -> None: ...
    def __getitem__(self, target: Any) -> Any: ...
    def attr_value(self, target: Any, index: int = ...) -> Any: ...
    def auth_name(self, target: Any) -> Any: ...
    def auth_code(self, target: Any) -> Any: ...
    def clone(self) -> Any: ...
    def from_esri(self) -> None: ...
    def identify_epsg(self) -> None: ...
    def to_esri(self) -> None: ...
    def validate(self) -> None: ...
    @property
    def name(self) -> Any: ...
    @property
    def srid(self) -> Any: ...
    @property
    def linear_name(self) -> Any: ...
    @property
    def linear_units(self) -> Any: ...
    @property
    def angular_name(self) -> Any: ...
    @property
    def angular_units(self) -> Any: ...
    @property
    def units(self) -> Any: ...
    @property
    def ellipsoid(self) -> Any: ...
    @property
    def semi_major(self) -> Any: ...
    @property
    def semi_minor(self) -> Any: ...
    @property
    def inverse_flattening(self) -> Any: ...
    @property
    def geographic(self) -> Any: ...
    @property
    def local(self) -> Any: ...
    @property
    def projected(self) -> Any: ...
    def import_epsg(self, epsg: Any) -> None: ...
    def import_proj(self, proj: Any) -> None: ...
    def import_user_input(self, user_input: Any) -> None: ...
    def import_wkt(self, wkt: Any) -> None: ...
    def import_xml(self, xml: Any) -> None: ...
    @property
    def wkt(self) -> Any: ...
    @property
    def proj(self) -> Any: ...
    @property
    def proj4(self) -> Any: ...

class CoordTransform(GDALBase):
    destructor: Any = ...
    ptr: Any = ...
    def __init__(self, source: Any, target: Any) -> None: ...
