import enum
from typing import Any

class ChoicesMeta(enum.EnumMeta):
    names: list[str] = ...
    choices: list[tuple[Any, str]] = ...
    labels: list[str] = ...
    values: list[Any] = ...
    def __contains__(self, item: Any) -> bool: ...

class Choices(enum.Enum, metaclass=ChoicesMeta):
    def __str__(self) -> Any: ...
    @property
    def label(self) -> str: ...
    @property
    def value(self) -> Any: ...

# fake
class _IntegerChoicesMeta(ChoicesMeta):
    names: list[str] = ...
    choices: list[tuple[int, str]] = ...
    labels: list[str] = ...
    values: list[int] = ...

class IntegerChoices(int, Choices, metaclass=_IntegerChoicesMeta):
    @property
    def value(self) -> int: ...

# fake
class _TextChoicesMeta(ChoicesMeta):
    names: list[str] = ...
    choices: list[tuple[str, str]] = ...
    labels: list[str] = ...
    values: list[str] = ...

class TextChoices(str, Choices, metaclass=_TextChoicesMeta):
    @property
    def value(self) -> str: ...
