from collections.abc import Iterable, Mapping
from datetime import datetime
from typing import Any, Generic, TypeVar
from typing_extensions import Self

from django.db.backends.sqlite3.base import DatabaseWrapper
from django.db.models.expressions import Expression, Func
from django.db.models.fields import TextField, related_lookups
from django.db.models.query_utils import RegisterLookupMixin
from django.db.models.sql.compiler import SQLCompiler
from django.utils.datastructures import OrderedSet
from django.utils.safestring import SafeText

_T = TypeVar("_T")

class Lookup(Generic[_T]):
    lookup_name: str = ...
    prepare_rhs: bool = ...
    can_use_none_as_rhs: bool = ...
    lhs: Any = ...
    rhs: Any = ...
    bilateral_transforms: list[type[Transform]] = ...
    def __init__(
        self,
        lhs: Expression | TextField[Any] | related_lookups.MultiColSource,
        rhs: Any,
    ) -> None: ...
    def apply_bilateral_transforms(self, value: Expression) -> Transform: ...
    def batch_process_rhs(
        self,
        compiler: SQLCompiler,
        connection: DatabaseWrapper,
        rhs: OrderedSet[Any] | None = ...,
    ) -> tuple[list[str], list[str]]: ...
    def get_source_expressions(self) -> list[Expression]: ...
    def set_source_expressions(self, new_exprs: list[Expression]) -> None: ...
    def get_prep_lookup(self) -> Any: ...
    def get_db_prep_lookup(
        self, value: int | str, connection: DatabaseWrapper
    ) -> tuple[str, list[SafeText]]: ...
    def process_lhs(
        self,
        compiler: SQLCompiler,
        connection: DatabaseWrapper,
        lhs: Expression | None = ...,
    ) -> tuple[str, list[int | str]]: ...
    def process_rhs(
        self, compiler: SQLCompiler, connection: DatabaseWrapper
    ) -> tuple[str, list[int | str]]: ...
    def rhs_is_direct_value(self) -> bool: ...
    def relabeled_clone(self, relabels: Mapping[str, str]) -> Self: ...
    def get_group_by_cols(self) -> list[Expression]: ...
    def as_sql(self, compiler: Any, connection: Any) -> Any: ...
    def contains_aggregate(self) -> bool: ...
    def contains_over_clause(self) -> bool: ...
    @property
    def is_summary(self) -> bool: ...

class Transform(RegisterLookupMixin, Func):
    bilateral: bool = ...
    @property
    def lhs(self) -> Expression: ...
    def get_bilateral_transforms(self) -> list[type[Transform]]: ...

class BuiltinLookup(Lookup[_T]):
    def get_rhs_op(self, connection: DatabaseWrapper, rhs: str) -> str: ...

class FieldGetDbPrepValueMixin:
    get_db_prep_lookup_value_is_iterable: bool = ...

class FieldGetDbPrepValueIterableMixin(FieldGetDbPrepValueMixin):
    def get_prep_lookup(self) -> Iterable[Any]: ...
    def resolve_expression_parameter(
        self, compiler: SQLCompiler, connection: DatabaseWrapper, sql: str, param: Any
    ) -> Any: ...

class PostgresOperatorLookup(FieldGetDbPrepValueMixin, Lookup[Any]):
    postgres_operator: Any = ...
    def as_postgresql(self, compiler: Any, connection: Any) -> Any: ...

class Exact(FieldGetDbPrepValueMixin, BuiltinLookup[Any]): ...
class IExact(BuiltinLookup[Any]): ...
class GreaterThan(FieldGetDbPrepValueMixin, BuiltinLookup[Any]): ...
class GreaterThanOrEqual(FieldGetDbPrepValueMixin, BuiltinLookup[_T]): ...
class LessThan(FieldGetDbPrepValueMixin, BuiltinLookup[_T]): ...
class LessThanOrEqual(FieldGetDbPrepValueMixin, BuiltinLookup[Any]): ...

class IntegerFieldFloatRounding:
    rhs: Any = ...
    def get_prep_lookup(self) -> Any: ...

class IntegerGreaterThanOrEqual(
    IntegerFieldFloatRounding, GreaterThanOrEqual[int | float]
): ...
class IntegerLessThan(IntegerFieldFloatRounding, LessThan[int | float]): ...

class In(FieldGetDbPrepValueIterableMixin, BuiltinLookup[Any]):
    def split_parameter_list_as_sql(self, compiler: Any, connection: Any) -> Any: ...

class PatternLookup(BuiltinLookup[str]):
    param_pattern: str = ...

class Contains(PatternLookup): ...
class IContains(Contains): ...
class StartsWith(PatternLookup): ...
class IStartsWith(StartsWith): ...
class EndsWith(PatternLookup): ...
class IEndsWith(EndsWith): ...
class Range(FieldGetDbPrepValueIterableMixin, BuiltinLookup[Any]): ...
class IsNull(BuiltinLookup[bool]): ...
class Regex(BuiltinLookup[str]): ...
class IRegex(Regex): ...

class YearLookup(Lookup[Any]):
    def year_lookup_bounds(
        self, connection: DatabaseWrapper, year: int
    ) -> list[str]: ...

class YearComparisonLookup(YearLookup):
    def get_rhs_op(self, connection: DatabaseWrapper, rhs: str) -> str: ...
    def get_bound(self, start: datetime, finish: datetime) -> Any: ...

class YearExact(YearLookup, Exact): ...
class YearGt(YearComparisonLookup): ...
class YearGte(YearComparisonLookup): ...
class YearLt(YearComparisonLookup): ...
class YearLte(YearComparisonLookup): ...

class UUIDTextMixin:
    rhs: Any = ...
    def process_rhs(self, qn: Any, connection: Any) -> Any: ...

class UUIDIExact(UUIDTextMixin, IExact): ...
class UUIDContains(UUIDTextMixin, Contains): ...
class UUIDIContains(UUIDTextMixin, IContains): ...
class UUIDStartsWith(UUIDTextMixin, StartsWith): ...
class UUIDIStartsWith(UUIDTextMixin, IStartsWith): ...
class UUIDEndsWith(UUIDTextMixin, EndsWith): ...
class UUIDIEndsWith(UUIDTextMixin, IEndsWith): ...
