from collections.abc import Callable, Iterator
from datetime import date, datetime
from decimal import Decimal
from itertools import chain
from typing import Any
from uuid import UUID

from django.db.models.base import Model
from django.db.models.expressions import BaseExpression, Expression
from django.db.models.sql.query import Query, RawQuery

FORCE: Any

class SQLCompiler:
    query: Any = ...
    connection: Any = ...
    using: Any = ...
    quote_cache: Any = ...
    select: Any = ...
    annotation_col_map: Any = ...
    klass_info: Any = ...
    ordering_parts: Any = ...
    def __init__(
        self, query: Query | RawQuery, connection: Any, using: str | None
    ) -> None: ...
    col_count: Any = ...
    def setup_query(self) -> None: ...
    has_extra_select: Any = ...
    def pre_sql_setup(
        self,
    ) -> tuple[
        list[tuple[Expression, tuple[str, list[Any] | tuple[str, str]], None]],
        list[tuple[Expression, tuple[str, list[int | str], bool]]],
        list[tuple[str, list[float]]],
    ]: ...
    def get_group_by(
        self,
        select: list[tuple[BaseExpression, tuple[str, list[float]], str | None]],
        order_by: list[tuple[Expression, tuple[str, list[int | str], bool]]],
    ) -> list[tuple[str, list[float]]]: ...
    def collapse_group_by(
        self,
        expressions: list[Expression],
        having: list[Expression] | tuple[Any, ...],
    ) -> list[Expression]: ...
    def get_select(
        self,
    ) -> tuple[
        list[tuple[Expression, tuple[str, list[int | str]], str | None]],
        dict[str, Any] | None,
        dict[str, int],
    ]: ...
    def get_order_by(self) -> list[tuple[Expression, tuple[str, list[Any], bool]]]: ...
    def get_extra_select(
        self,
        order_by: list[tuple[Expression, tuple[str, list[Any], bool]]],
        select: list[tuple[Expression, tuple[str, list[float]], str | None]],
    ) -> list[tuple[Expression, tuple[str, list[Any]], None]]: ...
    def quote_name_unless_alias(self, name: str) -> str: ...
    def compile(
        self, node: Any, select_format: Any = ...
    ) -> tuple[str, list[int | None] | tuple[int, int]]: ...
    def get_combinator_sql(
        self, combinator: str, all: bool
    ) -> tuple[list[str], list[int] | list[str]]: ...
    def as_sql(self, with_limits: bool = ..., with_col_aliases: bool = ...) -> Any: ...
    def get_default_columns(
        self,
        start_alias: str | None = ...,
        opts: Any | None = ...,
        from_parent: type[Model] | None = ...,
    ) -> list[Expression]: ...
    def get_distinct(self) -> tuple[list[Any], list[Any]]: ...
    def find_ordering_name(
        self,
        name: str,
        opts: Any,
        alias: str | None = ...,
        default_order: str = ...,
        already_seen: (
            set[tuple[tuple[tuple[str, str]] | None, tuple[tuple[str, str]]]] | None
        ) = ...,
    ) -> list[tuple[Expression, bool]]: ...
    def get_from_clause(self) -> tuple[list[str], list[int | str]]: ...
    def get_related_selections(
        self,
        select: list[tuple[Expression, str | None]],
        opts: Any | None = ...,
        root_alias: str | None = ...,
        cur_depth: int = ...,
        requested: dict[str, dict[str, dict[str, dict[Any, Any]]]] | bool | None = ...,
        restricted: bool | None = ...,
    ) -> list[dict[str, Any]]: ...
    def get_select_for_update_of_arguments(self) -> Any: ...
    def deferred_to_columns(self) -> dict[type[Model], set[str]]: ...
    def get_converters(
        self, expressions: list[Expression]
    ) -> dict[int, tuple[list[Callable[..., Any]], Expression]]: ...
    def apply_converters(
        self,
        rows: chain[Any],
        converters: dict[int, tuple[list[Callable[..., Any]], Expression]],
    ) -> Iterator[
        list[bytes | datetime | int | str | None]
        | list[date | Decimal | float | str | None]
        | list[datetime | float | str | UUID | None]
    ]: ...
    def results_iter(
        self,
        results: Iterator[Any] | list[list[tuple[int | str]]] | None = ...,
        tuple_expected: bool = ...,
        chunked_fetch: bool = ...,
        chunk_size: int = ...,
    ) -> Iterator[Any]: ...
    def has_results(self) -> bool: ...
    def execute_sql(
        self, result_type: str = ..., chunked_fetch: bool = ..., chunk_size: int = ...
    ) -> Any | None: ...
    def as_subquery_condition(
        self, alias: str, columns: list[str], compiler: SQLCompiler
    ) -> tuple[str, tuple[Any, ...]]: ...
    def explain_query(self) -> Iterator[str]: ...

class SQLInsertCompiler(SQLCompiler):
    returning_fields: Any = ...
    returning_params: Any = ...
    def field_as_sql(self, field: Any, val: Any) -> Any: ...
    def prepare_value(self, field: Any, value: Any) -> Any: ...
    def pre_save_val(self, field: Any, obj: Any) -> Any: ...
    def assemble_as_sql(self, fields: Any, value_rows: Any) -> Any: ...
    def as_sql(self) -> Any: ...  # type: ignore [override]

class SQLDeleteCompiler(SQLCompiler):
    def single_alias(self) -> Any: ...
    def as_sql(self) -> Any: ...  # type: ignore [override]

class SQLUpdateCompiler(SQLCompiler):
    def as_sql(self) -> Any: ...  # type: ignore [override]

class SQLAggregateCompiler(SQLCompiler):
    col_count: Any = ...
    def as_sql(self) -> Any: ...  # type: ignore [override]

def cursor_iter(
    cursor: Any, sentinel: Any, col_count: int | None, itersize: int
) -> Iterator[Any]: ...
