from collections.abc import Mapping, Sequence, Sized
from typing import Any

from django.forms import Form

TOTAL_FORM_COUNT: str = ...
INITIAL_FORM_COUNT: str = ...
MIN_NUM_FORM_COUNT: str = ...
MAX_NUM_FORM_COUNT: str = ...
ORDERING_FIELD_NAME: str = ...
DELETION_FIELD_NAME: str = ...

DEFAULT_MIN_NUM: int = ...
DEFAULT_MAX_NUM: int = ...

class ManagementForm(Form):
    cleaned_data: dict[str, int | None]

class BaseFormSet(Sized, Mapping[str, Any]):
    is_bound: Any = ...
    prefix: Any = ...
    auto_id: Any = ...
    data: Any = ...
    files: Any = ...
    initial: Any = ...
    form_kwargs: Any = ...
    error_class: Any = ...
    def __init__(
        self,
        data: Any | None = ...,
        files: Any | None = ...,
        auto_id: str = ...,
        prefix: Any | None = ...,
        initial: Any | None = ...,
        error_class: Any = ...,
        form_kwargs: Any | None = ...,
    ) -> None: ...
    def __iter__(self) -> Any: ...
    def __getitem__(self, index: Any) -> Any: ...
    def __len__(self) -> Any: ...
    def __bool__(self) -> Any: ...
    def management_form(self) -> Any: ...
    def total_form_count(self) -> Any: ...
    def initial_form_count(self) -> Any: ...
    @property
    def forms(self) -> Any: ...
    def get_form_kwargs(self, index: Any) -> Any: ...
    @property
    def initial_forms(self) -> Any: ...
    @property
    def extra_forms(self) -> Any: ...
    @property
    def empty_form(self) -> Any: ...
    @property
    def cleaned_data(self) -> Any: ...
    @property
    def deleted_forms(self) -> Any: ...
    @property
    def ordered_forms(self) -> Any: ...
    @classmethod
    def get_default_prefix(cls) -> Any: ...
    def non_form_errors(self) -> Any: ...
    @property
    def errors(self) -> Any: ...
    def total_error_count(self) -> Any: ...
    def is_valid(self) -> Any: ...
    def full_clean(self) -> Any: ...
    def clean(self) -> None: ...
    def has_changed(self) -> Any: ...
    def add_fields(self, form: Any, index: Any) -> None: ...
    def add_prefix(self, index: Any) -> Any: ...
    def is_multipart(self) -> Any: ...
    @property
    def media(self) -> Any: ...
    def as_table(self) -> Any: ...
    def as_p(self) -> Any: ...
    def as_ul(self) -> Any: ...

def formset_factory(
    form: Any,
    formset: Any = ...,
    extra: int = ...,
    can_order: bool = ...,
    can_delete: bool = ...,
    max_num: Any | None = ...,
    validate_max: bool = ...,
    min_num: Any | None = ...,
    validate_min: bool = ...,
) -> Any: ...
def all_valid(formsets: Sequence[Any]) -> bool: ...
