from collections import UserList
from collections.abc import Sequence
from datetime import datetime
from typing import Any

from django.core.exceptions import ValidationError
from django.utils.safestring import SafeText

def pretty_name(name: str) -> str: ...
def flatatt(attrs: dict[str, Any]) -> SafeText: ...

class ErrorDict(dict[str, Any]):
    def as_data(self) -> dict[str, list[ValidationError]]: ...
    def get_json_data(self, escape_html: bool = ...) -> dict[str, Any]: ...
    def as_json(self, escape_html: bool = ...) -> str: ...
    def as_ul(self) -> str: ...
    def as_text(self) -> str: ...

class ErrorList(UserList[Any]):
    data: list[ValidationError | str]
    error_class: str = ...
    def __init__(
        self,
        initlist: ErrorList | Sequence[str | Exception] | None = ...,
        error_class: str | None = ...,
    ) -> None: ...
    def as_data(self) -> list[ValidationError]: ...
    def get_json_data(self, escape_html: bool = ...) -> list[dict[str, str]]: ...
    def as_json(self, escape_html: bool = ...) -> str: ...
    def as_ul(self) -> str: ...
    def as_text(self) -> str: ...

def from_current_timezone(value: datetime) -> datetime: ...
def to_current_timezone(value: datetime) -> datetime: ...
