from collections.abc import Iterator, Mapping
from typing import Any

from django.template.base import Template

class BaseEngine:
    name: str = ...
    dirs: list[str] = ...
    app_dirs: bool = ...
    def __init__(self, params: Mapping[str, Any]) -> None: ...
    @property
    def app_dirname(self) -> str | None: ...
    def from_string(self, template_code: str) -> Template: ...
    def get_template(self, template_name: str) -> Template | None: ...
    @property
    def template_dirs(self) -> tuple[str]: ...
    def iter_template_filenames(self, template_name: str) -> Iterator[str]: ...
