from collections.abc import Iterator
from typing import Any

from django.template import base
from django.template.engine import Engine
from django.template.exceptions import TemplateDoesNotExist

from .base import BaseEngine

class DjangoTemplates(BaseEngine):
    engine: Engine = ...
    def __init__(self, params: dict[str, Any]) -> None: ...
    def get_templatetag_libraries(
        self, custom_libraries: dict[str, str]
    ) -> dict[str, str]: ...

class Template:
    template: base.Template
    backend: BaseEngine
    def __init__(self, template: base.Template, backend: BaseEngine) -> None: ...
    @property
    def origin(self) -> base.Origin: ...
    def render(self, context: Any = ..., request: Any = ...) -> str: ...

def copy_exception(
    exc: TemplateDoesNotExist, backend: DjangoTemplates | None = ...
) -> TemplateDoesNotExist: ...
def reraise(exc: TemplateDoesNotExist, backend: DjangoTemplates) -> Any: ...
def get_installed_libraries() -> dict[str, str]: ...
def get_package_libraries(pkg: Any) -> Iterator[str]: ...
