from typing import Any

from django.template.defaulttags import TemplateLiteral

_Token = list[int] | int | str

class TokenBase:
    id: Any = ...
    value: Any = ...
    first: Any = ...
    second: Any = ...
    def nud(self, parser: Any) -> None: ...
    def led(self, left: Any, parser: Any) -> None: ...
    def display(self) -> Any: ...

def infix(bp: Any, func: Any) -> Any: ...
def prefix(bp: Any, func: Any) -> Any: ...

OPERATORS: Any

class Literal(TokenBase):
    id: str = ...
    lbp: int = ...
    value: _Token | None = ...
    def __init__(self, value: _Token | None) -> None: ...
    def display(self) -> Any: ...
    def eval(self, context: dict[Any, Any]) -> _Token | None: ...

class EndToken(TokenBase):
    lbp: int = ...
    def nud(self, parser: Any) -> None: ...

class IfParser:
    error_class: Any = ...
    tokens: Any = ...
    pos: int = ...
    current_token: Any = ...
    def __init__(self, tokens: list[_Token | None]) -> None: ...
    def translate_token(self, token: _Token | None) -> Literal: ...
    def next_token(self) -> Literal: ...
    def parse(self) -> TemplateLiteral: ...
    def expression(self, rbp: int = ...) -> Literal: ...
    def create_var(self, value: _Token | None) -> Literal: ...
