from collections.abc import Callable
from functools import wraps as wraps  # noqa: F401
from typing import Any, Generic, TypeVar, overload
from typing_extensions import Self

from django.db.models.base import Model

def curry(_curried_func: Any, *args: Any, **kwargs: Any) -> Any: ...

_T = TypeVar("_T")

class cached_property(Generic[_T]):
    func: Callable[..., _T] = ...
    __doc__: Any = ...
    name: str = ...
    def __init__(self, func: Callable[..., _T], name: str | None = ...) -> None: ...
    @overload
    def __get__(self, instance: None, cls: type[Any] = ...) -> Self: ...
    @overload
    def __get__(self, instance: object, cls: type[Any] = ...) -> _T: ...

class Promise: ...

def lazy(
    func: Callable[..., Any] | type[str], *resultclasses: Any
) -> Callable[..., Any]: ...
def lazystr(text: Any) -> Any: ...
def keep_lazy(*resultclasses: Any) -> Callable[..., Any]: ...
def keep_lazy_text(func: Callable[..., Any]) -> Callable[..., Any]: ...

empty: Any

def new_method_proxy(func: Any) -> Any: ...

class LazyObject:
    def __init__(self) -> None: ...
    __getattr__: Any = ...
    def __setattr__(self, name: str, value: Any) -> None: ...
    def __delattr__(self, name: str) -> None: ...
    def __reduce__(self) -> tuple[Callable[..., Any], tuple[Model]]: ...
    def __copy__(self) -> Any: ...
    def __deepcopy__(self, memo: Any) -> Any: ...
    __bytes__: Any = ...
    __bool__: Any = ...
    __dir__: Any = ...
    __class__: Any = ...
    __ne__: Any = ...
    __hash__: Any = ...
    __getitem__: Any = ...
    __setitem__: Any = ...
    __delitem__: Any = ...
    __iter__: Any = ...
    __len__: Any = ...
    __contains__: Any = ...

def unpickle_lazyobject(wrapped: Model) -> Model: ...

class SimpleLazyObject(LazyObject):
    def __init__(self, func: Callable[..., Any]) -> None: ...
    def __copy__(self) -> list[int]: ...
    def __deepcopy__(self, memo: dict[Any, Any]) -> list[int]: ...

_PartitionMember = TypeVar("_PartitionMember")

def partition(
    predicate: Callable[..., Any], values: list[_PartitionMember]
) -> tuple[list[_PartitionMember], list[_PartitionMember]]: ...
