import types
from contextlib import ContextDecorator
from datetime import date
from datetime import datetime as datetime
from datetime import time
from datetime import timedelta as timedelta
from datetime import timezone
from datetime import tzinfo as tzinfo

from pytz import BaseTzInfo

_AnyTime = time | datetime

class UTC(tzinfo):
    def utcoffset(self, dt: datetime | None) -> timedelta | None: ...
    def tzname(self, dt: datetime | None) -> str: ...
    def dst(self, dt: datetime | None) -> timedelta | None: ...

class FixedOffset(tzinfo):
    def __init__(self, offset: int | None = ..., name: str | None = ...) -> None: ...
    def utcoffset(self, dt: datetime | None) -> timedelta | None: ...
    def tzname(self, dt: datetime | None) -> str: ...
    def dst(self, dt: datetime | timedelta | None) -> timedelta | None: ...

class ReferenceLocalTimezone(tzinfo):
    STDOFFSET: timedelta = ...
    DSTOFFSET: timedelta = ...
    DSTDIFF: timedelta = ...
    def __init__(self) -> None: ...
    def utcoffset(self, dt: datetime | None) -> timedelta | None: ...
    def dst(self, dt: datetime | None) -> timedelta | None: ...
    def tzname(self, dt: datetime | None) -> str: ...

class LocalTimezone(ReferenceLocalTimezone):
    def tzname(self, dt: datetime | None) -> str: ...

utc: UTC = ...

def get_fixed_timezone(offset: timedelta | int) -> timezone: ...
def get_default_timezone() -> BaseTzInfo: ...
def get_default_timezone_name() -> str: ...

# Strictly speaking, it is possible to activate() a non-pytz timezone,
# in which case BaseTzInfo is incorrect. However, this is unlikely,
# so we use it anyway, to keep things ergonomic for most users.
def get_current_timezone() -> BaseTzInfo: ...
def get_current_timezone_name() -> str: ...
def activate(timezone: tzinfo | str) -> None: ...
def deactivate() -> None: ...

class override(ContextDecorator):
    timezone: tzinfo = ...
    old_timezone: tzinfo | None = ...
    def __init__(self, timezone: str | tzinfo | None) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(
        self,
        exc_type: type[BaseException],
        exc_value: BaseException,
        traceback: types.TracebackType,
    ) -> None: ...

def localtime(
    value: _AnyTime | None = ..., timezone: tzinfo | None = ...
) -> datetime: ...
def localdate(value: _AnyTime | None = ..., timezone: tzinfo | None = ...) -> date: ...
def now() -> datetime: ...
def is_aware(value: _AnyTime) -> bool: ...
def is_naive(value: _AnyTime) -> bool: ...
def make_aware(
    value: _AnyTime, timezone: tzinfo | None = ..., is_dst: bool | None = ...
) -> datetime: ...
def make_naive(value: _AnyTime, timezone: tzinfo | None = ...) -> datetime: ...
