import functools
from collections.abc import Callable
from contextlib import ContextDecorator
from typing import Any

from django.core.handlers.wsgi import WSGIRequest

from . import trans_real as trans_real

LANGUAGE_SESSION_KEY: str

class TranslatorCommentWarning(SyntaxWarning): ...

class Trans:
    activate: Callable[..., Any]
    check_for_language: functools._lru_cache_wrapper[Any, Any]  # type: ignore [type-arg]
    deactivate: Callable[..., Any]
    deactivate_all: Callable[..., Any]
    get_language: Callable[..., Any]
    get_language_bidi: Callable[..., Any]
    get_language_from_path: Callable[..., Any]
    get_language_from_request: Callable[..., Any]
    gettext: Callable[..., Any]
    gettext_noop: Callable[..., Any]
    ngettext: Callable[..., Any]
    npgettext: Callable[..., Any]
    pgettext: Callable[..., Any]
    def __getattr__(self, real_name: Any) -> Any: ...

def gettext_noop(message: str) -> str: ...

ugettext_noop = gettext_noop

def gettext(message: str) -> str: ...

ugettext = gettext

def ngettext(singular: str, plural: str, number: float) -> str: ...

ungettext = ngettext

def pgettext(context: str, message: str) -> str: ...
def npgettext(context: str, singular: str, plural: str, number: int) -> str: ...

gettext_lazy = gettext
ugettext_lazy = ugettext
pgettext_lazy = pgettext

def ngettext_lazy(singular: str, plural: str, number: int | str | None) -> str: ...

ungettext_lazy = ngettext_lazy

def npgettext_lazy(
    context: str, singular: str, plural: str, number: int | str | None
) -> str: ...
def activate(language: str) -> None: ...
def deactivate() -> None: ...

class override(ContextDecorator):
    language: str | None = ...
    deactivate: bool = ...
    def __init__(self, language: str | None, deactivate: bool = ...) -> None: ...
    old_language: str | None = ...
    def __enter__(self) -> None: ...
    def __exit__(self, exc_type: None, exc_value: None, traceback: None) -> None: ...

def get_language() -> str: ...
def get_language_from_path(path: str) -> str | None: ...
def get_language_bidi() -> bool: ...
def check_for_language(lang_code: str | None) -> bool: ...
def to_language(locale: str) -> str: ...
def to_locale(language: str) -> str: ...
def get_language_from_request(request: WSGIRequest, check_path: bool = ...) -> str: ...
def templatize(src: str, **kwargs: Any) -> str: ...
def deactivate_all() -> None: ...
def get_supported_language_variant(lang_code: str, strict: bool = ...) -> str: ...
def get_language_info(lang_code: str) -> Any: ...
