from matplotlib.transforms import Bbox
import numpy as np
from matplotlib._typing import *
from matplotlib.text import Text
from matplotlib.font_manager import FontProperties
from io import BufferedWriter, BytesIO
from matplotlib.font_manager import FontProperties
from typing import Any, Tuple

import threading
from matplotlib.backend_bases import (
    FigureCanvasBase,
    FigureManagerBase,
    GraphicsContextBase,
    RendererBase,
    _Backend,
)

backend_version: str = ...

def get_hinting_flag() -> int: ...

class RendererAgg(RendererBase):

    lock: threading.RLock = ...

    def __init__(self, width, height, dpi) -> None: ...
    def __getstate__(self) -> dict[str, Any]: ...
    def __setstate__(self, state)-> None: ...
    def draw_path(self, gc, path, transform, rgbFace=...)-> None: ...
    def draw_mathtext(self, gc, x, y, s, prop, angle)-> None: ...
    def draw_text(
        self,
        gc: GraphicsContextBase,
        x: float,
        y: float,
        s: str,
        prop: FontProperties,
        angle: float,
        ismath=...,
        mtext: Text = ...,
    )-> None: ...
    def get_text_width_height_descent(
        self, s: str, prop: FontProperties, ismath: bool
    ) -> tuple[float, float, float]: ...
    def draw_tex(self, gc: GraphicsContextBase, x, y, s: str, prop: FontProperties, angle, *, mtext=...)-> None: ...
    def get_canvas_width_height(self)-> tuple[float, float]: ...
    def points_to_pixels(self, points: int|float) -> float: ...
    def buffer_rgba(self) -> memoryview: ...
    def tostring_argb(self) -> bytes: ...
    def tostring_rgb(self) -> bytes: ...
    def clear(self) -> None: ...
    def option_image_nocomposite(self) -> bool: ...
    def option_scale_image(self) -> bool: ...
    def restore_region(self, region, bbox=..., xy=...) -> None: ...
    def start_filter(self) -> None: ...
    def stop_filter(self, post_processing)-> None: ...

class FigureCanvasAgg(FigureCanvasBase):
    def copy_from_bbox(self, bbox: Bbox): ...
    def restore_region(self, region, bbox: Bbox=..., xy=...): ...
    def draw(self) -> None: ...
    def get_renderer(self, cleared: bool = ...) -> RendererAgg: ...
    def tostring_rgb(self) -> str: ...
    def tostring_argb(self) -> np.str_: ...
    def buffer_rgba(self) -> memoryview: ...
    def print_raw(self, filename_or_obj) -> None: ...

    print_rgba = print_raw

    def print_png(
        self,
        filename_or_obj: BytesIO|BufferedWriter|str,
        metadata: dict = ...,
        pil_kwargs: dict = ...
    ) -> None: ...
    def print_to_buffer(self)-> tuple[bytes, tuple[int, int]]: ...
    def print_jpg(
        self, filename_or_obj: str | PathLike | FileLike, pil_kwargs: dict = ...
    )-> None: ...

    print_jpeg = print_jpg
    def print_tif(
        self, filename_or_obj: str | PathLike | FileLike, *, pil_kwargs: dict = ...
    )-> None: ...

    print_tiff = print_tif
    def print_webp(
        self, filename_or_obj: str | PathLike | FileLike, *, pil_kwargs: dict = ...
    )-> None: ...

class _BackendAgg(_Backend):
    FigureCanvas = FigureCanvasAgg
    FigureManager = FigureManagerBase
