# Helpers for current-flow betweenness and current-flow closness
# Lazy computations for inverse Laplacian and flow-matrix rows.

from ...classes.graph import Graph

def flow_matrix_row(G: Graph, weight=None, dtype=..., solver="lu"): ...

# Class to compute the inverse laplacian only for specified rows
# Allows computation of the current-flow matrix without storing entire
# inverse laplacian matrix
class InverseLaplacian:
    def __init__(self, L, width=None, dtype=None): ...
    def init_solver(self, L): ...
    def solve(self, r): ...
    def solve_inverse(self, r): ...
    def get_rows(self, r1, r2): ...
    def get_row(self, r): ...
    def width(self, L): ...

class FullInverseLaplacian(InverseLaplacian):
    def init_solver(self, L): ...
    def solve(self, rhs): ...
    def solve_inverse(self, r): ...

class SuperLUInverseLaplacian(InverseLaplacian):
    def init_solver(self, L): ...
    def solve_inverse(self, r): ...
    def solve(self, rhs): ...

class CGInverseLaplacian(InverseLaplacian):
    def init_solver(self, L): ...
    def solve(self, rhs): ...
    def solve_inverse(self, r): ...
