from typing import Any

from heapq import heappop, heappush
from itertools import count

from ..classes.graph import Graph

__all__ = ["MinHeap", "PairingHeap", "BinaryHeap"]

class MinHeap:
    ...

    def __init__(self): ...
    def min(self) -> tuple: ...
    def pop(self) -> tuple: ...
    def get(self, key, default: Any = None): ...
    def insert(self, key, value, allow_increase: bool = False) -> bool: ...
    def __nonzero__(self): ...
    def __bool__(self): ...
    def __len__(self): ...
    def __contains__(self, key): ...

class PairingHeap(MinHeap):
    ...

    def __init__(self): ...
    def min(self) -> tuple: ...
    def pop(self) -> tuple: ...
    def get(self, key, default: Any = None): ...
    def insert(self, key, value, allow_increase: bool = False) -> bool: ...
    def _link(self, root, other): ...
    def _merge_children(self, root): ...
    def _cut(self, node): ...

class BinaryHeap(MinHeap):
    def __init__(self): ...
    def min(self) -> tuple: ...
    def pop(self) -> tuple: ...
    def get(self, key, default: Any = None): ...
    def insert(self, key, value, allow_increase: bool = False) -> bool: ...
