# Python: 3.8.2 (tags/v3.8.2:7b3ab59, Feb 25 2020, 23:03:10) [MSC v.1916 64 bit (AMD64)]
# Library: scipy, version: 1.6.2
# Module: scipy.optimize._highs._highs_wrapper, version: unspecified
import typing
import builtins as _mod_builtins
import scipy.optimize.optimize as _mod_scipy_optimize_optimize

OptimizeWarning = _mod_scipy_optimize_optimize.OptimizeWarning
__doc__: typing.Any
__file__: str
__name__: str
__package__: str
def __pyx_unpickle_Enum() -> typing.Any:
    ...

__test__: dict
def _highs_wrapper() -> typing.Any:
    "Solve linear programs using HiGHS [1]_.\n\n    Assume problems of the form:\n\n        MIN c.T @ x\n        s.t. lhs <= A @ x <= rhs\n             lb <= x <= ub\n\n    Parameters\n    ----------\n    c : 1-D array, (n,)\n        Array of objective value coefficients.\n    astart : 1-D array\n        CSC format index array.\n    aindex : 1-D array\n        CSC format index array.\n    avalue : 1-D array\n        Data array of the matrix.\n    lhs : 1-D array (or None), (m,)\n        Array of left hand side values of the inequality constraints.\n        If ``lhs=None``, then an array of ``-inf`` is assumed.\n    rhs : 1-D array, (m,)\n        Array of right hand side values of the inequality constraints.\n    lb : 1-D array (or None), (n,)\n        Lower bounds on solution variables x.  If ``lb=None``, then an\n        array of all `0` is assumed.\n    ub : 1-D array (or None), (n,)\n        Upper bounds on solution variables x.  If ``ub=None``, then an\n        array of ``inf`` is assumed.\n    options : dict\n        A dictionary of solver options with the following fields:\n\n            - allowed_simplex_cost_scale_factor : int\n                Undocumented advanced option.\n\n            - allowed_simplex_matrix_scale_factor : int\n                Undocumented advanced option.\n\n            - dual_feasibility_tolerance : double\n                Dual feasibility tolerance for simplex.\n                ``min(dual_feasibility_tolerance,\n                primal_feasibility_tolerance)`` will be used for\n                ipm feasibility tolerance.\n\n            - dual_objective_value_upper_bound : double\n                Upper bound on objective value for dual simplex:\n                algorithm terminates if reached\n\n            - dual_simplex_cleanup_strategy : int\n                Undocumented advanced option.\n\n            - dual_simplex_cost_perturbation_multiplier : double\n                Undocumented advanced option.\n\n            - dual_steepest_edge_weight_log_error_threshhold : double\n                Undocumented advanced option.\n\n            - infinite_bound : double\n                Limit on abs(constraint bound): values larger than\n                this will be treated as infinite\n\n            - infinite_cost : double\n                Limit on cost coefficient: values larger than this\n                will be treated as infinite.\n\n            - ipm_iteration_limit : int\n                Iteration limit for interior-point solver.\n\n            - ipm_optimality_tolerance : double\n                Optimality tolerance for IPM.\n\n            - keep_n_rows : int {-1, 0, 1}\n                Undocumented advanced option.\n\n                    - ``-1``: ``KEEP_N_ROWS_DELETE_ROWS``\n                    - ``0``: ``KEEP_N_ROWS_DELETE_ENTRIES``\n                    - ``1``: ``KEEP_N_ROWS_KEEP_ROWS``\n\n            - large_matrix_value : double\n                Upper limit on abs(matrix entries): values larger than\n                this will be treated as infinite\n\n            - less_infeasible_DSE_check : bool\n                Undocumented advanced option.\n\n            - less_infeasible_DSE_choose_row : bool\n                Undocumented advanced option.\n\n            - max_threads : int\n                Maximum number of threads in parallel execution.\n\n            - message_level : int {0, 1, 2, 4, 7}\n                Verbosity level, corresponds to:\n\n                    - ``0``: ``ML_NONE``\n                        All messaging to stdout is supressed.\n\n                    - ``1``: ``ML_VERBOSE``\n                        Includes a once-per-iteration report on simplex/ipm\n                        progress and information about each nonzero row and\n                        column.\n\n                    - ``2``: ``ML_DETAILED``\n                        Includes technical information about progress and\n                        events in applying the simplex method.\n\n                    - ``4``: ``ML_MINIMAL``\n                        Once-per-solve information about progress as well as a\n                        once-per-basis-matrix-reinversion report on progress in\n                        simplex or a once-per-iteration report on progress in IPX.\n\n                ``message_level`` behaves like a bitmask, i.e., any\n                combination of levels is possible using the bit-or\n                operator.\n\n            - min_threads : int\n                Minimum number of threads in parallel execution.\n\n            - mps_parser_type_free : bool\n                Use free format MPS parsing.\n\n            - parallel : bool\n                Run the solver in serial (False) or parallel (True).\n\n            - presolve : bool\n                Run the presolve or not (or if ``None``, then choose).\n\n            - primal_feasibility_tolerance : double\n                Primal feasibility tolerance.\n                ``min(dual_feasibility_tolerance,\n                primal_feasibility_tolerance)`` will be used for\n                ipm feasibility tolerance.\n\n            - run_as_hsol : bool\n                Undocumented advanced option.\n\n            - run_crossover : bool\n                Advanced option. Toggles running the crossover routine\n                for IPX.\n\n            - sense : int {1, -1}\n                ``sense=1`` corresponds to the MIN problem, ``sense=-1``\n                corresponds to the MAX problem. TODO: NOT IMPLEMENTED\n\n            - simplex_crash_strategy : int {0, 1, 2, 3, 4, 5, 6, 7, 8, 9}\n                Strategy for simplex crash: off / LTSSF / Bixby (0/1/2).\n                Default is ``0``.  Corresponds to the following:\n\n                    - ``0``: ``SIMPLEX_CRASH_STRATEGY_OFF``\n                    - ``1``: ``SIMPLEX_CRASH_STRATEGY_LTSSF_K``\n                    - ``2``: ``SIMPLEX_CRASH_STRATEGY_BIXBY``\n                    - ``3``: ``SIMPLEX_CRASH_STRATEGY_LTSSF_PRI``\n                    - ``4``: ``SIMPLEX_CRASH_STRATEGY_LTSF_K``\n                    - ``5``: ``SIMPLEX_CRASH_STRATEGY_LTSF_PRI``\n                    - ``6``: ``SIMPLEX_CRASH_STRATEGY_LTSF``\n                    - ``7``: ``SIMPLEX_CRASH_STRATEGY_BIXBY_NO_NONZERO_COL_COSTS``\n                    - ``8``: ``SIMPLEX_CRASH_STRATEGY_BASIC``\n                    - ``9``: ``SIMPLE_CRASH_STRATEGY_TEST_SING``\n\n            - simplex_dualise_strategy : int\n                Undocumented advanced option.\n\n            - simplex_dual_edge_weight_strategy : int {0, 1, 2, 3, 4}\n                Strategy for simplex dual edge weights:\n                Dantzig / Devex / Steepest Edge. Corresponds\n                to the following:\n\n                    - ``0``: ``SIMPLEX_DUAL_EDGE_WEIGHT_STRATEGY_DANTZIG``\n                    - ``1``: ``SIMPLEX_DUAL_EDGE_WEIGHT_STRATEGY_DEVEX``\n                    - ``2``: ``SIMPLEX_DUAL_EDGE_WEIGHT_STRATEGY_STEEPEST_EDGE_TO_DEVEX_SWITCH``\n                    - ``3``: ``SIMPLEX_DUAL_EDGE_WEIGHT_STRATEGY_STEEPEST_EDGE``\n                    - ``4``: ``SIMPLEX_DUAL_EDGE_WEIGHT_STRATEGY_STEEPEST_EDGE_UNIT_INITIAL``\n\n            - simplex_initial_condition_check : bool\n                Undocumented advanced option.\n\n            - simplex_initial_condition_tolerance : double\n                Undocumented advanced option.\n\n            - simplex_iteration_limit : int\n                Iteration limit for simplex solver.\n\n            - simplex_permute_strategy : int\n                Undocumented advanced option.\n\n            - simplex_price_strategy : int\n                Undocumented advanced option.\n\n            - simplex_primal_edge_weight_strategy : int {0, 1}\n                Strategy for simplex primal edge weights:\n                Dantzig / Devex.  Corresponds to the following:\n\n                    - ``0``: ``SIMPLEX_PRIMAL_EDGE_WEIGHT_STRATEGY_DANTZIG``\n                    - ``1``: ``SIMPLEX_PRIMAL_EDGE_WEIGHT_STRATEGY_DEVEX``\n\n            - simplex_scale_strategy : int {0, 1, 2, 3, 4, 5}\n                Strategy for scaling before simplex solver:\n                off / on (0/1)\n\n                    - ``0``:  ``SIMPLEX_SCALE_STRATEGY_OFF``\n                    - ``1``: ``SIMPLEX_SCALE_STRATEGY_HIGHS``\n                    - ``2``: ``SIMPLEX_SCALE_STRATEGY_HIGHS_FORCED``\n                    - ``3``: ``SIMPLEX_SCALE_STRATEGY_HIGHS_015``\n                    - ``4``: ``SIMPLEX_SCALE_STRATEGY_HIGHS_0157``\n                    - ``5``: ``SIMPLEX_SCALE_STRATEGY_HSOL``\n\n            - simplex_strategy : int {0, 1, 2, 3, 4}\n                Strategy for simplex solver. Default: 1. Corresponds\n                to the following:\n\n                    - ``0``: ``SIMPLEX_STRATEGY_MIN``\n                    - ``1``: ``SIMPLEX_STRATEGY_DUAL``\n                    - ``2``: ``SIMPLEX_STRATEGY_DUAL_TASKS``\n                    - ``3``: ``SIMPLEX_STRATEGY_DUAL_MULTI``\n                    - ``4``: ``SIMPLEX_STRATEGY_PRIMAL``\n\n            - simplex_update_limit : int\n                Limit on the number of simplex UPDATE operations.\n\n            - small_matrix_value : double\n                Lower limit on abs(matrix entries): values smaller\n                than this will be treated as zero.\n\n            - solution_file : str\n                Solution file\n\n            - solver : str {'simplex', 'ipm'}\n                Choose which solver to use.  If ``solver='simplex'``\n                and ``parallel=True`` then PAMI will be used.\n\n            - time_limit : double\n                Max number of seconds to run the solver for.\n\n            - use_original_HFactor_logic : bool\n                Undocumented advanced option.\n\n            - write_solution_to_file : bool\n                Write the primal and dual solution to a file\n\n            - write_solution_pretty : bool\n                Write the primal and dual solution in a pretty\n                (human-readable) format\n\n        See [2]_ for a list of all non-advanced options.\n\n    Returns\n    -------\n    res : dict\n\n        If model_status is one of OPTIMAL,\n        REACHED_DUAL_OBJECTIVE_VALUE_UPPER_BOUND, REACHED_TIME_LIMIT,\n        REACHED_ITERATION_LIMIT:\n\n            - ``status`` : int\n                Model status code.\n\n            - ``message`` : str\n                Message corresponding to model status code.\n\n            - ``x`` : list\n                Solution variables.\n\n            - ``slack`` : list\n                Slack variables.\n\n            - ``lambda`` : list\n                Lagrange multipliers assoicated with the constraints\n                Ax = b.\n\n            - ``s`` : list\n                Lagrange multipliers associated with the constraints\n                x >= 0.\n\n            - ``fun``\n                Final objective value.\n\n            - ``simplex_nit`` : int\n                Number of iterations accomplished by the simplex\n                solver.\n\n            - ``ipm_nit`` : int\n                Number of iterations accomplished by the interior-\n                point solver.\n\n        If model_status is not one of the above:\n\n            - ``status`` : int\n                Model status code.\n\n            - ``message`` : str\n                Message corresponding to model status code.\n\n    Notes\n    -----\n    If ``options['write_solution_to_file']`` is ``True`` but\n    ``options['solution_file']`` is unset or ``''``, then the solution\n    will be printed to ``stdout``.\n\n    If any iteration limit is reached, no solution will be\n    available.\n\n    ``OptimizeWarning`` will be raised if any option value set by\n    the user is found to be incorrect.\n\n    References\n    ----------\n    .. [1] https://www.maths.ed.ac.uk/hall/HiGHS\n    .. [2] https://www.maths.ed.ac.uk/hall/HiGHS/HighsOptions.html\n    "
    ...

def warn(message, category, stacklevel, source) -> typing.Any:
    'Issue a warning, or maybe ignore it or raise an exception.'
    ...

def __getattr__(name) -> typing.Any:
    ...

