# Python: 3.8.2 (tags/v3.8.2:7b3ab59, Feb 25 2020, 23:03:10) [MSC v.1916 64 bit (AMD64)]
# Library: scipy, version: 1.6.2
# Module: scipy.special._ufuncs, version: unspecified
import typing
import builtins as _mod_builtins

__all__: list
__doc__: typing.Any
__file__: str
__name__: str
__package__: str
__test__: dict
def _cospi(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_cospi(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, do not use."
    ...

def _ellip_harm(x1, x2, x3, x4, x5, x6, x7, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_ellip_harm(x1, x2, x3, x4, x5, x6, x7, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, use `ellip_harm` instead."
    ...

def _factorial(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_factorial(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, do not use."
    ...

def _igam_fac(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_igam_fac(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, do not use."
    ...

def _kolmogc(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_kolmogc(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, do not use."
    ...

def _kolmogci(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_kolmogci(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, do not use."
    ...

def _kolmogp(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_kolmogp(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, do not use."
    ...

def _lambertw(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_lambertw(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, use `lambertw` instead."
    ...

def _lanczos_sum_expg_scaled(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_lanczos_sum_expg_scaled(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, do not use."
    ...

def _lgam1p(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_lgam1p(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, do not use."
    ...

def _log1pmx(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_log1pmx(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, do not use."
    ...

def _riemann_zeta(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_riemann_zeta(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, use `zeta` instead."
    ...

_sf_error_action_map: dict
_sf_error_code_map: dict
def _sf_error_test_function(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_sf_error_test_function(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nPrivate function; do not use."
    ...

def _sinpi(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_sinpi(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, do not use."
    ...

def _smirnovc(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_smirnovc(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\n_smirnovc(n, d)\n Internal function, do not use."
    ...

def _smirnovci(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_smirnovci(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, do not use."
    ...

def _smirnovp(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_smirnovp(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\n_smirnovp(n, p)\n Internal function, do not use."
    ...

def _spherical_in(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_spherical_in(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, use `spherical_in` instead."
    ...

def _spherical_in_d(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_spherical_in_d(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, use `spherical_in` instead."
    ...

def _spherical_jn(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_spherical_jn(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, use `spherical_jn` instead."
    ...

def _spherical_jn_d(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_spherical_jn_d(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, use `spherical_jn` instead."
    ...

def _spherical_kn(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_spherical_kn(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, use `spherical_kn` instead."
    ...

def _spherical_kn_d(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_spherical_kn_d(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, use `spherical_kn` instead."
    ...

def _spherical_yn(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_spherical_yn(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, use `spherical_yn` instead."
    ...

def _spherical_yn_d(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_spherical_yn_d(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInternal function, use `spherical_yn` instead."
    ...

def _struve_asymp_large_z(x1, x2, x3, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_struve_asymp_large_z(x1, x2, x3[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\n_struve_asymp_large_z(v, z, is_h)\n\nInternal function for testing `struve` & `modstruve`\n\nEvaluates using asymptotic expansion\n\nReturns\n-------\nv, err"
    ...

def _struve_bessel_series(x1, x2, x3, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_struve_bessel_series(x1, x2, x3[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\n_struve_bessel_series(v, z, is_h)\n\nInternal function for testing `struve` & `modstruve`\n\nEvaluates using Bessel function series\n\nReturns\n-------\nv, err"
    ...

def _struve_power_series(x1, x2, x3, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_struve_power_series(x1, x2, x3[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\n_struve_power_series(v, z, is_h)\n\nInternal function for testing `struve` & `modstruve`\n\nEvaluates using power series\n\nReturns\n-------\nv, err"
    ...

def _zeta(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "_zeta(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\n_zeta(x, q)\n\nInternal function, Hurwitz zeta."
    ...

def agm(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'agm(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nagm(a, b)\n\nCompute the arithmetic-geometric mean of `a` and `b`.\n\nStart with a_0 = a and b_0 = b and iteratively compute::\n\n    a_{n+1} = (a_n + b_n)/2\n    b_{n+1} = sqrt(a_n*b_n)\n\na_n and b_n converge to the same limit as n increases; their common\nlimit is agm(a, b).\n\nParameters\n----------\na, b : array_like\n    Real values only. If the values are both negative, the result\n    is negative. If one value is negative and the other is positive,\n    `nan` is returned.\n\nReturns\n-------\nfloat\n    The arithmetic-geometric mean of `a` and `b`.\n\nExamples\n--------\n>>> from scipy.special import agm\n>>> a, b = 24.0, 6.0\n>>> agm(a, b)\n13.458171481725614\n\nCompare that result to the iteration:\n\n>>> while a != b:\n...     a, b = (a + b)/2, np.sqrt(a*b)\n...     print("a = %19.16f  b=%19.16f" % (a, b))\n...\na = 15.0000000000000000  b=12.0000000000000000\na = 13.5000000000000000  b=13.4164078649987388\na = 13.4582039324993694  b=13.4581390309909850\na = 13.4581714817451772  b=13.4581714817060547\na = 13.4581714817256159  b=13.4581714817256159\n\nWhen array-like arguments are given, broadcasting applies:\n\n>>> a = np.array([[1.5], [3], [6]])  # a has shape (3, 1).\n>>> b = np.array([6, 12, 24, 48])    # b has shape (4,).\n>>> agm(a, b)\narray([[  3.36454287,   5.42363427,   9.05798751,  15.53650756],\n       [  4.37037309,   6.72908574,  10.84726853,  18.11597502],\n       [  6.        ,   8.74074619,  13.45817148,  21.69453707]])'
    ...

def airy(x, out1=..., out2=..., out3=..., out4=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'airy(x[, out1, out2, out3, out4], / [, out=(None, None, None, None)], *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nairy(z)\n\nAiry functions and their derivatives.\n\nParameters\n----------\nz : array_like\n    Real or complex argument.\n\nReturns\n-------\nAi, Aip, Bi, Bip : ndarrays\n    Airy functions Ai and Bi, and their derivatives Aip and Bip.\n\nNotes\n-----\nThe Airy functions Ai and Bi are two independent solutions of\n\n.. math:: y\'\'(x) = x y(x).\n\nFor real `z` in [-10, 10], the computation is carried out by calling\nthe Cephes [1]_ `airy` routine, which uses power series summation\nfor small `z` and rational minimax approximations for large `z`.\n\nOutside this range, the AMOS [2]_ `zairy` and `zbiry` routines are\nemployed.  They are computed using power series for :math:`|z| < 1` and\nthe following relations to modified Bessel functions for larger `z`\n(where :math:`t \\equiv 2 z^{3/2}/3`):\n\n.. math::\n\n    Ai(z) = \\frac{1}{\\pi \\sqrt{3}} K_{1/3}(t)\n\n    Ai\'(z) = -\\frac{z}{\\pi \\sqrt{3}} K_{2/3}(t)\n\n    Bi(z) = \\sqrt{\\frac{z}{3}} \\left(I_{-1/3}(t) + I_{1/3}(t) \\right)\n\n    Bi\'(z) = \\frac{z}{\\sqrt{3}} \\left(I_{-2/3}(t) + I_{2/3}(t)\\right)\n\nSee also\n--------\nairye : exponentially scaled Airy functions.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/\n.. [2] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/\n\nExamples\n--------\nCompute the Airy functions on the interval [-15, 5].\n\n>>> from scipy import special\n>>> x = np.linspace(-15, 5, 201)\n>>> ai, aip, bi, bip = special.airy(x)\n\nPlot Ai(x) and Bi(x).\n\n>>> import matplotlib.pyplot as plt\n>>> plt.plot(x, ai, \'r\', label=\'Ai(x)\')\n>>> plt.plot(x, bi, \'b--\', label=\'Bi(x)\')\n>>> plt.ylim(-0.5, 1.0)\n>>> plt.grid()\n>>> plt.legend(loc=\'upper left\')\n>>> plt.show()'
    ...

def airye(x, out1=..., out2=..., out3=..., out4=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'airye(x[, out1, out2, out3, out4], / [, out=(None, None, None, None)], *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nairye(z)\n\nExponentially scaled Airy functions and their derivatives.\n\nScaling::\n\n    eAi  = Ai  * exp(2.0/3.0*z*sqrt(z))\n    eAip = Aip * exp(2.0/3.0*z*sqrt(z))\n    eBi  = Bi  * exp(-abs(2.0/3.0*(z*sqrt(z)).real))\n    eBip = Bip * exp(-abs(2.0/3.0*(z*sqrt(z)).real))\n\nParameters\n----------\nz : array_like\n    Real or complex argument.\n\nReturns\n-------\neAi, eAip, eBi, eBip : array_like\n    Exponentially scaled Airy functions eAi and eBi, and their derivatives \n    eAip and eBip\n\nNotes\n-----\nWrapper for the AMOS [1]_ routines `zairy` and `zbiry`.\n\nSee also\n--------\nairy\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/\n\nExamples\n--------\nWe can compute exponentially scaled Airy functions and their derivatives:\n\n>>> from scipy.special import airye\n>>> import matplotlib.pyplot as plt\n>>> z = np.linspace(0, 50, 500)\n>>> eAi, eAip, eBi, eBip = airye(z)\n>>> f, ax = plt.subplots(2, 1, sharex=True)\n>>> for ind, data in enumerate([[eAi, eAip, ["eAi", "eAip"]],\n...                             [eBi, eBip, ["eBi", "eBip"]]]):\n...     ax[ind].plot(z, data[0], "-r", z, data[1], "-b")\n...     ax[ind].legend(data[2])\n...     ax[ind].grid(True)\n>>> plt.show()\n\nWe can compute these using usual non-scaled Airy functions by:\n\n>>> from scipy.special import airy\n>>> Ai, Aip, Bi, Bip = airy(z)\n>>> np.allclose(eAi, Ai * np.exp(2.0 / 3.0 * z * np.sqrt(z)))\nTrue\n>>> np.allclose(eAip, Aip * np.exp(2.0 / 3.0 * z * np.sqrt(z)))\nTrue\n>>> np.allclose(eBi, Bi * np.exp(-abs(np.real(2.0 / 3.0 * z * np.sqrt(z)))))\nTrue\n>>> np.allclose(eBip, Bip * np.exp(-abs(np.real(2.0 / 3.0 * z * np.sqrt(z)))))\nTrue\n\nComparing non-scaled and exponentially scaled ones, the usual non-scaled \nfunction quickly underflows for large values, whereas the exponentially\nscaled function does not.\n\n>>> airy(200)\n(0.0, 0.0, nan, nan)\n>>> airye(200)\n(0.07501041684381093, -1.0609012305109042, 0.15003188417418148, 2.1215836725571093)'
    ...

def bdtr(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "bdtr(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbdtr(k, n, p)\n\nBinomial distribution cumulative distribution function.\n\nSum of the terms 0 through `floor(k)` of the Binomial probability density.\n\n.. math::\n    \\mathrm{bdtr}(k, n, p) = \\sum_{j=0}^{\\lfloor k \\rfloor} {{n}\\choose{j}} p^j (1-p)^{n-j}\n\nParameters\n----------\nk : array_like\n    Number of successes (double), rounded down to the nearest integer.\nn : array_like\n    Number of events (int).\np : array_like\n    Probability of success in a single event (float).\n\nReturns\n-------\ny : ndarray\n    Probability of `floor(k)` or fewer successes in `n` independent events with\n    success probabilities of `p`.\n\nNotes\n-----\nThe terms are not summed directly; instead the regularized incomplete beta\nfunction is employed, according to the formula,\n\n.. math::\n    \\mathrm{bdtr}(k, n, p) = I_{1 - p}(n - \\lfloor k \\rfloor, \\lfloor k \\rfloor + 1).\n\nWrapper for the Cephes [1]_ routine `bdtr`.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def bdtrc(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "bdtrc(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbdtrc(k, n, p)\n\nBinomial distribution survival function.\n\nSum of the terms `floor(k) + 1` through `n` of the binomial probability\ndensity,\n\n.. math::\n    \\mathrm{bdtrc}(k, n, p) = \\sum_{j=\\lfloor k \\rfloor +1}^n {{n}\\choose{j}} p^j (1-p)^{n-j}\n\nParameters\n----------\nk : array_like\n    Number of successes (double), rounded down to nearest integer.\nn : array_like\n    Number of events (int)\np : array_like\n    Probability of success in a single event.\n\nReturns\n-------\ny : ndarray\n    Probability of `floor(k) + 1` or more successes in `n` independent\n    events with success probabilities of `p`.\n\nSee also\n--------\nbdtr\nbetainc\n\nNotes\n-----\nThe terms are not summed directly; instead the regularized incomplete beta\nfunction is employed, according to the formula,\n\n.. math::\n    \\mathrm{bdtrc}(k, n, p) = I_{p}(\\lfloor k \\rfloor + 1, n - \\lfloor k \\rfloor).\n\nWrapper for the Cephes [1]_ routine `bdtrc`.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def bdtri(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "bdtri(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbdtri(k, n, y)\n\nInverse function to `bdtr` with respect to `p`.\n\nFinds the event probability `p` such that the sum of the terms 0 through\n`k` of the binomial probability density is equal to the given cumulative\nprobability `y`.\n\nParameters\n----------\nk : array_like\n    Number of successes (float), rounded down to the nearest integer.\nn : array_like\n    Number of events (float)\ny : array_like\n    Cumulative probability (probability of `k` or fewer successes in `n`\n    events).\n\nReturns\n-------\np : ndarray\n    The event probability such that `bdtr(\\lfloor k \\rfloor, n, p) = y`.\n\nSee also\n--------\nbdtr\nbetaincinv\n\nNotes\n-----\nThe computation is carried out using the inverse beta integral function\nand the relation,::\n\n    1 - p = betaincinv(n - k, k + 1, y).\n\nWrapper for the Cephes [1]_ routine `bdtri`.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def bdtrik(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "bdtrik(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbdtrik(y, n, p)\n\nInverse function to `bdtr` with respect to `k`.\n\nFinds the number of successes `k` such that the sum of the terms 0 through\n`k` of the Binomial probability density for `n` events with probability\n`p` is equal to the given cumulative probability `y`.\n\nParameters\n----------\ny : array_like\n    Cumulative probability (probability of `k` or fewer successes in `n`\n    events).\nn : array_like\n    Number of events (float).\np : array_like\n    Success probability (float).\n\nReturns\n-------\nk : ndarray\n    The number of successes `k` such that `bdtr(k, n, p) = y`.\n\nSee also\n--------\nbdtr\n\nNotes\n-----\nFormula 26.5.24 of [1]_ is used to reduce the binomial distribution to the\ncumulative incomplete beta distribution.\n\nComputation of `k` involves a search for a value that produces the desired\nvalue of `y`. The search relies on the monotonicity of `y` with `k`.\n\nWrapper for the CDFLIB [2]_ Fortran routine `cdfbin`.\n\nReferences\n----------\n.. [1] Milton Abramowitz and Irene A. Stegun, eds.\n       Handbook of Mathematical Functions with Formulas,\n       Graphs, and Mathematical Tables. New York: Dover, 1972.\n.. [2] Barry Brown, James Lovato, and Kathy Russell,\n       CDFLIB: Library of Fortran Routines for Cumulative Distribution\n       Functions, Inverses, and Other Parameters."
    ...

def bdtrin(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "bdtrin(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbdtrin(k, y, p)\n\nInverse function to `bdtr` with respect to `n`.\n\nFinds the number of events `n` such that the sum of the terms 0 through\n`k` of the Binomial probability density for events with probability `p` is\nequal to the given cumulative probability `y`.\n\nParameters\n----------\nk : array_like\n    Number of successes (float).\ny : array_like\n    Cumulative probability (probability of `k` or fewer successes in `n`\n    events).\np : array_like\n    Success probability (float).\n\nReturns\n-------\nn : ndarray\n    The number of events `n` such that `bdtr(k, n, p) = y`.\n\nSee also\n--------\nbdtr\n\nNotes\n-----\nFormula 26.5.24 of [1]_ is used to reduce the binomial distribution to the\ncumulative incomplete beta distribution.\n\nComputation of `n` involves a search for a value that produces the desired\nvalue of `y`. The search relies on the monotonicity of `y` with `n`.\n\nWrapper for the CDFLIB [2]_ Fortran routine `cdfbin`.\n\nReferences\n----------\n.. [1] Milton Abramowitz and Irene A. Stegun, eds.\n       Handbook of Mathematical Functions with Formulas,\n       Graphs, and Mathematical Tables. New York: Dover, 1972.\n.. [2] Barry Brown, James Lovato, and Kathy Russell,\n       CDFLIB: Library of Fortran Routines for Cumulative Distribution\n       Functions, Inverses, and Other Parameters."
    ...

def bei(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "bei(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbei(x, out=None)\n\nKelvin function bei.\n\nDefined as\n\n.. math::\n\n    \\mathrm{bei}(x) = \\Im[J_0(x e^{3 \\pi i / 4})]\n\nwhere :math:`J_0` is the Bessel function of the first kind of\norder zero (see `jv`). See [dlmf]_ for more details.\n\nParameters\n----------\nx : array_like\n    Real argument.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Values of the Kelvin function.\n\nSee Also\n--------\nber : the corresponding real part\nbeip : the derivative of bei\njv : Bessel function of the first kind\n\nReferences\n----------\n.. [dlmf] NIST, Digital Library of Mathematical Functions,\n    https://dlmf.nist.gov/10.61\n\nExamples\n--------\nIt can be expressed using Bessel functions.\n\n>>> import scipy.special as sc\n>>> x = np.array([1.0, 2.0, 3.0, 4.0])\n>>> sc.jv(0, x * np.exp(3 * np.pi * 1j / 4)).imag\narray([0.24956604, 0.97229163, 1.93758679, 2.29269032])\n>>> sc.bei(x)\narray([0.24956604, 0.97229163, 1.93758679, 2.29269032])"
    ...

def beip(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "beip(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbeip(x, out=None)\n\nDerivative of the Kelvin function bei.\n\nParameters\n----------\nx : array_like\n    Real argument.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    The values of the derivative of bei.\n\nSee Also\n--------\nbei\n\nReferences\n----------\n.. [dlmf] NIST, Digital Library of Mathematical Functions,\n    https://dlmf.nist.gov/10#PT5"
    ...

def ber(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ber(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nber(x, out=None)\n\nKelvin function ber.\n\nDefined as\n\n.. math::\n\n    \\mathrm{ber}(x) = \\Re[J_0(x e^{3 \\pi i / 4})]\n\nwhere :math:`J_0` is the Bessel function of the first kind of\norder zero (see `jv`). See [dlmf]_ for more details.\n\nParameters\n----------\nx : array_like\n    Real argument.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Values of the Kelvin function.\n\nSee Also\n--------\nbei : the corresponding real part\nberp : the derivative of bei\njv : Bessel function of the first kind\n\nReferences\n----------\n.. [dlmf] NIST, Digital Library of Mathematical Functions,\n    https://dlmf.nist.gov/10.61\n\nExamples\n--------\nIt can be expressed using Bessel functions.\n\n>>> import scipy.special as sc\n>>> x = np.array([1.0, 2.0, 3.0, 4.0])\n>>> sc.jv(0, x * np.exp(3 * np.pi * 1j / 4)).real\narray([ 0.98438178,  0.75173418, -0.22138025, -2.56341656])\n>>> sc.ber(x)\narray([ 0.98438178,  0.75173418, -0.22138025, -2.56341656])"
    ...

def berp(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "berp(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nberp(x, out=None)\n\nDerivative of the Kelvin function ber.\n\nParameters\n----------\nx : array_like\n    Real argument.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    The values of the derivative of ber.\n\nSee Also\n--------\nber\n\nReferences\n----------\n.. [dlmf] NIST, Digital Library of Mathematical Functions,\n    https://dlmf.nist.gov/10#PT5"
    ...

def besselpoly(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "besselpoly(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbesselpoly(a, lmb, nu, out=None)\n\nWeighted integral of the Bessel function of the first kind.\n\nComputes\n\n.. math::\n\n   \\int_0^1 x^\\lambda J_\\nu(2 a x) \\, dx\n\nwhere :math:`J_\\nu` is a Bessel function and :math:`\\lambda=lmb`,\n:math:`\\nu=nu`.\n\nParameters\n----------\na : array_like\n    Scale factor inside the Bessel function.\nlmb : array_like\n    Power of `x`\nnu : array_like\n    Order of the Bessel function.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Value of the integral."
    ...

def beta(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "beta(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbeta(a, b, out=None)\n\nBeta function.\n\nThis function is defined in [1]_ as\n\n.. math::\n\n    B(a, b) = \\int_0^1 t^{a-1}(1-t)^{b-1}dt\n            = \\frac{\\Gamma(a)\\Gamma(b)}{\\Gamma(a+b)},\n\nwhere :math:`\\Gamma` is the gamma function.\n\nParameters\n----------\na, b : array-like\n    Real-valued arguments\nout : ndarray, optional\n    Optional output array for the function result\n\nReturns\n-------\nscalar or ndarray\n    Value of the beta function\n\nSee Also\n--------\ngamma : the gamma function\nbetainc :  the incomplete beta function\nbetaln : the natural logarithm of the absolute\n         value of the beta function\n\nReferences\n----------\n.. [1] NIST Digital Library of Mathematical Functions,\n       Eq. 5.12.1. https://dlmf.nist.gov/5.12\n\nExamples\n--------\n>>> import scipy.special as sc\n\nThe beta function relates to the gamma function by the\ndefinition given above:\n\n>>> sc.beta(2, 3)\n0.08333333333333333\n>>> sc.gamma(2)*sc.gamma(3)/sc.gamma(2 + 3)\n0.08333333333333333\n\nAs this relationship demonstrates, the beta function\nis symmetric:\n\n>>> sc.beta(1.7, 2.4)\n0.16567527689031739\n>>> sc.beta(2.4, 1.7)\n0.16567527689031739\n\nThis function satisfies :math:`B(1, b) = 1/b`:\n\n>>> sc.beta(1, 4)\n0.25"
    ...

def betainc(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "betainc(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbetainc(a, b, x, out=None)\n\nIncomplete beta function.\n\nComputes the incomplete beta function, defined as [1]_:\n\n.. math::\n\n    I_x(a, b) = \\frac{\\Gamma(a+b)}{\\Gamma(a)\\Gamma(b)} \\int_0^x\n    t^{a-1}(1-t)^{b-1}dt,\n\nfor :math:`0 \\leq x \\leq 1`.\n\nParameters\n----------\na, b : array-like\n       Positive, real-valued parameters\nx : array-like\n    Real-valued such that :math:`0 \\leq x \\leq 1`,\n    the upper limit of integration\nout : ndarray, optional\n    Optional output array for the function values\n\nReturns\n-------\narray-like\n    Value of the incomplete beta function\n\nSee Also\n--------\nbeta : beta function\nbetaincinv : inverse of the incomplete beta function\n\nNotes\n-----\nThe incomplete beta function is also sometimes defined\nwithout the `gamma` terms, in which case the above\ndefinition is the so-called regularized incomplete beta\nfunction. Under this definition, you can get the incomplete\nbeta function by multiplying the result of the SciPy\nfunction by `beta`.\n\nReferences\n----------\n.. [1] NIST Digital Library of Mathematical Functions\n       https://dlmf.nist.gov/8.17\n\nExamples\n--------\n\nLet :math:`B(a, b)` be the `beta` function.\n\n>>> import scipy.special as sc\n\nThe coefficient in terms of `gamma` is equal to\n:math:`1/B(a, b)`. Also, when :math:`x=1`\nthe integral is equal to :math:`B(a, b)`.\nTherefore, :math:`I_{x=1}(a, b) = 1` for any :math:`a, b`.\n\n>>> sc.betainc(0.2, 3.5, 1.0)\n1.0\n\nIt satisfies\n:math:`I_x(a, b) = x^a F(a, 1-b, a+1, x)/ (aB(a, b))`,\nwhere :math:`F` is the hypergeometric function `hyp2f1`:\n\n>>> a, b, x = 1.4, 3.1, 0.5\n>>> x**a * sc.hyp2f1(a, 1 - b, a + 1, x)/(a * sc.beta(a, b))\n0.8148904036225295\n>>> sc.betainc(a, b, x)\n0.8148904036225296\n\nThis functions satisfies the relationship\n:math:`I_x(a, b) = 1 - I_{1-x}(b, a)`:\n\n>>> sc.betainc(2.2, 3.1, 0.4)\n0.49339638807619446\n>>> 1 - sc.betainc(3.1, 2.2, 1 - 0.4)\n0.49339638807619446"
    ...

def betaincinv(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "betaincinv(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbetaincinv(a, b, y, out=None)\n\nInverse of the incomplete beta function.\n\nComputes :math:`x` such that:\n\n.. math::\n\n    y = I_x(a, b) = \\frac{\\Gamma(a+b)}{\\Gamma(a)\\Gamma(b)}\n    \\int_0^x t^{a-1}(1-t)^{b-1}dt,\n\nwhere :math:`I_x` is the normalized incomplete beta\nfunction `betainc` and\n:math:`\\Gamma` is the `gamma` function [1]_.\n\nParameters\n----------\na, b : array-like\n    Positive, real-valued parameters\ny : array-like\n    Real-valued input\nout : ndarray, optional\n    Optional output array for function values\n\nReturns\n-------\narray-like\n    Value of the inverse of the incomplete beta function\n\nSee Also\n--------\nbetainc : incomplete beta function\ngamma : gamma function\n\nReferences\n----------\n.. [1] NIST Digital Library of Mathematical Functions\n       https://dlmf.nist.gov/8.17\n\nExamples\n--------\n>>> import scipy.special as sc\n\nThis function is the inverse of `betainc` for fixed\nvalues of :math:`a` and :math:`b`.\n\n>>> a, b = 1.2, 3.1\n>>> y = sc.betainc(a, b, 0.2)\n>>> sc.betaincinv(a, b, y)\n0.2\n>>>\n>>> a, b = 7.5, 0.4\n>>> x = sc.betaincinv(a, b, 0.5)\n>>> sc.betainc(a, b, x)\n0.5"
    ...

def betaln(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "betaln(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbetaln(a, b)\n\nNatural logarithm of absolute value of beta function.\n\nComputes ``ln(abs(beta(a, b)))``."
    ...

def binom(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "binom(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbinom(n, k)\n\nBinomial coefficient\n\nSee Also\n--------\ncomb : The number of combinations of N things taken k at a time."
    ...

def boxcox(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "boxcox(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nboxcox(x, lmbda)\n\nCompute the Box-Cox transformation.\n\nThe Box-Cox transformation is::\n\n    y = (x**lmbda - 1) / lmbda  if lmbda != 0\n        log(x)                  if lmbda == 0\n\nReturns `nan` if ``x < 0``.\nReturns `-inf` if ``x == 0`` and ``lmbda < 0``.\n\nParameters\n----------\nx : array_like\n    Data to be transformed.\nlmbda : array_like\n    Power parameter of the Box-Cox transform.\n\nReturns\n-------\ny : array\n    Transformed data.\n\nNotes\n-----\n\n.. versionadded:: 0.14.0\n\nExamples\n--------\n>>> from scipy.special import boxcox\n>>> boxcox([1, 4, 10], 2.5)\narray([   0.        ,   12.4       ,  126.09110641])\n>>> boxcox(2, [0, 1, 2])\narray([ 0.69314718,  1.        ,  1.5       ])"
    ...

def boxcox1p(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "boxcox1p(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nboxcox1p(x, lmbda)\n\nCompute the Box-Cox transformation of 1 + `x`.\n\nThe Box-Cox transformation computed by `boxcox1p` is::\n\n    y = ((1+x)**lmbda - 1) / lmbda  if lmbda != 0\n        log(1+x)                    if lmbda == 0\n\nReturns `nan` if ``x < -1``.\nReturns `-inf` if ``x == -1`` and ``lmbda < 0``.\n\nParameters\n----------\nx : array_like\n    Data to be transformed.\nlmbda : array_like\n    Power parameter of the Box-Cox transform.\n\nReturns\n-------\ny : array\n    Transformed data.\n\nNotes\n-----\n\n.. versionadded:: 0.14.0\n\nExamples\n--------\n>>> from scipy.special import boxcox1p\n>>> boxcox1p(1e-4, [0, 0.5, 1])\narray([  9.99950003e-05,   9.99975001e-05,   1.00000000e-04])\n>>> boxcox1p([0.01, 0.1], 0.25)\narray([ 0.00996272,  0.09645476])"
    ...

def btdtr(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "btdtr(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbtdtr(a, b, x)\n\nCumulative distribution function of the beta distribution.\n\nReturns the integral from zero to `x` of the beta probability density\nfunction,\n\n.. math::\n    I = \\int_0^x \\frac{\\Gamma(a + b)}{\\Gamma(a)\\Gamma(b)} t^{a-1} (1-t)^{b-1}\\,dt\n\nwhere :math:`\\Gamma` is the gamma function.\n\nParameters\n----------\na : array_like\n    Shape parameter (a > 0).\nb : array_like\n    Shape parameter (b > 0).\nx : array_like\n    Upper limit of integration, in [0, 1].\n\nReturns\n-------\nI : ndarray\n    Cumulative distribution function of the beta distribution with\n    parameters `a` and `b` at `x`.\n\nSee Also\n--------\nbetainc\n\nNotes\n-----\nThis function is identical to the incomplete beta integral function\n`betainc`.\n\nWrapper for the Cephes [1]_ routine `btdtr`.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def btdtri(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "btdtri(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbtdtri(a, b, p)\n\nThe `p`-th quantile of the beta distribution.\n\nThis function is the inverse of the beta cumulative distribution function,\n`btdtr`, returning the value of `x` for which `btdtr(a, b, x) = p`, or\n\n.. math::\n    p = \\int_0^x \\frac{\\Gamma(a + b)}{\\Gamma(a)\\Gamma(b)} t^{a-1} (1-t)^{b-1}\\,dt\n\nParameters\n----------\na : array_like\n    Shape parameter (`a` > 0).\nb : array_like\n    Shape parameter (`b` > 0).\np : array_like\n    Cumulative probability, in [0, 1].\n\nReturns\n-------\nx : ndarray\n    The quantile corresponding to `p`.\n\nSee Also\n--------\nbetaincinv\nbtdtr\n\nNotes\n-----\nThe value of `x` is found by interval halving or Newton iterations.\n\nWrapper for the Cephes [1]_ routine `incbi`, which solves the equivalent\nproblem of finding the inverse of the incomplete beta integral.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def btdtria(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "btdtria(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbtdtria(p, b, x)\n\nInverse of `btdtr` with respect to `a`.\n\nThis is the inverse of the beta cumulative distribution function, `btdtr`,\nconsidered as a function of `a`, returning the value of `a` for which\n`btdtr(a, b, x) = p`, or\n\n.. math::\n    p = \\int_0^x \\frac{\\Gamma(a + b)}{\\Gamma(a)\\Gamma(b)} t^{a-1} (1-t)^{b-1}\\,dt\n\nParameters\n----------\np : array_like\n    Cumulative probability, in [0, 1].\nb : array_like\n    Shape parameter (`b` > 0).\nx : array_like\n    The quantile, in [0, 1].\n\nReturns\n-------\na : ndarray\n    The value of the shape parameter `a` such that `btdtr(a, b, x) = p`.\n\nSee Also\n--------\nbtdtr : Cumulative distribution function of the beta distribution.\nbtdtri : Inverse with respect to `x`.\nbtdtrib : Inverse with respect to `b`.\n\nNotes\n-----\nWrapper for the CDFLIB [1]_ Fortran routine `cdfbet`.\n\nThe cumulative distribution function `p` is computed using a routine by\nDiDinato and Morris [2]_. Computation of `a` involves a search for a value\nthat produces the desired value of `p`. The search relies on the\nmonotonicity of `p` with `a`.\n\nReferences\n----------\n.. [1] Barry Brown, James Lovato, and Kathy Russell,\n       CDFLIB: Library of Fortran Routines for Cumulative Distribution\n       Functions, Inverses, and Other Parameters.\n.. [2] DiDinato, A. R. and Morris, A. H.,\n       Algorithm 708: Significant Digit Computation of the Incomplete Beta\n       Function Ratios. ACM Trans. Math. Softw. 18 (1993), 360-373."
    ...

def btdtrib(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "btdtrib(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nbtdtria(a, p, x)\n\nInverse of `btdtr` with respect to `b`.\n\nThis is the inverse of the beta cumulative distribution function, `btdtr`,\nconsidered as a function of `b`, returning the value of `b` for which\n`btdtr(a, b, x) = p`, or\n\n.. math::\n    p = \\int_0^x \\frac{\\Gamma(a + b)}{\\Gamma(a)\\Gamma(b)} t^{a-1} (1-t)^{b-1}\\,dt\n\nParameters\n----------\na : array_like\n    Shape parameter (`a` > 0).\np : array_like\n    Cumulative probability, in [0, 1].\nx : array_like\n    The quantile, in [0, 1].\n\nReturns\n-------\nb : ndarray\n    The value of the shape parameter `b` such that `btdtr(a, b, x) = p`.\n\nSee Also\n--------\nbtdtr : Cumulative distribution function of the beta distribution.\nbtdtri : Inverse with respect to `x`.\nbtdtria : Inverse with respect to `a`.\n\nNotes\n-----\nWrapper for the CDFLIB [1]_ Fortran routine `cdfbet`.\n\nThe cumulative distribution function `p` is computed using a routine by\nDiDinato and Morris [2]_. Computation of `b` involves a search for a value\nthat produces the desired value of `p`. The search relies on the\nmonotonicity of `p` with `b`.\n\nReferences\n----------\n.. [1] Barry Brown, James Lovato, and Kathy Russell,\n       CDFLIB: Library of Fortran Routines for Cumulative Distribution\n       Functions, Inverses, and Other Parameters.\n.. [2] DiDinato, A. R. and Morris, A. H.,\n       Algorithm 708: Significant Digit Computation of the Incomplete Beta\n       Function Ratios. ACM Trans. Math. Softw. 18 (1993), 360-373."
    ...

def cbrt(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "cbrt(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ncbrt(x)\n\nElement-wise cube root of `x`.\n\nParameters\n----------\nx : array_like\n    `x` must contain real numbers.\n\nReturns\n-------\nfloat\n    The cube root of each value in `x`.\n\nExamples\n--------\n>>> from scipy.special import cbrt\n\n>>> cbrt(8)\n2.0\n>>> cbrt([-8, -3, 0.125, 1.331])\narray([-2.        , -1.44224957,  0.5       ,  1.1       ])"
    ...

def chdtr(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "chdtr(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nchdtr(v, x, out=None)\n\nChi square cumulative distribution function.\n\nReturns the area under the left tail (from 0 to `x`) of the Chi\nsquare probability density function with `v` degrees of freedom:\n\n.. math::\n\n    \\frac{1}{2^{v/2} \\Gamma(v/2)} \\int_0^x t^{v/2 - 1} e^{-t/2} dt\n\nHere :math:`\\Gamma` is the Gamma function; see `gamma`. This\nintegral can be expressed in terms of the regularized lower\nincomplete gamma function `gammainc` as\n``gammainc(v / 2, x / 2)``. [1]_\n\nParameters\n----------\nv : array_like\n    Degrees of freedom.\nx : array_like\n    Upper bound of the integral.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Values of the cumulative distribution function.\n\nSee Also\n--------\nchdtrc, chdtri, chdtriv, gammainc\n\nReferences\n----------\n.. [1] Chi-Square distribution,\n    https://www.itl.nist.gov/div898/handbook/eda/section3/eda3666.htm\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt can be expressed in terms of the regularized lower incomplete\ngamma function.\n\n>>> v = 1\n>>> x = np.arange(4)\n>>> sc.chdtr(v, x)\narray([0.        , 0.68268949, 0.84270079, 0.91673548])\n>>> sc.gammainc(v / 2, x / 2)\narray([0.        , 0.68268949, 0.84270079, 0.91673548])"
    ...

def chdtrc(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "chdtrc(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nchdtrc(v, x, out=None)\n\nChi square survival function.\n\nReturns the area under the right hand tail (from `x` to infinity)\nof the Chi square probability density function with `v` degrees of\nfreedom:\n\n.. math::\n\n    \\frac{1}{2^{v/2} \\Gamma(v/2)} \\int_x^\\infty t^{v/2 - 1} e^{-t/2} dt\n\nHere :math:`\\Gamma` is the Gamma function; see `gamma`. This\nintegral can be expressed in terms of the regularized upper\nincomplete gamma function `gammaincc` as\n``gammaincc(v / 2, x / 2)``. [1]_\n\nParameters\n----------\nv : array_like\n    Degrees of freedom.\nx : array_like\n    Lower bound of the integral.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Values of the survival function.\n\nSee Also\n--------\nchdtr, chdtri, chdtriv, gammaincc\n\nReferences\n----------\n.. [1] Chi-Square distribution,\n    https://www.itl.nist.gov/div898/handbook/eda/section3/eda3666.htm\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt can be expressed in terms of the regularized upper incomplete\ngamma function.\n\n>>> v = 1\n>>> x = np.arange(4)\n>>> sc.chdtrc(v, x)\narray([1.        , 0.31731051, 0.15729921, 0.08326452])\n>>> sc.gammaincc(v / 2, x / 2)\narray([1.        , 0.31731051, 0.15729921, 0.08326452])"
    ...

def chdtri(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "chdtri(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nchdtri(v, p, out=None)\n\nInverse to `chdtrc` with respect to `x`.\n\nReturns `x` such that ``chdtrc(v, x) == p``.\n\nParameters\n----------\nv : array_like\n    Degrees of freedom.\np : array_like\n    Probability.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nx : scalar or ndarray\n    Value so that the probability a Chi square random variable\n    with `v` degrees of freedom is greater than `x` equals `p`.\n\nSee Also\n--------\nchdtrc, chdtr, chdtriv\n\nReferences\n----------\n.. [1] Chi-Square distribution,\n    https://www.itl.nist.gov/div898/handbook/eda/section3/eda3666.htm\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt inverts `chdtrc`.\n\n>>> v, p = 1, 0.3\n>>> sc.chdtrc(v, sc.chdtri(v, p))\n0.3\n>>> x = 1\n>>> sc.chdtri(v, sc.chdtrc(v, x))\n1.0"
    ...

def chdtriv(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "chdtriv(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nchdtriv(p, x, out=None)\n\nInverse to `chdtr` with respect to `v`.\n\nReturns `v` such that ``chdtr(v, x) == p``.\n\nParameters\n----------\np : array_like\n    Probability that the Chi square random variable is less than\n    or equal to `x`.\nx : array_like\n    Nonnegative input.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Degrees of freedom.\n\nSee Also\n--------\nchdtr, chdtrc, chdtri\n\nReferences\n----------\n.. [1] Chi-Square distribution,\n    https://www.itl.nist.gov/div898/handbook/eda/section3/eda3666.htm\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt inverts `chdtr`.\n\n>>> p, x = 0.5, 1\n>>> sc.chdtr(sc.chdtriv(p, x), x)\n0.5000000000202172\n>>> v = 1\n>>> sc.chdtriv(sc.chdtr(v, x), v)\n1.0000000000000013"
    ...

def chndtr(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "chndtr(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nchndtr(x, df, nc)\n\nNon-central chi square cumulative distribution function"
    ...

def chndtridf(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "chndtridf(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nchndtridf(x, p, nc)\n\nInverse to `chndtr` vs `df`"
    ...

def chndtrinc(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "chndtrinc(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nchndtrinc(x, df, p)\n\nInverse to `chndtr` vs `nc`"
    ...

def chndtrix(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "chndtrix(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nchndtrix(p, df, nc)\n\nInverse to `chndtr` vs `x`"
    ...

def cosdg(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "cosdg(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ncosdg(x, out=None)\n\nCosine of the angle `x` given in degrees.\n\nParameters\n----------\nx : array_like\n    Angle, given in degrees.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Cosine of the input.\n\nSee Also\n--------\nsindg, tandg, cotdg\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is more accurate than using cosine directly.\n\n>>> x = 90 + 180 * np.arange(3)\n>>> sc.cosdg(x)\narray([-0.,  0., -0.])\n>>> np.cos(x * np.pi / 180)\narray([ 6.1232340e-17, -1.8369702e-16,  3.0616170e-16])"
    ...

def cosm1(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "cosm1(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ncosm1(x, out=None)\n\ncos(x) - 1 for use when `x` is near zero.\n\nParameters\n----------\nx : array_like\n    Real valued argument.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Values of ``cos(x) - 1``.\n\nSee Also\n--------\nexpm1, log1p\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is more accurate than computing ``cos(x) - 1`` directly for\n``x`` around 0.\n\n>>> x = 1e-30\n>>> np.cos(x) - 1\n0.0\n>>> sc.cosm1(x)\n-5.0000000000000005e-61"
    ...

def cotdg(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "cotdg(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ncotdg(x, out=None)\n\nCotangent of the angle `x` given in degrees.\n\nParameters\n----------\nx : array_like\n    Angle, given in degrees.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Cotangent at the input.\n\nSee Also\n--------\nsindg, cosdg, tandg\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is more accurate than using cotangent directly.\n\n>>> x = 90 + 180 * np.arange(3)\n>>> sc.cotdg(x)\narray([0., 0., 0.])\n>>> 1 / np.tan(x * np.pi / 180)\narray([6.1232340e-17, 1.8369702e-16, 3.0616170e-16])"
    ...

def dawsn(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "dawsn(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ndawsn(x)\n\nDawson's integral.\n\nComputes::\n\n    exp(-x**2) * integral(exp(t**2), t=0..x).\n\nSee Also\n--------\nwofz, erf, erfc, erfcx, erfi\n\nReferences\n----------\n.. [1] Steven G. Johnson, Faddeeva W function implementation.\n   http://ab-initio.mit.edu/Faddeeva\n\nExamples\n--------\n>>> from scipy import special\n>>> import matplotlib.pyplot as plt\n>>> x = np.linspace(-15, 15, num=1000)\n>>> plt.plot(x, special.dawsn(x))\n>>> plt.xlabel('$x$')\n>>> plt.ylabel('$dawsn(x)$')\n>>> plt.show()"
    ...

def ellipe(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ellipe(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nellipe(m)\n\nComplete elliptic integral of the second kind\n\nThis function is defined as\n\n.. math:: E(m) = \\int_0^{\\pi/2} [1 - m \\sin(t)^2]^{1/2} dt\n\nParameters\n----------\nm : array_like\n    Defines the parameter of the elliptic integral.\n\nReturns\n-------\nE : ndarray\n    Value of the elliptic integral.\n\nNotes\n-----\nWrapper for the Cephes [1]_ routine `ellpe`.\n\nFor `m > 0` the computation uses the approximation,\n\n.. math:: E(m) \\approx P(1-m) - (1-m) \\log(1-m) Q(1-m),\n\nwhere :math:`P` and :math:`Q` are tenth-order polynomials.  For\n`m < 0`, the relation\n\n.. math:: E(m) = E(m/(m - 1)) \\sqrt(1-m)\n\nis used.\n\nThe parameterization in terms of :math:`m` follows that of section\n17.2 in [2]_. Other parameterizations in terms of the\ncomplementary parameter :math:`1 - m`, modular angle\n:math:`\\sin^2(\\alpha) = m`, or modulus :math:`k^2 = m` are also\nused, so be careful that you choose the correct parameter.\n\nSee Also\n--------\nellipkm1 : Complete elliptic integral of the first kind, near `m` = 1\nellipk : Complete elliptic integral of the first kind\nellipkinc : Incomplete elliptic integral of the first kind\nellipeinc : Incomplete elliptic integral of the second kind\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/\n.. [2] Milton Abramowitz and Irene A. Stegun, eds.\n       Handbook of Mathematical Functions with Formulas,\n       Graphs, and Mathematical Tables. New York: Dover, 1972.\n\nExamples\n--------\nThis function is used in finding the circumference of an\nellipse with semi-major axis `a` and semi-minor axis `b`.\n\n>>> from scipy import special\n\n>>> a = 3.5\n>>> b = 2.1\n>>> e_sq = 1.0 - b**2/a**2  # eccentricity squared\n\nThen the circumference is found using the following:\n\n>>> C = 4*a*special.ellipe(e_sq)  # circumference formula\n>>> C\n17.868899204378693\n\nWhen `a` and `b` are the same (meaning eccentricity is 0),\nthis reduces to the circumference of a circle.\n\n>>> 4*a*special.ellipe(0.0)  # formula for ellipse with a = b\n21.991148575128552\n>>> 2*np.pi*a  # formula for circle of radius a\n21.991148575128552"
    ...

def ellipeinc(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ellipeinc(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nellipeinc(phi, m)\n\nIncomplete elliptic integral of the second kind\n\nThis function is defined as\n\n.. math:: E(\\phi, m) = \\int_0^{\\phi} [1 - m \\sin(t)^2]^{1/2} dt\n\nParameters\n----------\nphi : array_like\n    amplitude of the elliptic integral.\n\nm : array_like\n    parameter of the elliptic integral.\n\nReturns\n-------\nE : ndarray\n    Value of the elliptic integral.\n\nNotes\n-----\nWrapper for the Cephes [1]_ routine `ellie`.\n\nComputation uses arithmetic-geometric means algorithm.\n\nThe parameterization in terms of :math:`m` follows that of section\n17.2 in [2]_. Other parameterizations in terms of the\ncomplementary parameter :math:`1 - m`, modular angle\n:math:`\\sin^2(\\alpha) = m`, or modulus :math:`k^2 = m` are also\nused, so be careful that you choose the correct parameter.\n\nSee Also\n--------\nellipkm1 : Complete elliptic integral of the first kind, near `m` = 1\nellipk : Complete elliptic integral of the first kind\nellipkinc : Incomplete elliptic integral of the first kind\nellipe : Complete elliptic integral of the second kind\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/\n.. [2] Milton Abramowitz and Irene A. Stegun, eds.\n       Handbook of Mathematical Functions with Formulas,\n       Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def ellipj(x1, x2, out1=..., out2=..., out3=..., out4=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ellipj(x1, x2[, out1, out2, out3, out4], / [, out=(None, None, None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nellipj(u, m)\n\nJacobian elliptic functions\n\nCalculates the Jacobian elliptic functions of parameter `m` between\n0 and 1, and real argument `u`.\n\nParameters\n----------\nm : array_like\n    Parameter.\nu : array_like\n    Argument.\n\nReturns\n-------\nsn, cn, dn, ph : ndarrays\n    The returned functions::\n\n        sn(u|m), cn(u|m), dn(u|m)\n\n    The value `ph` is such that if `u = ellipkinc(ph, m)`,\n    then `sn(u|m) = sin(ph)` and `cn(u|m) = cos(ph)`.\n\nNotes\n-----\nWrapper for the Cephes [1]_ routine `ellpj`.\n\nThese functions are periodic, with quarter-period on the real axis\nequal to the complete elliptic integral `ellipk(m)`.\n\nRelation to incomplete elliptic integral: If `u = ellipkinc(phi,m)`, then\n`sn(u|m) = sin(phi)`, and `cn(u|m) = cos(phi)`. The `phi` is called\nthe amplitude of `u`.\n\nComputation is by means of the arithmetic-geometric mean algorithm,\nexcept when `m` is within 1e-9 of 0 or 1. In the latter case with `m`\nclose to 1, the approximation applies only for `phi < pi/2`.\n\nSee also\n--------\nellipk : Complete elliptic integral of the first kind\nellipkinc : Incomplete elliptic integral of the first kind\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def ellipk(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ellipk(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nellipk(m)\n\nComplete elliptic integral of the first kind.\n\nThis function is defined as\n\n.. math:: K(m) = \\int_0^{\\pi/2} [1 - m \\sin(t)^2]^{-1/2} dt\n\nParameters\n----------\nm : array_like\n    The parameter of the elliptic integral.\n\nReturns\n-------\nK : array_like\n    Value of the elliptic integral.\n\nNotes\n-----\nFor more precision around point m = 1, use `ellipkm1`, which this\nfunction calls.\n\nThe parameterization in terms of :math:`m` follows that of section\n17.2 in [1]_. Other parameterizations in terms of the\ncomplementary parameter :math:`1 - m`, modular angle\n:math:`\\sin^2(\\alpha) = m`, or modulus :math:`k^2 = m` are also\nused, so be careful that you choose the correct parameter.\n\nSee Also\n--------\nellipkm1 : Complete elliptic integral of the first kind around m = 1\nellipkinc : Incomplete elliptic integral of the first kind\nellipe : Complete elliptic integral of the second kind\nellipeinc : Incomplete elliptic integral of the second kind\n\nReferences\n----------\n.. [1] Milton Abramowitz and Irene A. Stegun, eds.\n       Handbook of Mathematical Functions with Formulas,\n       Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def ellipkinc(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ellipkinc(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nellipkinc(phi, m)\n\nIncomplete elliptic integral of the first kind\n\nThis function is defined as\n\n.. math:: K(\\phi, m) = \\int_0^{\\phi} [1 - m \\sin(t)^2]^{-1/2} dt\n\nThis function is also called `F(phi, m)`.\n\nParameters\n----------\nphi : array_like\n    amplitude of the elliptic integral\n\nm : array_like\n    parameter of the elliptic integral\n\nReturns\n-------\nK : ndarray\n    Value of the elliptic integral\n\nNotes\n-----\nWrapper for the Cephes [1]_ routine `ellik`.  The computation is\ncarried out using the arithmetic-geometric mean algorithm.\n\nThe parameterization in terms of :math:`m` follows that of section\n17.2 in [2]_. Other parameterizations in terms of the\ncomplementary parameter :math:`1 - m`, modular angle\n:math:`\\sin^2(\\alpha) = m`, or modulus :math:`k^2 = m` are also\nused, so be careful that you choose the correct parameter.\n\nSee Also\n--------\nellipkm1 : Complete elliptic integral of the first kind, near `m` = 1\nellipk : Complete elliptic integral of the first kind\nellipe : Complete elliptic integral of the second kind\nellipeinc : Incomplete elliptic integral of the second kind\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/\n.. [2] Milton Abramowitz and Irene A. Stegun, eds.\n       Handbook of Mathematical Functions with Formulas,\n       Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def ellipkm1(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ellipkm1(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nellipkm1(p)\n\nComplete elliptic integral of the first kind around `m` = 1\n\nThis function is defined as\n\n.. math:: K(p) = \\int_0^{\\pi/2} [1 - m \\sin(t)^2]^{-1/2} dt\n\nwhere `m = 1 - p`.\n\nParameters\n----------\np : array_like\n    Defines the parameter of the elliptic integral as `m = 1 - p`.\n\nReturns\n-------\nK : ndarray\n    Value of the elliptic integral.\n\nNotes\n-----\nWrapper for the Cephes [1]_ routine `ellpk`.\n\nFor `p <= 1`, computation uses the approximation,\n\n.. math:: K(p) \\approx P(p) - \\log(p) Q(p),\n\nwhere :math:`P` and :math:`Q` are tenth-order polynomials.  The\nargument `p` is used internally rather than `m` so that the logarithmic\nsingularity at `m = 1` will be shifted to the origin; this preserves\nmaximum accuracy.  For `p > 1`, the identity\n\n.. math:: K(p) = K(1/p)/\\sqrt(p)\n\nis used.\n\nSee Also\n--------\nellipk : Complete elliptic integral of the first kind\nellipkinc : Incomplete elliptic integral of the first kind\nellipe : Complete elliptic integral of the second kind\nellipeinc : Incomplete elliptic integral of the second kind\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def entr(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "entr(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nentr(x)\n\nElementwise function for computing entropy.\n\n.. math:: \\text{entr}(x) = \\begin{cases} - x \\log(x) & x > 0  \\\\ 0 & x = 0 \\\\ -\\infty & \\text{otherwise} \\end{cases}\n\nParameters\n----------\nx : ndarray\n    Input array.\n\nReturns\n-------\nres : ndarray\n    The value of the elementwise entropy function at the given points `x`.\n\nSee Also\n--------\nkl_div, rel_entr\n\nNotes\n-----\nThis function is concave.\n\n.. versionadded:: 0.15.0"
    ...

def erf(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "erf(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nerf(z)\n\nReturns the error function of complex argument.\n\nIt is defined as ``2/sqrt(pi)*integral(exp(-t**2), t=0..z)``.\n\nParameters\n----------\nx : ndarray\n    Input array.\n\nReturns\n-------\nres : ndarray\n    The values of the error function at the given points `x`.\n\nSee Also\n--------\nerfc, erfinv, erfcinv, wofz, erfcx, erfi\n\nNotes\n-----\nThe cumulative of the unit normal distribution is given by\n``Phi(z) = 1/2[1 + erf(z/sqrt(2))]``.\n\nReferences\n----------\n.. [1] https://en.wikipedia.org/wiki/Error_function\n.. [2] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover,\n    1972. http://www.math.sfu.ca/~cbm/aands/page_297.htm\n.. [3] Steven G. Johnson, Faddeeva W function implementation.\n   http://ab-initio.mit.edu/Faddeeva\n\nExamples\n--------\n>>> from scipy import special\n>>> import matplotlib.pyplot as plt\n>>> x = np.linspace(-3, 3)\n>>> plt.plot(x, special.erf(x))\n>>> plt.xlabel('$x$')\n>>> plt.ylabel('$erf(x)$')\n>>> plt.show()"
    ...

def erfc(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "erfc(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nerfc(x, out=None)\n\nComplementary error function, ``1 - erf(x)``.\n\nParameters\n----------\nx : array_like\n    Real or complex valued argument\nout : ndarray, optional\n    Optional output array for the function results\n\nReturns\n-------\nscalar or ndarray\n    Values of the complementary error function\n\nSee Also\n--------\nerf, erfi, erfcx, dawsn, wofz\n\nReferences\n----------\n.. [1] Steven G. Johnson, Faddeeva W function implementation.\n   http://ab-initio.mit.edu/Faddeeva\n\nExamples\n--------\n>>> from scipy import special\n>>> import matplotlib.pyplot as plt\n>>> x = np.linspace(-3, 3)\n>>> plt.plot(x, special.erfc(x))\n>>> plt.xlabel('$x$')\n>>> plt.ylabel('$erfc(x)$')\n>>> plt.show()"
    ...

def erfcinv(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "erfcinv(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInverse of the complementary error function.\n\n    Computes the inverse of the complementary error function.\n\n    In the complex domain, there is no unique complex number w satisfying\n    erfc(w)=z. This indicates a true inverse function would have multi-value.\n    When the domain restricts to the real, 0 < x < 2, there is a unique real\n    number satisfying erfc(erfcinv(x)) = erfcinv(erfc(x)).\n\n    It is related to inverse of the error function by erfcinv(1-x) = erfinv(x)\n\n    Parameters\n    ----------\n    y : ndarray\n        Argument at which to evaluate. Domain: [0, 2]\n\n    Returns\n    -------\n    erfcinv : ndarray\n        The inverse of erfc of y, element-wise\n\n    See Also\n    --------\n    erf : Error function of a complex argument\n    erfc : Complementary error function, ``1 - erf(x)``\n    erfinv : Inverse of the error function\n\n    Examples\n    --------\n    1) evaluating a float number\n\n    >>> from scipy import special\n    >>> special.erfcinv(0.5)\n    0.4769362762044698\n\n    2) evaluating an ndarray\n\n    >>> from scipy import special\n    >>> y = np.linspace(0.0, 2.0, num=11)\n    >>> special.erfcinv(y)\n    array([        inf,  0.9061938 ,  0.59511608,  0.37080716,  0.17914345,\n           -0.        , -0.17914345, -0.37080716, -0.59511608, -0.9061938 ,\n                  -inf])"
    ...

def erfcx(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "erfcx(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nerfcx(x, out=None)\n\nScaled complementary error function, ``exp(x**2) * erfc(x)``.\n\nParameters\n----------\nx : array_like\n    Real or complex valued argument\nout : ndarray, optional\n    Optional output array for the function results\n\nReturns\n-------\nscalar or ndarray\n    Values of the scaled complementary error function\n\n\nSee Also\n--------\nerf, erfc, erfi, dawsn, wofz\n\nNotes\n-----\n\n.. versionadded:: 0.12.0\n\nReferences\n----------\n.. [1] Steven G. Johnson, Faddeeva W function implementation.\n   http://ab-initio.mit.edu/Faddeeva\n\nExamples\n--------\n>>> from scipy import special\n>>> import matplotlib.pyplot as plt\n>>> x = np.linspace(-3, 3)\n>>> plt.plot(x, special.erfcx(x))\n>>> plt.xlabel('$x$')\n>>> plt.ylabel('$erfcx(x)$')\n>>> plt.show()"
    ...

def erfi(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "erfi(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nerfi(z, out=None)\n\nImaginary error function, ``-i erf(i z)``.\n\nParameters\n----------\nz : array_like\n    Real or complex valued argument\nout : ndarray, optional\n    Optional output array for the function results\n\nReturns\n-------\nscalar or ndarray\n    Values of the imaginary error function\n\nSee Also\n--------\nerf, erfc, erfcx, dawsn, wofz\n\nNotes\n-----\n\n.. versionadded:: 0.12.0\n\nReferences\n----------\n.. [1] Steven G. Johnson, Faddeeva W function implementation.\n   http://ab-initio.mit.edu/Faddeeva\n\nExamples\n--------\n>>> from scipy import special\n>>> import matplotlib.pyplot as plt\n>>> x = np.linspace(-3, 3)\n>>> plt.plot(x, special.erfi(x))\n>>> plt.xlabel('$x$')\n>>> plt.ylabel('$erfi(x)$')\n>>> plt.show()"
    ...

def erfinv(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "erfinv(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nInverse of the error function.\n\n    Computes the inverse of the error function.\n\n    In the complex domain, there is no unique complex number w satisfying\n    erf(w)=z. This indicates a true inverse function would have multi-value.\n    When the domain restricts to the real, -1 < x < 1, there is a unique real\n    number satisfying erf(erfinv(x)) = x.\n\n    Parameters\n    ----------\n    y : ndarray\n        Argument at which to evaluate. Domain: [-1, 1]\n\n    Returns\n    -------\n    erfinv : ndarray\n        The inverse of erf of y, element-wise)\n\n    See Also\n    --------\n    erf : Error function of a complex argument\n    erfc : Complementary error function, ``1 - erf(x)``\n    erfcinv : Inverse of the complementary error function\n\n    Examples\n    --------\n    1) evaluating a float number\n\n    >>> from scipy import special\n    >>> special.erfinv(0.5)\n    0.4769362762044698\n\n    2) evaluating an ndarray\n\n    >>> from scipy import special\n    >>> y = np.linspace(-1.0, 1.0, num=10)\n    >>> special.erfinv(y)\n    array([       -inf, -0.86312307, -0.5407314 , -0.30457019, -0.0987901 ,\n            0.0987901 ,  0.30457019,  0.5407314 ,  0.86312307,         inf])"
    ...

class errstate(_mod_builtins.object):
    "Context manager for special-function error handling.\n\n    Using an instance of `errstate` as a context manager allows\n    statements in that context to execute with a known error handling\n    behavior. Upon entering the context the error handling is set with\n    `seterr`, and upon exiting it is restored to what it was before.\n\n    Parameters\n    ----------\n    kwargs : {all, singular, underflow, overflow, slow, loss, no_result, domain, arg, other}\n        Keyword arguments. The valid keywords are possible\n        special-function errors. Each keyword should have a string\n        value that defines the treatement for the particular type of\n        error. Values must be 'ignore', 'warn', or 'other'. See\n        `seterr` for details.\n\n    See Also\n    --------\n    geterr : get the current way of handling special-function errors\n    seterr : set how special-function errors are handled\n    numpy.errstate : similar numpy function for floating-point errors\n\n    Examples\n    --------\n    >>> import scipy.special as sc\n    >>> from pytest import raises\n    >>> sc.gammaln(0)\n    inf\n    >>> with sc.errstate(singular='raise'):\n    ...     with raises(sc.SpecialFunctionError):\n    ...         sc.gammaln(0)\n    ...\n    >>> sc.gammaln(0)\n    inf\n\n    We can also raise on every category except one.\n\n    >>> with sc.errstate(all='raise', singular='ignore'):\n    ...     sc.gammaln(0)\n    ...     with raises(sc.SpecialFunctionError):\n    ...         sc.spence(-1)\n    ...\n    inf\n\n    "
    __dict__: typing.Dict[str, typing.Any]
    def __enter__(self) -> typing.Any:
        ...
    
    def __exit__(self, exc_type, exc_value, traceback) -> typing.Any:
        ...
    
    def __init__(self, **kwargs) -> None:
        "Context manager for special-function error handling.\n\n    Using an instance of `errstate` as a context manager allows\n    statements in that context to execute with a known error handling\n    behavior. Upon entering the context the error handling is set with\n    `seterr`, and upon exiting it is restored to what it was before.\n\n    Parameters\n    ----------\n    kwargs : {all, singular, underflow, overflow, slow, loss, no_result, domain, arg, other}\n        Keyword arguments. The valid keywords are possible\n        special-function errors. Each keyword should have a string\n        value that defines the treatement for the particular type of\n        error. Values must be 'ignore', 'warn', or 'other'. See\n        `seterr` for details.\n\n    See Also\n    --------\n    geterr : get the current way of handling special-function errors\n    seterr : set how special-function errors are handled\n    numpy.errstate : similar numpy function for floating-point errors\n\n    Examples\n    --------\n    >>> import scipy.special as sc\n    >>> from pytest import raises\n    >>> sc.gammaln(0)\n    inf\n    >>> with sc.errstate(singular='raise'):\n    ...     with raises(sc.SpecialFunctionError):\n    ...         sc.gammaln(0)\n    ...\n    >>> sc.gammaln(0)\n    inf\n\n    We can also raise on every category except one.\n\n    >>> with sc.errstate(all='raise', singular='ignore'):\n    ...     sc.gammaln(0)\n    ...     with raises(sc.SpecialFunctionError):\n    ...         sc.spence(-1)\n    ...\n    inf\n\n    "
        ...
    
    @classmethod
    def __init_subclass__(cls) -> None:
        'This method is called when a class is subclassed.\n\nThe default implementation does nothing. It may be\noverridden to extend subclasses.\n'
        ...
    
    __module__: str
    @classmethod
    def __subclasshook__(cls, subclass: typing.Any) -> bool:
        'Abstract classes can override this to customize issubclass().\n\nThis is invoked early on by abc.ABCMeta.__subclasscheck__().\nIt should return True, False or NotImplemented.  If it returns\nNotImplemented, the normal algorithm is used.  Otherwise, it\noverrides the normal algorithm (and the outcome is cached).\n'
        ...
    
    @property
    def __weakref__(self) -> typing.Any:
        'list of weak references to the object (if defined)'
        ...
    
    def __getattr__(self, name) -> typing.Any:
        ...
    

def eval_chebyc(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_chebyc(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_chebyc(n, x, out=None)\n\nEvaluate Chebyshev polynomial of the first kind on [-2, 2] at a\npoint.\n\nThese polynomials are defined as\n\n.. math::\n\n    C_n(x) = 2 T_n(x/2)\n\nwhere :math:`T_n` is a Chebyshev polynomial of the first kind. See\n22.5.11 in [AS]_ for details.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial. If not an integer, the result is\n    determined via the relation to `eval_chebyt`.\nx : array_like\n    Points at which to evaluate the Chebyshev polynomial\n\nReturns\n-------\nC : ndarray\n    Values of the Chebyshev polynomial\n\nSee Also\n--------\nroots_chebyc : roots and quadrature weights of Chebyshev\n               polynomials of the first kind on [-2, 2]\nchebyc : Chebyshev polynomial object\nnumpy.polynomial.chebyshev.Chebyshev : Chebyshev series\neval_chebyt : evaluate Chebycshev polynomials of the first kind\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972.\n\nExamples\n--------\n>>> import scipy.special as sc\n\nThey are a scaled version of the Chebyshev polynomials of the\nfirst kind.\n\n>>> x = np.linspace(-2, 2, 6)\n>>> sc.eval_chebyc(3, x)\narray([-2.   ,  1.872,  1.136, -1.136, -1.872,  2.   ])\n>>> 2 * sc.eval_chebyt(3, x / 2)\narray([-2.   ,  1.872,  1.136, -1.136, -1.872,  2.   ])"
    ...

def eval_chebys(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_chebys(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_chebys(n, x, out=None)\n\nEvaluate Chebyshev polynomial of the second kind on [-2, 2] at a\npoint.\n\nThese polynomials are defined as\n\n.. math::\n\n    S_n(x) = U_n(x/2)\n\nwhere :math:`U_n` is a Chebyshev polynomial of the second\nkind. See 22.5.13 in [AS]_ for details.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial. If not an integer, the result is\n    determined via the relation to `eval_chebyu`.\nx : array_like\n    Points at which to evaluate the Chebyshev polynomial\n\nReturns\n-------\nS : ndarray\n    Values of the Chebyshev polynomial\n\nSee Also\n--------\nroots_chebys : roots and quadrature weights of Chebyshev\n               polynomials of the second kind on [-2, 2]\nchebys : Chebyshev polynomial object\neval_chebyu : evaluate Chebyshev polynomials of the second kind\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972.\n\nExamples\n--------\n>>> import scipy.special as sc\n\nThey are a scaled version of the Chebyshev polynomials of the\nsecond kind.\n\n>>> x = np.linspace(-2, 2, 6)\n>>> sc.eval_chebys(3, x)\narray([-4.   ,  0.672,  0.736, -0.736, -0.672,  4.   ])\n>>> sc.eval_chebyu(3, x / 2)\narray([-4.   ,  0.672,  0.736, -0.736, -0.672,  4.   ])"
    ...

def eval_chebyt(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_chebyt(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_chebyt(n, x, out=None)\n\nEvaluate Chebyshev polynomial of the first kind at a point.\n\nThe Chebyshev polynomials of the first kind can be defined via the\nGauss hypergeometric function :math:`{}_2F_1` as\n\n.. math::\n\n    T_n(x) = {}_2F_1(n, -n; 1/2; (1 - x)/2).\n\nWhen :math:`n` is an integer the result is a polynomial of degree\n:math:`n`. See 22.5.47 in [AS]_ for details.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial. If not an integer, the result is\n    determined via the relation to the Gauss hypergeometric\n    function.\nx : array_like\n    Points at which to evaluate the Chebyshev polynomial\n\nReturns\n-------\nT : ndarray\n    Values of the Chebyshev polynomial\n\nSee Also\n--------\nroots_chebyt : roots and quadrature weights of Chebyshev\n               polynomials of the first kind\nchebyu : Chebychev polynomial object\neval_chebyu : evaluate Chebyshev polynomials of the second kind\nhyp2f1 : Gauss hypergeometric function\nnumpy.polynomial.chebyshev.Chebyshev : Chebyshev series\n\nNotes\n-----\nThis routine is numerically stable for `x` in ``[-1, 1]`` at least\nup to order ``10000``.\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def eval_chebyu(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_chebyu(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_chebyu(n, x, out=None)\n\nEvaluate Chebyshev polynomial of the second kind at a point.\n\nThe Chebyshev polynomials of the second kind can be defined via\nthe Gauss hypergeometric function :math:`{}_2F_1` as\n\n.. math::\n\n    U_n(x) = (n + 1) {}_2F_1(-n, n + 2; 3/2; (1 - x)/2).\n\nWhen :math:`n` is an integer the result is a polynomial of degree\n:math:`n`. See 22.5.48 in [AS]_ for details.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial. If not an integer, the result is\n    determined via the relation to the Gauss hypergeometric\n    function.\nx : array_like\n    Points at which to evaluate the Chebyshev polynomial\n\nReturns\n-------\nU : ndarray\n    Values of the Chebyshev polynomial\n\nSee Also\n--------\nroots_chebyu : roots and quadrature weights of Chebyshev\n               polynomials of the second kind\nchebyu : Chebyshev polynomial object\neval_chebyt : evaluate Chebyshev polynomials of the first kind\nhyp2f1 : Gauss hypergeometric function\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def eval_gegenbauer(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_gegenbauer(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_gegenbauer(n, alpha, x, out=None)\n\nEvaluate Gegenbauer polynomial at a point.\n\nThe Gegenbauer polynomials can be defined via the Gauss\nhypergeometric function :math:`{}_2F_1` as\n\n.. math::\n\n    C_n^{(\\alpha)} = \\frac{(2\\alpha)_n}{\\Gamma(n + 1)}\n      {}_2F_1(-n, 2\\alpha + n; \\alpha + 1/2; (1 - z)/2).\n\nWhen :math:`n` is an integer the result is a polynomial of degree\n:math:`n`. See 22.5.46 in [AS]_ for details.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial. If not an integer, the result is\n    determined via the relation to the Gauss hypergeometric\n    function.\nalpha : array_like\n    Parameter\nx : array_like\n    Points at which to evaluate the Gegenbauer polynomial\n\nReturns\n-------\nC : ndarray\n    Values of the Gegenbauer polynomial\n\nSee Also\n--------\nroots_gegenbauer : roots and quadrature weights of Gegenbauer\n                   polynomials\ngegenbauer : Gegenbauer polynomial object\nhyp2f1 : Gauss hypergeometric function\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def eval_genlaguerre(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_genlaguerre(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_genlaguerre(n, alpha, x, out=None)\n\nEvaluate generalized Laguerre polynomial at a point.\n\nThe generalized Laguerre polynomials can be defined via the\nconfluent hypergeometric function :math:`{}_1F_1` as\n\n.. math::\n\n    L_n^{(\\alpha)}(x) = \\binom{n + \\alpha}{n}\n      {}_1F_1(-n, \\alpha + 1, x).\n\nWhen :math:`n` is an integer the result is a polynomial of degree\n:math:`n`. See 22.5.54 in [AS]_ for details. The Laguerre\npolynomials are the special case where :math:`\\alpha = 0`.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial. If not an integer, the result is\n    determined via the relation to the confluent hypergeometric\n    function.\nalpha : array_like\n    Parameter; must have ``alpha > -1``\nx : array_like\n    Points at which to evaluate the generalized Laguerre\n    polynomial\n\nReturns\n-------\nL : ndarray\n    Values of the generalized Laguerre polynomial\n\nSee Also\n--------\nroots_genlaguerre : roots and quadrature weights of generalized\n                    Laguerre polynomials\ngenlaguerre : generalized Laguerre polynomial object\nhyp1f1 : confluent hypergeometric function\neval_laguerre : evaluate Laguerre polynomials\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def eval_hermite(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_hermite(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_hermite(n, x, out=None)\n\nEvaluate physicist's Hermite polynomial at a point.\n\nDefined by\n\n.. math::\n\n    H_n(x) = (-1)^n e^{x^2} \\frac{d^n}{dx^n} e^{-x^2};\n\n:math:`H_n` is a polynomial of degree :math:`n`. See 22.11.7 in\n[AS]_ for details.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial\nx : array_like\n    Points at which to evaluate the Hermite polynomial\n\nReturns\n-------\nH : ndarray\n    Values of the Hermite polynomial\n\nSee Also\n--------\nroots_hermite : roots and quadrature weights of physicist's\n                Hermite polynomials\nhermite : physicist's Hermite polynomial object\nnumpy.polynomial.hermite.Hermite : Physicist's Hermite series\neval_hermitenorm : evaluate Probabilist's Hermite polynomials\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def eval_hermitenorm(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_hermitenorm(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_hermitenorm(n, x, out=None)\n\nEvaluate probabilist's (normalized) Hermite polynomial at a\npoint.\n\nDefined by\n\n.. math::\n\n    He_n(x) = (-1)^n e^{x^2/2} \\frac{d^n}{dx^n} e^{-x^2/2};\n\n:math:`He_n` is a polynomial of degree :math:`n`. See 22.11.8 in\n[AS]_ for details.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial\nx : array_like\n    Points at which to evaluate the Hermite polynomial\n\nReturns\n-------\nHe : ndarray\n    Values of the Hermite polynomial\n\nSee Also\n--------\nroots_hermitenorm : roots and quadrature weights of probabilist's\n                    Hermite polynomials\nhermitenorm : probabilist's Hermite polynomial object\nnumpy.polynomial.hermite_e.HermiteE : Probabilist's Hermite series\neval_hermite : evaluate physicist's Hermite polynomials\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def eval_jacobi(x1, x2, x3, x4, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_jacobi(x1, x2, x3, x4, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_jacobi(n, alpha, beta, x, out=None)\n\nEvaluate Jacobi polynomial at a point.\n\nThe Jacobi polynomials can be defined via the Gauss hypergeometric\nfunction :math:`{}_2F_1` as\n\n.. math::\n\n    P_n^{(\\alpha, \\beta)}(x) = \\frac{(\\alpha + 1)_n}{\\Gamma(n + 1)}\n      {}_2F_1(-n, 1 + \\alpha + \\beta + n; \\alpha + 1; (1 - z)/2)\n\nwhere :math:`(\\cdot)_n` is the Pochhammer symbol; see `poch`. When\n:math:`n` is an integer the result is a polynomial of degree\n:math:`n`. See 22.5.42 in [AS]_ for details.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial. If not an integer the result is\n    determined via the relation to the Gauss hypergeometric\n    function.\nalpha : array_like\n    Parameter\nbeta : array_like\n    Parameter\nx : array_like\n    Points at which to evaluate the polynomial\n\nReturns\n-------\nP : ndarray\n    Values of the Jacobi polynomial\n\nSee Also\n--------\nroots_jacobi : roots and quadrature weights of Jacobi polynomials\njacobi : Jacobi polynomial object\nhyp2f1 : Gauss hypergeometric function\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def eval_laguerre(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_laguerre(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_laguerre(n, x, out=None)\n\nEvaluate Laguerre polynomial at a point.\n\nThe Laguerre polynomials can be defined via the confluent\nhypergeometric function :math:`{}_1F_1` as\n\n.. math::\n\n    L_n(x) = {}_1F_1(-n, 1, x).\n\nSee 22.5.16 and 22.5.54 in [AS]_ for details. When :math:`n` is an\ninteger the result is a polynomial of degree :math:`n`.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial. If not an integer the result is\n    determined via the relation to the confluent hypergeometric\n    function.\nx : array_like\n    Points at which to evaluate the Laguerre polynomial\n\nReturns\n-------\nL : ndarray\n    Values of the Laguerre polynomial\n\nSee Also\n--------\nroots_laguerre : roots and quadrature weights of Laguerre\n                 polynomials\nlaguerre : Laguerre polynomial object\nnumpy.polynomial.laguerre.Laguerre : Laguerre series\neval_genlaguerre : evaluate generalized Laguerre polynomials\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def eval_legendre(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'eval_legendre(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\neval_legendre(n, x, out=None)\n\nEvaluate Legendre polynomial at a point.\n\nThe Legendre polynomials can be defined via the Gauss\nhypergeometric function :math:`{}_2F_1` as\n\n.. math::\n\n    P_n(x) = {}_2F_1(-n, n + 1; 1; (1 - x)/2).\n\nWhen :math:`n` is an integer the result is a polynomial of degree\n:math:`n`. See 22.5.49 in [AS]_ for details.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial. If not an integer, the result is\n    determined via the relation to the Gauss hypergeometric\n    function.\nx : array_like\n    Points at which to evaluate the Legendre polynomial\n\nReturns\n-------\nP : ndarray\n    Values of the Legendre polynomial\n\nSee Also\n--------\nroots_legendre : roots and quadrature weights of Legendre\n                 polynomials\nlegendre : Legendre polynomial object\nhyp2f1 : Gauss hypergeometric function\nnumpy.polynomial.legendre.Legendre : Legendre series\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972.\n\nExamples\n--------\n>>> from scipy.special import eval_legendre\n\nEvaluate the zero-order Legendre polynomial at x = 0\n\n>>> eval_legendre(0, 0)\n1.0\n\nEvaluate the first-order Legendre polynomial between -1 and 1\n\n>>> import numpy as np\n>>> X = np.linspace(-1, 1, 5)  # Domain of Legendre polynomials\n>>> eval_legendre(1, X)\narray([-1. , -0.5,  0. ,  0.5,  1. ])\n\nEvaluate Legendre polynomials of order 0 through 4 at x = 0\n\n>>> N = range(0, 5)\n>>> eval_legendre(N, 0)\narray([ 1.   ,  0.   , -0.5  ,  0.   ,  0.375])\n\nPlot Legendre polynomials of order 0 through 4\n\n>>> X = np.linspace(-1, 1)\n\n>>> import matplotlib.pyplot as plt\n>>> for n in range(0, 5):\n...     y = eval_legendre(n, X)\n...     plt.plot(X, y, label=r\'$P_{}(x)$\'.format(n))\n\n>>> plt.title("Legendre Polynomials")\n>>> plt.xlabel("x")\n>>> plt.ylabel(r\'$P_n(x)$\')\n>>> plt.legend(loc=\'lower right\')\n>>> plt.show()'
    ...

def eval_sh_chebyt(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_sh_chebyt(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_sh_chebyt(n, x, out=None)\n\nEvaluate shifted Chebyshev polynomial of the first kind at a\npoint.\n\nThese polynomials are defined as\n\n.. math::\n\n    T_n^*(x) = T_n(2x - 1)\n\nwhere :math:`T_n` is a Chebyshev polynomial of the first kind. See\n22.5.14 in [AS]_ for details.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial. If not an integer, the result is\n    determined via the relation to `eval_chebyt`.\nx : array_like\n    Points at which to evaluate the shifted Chebyshev polynomial\n\nReturns\n-------\nT : ndarray\n    Values of the shifted Chebyshev polynomial\n\nSee Also\n--------\nroots_sh_chebyt : roots and quadrature weights of shifted\n                  Chebyshev polynomials of the first kind\nsh_chebyt : shifted Chebyshev polynomial object\neval_chebyt : evaluate Chebyshev polynomials of the first kind\nnumpy.polynomial.chebyshev.Chebyshev : Chebyshev series\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def eval_sh_chebyu(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_sh_chebyu(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_sh_chebyu(n, x, out=None)\n\nEvaluate shifted Chebyshev polynomial of the second kind at a\npoint.\n\nThese polynomials are defined as\n\n.. math::\n\n    U_n^*(x) = U_n(2x - 1)\n\nwhere :math:`U_n` is a Chebyshev polynomial of the first kind. See\n22.5.15 in [AS]_ for details.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial. If not an integer, the result is\n    determined via the relation to `eval_chebyu`.\nx : array_like\n    Points at which to evaluate the shifted Chebyshev polynomial\n\nReturns\n-------\nU : ndarray\n    Values of the shifted Chebyshev polynomial\n\nSee Also\n--------\nroots_sh_chebyu : roots and quadrature weights of shifted\n                  Chebychev polynomials of the second kind\nsh_chebyu : shifted Chebyshev polynomial object\neval_chebyu : evaluate Chebyshev polynomials of the second kind\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def eval_sh_jacobi(x1, x2, x3, x4, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_sh_jacobi(x1, x2, x3, x4, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_sh_jacobi(n, p, q, x, out=None)\n\nEvaluate shifted Jacobi polynomial at a point.\n\nDefined by\n\n.. math::\n\n    G_n^{(p, q)}(x)\n      = \\binom{2n + p - 1}{n}^{-1} P_n^{(p - q, q - 1)}(2x - 1),\n\nwhere :math:`P_n^{(\\cdot, \\cdot)}` is the n-th Jacobi\npolynomial. See 22.5.2 in [AS]_ for details.\n\nParameters\n----------\nn : int\n    Degree of the polynomial. If not an integer, the result is\n    determined via the relation to `binom` and `eval_jacobi`.\np : float\n    Parameter\nq : float\n    Parameter\n\nReturns\n-------\nG : ndarray\n    Values of the shifted Jacobi polynomial.\n\nSee Also\n--------\nroots_sh_jacobi : roots and quadrature weights of shifted Jacobi\n                  polynomials\nsh_jacobi : shifted Jacobi polynomial object\neval_jacobi : evaluate Jacobi polynomials\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def eval_sh_legendre(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "eval_sh_legendre(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\neval_sh_legendre(n, x, out=None)\n\nEvaluate shifted Legendre polynomial at a point.\n\nThese polynomials are defined as\n\n.. math::\n\n    P_n^*(x) = P_n(2x - 1)\n\nwhere :math:`P_n` is a Legendre polynomial. See 2.2.11 in [AS]_\nfor details.\n\nParameters\n----------\nn : array_like\n    Degree of the polynomial. If not an integer, the value is\n    determined via the relation to `eval_legendre`.\nx : array_like\n    Points at which to evaluate the shifted Legendre polynomial\n\nReturns\n-------\nP : ndarray\n    Values of the shifted Legendre polynomial\n\nSee Also\n--------\nroots_sh_legendre : roots and quadrature weights of shifted\n                    Legendre polynomials\nsh_legendre : shifted Legendre polynomial object\neval_legendre : evaluate Legendre polynomials\nnumpy.polynomial.legendre.Legendre : Legendre series\n\nReferences\n----------\n.. [AS] Milton Abramowitz and Irene A. Stegun, eds.\n    Handbook of Mathematical Functions with Formulas,\n    Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def exp1(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "exp1(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nexp1(z, out=None)\n\nExponential integral E1.\n\nFor complex :math:`z \\ne 0` the exponential integral can be defined as\n[1]_\n\n.. math::\n\n   E_1(z) = \\int_z^\\infty \\frac{e^{-t}}{t} dt,\n\nwhere the path of the integral does not cross the negative real\naxis or pass through the origin.\n\nParameters\n----------\nz: array_like\n    Real or complex argument.\nout: ndarray, optional\n    Optional output array for the function results\n\nReturns\n-------\nscalar or ndarray\n    Values of the exponential integral E1\n\nSee Also\n--------\nexpi : exponential integral :math:`Ei`\nexpn : generalization of :math:`E_1`\n\nNotes\n-----\nFor :math:`x > 0` it is related to the exponential integral\n:math:`Ei` (see `expi`) via the relation\n\n.. math::\n\n   E_1(x) = -Ei(-x).\n\nReferences\n----------\n.. [1] Digital Library of Mathematical Functions, 6.2.1\n       https://dlmf.nist.gov/6.2#E1\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt has a pole at 0.\n\n>>> sc.exp1(0)\ninf\n\nIt has a branch cut on the negative real axis.\n\n>>> sc.exp1(-1)\nnan\n>>> sc.exp1(complex(-1, 0))\n(-1.8951178163559368-3.141592653589793j)\n>>> sc.exp1(complex(-1, -0.0))\n(-1.8951178163559368+3.141592653589793j)\n\nIt approaches 0 along the positive real axis.\n\n>>> sc.exp1([1, 10, 100, 1000])\narray([2.19383934e-01, 4.15696893e-06, 3.68359776e-46, 0.00000000e+00])\n\nIt is related to `expi`.\n\n>>> x = np.array([1, 2, 3, 4])\n>>> sc.exp1(x)\narray([0.21938393, 0.04890051, 0.01304838, 0.00377935])\n>>> -sc.expi(-x)\narray([0.21938393, 0.04890051, 0.01304838, 0.00377935])"
    ...

def exp10(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "exp10(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nexp10(x)\n\nCompute ``10**x`` element-wise.\n\nParameters\n----------\nx : array_like\n    `x` must contain real numbers.\n\nReturns\n-------\nfloat\n    ``10**x``, computed element-wise.\n\nExamples\n--------\n>>> from scipy.special import exp10\n\n>>> exp10(3)\n1000.0\n>>> x = np.array([[-1, -0.5, 0], [0.5, 1, 1.5]])\n>>> exp10(x)\narray([[  0.1       ,   0.31622777,   1.        ],\n       [  3.16227766,  10.        ,  31.6227766 ]])"
    ...

def exp2(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "exp2(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nexp2(x)\n\nCompute ``2**x`` element-wise.\n\nParameters\n----------\nx : array_like\n    `x` must contain real numbers.\n\nReturns\n-------\nfloat\n    ``2**x``, computed element-wise.\n\nExamples\n--------\n>>> from scipy.special import exp2\n\n>>> exp2(3)\n8.0\n>>> x = np.array([[-1, -0.5, 0], [0.5, 1, 1.5]])\n>>> exp2(x)\narray([[ 0.5       ,  0.70710678,  1.        ],\n       [ 1.41421356,  2.        ,  2.82842712]])"
    ...

def expi(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "expi(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nexpi(x, out=None)\n\nExponential integral Ei.\n\nFor real :math:`x`, the exponential integral is defined as [1]_\n\n.. math::\n\n    Ei(x) = \\int_{-\\infty}^x \\frac{e^t}{t} dt.\n\nFor :math:`x > 0` the integral is understood as a Cauchy principle\nvalue.\n\nIt is extended to the complex plane by analytic continuation of\nthe function on the interval :math:`(0, \\infty)`. The complex\nvariant has a branch cut on the negative real axis.\n\nParameters\n----------\nx: array_like\n    Real or complex valued argument\nout: ndarray, optional\n    Optional output array for the function results\n\nReturns\n-------\nscalar or ndarray\n    Values of the exponential integral\n\nNotes\n-----\nThe exponential integrals :math:`E_1` and :math:`Ei` satisfy the\nrelation\n\n.. math::\n\n    E_1(x) = -Ei(-x)\n\nfor :math:`x > 0`.\n\nSee Also\n--------\nexp1 : Exponential integral :math:`E_1`\nexpn : Generalized exponential integral :math:`E_n`\n\nReferences\n----------\n.. [1] Digital Library of Mathematical Functions, 6.2.5\n       https://dlmf.nist.gov/6.2#E5\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is related to `exp1`.\n\n>>> x = np.array([1, 2, 3, 4])\n>>> -sc.expi(-x)\narray([0.21938393, 0.04890051, 0.01304838, 0.00377935])\n>>> sc.exp1(x)\narray([0.21938393, 0.04890051, 0.01304838, 0.00377935])\n\nThe complex variant has a branch cut on the negative real axis.\n\n>>> import scipy.special as sc\n>>> sc.expi(-1 + 1e-12j)\n(-0.21938393439552062+3.1415926535894254j)\n>>> sc.expi(-1 - 1e-12j)\n(-0.21938393439552062-3.1415926535894254j)\n\nAs the complex variant approaches the branch cut, the real parts\napproach the value of the real variant.\n\n>>> sc.expi(-1)\n-0.21938393439552062\n\nThe SciPy implementation returns the real variant for complex\nvalues on the branch cut.\n\n>>> sc.expi(complex(-1, 0.0))\n(-0.21938393439552062-0j)\n>>> sc.expi(complex(-1, -0.0))\n(-0.21938393439552062-0j)"
    ...

def expit(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "expit(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nexpit(x)\n\nExpit (a.k.a. logistic sigmoid) ufunc for ndarrays.\n\nThe expit function, also known as the logistic sigmoid function, is\ndefined as ``expit(x) = 1/(1+exp(-x))``.  It is the inverse of the\nlogit function.\n\nParameters\n----------\nx : ndarray\n    The ndarray to apply expit to element-wise.\n\nReturns\n-------\nout : ndarray\n    An ndarray of the same shape as x. Its entries\n    are `expit` of the corresponding entry of x.\n\nSee Also\n--------\nlogit\n\nNotes\n-----\nAs a ufunc expit takes a number of optional\nkeyword arguments. For more information\nsee `ufuncs <https://docs.scipy.org/doc/numpy/reference/ufuncs.html>`_\n\n.. versionadded:: 0.10.0\n\nExamples\n--------\n>>> from scipy.special import expit, logit\n\n>>> expit([-np.inf, -1.5, 0, 1.5, np.inf])\narray([ 0.        ,  0.18242552,  0.5       ,  0.81757448,  1.        ])\n\n`logit` is the inverse of `expit`:\n\n>>> logit(expit([-2.5, 0, 3.1, 5.0]))\narray([-2.5,  0. ,  3.1,  5. ])\n\nPlot expit(x) for x in [-6, 6]:\n\n>>> import matplotlib.pyplot as plt\n>>> x = np.linspace(-6, 6, 121)\n>>> y = expit(x)\n>>> plt.plot(x, y)\n>>> plt.grid()\n>>> plt.xlim(-6, 6)\n>>> plt.xlabel('x')\n>>> plt.title('expit(x)')\n>>> plt.show()"
    ...

def expm1(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'expm1(x, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nexpm1(x)\n\nCompute ``exp(x) - 1``.\n\nWhen `x` is near zero, ``exp(x)`` is near 1, so the numerical calculation\nof ``exp(x) - 1`` can suffer from catastrophic loss of precision.\n``expm1(x)`` is implemented to avoid the loss of precision that occurs when\n`x` is near zero.\n\nParameters\n----------\nx : array_like\n    `x` must contain real numbers.\n\nReturns\n-------\nfloat\n    ``exp(x) - 1`` computed element-wise.\n\nExamples\n--------\n>>> from scipy.special import expm1\n\n>>> expm1(1.0)\n1.7182818284590451\n>>> expm1([-0.2, -0.1, 0, 0.1, 0.2])\narray([-0.18126925, -0.09516258,  0.        ,  0.10517092,  0.22140276])\n\nThe exact value of ``exp(7.5e-13) - 1`` is::\n\n    7.5000000000028125000000007031250000001318...*10**-13.\n\nHere is what ``expm1(7.5e-13)`` gives:\n\n>>> expm1(7.5e-13)\n7.5000000000028135e-13\n\nCompare that to ``exp(7.5e-13) - 1``, where the subtraction results in\na "catastrophic" loss of precision:\n\n>>> np.exp(7.5e-13) - 1\n7.5006667543675576e-13'
    ...

def expn(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "expn(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nexpn(n, x, out=None)\n\nGeneralized exponential integral En.\n\nFor integer :math:`n \\geq 0` and real :math:`x \\geq 0` the\ngeneralized exponential integral is defined as [dlmf]_\n\n.. math::\n\n    E_n(x) = x^{n - 1} \\int_x^\\infty \\frac{e^{-t}}{t^n} dt.\n\nParameters\n----------\nn: array_like\n    Non-negative integers\nx: array_like\n    Real argument\nout: ndarray, optional\n    Optional output array for the function results\n\nReturns\n-------\nscalar or ndarray\n    Values of the generalized exponential integral\n\nSee Also\n--------\nexp1 : special case of :math:`E_n` for :math:`n = 1`\nexpi : related to :math:`E_n` when :math:`n = 1`\n\nReferences\n----------\n.. [dlmf] Digital Library of Mathematical Functions, 8.19.2\n          https://dlmf.nist.gov/8.19#E2\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIts domain is nonnegative n and x.\n\n>>> sc.expn(-1, 1.0), sc.expn(1, -1.0)\n(nan, nan)\n\nIt has a pole at ``x = 0`` for ``n = 1, 2``; for larger ``n`` it\nis equal to ``1 / (n - 1)``.\n\n>>> sc.expn([0, 1, 2, 3, 4], 0)\narray([       inf,        inf, 1.        , 0.5       , 0.33333333])\n\nFor n equal to 0 it reduces to ``exp(-x) / x``.\n\n>>> x = np.array([1, 2, 3, 4])\n>>> sc.expn(0, x)\narray([0.36787944, 0.06766764, 0.01659569, 0.00457891])\n>>> np.exp(-x) / x\narray([0.36787944, 0.06766764, 0.01659569, 0.00457891])\n\nFor n equal to 1 it reduces to `exp1`.\n\n>>> sc.expn(1, x)\narray([0.21938393, 0.04890051, 0.01304838, 0.00377935])\n>>> sc.exp1(x)\narray([0.21938393, 0.04890051, 0.01304838, 0.00377935])"
    ...

def exprel(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "exprel(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nexprel(x)\n\nRelative error exponential, ``(exp(x) - 1)/x``.\n\nWhen `x` is near zero, ``exp(x)`` is near 1, so the numerical calculation\nof ``exp(x) - 1`` can suffer from catastrophic loss of precision.\n``exprel(x)`` is implemented to avoid the loss of precision that occurs when\n`x` is near zero.\n\nParameters\n----------\nx : ndarray\n    Input array.  `x` must contain real numbers.\n\nReturns\n-------\nfloat\n    ``(exp(x) - 1)/x``, computed element-wise.\n\nSee Also\n--------\nexpm1\n\nNotes\n-----\n.. versionadded:: 0.17.0\n\nExamples\n--------\n>>> from scipy.special import exprel\n\n>>> exprel(0.01)\n1.0050167084168056\n>>> exprel([-0.25, -0.1, 0, 0.1, 0.25])\narray([ 0.88479687,  0.95162582,  1.        ,  1.05170918,  1.13610167])\n\nCompare ``exprel(5e-9)`` to the naive calculation.  The exact value\nis ``1.00000000250000000416...``.\n\n>>> exprel(5e-9)\n1.0000000025\n\n>>> (np.exp(5e-9) - 1)/5e-9\n0.99999999392252903"
    ...

def fdtr(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "fdtr(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nfdtr(dfn, dfd, x)\n\nF cumulative distribution function.\n\nReturns the value of the cumulative distribution function of the\nF-distribution, also known as Snedecor's F-distribution or the\nFisher-Snedecor distribution.\n\nThe F-distribution with parameters :math:`d_n` and :math:`d_d` is the\ndistribution of the random variable,\n\n.. math::\n    X = \\frac{U_n/d_n}{U_d/d_d},\n\nwhere :math:`U_n` and :math:`U_d` are random variables distributed\n:math:`\\chi^2`, with :math:`d_n` and :math:`d_d` degrees of freedom,\nrespectively.\n\nParameters\n----------\ndfn : array_like\n    First parameter (positive float).\ndfd : array_like\n    Second parameter (positive float).\nx : array_like\n    Argument (nonnegative float).\n\nReturns\n-------\ny : ndarray\n    The CDF of the F-distribution with parameters `dfn` and `dfd` at `x`.\n\nNotes\n-----\nThe regularized incomplete beta function is used, according to the\nformula,\n\n.. math::\n    F(d_n, d_d; x) = I_{xd_n/(d_d + xd_n)}(d_n/2, d_d/2).\n\nWrapper for the Cephes [1]_ routine `fdtr`.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def fdtrc(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "fdtrc(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nfdtrc(dfn, dfd, x)\n\nF survival function.\n\nReturns the complemented F-distribution function (the integral of the\ndensity from `x` to infinity).\n\nParameters\n----------\ndfn : array_like\n    First parameter (positive float).\ndfd : array_like\n    Second parameter (positive float).\nx : array_like\n    Argument (nonnegative float).\n\nReturns\n-------\ny : ndarray\n    The complemented F-distribution function with parameters `dfn` and\n    `dfd` at `x`.\n\nSee also\n--------\nfdtr\n\nNotes\n-----\nThe regularized incomplete beta function is used, according to the\nformula,\n\n.. math::\n    F(d_n, d_d; x) = I_{d_d/(d_d + xd_n)}(d_d/2, d_n/2).\n\nWrapper for the Cephes [1]_ routine `fdtrc`.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def fdtri(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "fdtri(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nfdtri(dfn, dfd, p)\n\nThe `p`-th quantile of the F-distribution.\n\nThis function is the inverse of the F-distribution CDF, `fdtr`, returning\nthe `x` such that `fdtr(dfn, dfd, x) = p`.\n\nParameters\n----------\ndfn : array_like\n    First parameter (positive float).\ndfd : array_like\n    Second parameter (positive float).\np : array_like\n    Cumulative probability, in [0, 1].\n\nReturns\n-------\nx : ndarray\n    The quantile corresponding to `p`.\n\nNotes\n-----\nThe computation is carried out using the relation to the inverse\nregularized beta function, :math:`I^{-1}_x(a, b)`.  Let\n:math:`z = I^{-1}_p(d_d/2, d_n/2).`  Then,\n\n.. math::\n    x = \\frac{d_d (1 - z)}{d_n z}.\n\nIf `p` is such that :math:`x < 0.5`, the following relation is used\ninstead for improved stability: let\n:math:`z' = I^{-1}_{1 - p}(d_n/2, d_d/2).` Then,\n\n.. math::\n    x = \\frac{d_d z'}{d_n (1 - z')}.\n\nWrapper for the Cephes [1]_ routine `fdtri`.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def fdtridfd(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "fdtridfd(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nfdtridfd(dfn, p, x)\n\nInverse to `fdtr` vs dfd\n\nFinds the F density argument dfd such that ``fdtr(dfn, dfd, x) == p``."
    ...

def fresnel(x, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "fresnel(x[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nfresnel(z, out=None)\n\nFresnel integrals.\n\nThe Fresnel integrals are defined as\n\n.. math::\n\n   S(z) &= \\int_0^z \\sin(\\pi t^2 /2) dt \\\\\n   C(z) &= \\int_0^z \\cos(\\pi t^2 /2) dt.\n\nSee [dlmf]_ for details.\n\nParameters\n----------\nz : array_like\n    Real or complex valued argument\nout : 2-tuple of ndarrays, optional\n    Optional output arrays for the function results\n\nReturns\n-------\nS, C : 2-tuple of scalar or ndarray\n    Values of the Fresnel integrals\n\nSee Also\n--------\nfresnel_zeros : zeros of the Fresnel integrals\n\nReferences\n----------\n.. [dlmf] NIST Digital Library of Mathematical Functions\n          https://dlmf.nist.gov/7.2#iii\n\nExamples\n--------\n>>> import scipy.special as sc\n\nAs z goes to infinity along the real axis, S and C converge to 0.5.\n\n>>> S, C = sc.fresnel([0.1, 1, 10, 100, np.inf])\n>>> S\narray([0.00052359, 0.43825915, 0.46816998, 0.4968169 , 0.5       ])\n>>> C\narray([0.09999753, 0.7798934 , 0.49989869, 0.4999999 , 0.5       ])\n\nThey are related to the error function `erf`.\n\n>>> z = np.array([1, 2, 3, 4])\n>>> zeta = 0.5 * np.sqrt(np.pi) * (1 - 1j) * z\n>>> S, C = sc.fresnel(z)\n>>> C + 1j*S\narray([0.7798934 +0.43825915j, 0.48825341+0.34341568j,\n       0.60572079+0.496313j  , 0.49842603+0.42051575j])\n>>> 0.5 * (1 + 1j) * sc.erf(zeta)\narray([0.7798934 +0.43825915j, 0.48825341+0.34341568j,\n       0.60572079+0.496313j  , 0.49842603+0.42051575j])"
    ...

def gamma(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "gamma(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ngamma(z)\n\ngamma function.\n\nThe gamma function is defined as\n\n.. math::\n\n   \\Gamma(z) = \\int_0^\\infty t^{z-1} e^{-t} dt\n\nfor :math:`\\Re(z) > 0` and is extended to the rest of the complex\nplane by analytic continuation. See [dlmf]_ for more details.\n\nParameters\n----------\nz : array_like\n    Real or complex valued argument\n\nReturns\n-------\nscalar or ndarray\n    Values of the gamma function\n\nNotes\n-----\nThe gamma function is often referred to as the generalized\nfactorial since :math:`\\Gamma(n + 1) = n!` for natural numbers\n:math:`n`. More generally it satisfies the recurrence relation\n:math:`\\Gamma(z + 1) = z \\cdot \\Gamma(z)` for complex :math:`z`,\nwhich, combined with the fact that :math:`\\Gamma(1) = 1`, implies\nthe above identity for :math:`z = n`.\n\nReferences\n----------\n.. [dlmf] NIST Digital Library of Mathematical Functions\n          https://dlmf.nist.gov/5.2#E1\n\nExamples\n--------\n>>> from scipy.special import gamma, factorial\n\n>>> gamma([0, 0.5, 1, 5])\narray([         inf,   1.77245385,   1.        ,  24.        ])\n\n>>> z = 2.5 + 1j\n>>> gamma(z)\n(0.77476210455108352+0.70763120437959293j)\n>>> gamma(z+1), z*gamma(z)  # Recurrence property\n((1.2292740569981171+2.5438401155000685j),\n (1.2292740569981158+2.5438401155000658j))\n\n>>> gamma(0.5)**2  # gamma(0.5) = sqrt(pi)\n3.1415926535897927\n\nPlot gamma(x) for real x\n\n>>> x = np.linspace(-3.5, 5.5, 2251)\n>>> y = gamma(x)\n\n>>> import matplotlib.pyplot as plt\n>>> plt.plot(x, y, 'b', alpha=0.6, label='gamma(x)')\n>>> k = np.arange(1, 7)\n>>> plt.plot(k, factorial(k-1), 'k*', alpha=0.6,\n...          label='(x-1)!, x = 1, 2, ...')\n>>> plt.xlim(-3.5, 5.5)\n>>> plt.ylim(-10, 25)\n>>> plt.grid()\n>>> plt.xlabel('x')\n>>> plt.legend(loc='lower right')\n>>> plt.show()"
    ...

def gammainc(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'gammainc(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\ngammainc(a, x)\n\nRegularized lower incomplete gamma function.\n\nIt is defined as\n\n.. math::\n\n    P(a, x) = \\frac{1}{\\Gamma(a)} \\int_0^x t^{a - 1}e^{-t} dt\n\nfor :math:`a > 0` and :math:`x \\geq 0`. See [dlmf]_ for details.\n\nParameters\n----------\na : array_like\n    Positive parameter\nx : array_like\n    Nonnegative argument\n\nReturns\n-------\nscalar or ndarray\n    Values of the lower incomplete gamma function\n\nNotes\n-----\nThe function satisfies the relation ``gammainc(a, x) +\ngammaincc(a, x) = 1`` where `gammaincc` is the regularized upper\nincomplete gamma function.\n\nThe implementation largely follows that of [boost]_.\n\nSee also\n--------\ngammaincc : regularized upper incomplete gamma function\ngammaincinv : inverse of the regularized lower incomplete gamma\n    function with respect to `x`\ngammainccinv : inverse of the regularized upper incomplete gamma\n    function with respect to `x`\n\nReferences\n----------\n.. [dlmf] NIST Digital Library of Mathematical functions\n          https://dlmf.nist.gov/8.2#E4\n.. [boost] Maddock et. al., "Incomplete Gamma Functions",\n   https://www.boost.org/doc/libs/1_61_0/libs/math/doc/html/math_toolkit/sf_gamma/igamma.html\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is the CDF of the gamma distribution, so it starts at 0 and\nmonotonically increases to 1.\n\n>>> sc.gammainc(0.5, [0, 1, 10, 100])\narray([0.        , 0.84270079, 0.99999226, 1.        ])\n\nIt is equal to one minus the upper incomplete gamma function.\n\n>>> a, x = 0.5, 0.4\n>>> sc.gammainc(a, x)\n0.6289066304773024\n>>> 1 - sc.gammaincc(a, x)\n0.6289066304773024'
    ...

def gammaincc(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'gammaincc(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\ngammaincc(a, x)\n\nRegularized upper incomplete gamma function.\n\nIt is defined as\n\n.. math::\n\n    Q(a, x) = \\frac{1}{\\Gamma(a)} \\int_x^\\infty t^{a - 1}e^{-t} dt\n\nfor :math:`a > 0` and :math:`x \\geq 0`. See [dlmf]_ for details.\n\nParameters\n----------\na : array_like\n    Positive parameter\nx : array_like\n    Nonnegative argument\n\nReturns\n-------\nscalar or ndarray\n    Values of the upper incomplete gamma function\n\nNotes\n-----\nThe function satisfies the relation ``gammainc(a, x) +\ngammaincc(a, x) = 1`` where `gammainc` is the regularized lower\nincomplete gamma function.\n\nThe implementation largely follows that of [boost]_.\n\nSee also\n--------\ngammainc : regularized lower incomplete gamma function\ngammaincinv : inverse of the regularized lower incomplete gamma\n    function with respect to `x`\ngammainccinv : inverse to of the regularized upper incomplete\n    gamma function with respect to `x`\n\nReferences\n----------\n.. [dlmf] NIST Digital Library of Mathematical functions\n          https://dlmf.nist.gov/8.2#E4\n.. [boost] Maddock et. al., "Incomplete Gamma Functions",\n   https://www.boost.org/doc/libs/1_61_0/libs/math/doc/html/math_toolkit/sf_gamma/igamma.html\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is the survival function of the gamma distribution, so it\nstarts at 1 and monotonically decreases to 0.\n\n>>> sc.gammaincc(0.5, [0, 1, 10, 100, 1000])\narray([1.00000000e+00, 1.57299207e-01, 7.74421643e-06, 2.08848758e-45,\n       0.00000000e+00])\n\nIt is equal to one minus the lower incomplete gamma function.\n\n>>> a, x = 0.5, 0.4\n>>> sc.gammaincc(a, x)\n0.37109336952269756\n>>> 1 - sc.gammainc(a, x)\n0.37109336952269756'
    ...

def gammainccinv(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "gammainccinv(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ngammainccinv(a, y)\n\nInverse of the upper incomplete gamma function with respect to `x`\n\nGiven an input :math:`y` between 0 and 1, returns :math:`x` such\nthat :math:`y = Q(a, x)`. Here :math:`Q` is the upper incomplete\ngamma function; see `gammaincc`. This is well-defined because the\nupper incomplete gamma function is monotonic as can be seen from\nits definition in [dlmf]_.\n\nParameters\n----------\na : array_like\n    Positive parameter\ny : array_like\n    Argument between 0 and 1, inclusive\n\nReturns\n-------\nscalar or ndarray\n    Values of the inverse of the upper incomplete gamma function\n\nSee Also\n--------\ngammaincc : regularized upper incomplete gamma function\ngammainc : regularized lower incomplete gamma function\ngammaincinv : inverse of the regularized lower incomplete gamma\n    function with respect to `x`\n\nReferences\n----------\n.. [dlmf] NIST Digital Library of Mathematical Functions\n          https://dlmf.nist.gov/8.2#E4\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt starts at infinity and monotonically decreases to 0.\n\n>>> sc.gammainccinv(0.5, [0, 0.1, 0.5, 1])\narray([       inf, 1.35277173, 0.22746821, 0.        ])\n\nIt inverts the upper incomplete gamma function.\n\n>>> a, x = 0.5, [0, 0.1, 0.5, 1]\n>>> sc.gammaincc(a, sc.gammainccinv(a, x))\narray([0. , 0.1, 0.5, 1. ])\n\n>>> a, x = 0.5, [0, 10, 50]\n>>> sc.gammainccinv(a, sc.gammaincc(a, x))\narray([ 0., 10., 50.])"
    ...

def gammaincinv(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "gammaincinv(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ngammaincinv(a, y)\n\nInverse to the lower incomplete gamma function with respect to `x`.\n\nGiven an input :math:`y` between 0 and 1, returns :math:`x` such\nthat :math:`y = P(a, x)`. Here :math:`P` is the regularized lower\nincomplete gamma function; see `gammainc`. This is well-defined\nbecause the lower incomplete gamma function is monotonic as can be\nseen from its definition in [dlmf]_.\n\nParameters\n----------\na : array_like\n    Positive parameter\ny : array_like\n    Parameter between 0 and 1, inclusive\n\nReturns\n-------\nscalar or ndarray\n    Values of the inverse of the lower incomplete gamma function\n\nSee Also\n--------\ngammainc : regularized lower incomplete gamma function\ngammaincc : regularized upper incomplete gamma function\ngammainccinv : inverse of the regualizred upper incomplete gamma\n    function with respect to `x`\n\nReferences\n----------\n.. [dlmf] NIST Digital Library of Mathematical Functions\n          https://dlmf.nist.gov/8.2#E4\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt starts at 0 and monotonically increases to infinity.\n\n>>> sc.gammaincinv(0.5, [0, 0.1 ,0.5, 1])\narray([0.        , 0.00789539, 0.22746821,        inf])\n\nIt inverts the lower incomplete gamma function.\n\n>>> a, x = 0.5, [0, 0.1, 0.5, 1]\n>>> sc.gammainc(a, sc.gammaincinv(a, x))\narray([0. , 0.1, 0.5, 1. ])\n\n>>> a, x = 0.5, [0, 10, 25]\n>>> sc.gammaincinv(a, sc.gammainc(a, x))\narray([ 0.        , 10.        , 25.00001465])"
    ...

def gammaln(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "gammaln(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ngammaln(x, out=None)\n\nLogarithm of the absolute value of the gamma function.\n\nDefined as\n\n.. math::\n\n   \\ln(\\lvert\\Gamma(x)\\rvert)\n\nwhere :math:`\\Gamma` is the gamma function. For more details on\nthe gamma function, see [dlmf]_.\n\nParameters\n----------\nx : array_like\n    Real argument\nout : ndarray, optional\n    Optional output array for the function results\n\nReturns\n-------\nscalar or ndarray\n    Values of the log of the absolute value of gamma\n\nSee Also\n--------\ngammasgn : sign of the gamma function\nloggamma : principal branch of the logarithm of the gamma function\n\nNotes\n-----\nIt is the same function as the Python standard library function\n:func:`math.lgamma`.\n\nWhen used in conjunction with `gammasgn`, this function is useful\nfor working in logspace on the real axis without having to deal\nwith complex numbers via the relation ``exp(gammaln(x)) =\ngammasgn(x) * gamma(x)``.\n\nFor complex-valued log-gamma, use `loggamma` instead of `gammaln`.\n\nReferences\n----------\n.. [dlmf] NIST Digital Library of Mathematical Functions\n          https://dlmf.nist.gov/5\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt has two positive zeros.\n\n>>> sc.gammaln([1, 2])\narray([0., 0.])\n\nIt has poles at nonpositive integers.\n\n>>> sc.gammaln([0, -1, -2, -3, -4])\narray([inf, inf, inf, inf, inf])\n\nIt asymptotically approaches ``x * log(x)`` (Stirling's formula).\n\n>>> x = np.array([1e10, 1e20, 1e40, 1e80])\n>>> sc.gammaln(x)\narray([2.20258509e+11, 4.50517019e+21, 9.11034037e+41, 1.83206807e+82])\n>>> x * np.log(x)\narray([2.30258509e+11, 4.60517019e+21, 9.21034037e+41, 1.84206807e+82])"
    ...

def gammasgn(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "gammasgn(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ngammasgn(x)\n\nSign of the gamma function.\n\nIt is defined as\n\n.. math::\n\n   \\text{gammasgn}(x) =\n   \\begin{cases}\n     +1 & \\Gamma(x) > 0 \\\\\n     -1 & \\Gamma(x) < 0\n   \\end{cases}\n\nwhere :math:`\\Gamma` is the gamma function; see `gamma`. This\ndefinition is complete since the gamma function is never zero;\nsee the discussion after [dlmf]_.\n\nParameters\n----------\nx : array_like\n    Real argument\n\nReturns\n-------\nscalar or ndarray\n    Sign of the gamma function\n\nNotes\n-----\nThe gamma function can be computed as ``gammasgn(x) *\nnp.exp(gammaln(x))``.\n\nSee Also\n--------\ngamma : the gamma function\ngammaln : log of the absolute value of the gamma function\nloggamma : analytic continuation of the log of the gamma function\n\nReferences\n----------\n.. [dlmf] NIST Digital Library of Mathematical Functions\n          https://dlmf.nist.gov/5.2#E1\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is 1 for `x > 0`.\n\n>>> sc.gammasgn([1, 2, 3, 4])\narray([1., 1., 1., 1.])\n\nIt alternates between -1 and 1 for negative integers.\n\n>>> sc.gammasgn([-0.5, -1.5, -2.5, -3.5])\narray([-1.,  1., -1.,  1.])\n\nIt can be used to compute the gamma function.\n\n>>> x = [1.5, 0.5, -0.5, -1.5]\n>>> sc.gammasgn(x) * np.exp(sc.gammaln(x))\narray([ 0.88622693,  1.77245385, -3.5449077 ,  2.3632718 ])\n>>> sc.gamma(x)\narray([ 0.88622693,  1.77245385, -3.5449077 ,  2.3632718 ])"
    ...

def gdtr(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "gdtr(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ngdtr(a, b, x)\n\nGamma distribution cumulative distribution function.\n\nReturns the integral from zero to `x` of the gamma probability density\nfunction,\n\n.. math::\n\n    F = \\int_0^x \\frac{a^b}{\\Gamma(b)} t^{b-1} e^{-at}\\,dt,\n\nwhere :math:`\\Gamma` is the gamma function.\n\nParameters\n----------\na : array_like\n    The rate parameter of the gamma distribution, sometimes denoted\n    :math:`\\beta` (float).  It is also the reciprocal of the scale\n    parameter :math:`\\theta`.\nb : array_like\n    The shape parameter of the gamma distribution, sometimes denoted\n    :math:`\\alpha` (float).\nx : array_like\n    The quantile (upper limit of integration; float).\n\nSee also\n--------\ngdtrc : 1 - CDF of the gamma distribution.\n\nReturns\n-------\nF : ndarray\n    The CDF of the gamma distribution with parameters `a` and `b`\n    evaluated at `x`.\n\nNotes\n-----\nThe evaluation is carried out using the relation to the incomplete gamma\nintegral (regularized gamma function).\n\nWrapper for the Cephes [1]_ routine `gdtr`.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def gdtrc(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "gdtrc(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ngdtrc(a, b, x)\n\nGamma distribution survival function.\n\nIntegral from `x` to infinity of the gamma probability density function,\n\n.. math::\n\n    F = \\int_x^\\infty \\frac{a^b}{\\Gamma(b)} t^{b-1} e^{-at}\\,dt,\n\nwhere :math:`\\Gamma` is the gamma function.\n\nParameters\n----------\na : array_like\n    The rate parameter of the gamma distribution, sometimes denoted\n    :math:`\\beta` (float). It is also the reciprocal of the scale\n    parameter :math:`\\theta`.\nb : array_like\n    The shape parameter of the gamma distribution, sometimes denoted\n    :math:`\\alpha` (float).\nx : array_like\n    The quantile (lower limit of integration; float).\n\nReturns\n-------\nF : ndarray\n    The survival function of the gamma distribution with parameters `a`\n    and `b` evaluated at `x`.\n\nSee Also\n--------\ngdtr, gdtrix\n\nNotes\n-----\nThe evaluation is carried out using the relation to the incomplete gamma\nintegral (regularized gamma function).\n\nWrapper for the Cephes [1]_ routine `gdtrc`.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def gdtria(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'gdtria(x1, x2, x3, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\ngdtria(p, b, x, out=None)\n\nInverse of `gdtr` vs a.\n\nReturns the inverse with respect to the parameter `a` of ``p =\ngdtr(a, b, x)``, the cumulative distribution function of the gamma\ndistribution.\n\nParameters\n----------\np : array_like\n    Probability values.\nb : array_like\n    `b` parameter values of `gdtr(a, b, x)`. `b` is the "shape" parameter\n    of the gamma distribution.\nx : array_like\n    Nonnegative real values, from the domain of the gamma distribution.\nout : ndarray, optional\n    If a fourth argument is given, it must be a numpy.ndarray whose size\n    matches the broadcast result of `a`, `b` and `x`.  `out` is then the\n    array returned by the function.\n\nReturns\n-------\na : ndarray\n    Values of the `a` parameter such that `p = gdtr(a, b, x)`.  `1/a`\n    is the "scale" parameter of the gamma distribution.\n\nSee Also\n--------\ngdtr : CDF of the gamma distribution.\ngdtrib : Inverse with respect to `b` of `gdtr(a, b, x)`.\ngdtrix : Inverse with respect to `x` of `gdtr(a, b, x)`.\n\nNotes\n-----\nWrapper for the CDFLIB [1]_ Fortran routine `cdfgam`.\n\nThe cumulative distribution function `p` is computed using a routine by\nDiDinato and Morris [2]_. Computation of `a` involves a search for a value\nthat produces the desired value of `p`. The search relies on the\nmonotonicity of `p` with `a`.\n\nReferences\n----------\n.. [1] Barry Brown, James Lovato, and Kathy Russell,\n       CDFLIB: Library of Fortran Routines for Cumulative Distribution\n       Functions, Inverses, and Other Parameters.\n.. [2] DiDinato, A. R. and Morris, A. H.,\n       Computation of the incomplete gamma function ratios and their\n       inverse.  ACM Trans. Math. Softw. 12 (1986), 377-393.\n\nExamples\n--------\nFirst evaluate `gdtr`.\n\n>>> from scipy.special import gdtr, gdtria\n>>> p = gdtr(1.2, 3.4, 5.6)\n>>> print(p)\n0.94378087442\n\nVerify the inverse.\n\n>>> gdtria(p, 3.4, 5.6)\n1.2'
    ...

def gdtrib(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'gdtrib(x1, x2, x3, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\ngdtrib(a, p, x, out=None)\n\nInverse of `gdtr` vs b.\n\nReturns the inverse with respect to the parameter `b` of ``p =\ngdtr(a, b, x)``, the cumulative distribution function of the gamma\ndistribution.\n\nParameters\n----------\na : array_like\n    `a` parameter values of `gdtr(a, b, x)`. `1/a` is the "scale"\n    parameter of the gamma distribution.\np : array_like\n    Probability values.\nx : array_like\n    Nonnegative real values, from the domain of the gamma distribution.\nout : ndarray, optional\n    If a fourth argument is given, it must be a numpy.ndarray whose size\n    matches the broadcast result of `a`, `b` and `x`.  `out` is then the\n    array returned by the function.\n\nReturns\n-------\nb : ndarray\n    Values of the `b` parameter such that `p = gdtr(a, b, x)`.  `b` is\n    the "shape" parameter of the gamma distribution.\n\nSee Also\n--------\ngdtr : CDF of the gamma distribution.\ngdtria : Inverse with respect to `a` of `gdtr(a, b, x)`.\ngdtrix : Inverse with respect to `x` of `gdtr(a, b, x)`.\n\nNotes\n-----\nWrapper for the CDFLIB [1]_ Fortran routine `cdfgam`.\n\nThe cumulative distribution function `p` is computed using a routine by\nDiDinato and Morris [2]_. Computation of `b` involves a search for a value\nthat produces the desired value of `p`. The search relies on the\nmonotonicity of `p` with `b`.\n\nReferences\n----------\n.. [1] Barry Brown, James Lovato, and Kathy Russell,\n       CDFLIB: Library of Fortran Routines for Cumulative Distribution\n       Functions, Inverses, and Other Parameters.\n.. [2] DiDinato, A. R. and Morris, A. H.,\n       Computation of the incomplete gamma function ratios and their\n       inverse.  ACM Trans. Math. Softw. 12 (1986), 377-393.\n\nExamples\n--------\nFirst evaluate `gdtr`.\n\n>>> from scipy.special import gdtr, gdtrib\n>>> p = gdtr(1.2, 3.4, 5.6)\n>>> print(p)\n0.94378087442\n\nVerify the inverse.\n\n>>> gdtrib(1.2, p, 5.6)\n3.3999999999723882'
    ...

def gdtrix(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'gdtrix(x1, x2, x3, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\ngdtrix(a, b, p, out=None)\n\nInverse of `gdtr` vs x.\n\nReturns the inverse with respect to the parameter `x` of ``p =\ngdtr(a, b, x)``, the cumulative distribution function of the gamma\ndistribution. This is also known as the pth quantile of the\ndistribution.\n\nParameters\n----------\na : array_like\n    `a` parameter values of `gdtr(a, b, x)`. `1/a` is the "scale"\n    parameter of the gamma distribution.\nb : array_like\n    `b` parameter values of `gdtr(a, b, x)`. `b` is the "shape" parameter\n    of the gamma distribution.\np : array_like\n    Probability values.\nout : ndarray, optional\n    If a fourth argument is given, it must be a numpy.ndarray whose size\n    matches the broadcast result of `a`, `b` and `x`. `out` is then the\n    array returned by the function.\n\nReturns\n-------\nx : ndarray\n    Values of the `x` parameter such that `p = gdtr(a, b, x)`.\n\nSee Also\n--------\ngdtr : CDF of the gamma distribution.\ngdtria : Inverse with respect to `a` of `gdtr(a, b, x)`.\ngdtrib : Inverse with respect to `b` of `gdtr(a, b, x)`.\n\nNotes\n-----\nWrapper for the CDFLIB [1]_ Fortran routine `cdfgam`.\n\nThe cumulative distribution function `p` is computed using a routine by\nDiDinato and Morris [2]_. Computation of `x` involves a search for a value\nthat produces the desired value of `p`. The search relies on the\nmonotonicity of `p` with `x`.\n\nReferences\n----------\n.. [1] Barry Brown, James Lovato, and Kathy Russell,\n       CDFLIB: Library of Fortran Routines for Cumulative Distribution\n       Functions, Inverses, and Other Parameters.\n.. [2] DiDinato, A. R. and Morris, A. H.,\n       Computation of the incomplete gamma function ratios and their\n       inverse.  ACM Trans. Math. Softw. 12 (1986), 377-393.\n\nExamples\n--------\nFirst evaluate `gdtr`.\n\n>>> from scipy.special import gdtr, gdtrix\n>>> p = gdtr(1.2, 3.4, 5.6)\n>>> print(p)\n0.94378087442\n\nVerify the inverse.\n\n>>> gdtrix(1.2, 3.4, p)\n5.5999999999999996'
    ...

def geterr() -> typing.Any:
    'Get the current way of handling special-function errors.\n\n    Returns\n    -------\n    err : dict\n        A dictionary with keys "singular", "underflow", "overflow",\n        "slow", "loss", "no_result", "domain", "arg", and "other",\n        whose values are from the strings "ignore", "warn", and\n        "raise". The keys represent possible special-function errors,\n        and the values define how these errors are handled.\n\n    See Also\n    --------\n    seterr : set how special-function errors are handled\n    errstate : context manager for special-function error handling\n    numpy.geterr : similar numpy function for floating-point errors\n\n    Notes\n    -----\n    For complete documentation of the types of special-function errors\n    and treatment options, see `seterr`.\n\n    Examples\n    --------\n    By default all errors are ignored.\n\n    >>> import scipy.special as sc\n    >>> for key, value in sorted(sc.geterr().items()):\n    ...     print("{}: {}".format(key, value))\n    ...\n    arg: ignore\n    domain: ignore\n    loss: ignore\n    no_result: ignore\n    other: ignore\n    overflow: ignore\n    singular: ignore\n    slow: ignore\n    underflow: ignore\n\n    '
    ...

def hankel1(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'hankel1(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nhankel1(v, z)\n\nHankel function of the first kind\n\nParameters\n----------\nv : array_like\n    Order (float).\nz : array_like\n    Argument (float or complex).\n\nReturns\n-------\nout : Values of the Hankel function of the first kind.\n\nNotes\n-----\nA wrapper for the AMOS [1]_ routine `zbesh`, which carries out the\ncomputation using the relation,\n\n.. math:: H^{(1)}_v(z) = \\frac{2}{\\imath\\pi} \\exp(-\\imath \\pi v/2) K_v(z \\exp(-\\imath\\pi/2))\n\nwhere :math:`K_v` is the modified Bessel function of the second kind.\nFor negative orders, the relation\n\n.. math:: H^{(1)}_{-v}(z) = H^{(1)}_v(z) \\exp(\\imath\\pi v)\n\nis used.\n\nSee also\n--------\nhankel1e : this function with leading exponential behavior stripped off.\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/'
    ...

def hankel1e(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'hankel1e(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nhankel1e(v, z)\n\nExponentially scaled Hankel function of the first kind\n\nDefined as::\n\n    hankel1e(v, z) = hankel1(v, z) * exp(-1j * z)\n\nParameters\n----------\nv : array_like\n    Order (float).\nz : array_like\n    Argument (float or complex).\n\nReturns\n-------\nout : Values of the exponentially scaled Hankel function.\n\nNotes\n-----\nA wrapper for the AMOS [1]_ routine `zbesh`, which carries out the\ncomputation using the relation,\n\n.. math:: H^{(1)}_v(z) = \\frac{2}{\\imath\\pi} \\exp(-\\imath \\pi v/2) K_v(z \\exp(-\\imath\\pi/2))\n\nwhere :math:`K_v` is the modified Bessel function of the second kind.\nFor negative orders, the relation\n\n.. math:: H^{(1)}_{-v}(z) = H^{(1)}_v(z) \\exp(\\imath\\pi v)\n\nis used.\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/'
    ...

def hankel2(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'hankel2(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nhankel2(v, z)\n\nHankel function of the second kind\n\nParameters\n----------\nv : array_like\n    Order (float).\nz : array_like\n    Argument (float or complex).\n\nReturns\n-------\nout : Values of the Hankel function of the second kind.\n\nNotes\n-----\nA wrapper for the AMOS [1]_ routine `zbesh`, which carries out the\ncomputation using the relation,\n\n.. math:: H^{(2)}_v(z) = -\\frac{2}{\\imath\\pi} \\exp(\\imath \\pi v/2) K_v(z \\exp(\\imath\\pi/2))\n\nwhere :math:`K_v` is the modified Bessel function of the second kind.\nFor negative orders, the relation\n\n.. math:: H^{(2)}_{-v}(z) = H^{(2)}_v(z) \\exp(-\\imath\\pi v)\n\nis used.\n\nSee also\n--------\nhankel2e : this function with leading exponential behavior stripped off.\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/'
    ...

def hankel2e(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'hankel2e(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nhankel2e(v, z)\n\nExponentially scaled Hankel function of the second kind\n\nDefined as::\n\n    hankel2e(v, z) = hankel2(v, z) * exp(1j * z)\n\nParameters\n----------\nv : array_like\n    Order (float).\nz : array_like\n    Argument (float or complex).\n\nReturns\n-------\nout : Values of the exponentially scaled Hankel function of the second kind.\n\nNotes\n-----\nA wrapper for the AMOS [1]_ routine `zbesh`, which carries out the\ncomputation using the relation,\n\n.. math:: H^{(2)}_v(z) = -\\frac{2}{\\imath\\pi} \\exp(\\frac{\\imath \\pi v}{2}) K_v(z exp(\\frac{\\imath\\pi}{2}))\n\nwhere :math:`K_v` is the modified Bessel function of the second kind.\nFor negative orders, the relation\n\n.. math:: H^{(2)}_{-v}(z) = H^{(2)}_v(z) \\exp(-\\imath\\pi v)\n\nis used.\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/'
    ...

def huber(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "huber(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nhuber(delta, r)\n\nHuber loss function.\n\n.. math:: \\text{huber}(\\delta, r) = \\begin{cases} \\infty & \\delta < 0  \\\\ \\frac{1}{2}r^2 & 0 \\le \\delta, | r | \\le \\delta \\\\ \\delta ( |r| - \\frac{1}{2}\\delta ) & \\text{otherwise} \\end{cases}\n\nParameters\n----------\ndelta : ndarray\n    Input array, indicating the quadratic vs. linear loss changepoint.\nr : ndarray\n    Input array, possibly representing residuals.\n\nReturns\n-------\nres : ndarray\n    The computed Huber loss function values.\n\nNotes\n-----\nThis function is convex in r.\n\n.. versionadded:: 0.15.0"
    ...

def hyp0f1(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'hyp0f1(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nhyp0f1(v, z, out=None)\n\nConfluent hypergeometric limit function 0F1.\n\nParameters\n----------\nv : array_like\n    Real-valued parameter\nz : array_like\n    Real- or complex-valued argument\nout : ndarray, optional\n    Optional output array for the function results\n\nReturns\n-------\nscalar or ndarray\n    The confluent hypergeometric limit function\n\nNotes\n-----\nThis function is defined as:\n\n.. math:: _0F_1(v, z) = \\sum_{k=0}^{\\infty}\\frac{z^k}{(v)_k k!}.\n\nIt\'s also the limit as :math:`q \\to \\infty` of :math:`_1F_1(q; v; z/q)`,\nand satisfies the differential equation :math:`f\'\'(z) + vf\'(z) =\nf(z)`. See [1]_ for more information.\n\nReferences\n----------\n.. [1] Wolfram MathWorld, "Confluent Hypergeometric Limit Function",\n       http://mathworld.wolfram.com/ConfluentHypergeometricLimitFunction.html\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is one when `z` is zero.\n\n>>> sc.hyp0f1(1, 0)\n1.0\n\nIt is the limit of the confluent hypergeometric function as `q`\ngoes to infinity.\n\n>>> q = np.array([1, 10, 100, 1000])\n>>> v = 1\n>>> z = 1\n>>> sc.hyp1f1(q, v, z / q)\narray([2.71828183, 2.31481985, 2.28303778, 2.27992985])\n>>> sc.hyp0f1(v, z)\n2.2795853023360673\n\nIt is related to Bessel functions.\n\n>>> n = 1\n>>> x = np.linspace(0, 1, 5)\n>>> sc.jv(n, x)\narray([0.        , 0.12402598, 0.24226846, 0.3492436 , 0.44005059])\n>>> (0.5 * x)**n / sc.factorial(n) * sc.hyp0f1(n + 1, -0.25 * x**2)\narray([0.        , 0.12402598, 0.24226846, 0.3492436 , 0.44005059])'
    ...

def hyp1f1(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "hyp1f1(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nhyp1f1(a, b, x, out=None)\n\nConfluent hypergeometric function 1F1.\n\nThe confluent hypergeometric function is defined by the series\n\n.. math::\n\n   {}_1F_1(a; b; x) = \\sum_{k = 0}^\\infty \\frac{(a)_k}{(b)_k k!} x^k.\n\nSee [dlmf]_ for more details. Here :math:`(\\cdot)_k` is the\nPochhammer symbol; see `poch`.\n\nParameters\n----------\na, b : array_like\n    Real parameters\nx : array_like\n    Real or complex argument\nout : ndarray, optional\n    Optional output array for the function results\n\nReturns\n-------\nscalar or ndarray\n    Values of the confluent hypergeometric function\n\nSee also\n--------\nhyperu : another confluent hypergeometric function\nhyp0f1 : confluent hypergeometric limit function\nhyp2f1 : Gaussian hypergeometric function\n\nReferences\n----------\n.. [dlmf] NIST Digital Library of Mathematical Functions\n          https://dlmf.nist.gov/13.2#E2\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is one when `x` is zero:\n\n>>> sc.hyp1f1(0.5, 0.5, 0)\n1.0\n\nIt is singular when `b` is a nonpositive integer.\n\n>>> sc.hyp1f1(0.5, -1, 0)\ninf\n\nIt is a polynomial when `a` is a nonpositive integer.\n\n>>> a, b, x = -1, 0.5, np.array([1.0, 2.0, 3.0, 4.0])\n>>> sc.hyp1f1(a, b, x)\narray([-1., -3., -5., -7.])\n>>> 1 + (a / b) * x\narray([-1., -3., -5., -7.])\n\nIt reduces to the exponential function when `a = b`.\n\n>>> sc.hyp1f1(2, 2, [1, 2, 3, 4])\narray([ 2.71828183,  7.3890561 , 20.08553692, 54.59815003])\n>>> np.exp([1, 2, 3, 4])\narray([ 2.71828183,  7.3890561 , 20.08553692, 54.59815003])"
    ...

def hyp2f1(x1, x2, x3, x4, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'hyp2f1(x1, x2, x3, x4, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nhyp2f1(a, b, c, z)\n\nGauss hypergeometric function 2F1(a, b; c; z)\n\nParameters\n----------\na, b, c : array_like\n    Arguments, should be real-valued.\nz : array_like\n    Argument, real or complex.\n\nReturns\n-------\nhyp2f1 : scalar or ndarray\n    The values of the gaussian hypergeometric function.\n\nSee also\n--------\nhyp0f1 : confluent hypergeometric limit function.\nhyp1f1 : Kummer\'s (confluent hypergeometric) function.\n\nNotes\n-----\nThis function is defined for :math:`|z| < 1` as\n\n.. math::\n\n   \\mathrm{hyp2f1}(a, b, c, z) = \\sum_{n=0}^\\infty\n   \\frac{(a)_n (b)_n}{(c)_n}\\frac{z^n}{n!},\n\nand defined on the rest of the complex z-plane by analytic\ncontinuation [1]_.\nHere :math:`(\\cdot)_n` is the Pochhammer symbol; see `poch`. When\n:math:`n` is an integer the result is a polynomial of degree :math:`n`.\n\nThe implementation for complex values of ``z`` is described in [2]_.\n\nReferences\n----------\n.. [1] NIST Digital Library of Mathematical Functions\n       https://dlmf.nist.gov/15.2\n.. [2] S. Zhang and J.M. Jin, "Computation of Special Functions", Wiley 1996\n.. [3] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt has poles when `c` is a negative integer.\n\n>>> sc.hyp2f1(1, 1, -2, 1)\ninf\n\nIt is a polynomial when `a` or `b` is a negative integer.\n\n>>> a, b, c = -1, 1, 1.5\n>>> z = np.linspace(0, 1, 5)\n>>> sc.hyp2f1(a, b, c, z)\narray([1.        , 0.83333333, 0.66666667, 0.5       , 0.33333333])\n>>> 1 + a * b * z / c\narray([1.        , 0.83333333, 0.66666667, 0.5       , 0.33333333])\n\nIt is symmetric in `a` and `b`.\n\n>>> a = np.linspace(0, 1, 5)\n>>> b = np.linspace(0, 1, 5)\n>>> sc.hyp2f1(a, b, 1, 0.5)\narray([1.        , 1.03997334, 1.1803406 , 1.47074441, 2.        ])\n>>> sc.hyp2f1(b, a, 1, 0.5)\narray([1.        , 1.03997334, 1.1803406 , 1.47074441, 2.        ])\n\nIt contains many other functions as special cases.\n\n>>> z = 0.5\n>>> sc.hyp2f1(1, 1, 2, z)\n1.3862943611198901\n>>> -np.log(1 - z) / z\n1.3862943611198906\n\n>>> sc.hyp2f1(0.5, 1, 1.5, z**2)\n1.098612288668109\n>>> np.log((1 + z) / (1 - z)) / (2 * z)\n1.0986122886681098\n\n>>> sc.hyp2f1(0.5, 1, 1.5, -z**2)\n0.9272952180016117\n>>> np.arctan(z) / z\n0.9272952180016123'
    ...

def hyperu(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "hyperu(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nhyperu(a, b, x, out=None)\n\nConfluent hypergeometric function U\n\nIt is defined as the solution to the equation\n\n.. math::\n\n   x \\frac{d^2w}{dx^2} + (b - x) \\frac{dw}{dx} - aw = 0\n\nwhich satisfies the property\n\n.. math::\n\n   U(a, b, x) \\sim x^{-a}\n\nas :math:`x \\to \\infty`. See [dlmf]_ for more details.\n\nParameters\n----------\na, b : array_like\n    Real-valued parameters\nx : array_like\n    Real-valued argument\nout : ndarray\n    Optional output array for the function values\n\nReturns\n-------\nscalar or ndarray\n    Values of `U`\n\nReferences\n----------\n.. [dlmf] NIST Digital Library of Mathematics Functions\n          https://dlmf.nist.gov/13.2#E6\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt has a branch cut along the negative `x` axis.\n\n>>> x = np.linspace(-0.1, -10, 5)\n>>> sc.hyperu(1, 1, x)\narray([nan, nan, nan, nan, nan])\n\nIt approaches zero as `x` goes to infinity.\n\n>>> x = np.array([1, 10, 100])\n>>> sc.hyperu(1, 1, x)\narray([0.59634736, 0.09156333, 0.00990194])\n\nIt satisfies Kummer's transformation.\n\n>>> a, b, x = 2, 1, 1\n>>> sc.hyperu(a, b, x)\n0.1926947246463881\n>>> x**(1 - b) * sc.hyperu(a - b + 1, 2 - b, x)\n0.1926947246463881"
    ...

def i0(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "i0(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ni0(x)\n\nModified Bessel function of order 0.\n\nDefined as,\n\n.. math::\n    I_0(x) = \\sum_{k=0}^\\infty \\frac{(x^2/4)^k}{(k!)^2} = J_0(\\imath x),\n\nwhere :math:`J_0` is the Bessel function of the first kind of order 0.\n\nParameters\n----------\nx : array_like\n    Argument (float)\n\nReturns\n-------\nI : ndarray\n    Value of the modified Bessel function of order 0 at `x`.\n\nNotes\n-----\nThe range is partitioned into the two intervals [0, 8] and (8, infinity).\nChebyshev polynomial expansions are employed in each interval.\n\nThis function is a wrapper for the Cephes [1]_ routine `i0`.\n\nSee also\n--------\niv\ni0e\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def i0e(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "i0e(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ni0e(x)\n\nExponentially scaled modified Bessel function of order 0.\n\nDefined as::\n\n    i0e(x) = exp(-abs(x)) * i0(x).\n\nParameters\n----------\nx : array_like\n    Argument (float)\n\nReturns\n-------\nI : ndarray\n    Value of the exponentially scaled modified Bessel function of order 0\n    at `x`.\n\nNotes\n-----\nThe range is partitioned into the two intervals [0, 8] and (8, infinity).\nChebyshev polynomial expansions are employed in each interval. The\npolynomial expansions used are the same as those in `i0`, but\nthey are not multiplied by the dominant exponential factor.\n\nThis function is a wrapper for the Cephes [1]_ routine `i0e`.\n\nSee also\n--------\niv\ni0\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def i1(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "i1(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ni1(x)\n\nModified Bessel function of order 1.\n\nDefined as,\n\n.. math::\n    I_1(x) = \\frac{1}{2}x \\sum_{k=0}^\\infty \\frac{(x^2/4)^k}{k! (k + 1)!}\n           = -\\imath J_1(\\imath x),\n\nwhere :math:`J_1` is the Bessel function of the first kind of order 1.\n\nParameters\n----------\nx : array_like\n    Argument (float)\n\nReturns\n-------\nI : ndarray\n    Value of the modified Bessel function of order 1 at `x`.\n\nNotes\n-----\nThe range is partitioned into the two intervals [0, 8] and (8, infinity).\nChebyshev polynomial expansions are employed in each interval.\n\nThis function is a wrapper for the Cephes [1]_ routine `i1`.\n\nSee also\n--------\niv\ni1e\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def i1e(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "i1e(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ni1e(x)\n\nExponentially scaled modified Bessel function of order 1.\n\nDefined as::\n\n    i1e(x) = exp(-abs(x)) * i1(x)\n\nParameters\n----------\nx : array_like\n    Argument (float)\n\nReturns\n-------\nI : ndarray\n    Value of the exponentially scaled modified Bessel function of order 1\n    at `x`.\n\nNotes\n-----\nThe range is partitioned into the two intervals [0, 8] and (8, infinity).\nChebyshev polynomial expansions are employed in each interval. The\npolynomial expansions used are the same as those in `i1`, but\nthey are not multiplied by the dominant exponential factor.\n\nThis function is a wrapper for the Cephes [1]_ routine `i1e`.\n\nSee also\n--------\niv\ni1\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def inv_boxcox(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "inv_boxcox(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ninv_boxcox(y, lmbda)\n\nCompute the inverse of the Box-Cox transformation.\n\nFind ``x`` such that::\n\n    y = (x**lmbda - 1) / lmbda  if lmbda != 0\n        log(x)                  if lmbda == 0\n\nParameters\n----------\ny : array_like\n    Data to be transformed.\nlmbda : array_like\n    Power parameter of the Box-Cox transform.\n\nReturns\n-------\nx : array\n    Transformed data.\n\nNotes\n-----\n\n.. versionadded:: 0.16.0\n\nExamples\n--------\n>>> from scipy.special import boxcox, inv_boxcox\n>>> y = boxcox([1, 4, 10], 2.5)\n>>> inv_boxcox(y, 2.5)\narray([1., 4., 10.])"
    ...

def inv_boxcox1p(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "inv_boxcox1p(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ninv_boxcox1p(y, lmbda)\n\nCompute the inverse of the Box-Cox transformation.\n\nFind ``x`` such that::\n\n    y = ((1+x)**lmbda - 1) / lmbda  if lmbda != 0\n        log(1+x)                    if lmbda == 0\n\nParameters\n----------\ny : array_like\n    Data to be transformed.\nlmbda : array_like\n    Power parameter of the Box-Cox transform.\n\nReturns\n-------\nx : array\n    Transformed data.\n\nNotes\n-----\n\n.. versionadded:: 0.16.0\n\nExamples\n--------\n>>> from scipy.special import boxcox1p, inv_boxcox1p\n>>> y = boxcox1p([1, 4, 10], 2.5)\n>>> inv_boxcox1p(y, 2.5)\narray([1., 4., 10.])"
    ...

def it2i0k0(x, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "it2i0k0(x[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nit2i0k0(x, out=None)\n\nIntegrals related to modified Bessel functions of order 0.\n\nComputes the integrals\n\n.. math::\n\n    \\int_0^x \\frac{I_0(t) - 1}{t} dt \\\\\n    \\int_x^\\infty \\frac{K_0(t)}{t} dt.\n\nParameters\n----------\nx : array_like\n    Values at which to evaluate the integrals.\nout : tuple of ndarrays, optional\n    Optional output arrays for the function results.\n\nReturns\n-------\nii0 : scalar or ndarray\n    The integral for `i0`\nik0 : scalar or ndarray\n    The integral for `k0`"
    ...

def it2j0y0(x, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "it2j0y0(x[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nit2j0y0(x, out=None)\n\nIntegrals related to Bessel functions of the first kind of order 0.\n\nComputes the integrals\n\n.. math::\n\n    \\int_0^x \\frac{1 - J_0(t)}{t} dt \\\\\n    \\int_x^\\infty \\frac{Y_0(t)}{t} dt.\n\nFor more on :math:`J_0` and :math:`Y_0` see `j0` and `y0`.\n\nParameters\n----------\nx : array_like\n    Values at which to evaluate the integrals.\nout : tuple of ndarrays, optional\n    Optional output arrays for the function results.\n\nReturns\n-------\nij0 : scalar or ndarray\n    The integral for `j0`\niy0 : scalar or ndarray\n    The integral for `y0`"
    ...

def it2struve0(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'it2struve0(x, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nit2struve0(x)\n\nIntegral related to the Struve function of order 0.\n\nReturns the integral,\n\n.. math::\n    \\int_x^\\infty \\frac{H_0(t)}{t}\\,dt\n\nwhere :math:`H_0` is the Struve function of order 0.\n\nParameters\n----------\nx : array_like\n    Lower limit of integration.\n\nReturns\n-------\nI : ndarray\n    The value of the integral.\n\nSee also\n--------\nstruve\n\nNotes\n-----\nWrapper for a Fortran routine created by Shanjie Zhang and Jianming\nJin [1]_.\n\nReferences\n----------\n.. [1] Zhang, Shanjie and Jin, Jianming. "Computation of Special\n       Functions", John Wiley and Sons, 1996.\n       https://people.sc.fsu.edu/~jburkardt/f_src/special_functions/special_functions.html'
    ...

def itairy(x, out1=..., out2=..., out3=..., out4=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'itairy(x[, out1, out2, out3, out4], / [, out=(None, None, None, None)], *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nitairy(x)\n\nIntegrals of Airy functions\n\nCalculates the integrals of Airy functions from 0 to `x`.\n\nParameters\n----------\n\nx: array_like\n    Upper limit of integration (float).\n\nReturns\n-------\nApt\n    Integral of Ai(t) from 0 to x.\nBpt\n    Integral of Bi(t) from 0 to x.\nAnt\n    Integral of Ai(-t) from 0 to x.\nBnt\n    Integral of Bi(-t) from 0 to x.\n\nNotes\n-----\n\nWrapper for a Fortran routine created by Shanjie Zhang and Jianming\nJin [1]_.\n\nReferences\n----------\n\n.. [1] Zhang, Shanjie and Jin, Jianming. "Computation of Special\n       Functions", John Wiley and Sons, 1996.\n       https://people.sc.fsu.edu/~jburkardt/f_src/special_functions/special_functions.html'
    ...

def iti0k0(x, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "iti0k0(x[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\niti0k0(x, out=None)\n\nIntegrals of modified Bessel functions of order 0.\n\nComputes the integrals\n\n.. math::\n\n    \\int_0^x I_0(t) dt \\\\\n    \\int_0^x K_0(t) dt.\n\nFor more on :math:`I_0` and :math:`K_0` see `i0` and `k0`.\n\nParameters\n----------\nx : array_like\n    Values at which to evaluate the integrals.\nout : tuple of ndarrays, optional\n    Optional output arrays for the function results.\n\nReturns\n-------\nii0 : scalar or ndarray\n    The integral for `i0`\nik0 : scalar or ndarray\n    The integral for `k0`"
    ...

def itj0y0(x, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "itj0y0(x[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nitj0y0(x, out=None)\n\nIntegrals of Bessel functions of the first kind of order 0.\n\nComputes the integrals\n\n.. math::\n\n    \\int_0^x J_0(t) dt \\\\\n    \\int_0^x Y_0(t) dt.\n\nFor more on :math:`J_0` and :math:`Y_0` see `j0` and `y0`.\n\nParameters\n----------\nx : array_like\n    Values at which to evaluate the integrals.\nout : tuple of ndarrays, optional\n    Optional output arrays for the function results.\n\nReturns\n-------\nij0 : scalar or ndarray\n    The integral of `j0`\niy0 : scalar or ndarray\n    The integral of `y0`"
    ...

def itmodstruve0(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'itmodstruve0(x, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nitmodstruve0(x)\n\nIntegral of the modified Struve function of order 0.\n\n.. math::\n    I = \\int_0^x L_0(t)\\,dt\n\nParameters\n----------\nx : array_like\n    Upper limit of integration (float).\n\nReturns\n-------\nI : ndarray\n    The integral of :math:`L_0` from 0 to `x`.\n\nNotes\n-----\nWrapper for a Fortran routine created by Shanjie Zhang and Jianming\nJin [1]_.\n\nReferences\n----------\n.. [1] Zhang, Shanjie and Jin, Jianming. "Computation of Special\n       Functions", John Wiley and Sons, 1996.\n       https://people.sc.fsu.edu/~jburkardt/f_src/special_functions/special_functions.html'
    ...

def itstruve0(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'itstruve0(x, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nitstruve0(x)\n\nIntegral of the Struve function of order 0.\n\n.. math::\n    I = \\int_0^x H_0(t)\\,dt\n\nParameters\n----------\nx : array_like\n    Upper limit of integration (float).\n\nReturns\n-------\nI : ndarray\n    The integral of :math:`H_0` from 0 to `x`.\n\nSee also\n--------\nstruve\n\nNotes\n-----\nWrapper for a Fortran routine created by Shanjie Zhang and Jianming\nJin [1]_.\n\nReferences\n----------\n.. [1] Zhang, Shanjie and Jin, Jianming. "Computation of Special\n       Functions", John Wiley and Sons, 1996.\n       https://people.sc.fsu.edu/~jburkardt/f_src/special_functions/special_functions.html'
    ...

def iv(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'iv(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\niv(v, z)\n\nModified Bessel function of the first kind of real order.\n\nParameters\n----------\nv : array_like\n    Order. If `z` is of real type and negative, `v` must be integer\n    valued.\nz : array_like of float or complex\n    Argument.\n\nReturns\n-------\nout : ndarray\n    Values of the modified Bessel function.\n\nNotes\n-----\nFor real `z` and :math:`v \\in [-50, 50]`, the evaluation is carried out\nusing Temme\'s method [1]_.  For larger orders, uniform asymptotic\nexpansions are applied.\n\nFor complex `z` and positive `v`, the AMOS [2]_ `zbesi` routine is\ncalled. It uses a power series for small `z`, the asymptotic expansion\nfor large `abs(z)`, the Miller algorithm normalized by the Wronskian\nand a Neumann series for intermediate magnitudes, and the uniform\nasymptotic expansions for :math:`I_v(z)` and :math:`J_v(z)` for large\norders. Backward recurrence is used to generate sequences or reduce\norders when necessary.\n\nThe calculations above are done in the right half plane and continued\ninto the left half plane by the formula,\n\n.. math:: I_v(z \\exp(\\pm\\imath\\pi)) = \\exp(\\pm\\pi v) I_v(z)\n\n(valid when the real part of `z` is positive).  For negative `v`, the\nformula\n\n.. math:: I_{-v}(z) = I_v(z) + \\frac{2}{\\pi} \\sin(\\pi v) K_v(z)\n\nis used, where :math:`K_v(z)` is the modified Bessel function of the\nsecond kind, evaluated using the AMOS routine `zbesk`.\n\nSee also\n--------\nkve : This function with leading exponential behavior stripped off.\n\nReferences\n----------\n.. [1] Temme, Journal of Computational Physics, vol 21, 343 (1976)\n.. [2] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/'
    ...

def ive(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'ive(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nive(v, z)\n\nExponentially scaled modified Bessel function of the first kind\n\nDefined as::\n\n    ive(v, z) = iv(v, z) * exp(-abs(z.real))\n\nParameters\n----------\nv : array_like of float\n    Order.\nz : array_like of float or complex\n    Argument.\n\nReturns\n-------\nout : ndarray\n    Values of the exponentially scaled modified Bessel function.\n\nNotes\n-----\nFor positive `v`, the AMOS [1]_ `zbesi` routine is called. It uses a\npower series for small `z`, the asymptotic expansion for large\n`abs(z)`, the Miller algorithm normalized by the Wronskian and a\nNeumann series for intermediate magnitudes, and the uniform asymptotic\nexpansions for :math:`I_v(z)` and :math:`J_v(z)` for large orders.\nBackward recurrence is used to generate sequences or reduce orders when\nnecessary.\n\nThe calculations above are done in the right half plane and continued\ninto the left half plane by the formula,\n\n.. math:: I_v(z \\exp(\\pm\\imath\\pi)) = \\exp(\\pm\\pi v) I_v(z)\n\n(valid when the real part of `z` is positive).  For negative `v`, the\nformula\n\n.. math:: I_{-v}(z) = I_v(z) + \\frac{2}{\\pi} \\sin(\\pi v) K_v(z)\n\nis used, where :math:`K_v(z)` is the modified Bessel function of the\nsecond kind, evaluated using the AMOS routine `zbesk`.\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/'
    ...

def j0(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "j0(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nj0(x)\n\nBessel function of the first kind of order 0.\n\nParameters\n----------\nx : array_like\n    Argument (float).\n\nReturns\n-------\nJ : ndarray\n    Value of the Bessel function of the first kind of order 0 at `x`.\n\nNotes\n-----\nThe domain is divided into the intervals [0, 5] and (5, infinity). In the\nfirst interval the following rational approximation is used:\n\n.. math::\n\n    J_0(x) \\approx (w - r_1^2)(w - r_2^2) \\frac{P_3(w)}{Q_8(w)},\n\nwhere :math:`w = x^2` and :math:`r_1`, :math:`r_2` are the zeros of\n:math:`J_0`, and :math:`P_3` and :math:`Q_8` are polynomials of degrees 3\nand 8, respectively.\n\nIn the second interval, the Hankel asymptotic expansion is employed with\ntwo rational functions of degree 6/6 and 7/7.\n\nThis function is a wrapper for the Cephes [1]_ routine `j0`.\nIt should not be confused with the spherical Bessel functions (see\n`spherical_jn`).\n\nSee also\n--------\njv : Bessel function of real order and complex argument.\nspherical_jn : spherical Bessel functions.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def j1(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "j1(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nj1(x)\n\nBessel function of the first kind of order 1.\n\nParameters\n----------\nx : array_like\n    Argument (float).\n\nReturns\n-------\nJ : ndarray\n    Value of the Bessel function of the first kind of order 1 at `x`.\n\nNotes\n-----\nThe domain is divided into the intervals [0, 8] and (8, infinity). In the\nfirst interval a 24 term Chebyshev expansion is used. In the second, the\nasymptotic trigonometric representation is employed using two rational\nfunctions of degree 5/5.\n\nThis function is a wrapper for the Cephes [1]_ routine `j1`.\nIt should not be confused with the spherical Bessel functions (see\n`spherical_jn`).\n\nSee also\n--------\njv\nspherical_jn : spherical Bessel functions.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def jn(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'jv(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\njv(v, z)\n\nBessel function of the first kind of real order and complex argument.\n\nParameters\n----------\nv : array_like\n    Order (float).\nz : array_like\n    Argument (float or complex).\n\nReturns\n-------\nJ : ndarray\n    Value of the Bessel function, :math:`J_v(z)`.\n\nNotes\n-----\nFor positive `v` values, the computation is carried out using the AMOS\n[1]_ `zbesj` routine, which exploits the connection to the modified\nBessel function :math:`I_v`,\n\n.. math::\n    J_v(z) = \\exp(v\\pi\\imath/2) I_v(-\\imath z)\\qquad (\\Im z > 0)\n\n    J_v(z) = \\exp(-v\\pi\\imath/2) I_v(\\imath z)\\qquad (\\Im z < 0)\n\nFor negative `v` values the formula,\n\n.. math:: J_{-v}(z) = J_v(z) \\cos(\\pi v) - Y_v(z) \\sin(\\pi v)\n\nis used, where :math:`Y_v(z)` is the Bessel function of the second\nkind, computed using the AMOS routine `zbesy`.  Note that the second\nterm is exactly zero for integer `v`; to improve accuracy the second\nterm is explicitly omitted for `v` values such that `v = floor(v)`.\n\nNot to be confused with the spherical Bessel functions (see `spherical_jn`).\n\nSee also\n--------\njve : :math:`J_v` with leading exponential behavior stripped off.\nspherical_jn : spherical Bessel functions.\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/'
    ...

def jv(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'jv(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\njv(v, z)\n\nBessel function of the first kind of real order and complex argument.\n\nParameters\n----------\nv : array_like\n    Order (float).\nz : array_like\n    Argument (float or complex).\n\nReturns\n-------\nJ : ndarray\n    Value of the Bessel function, :math:`J_v(z)`.\n\nNotes\n-----\nFor positive `v` values, the computation is carried out using the AMOS\n[1]_ `zbesj` routine, which exploits the connection to the modified\nBessel function :math:`I_v`,\n\n.. math::\n    J_v(z) = \\exp(v\\pi\\imath/2) I_v(-\\imath z)\\qquad (\\Im z > 0)\n\n    J_v(z) = \\exp(-v\\pi\\imath/2) I_v(\\imath z)\\qquad (\\Im z < 0)\n\nFor negative `v` values the formula,\n\n.. math:: J_{-v}(z) = J_v(z) \\cos(\\pi v) - Y_v(z) \\sin(\\pi v)\n\nis used, where :math:`Y_v(z)` is the Bessel function of the second\nkind, computed using the AMOS routine `zbesy`.  Note that the second\nterm is exactly zero for integer `v`; to improve accuracy the second\nterm is explicitly omitted for `v` values such that `v = floor(v)`.\n\nNot to be confused with the spherical Bessel functions (see `spherical_jn`).\n\nSee also\n--------\njve : :math:`J_v` with leading exponential behavior stripped off.\nspherical_jn : spherical Bessel functions.\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/'
    ...

def jve(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'jve(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\njve(v, z)\n\nExponentially scaled Bessel function of order `v`.\n\nDefined as::\n\n    jve(v, z) = jv(v, z) * exp(-abs(z.imag))\n\nParameters\n----------\nv : array_like\n    Order (float).\nz : array_like\n    Argument (float or complex).\n\nReturns\n-------\nJ : ndarray\n    Value of the exponentially scaled Bessel function.\n\nNotes\n-----\nFor positive `v` values, the computation is carried out using the AMOS\n[1]_ `zbesj` routine, which exploits the connection to the modified\nBessel function :math:`I_v`,\n\n.. math::\n    J_v(z) = \\exp(v\\pi\\imath/2) I_v(-\\imath z)\\qquad (\\Im z > 0)\n\n    J_v(z) = \\exp(-v\\pi\\imath/2) I_v(\\imath z)\\qquad (\\Im z < 0)\n\nFor negative `v` values the formula,\n\n.. math:: J_{-v}(z) = J_v(z) \\cos(\\pi v) - Y_v(z) \\sin(\\pi v)\n\nis used, where :math:`Y_v(z)` is the Bessel function of the second\nkind, computed using the AMOS routine `zbesy`.  Note that the second\nterm is exactly zero for integer `v`; to improve accuracy the second\nterm is explicitly omitted for `v` values such that `v = floor(v)`.\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/'
    ...

def k0(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "k0(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nk0(x)\n\nModified Bessel function of the second kind of order 0, :math:`K_0`.\n\nThis function is also sometimes referred to as the modified Bessel\nfunction of the third kind of order 0.\n\nParameters\n----------\nx : array_like\n    Argument (float).\n\nReturns\n-------\nK : ndarray\n    Value of the modified Bessel function :math:`K_0` at `x`.\n\nNotes\n-----\nThe range is partitioned into the two intervals [0, 2] and (2, infinity).\nChebyshev polynomial expansions are employed in each interval.\n\nThis function is a wrapper for the Cephes [1]_ routine `k0`.\n\nSee also\n--------\nkv\nk0e\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def k0e(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "k0e(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nk0e(x)\n\nExponentially scaled modified Bessel function K of order 0\n\nDefined as::\n\n    k0e(x) = exp(x) * k0(x).\n\nParameters\n----------\nx : array_like\n    Argument (float)\n\nReturns\n-------\nK : ndarray\n    Value of the exponentially scaled modified Bessel function K of order\n    0 at `x`.\n\nNotes\n-----\nThe range is partitioned into the two intervals [0, 2] and (2, infinity).\nChebyshev polynomial expansions are employed in each interval.\n\nThis function is a wrapper for the Cephes [1]_ routine `k0e`.\n\nSee also\n--------\nkv\nk0\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def k1(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "k1(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nk1(x)\n\nModified Bessel function of the second kind of order 1, :math:`K_1(x)`.\n\nParameters\n----------\nx : array_like\n    Argument (float)\n\nReturns\n-------\nK : ndarray\n    Value of the modified Bessel function K of order 1 at `x`.\n\nNotes\n-----\nThe range is partitioned into the two intervals [0, 2] and (2, infinity).\nChebyshev polynomial expansions are employed in each interval.\n\nThis function is a wrapper for the Cephes [1]_ routine `k1`.\n\nSee also\n--------\nkv\nk1e\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def k1e(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "k1e(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nk1e(x)\n\nExponentially scaled modified Bessel function K of order 1\n\nDefined as::\n\n    k1e(x) = exp(x) * k1(x)\n\nParameters\n----------\nx : array_like\n    Argument (float)\n\nReturns\n-------\nK : ndarray\n    Value of the exponentially scaled modified Bessel function K of order\n    1 at `x`.\n\nNotes\n-----\nThe range is partitioned into the two intervals [0, 2] and (2, infinity).\nChebyshev polynomial expansions are employed in each interval.\n\nThis function is a wrapper for the Cephes [1]_ routine `k1e`.\n\nSee also\n--------\nkv\nk1\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def kei(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "kei(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nkei(x, out=None)\n\nKelvin function kei.\n\nDefined as\n\n.. math::\n\n    \\mathrm{kei}(x) = \\Im[K_0(x e^{\\pi i / 4})]\n\nwhere :math:`K_0` is the modified Bessel function of the second\nkind (see `kv`). See [dlmf]_ for more details.\n\nParameters\n----------\nx : array_like\n    Real argument.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Values of the Kelvin function.\n\nSee Also\n--------\nker : the corresponding real part\nkeip : the derivative of kei\nkv : modified Bessel function of the second kind\n\nReferences\n----------\n.. [dlmf] NIST, Digital Library of Mathematical Functions,\n    https://dlmf.nist.gov/10.61\n\nExamples\n--------\nIt can be expressed using the modified Bessel function of the\nsecond kind.\n\n>>> import scipy.special as sc\n>>> x = np.array([1.0, 2.0, 3.0, 4.0])\n>>> sc.kv(0, x * np.exp(np.pi * 1j / 4)).imag\narray([-0.49499464, -0.20240007, -0.05112188,  0.0021984 ])\n>>> sc.kei(x)\narray([-0.49499464, -0.20240007, -0.05112188,  0.0021984 ])"
    ...

def keip(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "keip(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nkeip(x, out=None)\n\nDerivative of the Kelvin function kei.\n\nParameters\n----------\nx : array_like\n    Real argument.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    The values of the derivative of kei.\n\nSee Also\n--------\nkei\n\nReferences\n----------\n.. [dlmf] NIST, Digital Library of Mathematical Functions,\n    https://dlmf.nist.gov/10#PT5"
    ...

def kelvin(x, out1=..., out2=..., out3=..., out4=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "kelvin(x[, out1, out2, out3, out4], / [, out=(None, None, None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nkelvin(x)\n\nKelvin functions as complex numbers\n\nReturns\n-------\nBe, Ke, Bep, Kep\n    The tuple (Be, Ke, Bep, Kep) contains complex numbers\n    representing the real and imaginary Kelvin functions and their\n    derivatives evaluated at `x`.  For example, kelvin(x)[0].real =\n    ber x and kelvin(x)[0].imag = bei x with similar relationships\n    for ker and kei."
    ...

def ker(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ker(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nker(x, out=None)\n\nKelvin function ker.\n\nDefined as\n\n.. math::\n\n    \\mathrm{ker}(x) = \\Re[K_0(x e^{\\pi i / 4})]\n\nWhere :math:`K_0` is the modified Bessel function of the second\nkind (see `kv`). See [dlmf]_ for more details.\n\nParameters\n----------\nx : array_like\n    Real argument.\nout : ndarray, optional\n    Optional output array for the function results.\n\nSee Also\n--------\nkei : the corresponding imaginary part\nkerp : the derivative of ker\nkv : modified Bessel function of the second kind\n\nReturns\n-------\nscalar or ndarray\n    Values of the Kelvin function.\n\nReferences\n----------\n.. [dlmf] NIST, Digital Library of Mathematical Functions,\n    https://dlmf.nist.gov/10.61\n\nExamples\n--------\nIt can be expressed using the modified Bessel function of the\nsecond kind.\n\n>>> import scipy.special as sc\n>>> x = np.array([1.0, 2.0, 3.0, 4.0])\n>>> sc.kv(0, x * np.exp(np.pi * 1j / 4)).real\narray([ 0.28670621, -0.04166451, -0.06702923, -0.03617885])\n>>> sc.ker(x)\narray([ 0.28670621, -0.04166451, -0.06702923, -0.03617885])"
    ...

def kerp(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "kerp(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nkerp(x, out=None)\n\nDerivative of the Kelvin function ker.\n\nParameters\n----------\nx : array_like\n    Real argument.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Values of the derivative of ker.\n\nSee Also\n--------\nker\n\nReferences\n----------\n.. [dlmf] NIST, Digital Library of Mathematical Functions,\n    https://dlmf.nist.gov/10#PT5"
    ...

def kl_div(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'kl_div(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nkl_div(x, y, out=None)\n\nElementwise function for computing Kullback-Leibler divergence.\n\n.. math::\n\n    \\mathrm{kl\\_div}(x, y) =\n      \\begin{cases}\n        x \\log(x / y) - x + y & x > 0, y > 0 \\\\\n        y & x = 0, y \\ge 0 \\\\\n        \\infty & \\text{otherwise}\n      \\end{cases}\n\nParameters\n----------\nx, y : array_like\n    Real arguments\nout : ndarray, optional\n    Optional output array for the function results\n\nReturns\n-------\nscalar or ndarray\n    Values of the Kullback-Liebler divergence.\n\nSee Also\n--------\nentr, rel_entr\n\nNotes\n-----\n.. versionadded:: 0.15.0\n\nThis function is non-negative and is jointly convex in `x` and `y`.\n\nThe origin of this function is in convex programming; see [1]_ for\ndetails. This is why the the function contains the extra :math:`-x\n+ y` terms over what might be expected from the Kullback-Leibler\ndivergence. For a version of the function without the extra terms,\nsee `rel_entr`.\n\nReferences\n----------\n.. [1] Grant, Boyd, and Ye, "CVX: Matlab Software for Disciplined Convex\n    Programming", http://cvxr.com/cvx/'
    ...

def kn(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'kn(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nkn(n, x)\n\nModified Bessel function of the second kind of integer order `n`\n\nReturns the modified Bessel function of the second kind for integer order\n`n` at real `z`.\n\nThese are also sometimes called functions of the third kind, Basset\nfunctions, or Macdonald functions.\n\nParameters\n----------\nn : array_like of int\n    Order of Bessel functions (floats will truncate with a warning)\nz : array_like of float\n    Argument at which to evaluate the Bessel functions\n\nReturns\n-------\nout : ndarray\n    The results\n\nNotes\n-----\nWrapper for AMOS [1]_ routine `zbesk`.  For a discussion of the\nalgorithm used, see [2]_ and the references therein.\n\nSee Also\n--------\nkv : Same function, but accepts real order and complex argument\nkvp : Derivative of this function\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/\n.. [2] Donald E. Amos, "Algorithm 644: A portable package for Bessel\n       functions of a complex argument and nonnegative order", ACM\n       TOMS Vol. 12 Issue 3, Sept. 1986, p. 265\n\nExamples\n--------\nPlot the function of several orders for real input:\n\n>>> from scipy.special import kn\n>>> import matplotlib.pyplot as plt\n>>> x = np.linspace(0, 5, 1000)\n>>> for N in range(6):\n...     plt.plot(x, kn(N, x), label=\'$K_{}(x)$\'.format(N))\n>>> plt.ylim(0, 10)\n>>> plt.legend()\n>>> plt.title(r\'Modified Bessel function of the second kind $K_n(x)$\')\n>>> plt.show()\n\nCalculate for a single value at multiple orders:\n\n>>> kn([4, 5, 6], 1)\narray([   44.23241585,   360.9605896 ,  3653.83831186])'
    ...

def kolmogi(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "kolmogi(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nkolmogi(p)\n\nInverse Survival Function of Kolmogorov distribution\n\nIt is the inverse function to `kolmogorov`.\nReturns y such that ``kolmogorov(y) == p``.\n\nParameters\n----------\np : float array_like\n    Probability\n\nReturns\n-------\nfloat\n    The value(s) of kolmogi(p)\n\nNotes\n-----\n`kolmogorov` is used by `stats.kstest` in the application of the\nKolmogorov-Smirnov Goodness of Fit test. For historial reasons this\nfunction is exposed in `scpy.special`, but the recommended way to achieve\nthe most accurate CDF/SF/PDF/PPF/ISF computations is to use the\n`stats.kstwobign` distribution.\n\nSee Also\n--------\nkolmogorov : The Survival Function for the distribution\nscipy.stats.kstwobign : Provides the functionality as a continuous distribution\nsmirnov, smirnovi : Functions for the one-sided distribution\n\nExamples\n--------\n>>> from scipy.special import kolmogi\n>>> kolmogi([0, 0.1, 0.25, 0.5, 0.75, 0.9, 1.0])\narray([        inf,  1.22384787,  1.01918472,  0.82757356,  0.67644769,\n        0.57117327,  0.        ])"
    ...

def kolmogorov(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "kolmogorov(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nkolmogorov(y)\n\nComplementary cumulative distribution (Survival Function) function of\nKolmogorov distribution.\n\nReturns the complementary cumulative distribution function of\nKolmogorov's limiting distribution (``D_n*\\sqrt(n)`` as n goes to infinity)\nof a two-sided test for equality between an empirical and a theoretical\ndistribution. It is equal to the (limit as n->infinity of the)\nprobability that ``sqrt(n) * max absolute deviation > y``.\n\nParameters\n----------\ny : float array_like\n  Absolute deviation between the Empirical CDF (ECDF) and the target CDF,\n  multiplied by sqrt(n).\n\nReturns\n-------\nfloat\n    The value(s) of kolmogorov(y)\n\nNotes\n-----\n`kolmogorov` is used by `stats.kstest` in the application of the\nKolmogorov-Smirnov Goodness of Fit test. For historial reasons this\nfunction is exposed in `scpy.special`, but the recommended way to achieve\nthe most accurate CDF/SF/PDF/PPF/ISF computations is to use the\n`stats.kstwobign` distribution.\n\nSee Also\n--------\nkolmogi : The Inverse Survival Function for the distribution\nscipy.stats.kstwobign : Provides the functionality as a continuous distribution\nsmirnov, smirnovi : Functions for the one-sided distribution\n\nExamples\n--------\nShow the probability of a gap at least as big as 0, 0.5 and 1.0.\n\n>>> from scipy.special import kolmogorov\n>>> from scipy.stats import kstwobign\n>>> kolmogorov([0, 0.5, 1.0])\narray([ 1.        ,  0.96394524,  0.26999967])\n\nCompare a sample of size 1000 drawn from a Laplace(0, 1) distribution against\nthe target distribution, a Normal(0, 1) distribution.\n\n>>> from scipy.stats import norm, laplace\n>>> n = 1000\n>>> np.random.seed(seed=233423)\n>>> lap01 = laplace(0, 1)\n>>> x = np.sort(lap01.rvs(n))\n>>> np.mean(x), np.std(x)\n(-0.083073685397609842, 1.3676426568399822)\n\nConstruct the Empirical CDF and the K-S statistic Dn.\n\n>>> target = norm(0,1)  # Normal mean 0, stddev 1\n>>> cdfs = target.cdf(x)\n>>> ecdfs = np.arange(n+1, dtype=float)/n\n>>> gaps = np.column_stack([cdfs - ecdfs[:n], ecdfs[1:] - cdfs])\n>>> Dn = np.max(gaps)\n>>> Kn = np.sqrt(n) * Dn\n>>> print('Dn=%f, sqrt(n)*Dn=%f' % (Dn, Kn))\nDn=0.058286, sqrt(n)*Dn=1.843153\n>>> print(chr(10).join(['For a sample of size n drawn from a N(0, 1) distribution:',\n...   ' the approximate Kolmogorov probability that sqrt(n)*Dn>=%f is %f' %  (Kn, kolmogorov(Kn)),\n...   ' the approximate Kolmogorov probability that sqrt(n)*Dn<=%f is %f' %  (Kn, kstwobign.cdf(Kn))]))\nFor a sample of size n drawn from a N(0, 1) distribution:\n the approximate Kolmogorov probability that sqrt(n)*Dn>=1.843153 is 0.002240\n the approximate Kolmogorov probability that sqrt(n)*Dn<=1.843153 is 0.997760\n\nPlot the Empirical CDF against the target N(0, 1) CDF.\n\n>>> import matplotlib.pyplot as plt\n>>> plt.step(np.concatenate([[-3], x]), ecdfs, where='post', label='Empirical CDF')\n>>> x3 = np.linspace(-3, 3, 100)\n>>> plt.plot(x3, target.cdf(x3), label='CDF for N(0, 1)')\n>>> plt.ylim([0, 1]); plt.grid(True); plt.legend();\n>>> # Add vertical lines marking Dn+ and Dn-\n>>> iminus, iplus = np.argmax(gaps, axis=0)\n>>> plt.vlines([x[iminus]], ecdfs[iminus], cdfs[iminus], color='r', linestyle='dashed', lw=4)\n>>> plt.vlines([x[iplus]], cdfs[iplus], ecdfs[iplus+1], color='r', linestyle='dashed', lw=4)\n>>> plt.show()"
    ...

def kv(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'kv(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nkv(v, z)\n\nModified Bessel function of the second kind of real order `v`\n\nReturns the modified Bessel function of the second kind for real order\n`v` at complex `z`.\n\nThese are also sometimes called functions of the third kind, Basset\nfunctions, or Macdonald functions.  They are defined as those solutions\nof the modified Bessel equation for which,\n\n.. math::\n    K_v(x) \\sim \\sqrt{\\pi/(2x)} \\exp(-x)\n\nas :math:`x \\to \\infty` [3]_.\n\nParameters\n----------\nv : array_like of float\n    Order of Bessel functions\nz : array_like of complex\n    Argument at which to evaluate the Bessel functions\n\nReturns\n-------\nout : ndarray\n    The results. Note that input must be of complex type to get complex\n    output, e.g. ``kv(3, -2+0j)`` instead of ``kv(3, -2)``.\n\nNotes\n-----\nWrapper for AMOS [1]_ routine `zbesk`.  For a discussion of the\nalgorithm used, see [2]_ and the references therein.\n\nSee Also\n--------\nkve : This function with leading exponential behavior stripped off.\nkvp : Derivative of this function\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/\n.. [2] Donald E. Amos, "Algorithm 644: A portable package for Bessel\n       functions of a complex argument and nonnegative order", ACM\n       TOMS Vol. 12 Issue 3, Sept. 1986, p. 265\n.. [3] NIST Digital Library of Mathematical Functions,\n       Eq. 10.25.E3. https://dlmf.nist.gov/10.25.E3\n\nExamples\n--------\nPlot the function of several orders for real input:\n\n>>> from scipy.special import kv\n>>> import matplotlib.pyplot as plt\n>>> x = np.linspace(0, 5, 1000)\n>>> for N in np.linspace(0, 6, 5):\n...     plt.plot(x, kv(N, x), label=\'$K_{{{}}}(x)$\'.format(N))\n>>> plt.ylim(0, 10)\n>>> plt.legend()\n>>> plt.title(r\'Modified Bessel function of the second kind $K_\\nu(x)$\')\n>>> plt.show()\n\nCalculate for a single value at multiple orders:\n\n>>> kv([4, 4.5, 5], 1+2j)\narray([ 0.1992+2.3892j,  2.3493+3.6j   ,  7.2827+3.8104j])'
    ...

def kve(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'kve(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nkve(v, z)\n\nExponentially scaled modified Bessel function of the second kind.\n\nReturns the exponentially scaled, modified Bessel function of the\nsecond kind (sometimes called the third kind) for real order `v` at\ncomplex `z`::\n\n    kve(v, z) = kv(v, z) * exp(z)\n\nParameters\n----------\nv : array_like of float\n    Order of Bessel functions\nz : array_like of complex\n    Argument at which to evaluate the Bessel functions\n\nReturns\n-------\nout : ndarray\n    The exponentially scaled modified Bessel function of the second kind.\n\nNotes\n-----\nWrapper for AMOS [1]_ routine `zbesk`.  For a discussion of the\nalgorithm used, see [2]_ and the references therein.\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/\n.. [2] Donald E. Amos, "Algorithm 644: A portable package for Bessel\n       functions of a complex argument and nonnegative order", ACM\n       TOMS Vol. 12 Issue 3, Sept. 1986, p. 265'
    ...

def log1p(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "log1p(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nlog1p(x, out=None)\n\nCalculates log(1 + x) for use when `x` is near zero.\n\nParameters\n----------\nx : array_like\n    Real or complex valued input.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Values of ``log(1 + x)``.\n\nSee Also\n--------\nexpm1, cosm1\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is more accurate than using ``log(1 + x)`` directly for ``x``\nnear 0. Note that in the below example ``1 + 1e-17 == 1`` to\ndouble precision.\n\n>>> sc.log1p(1e-17)\n1e-17\n>>> np.log(1 + 1e-17)\n0.0"
    ...

def log_ndtr(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "log_ndtr(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nlog_ndtr(x)\n\nLogarithm of Gaussian cumulative distribution function.\n\nReturns the log of the area under the standard Gaussian probability\ndensity function, integrated from minus infinity to `x`::\n\n    log(1/sqrt(2*pi) * integral(exp(-t**2 / 2), t=-inf..x))\n\nParameters\n----------\nx : array_like, real or complex\n    Argument\n\nReturns\n-------\nndarray\n    The value of the log of the normal CDF evaluated at `x`\n\nSee Also\n--------\nerf\nerfc\nscipy.stats.norm\nndtr"
    ...

def loggamma(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "loggamma(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nloggamma(z, out=None)\n\nPrincipal branch of the logarithm of the gamma function.\n\nDefined to be :math:`\\log(\\Gamma(x))` for :math:`x > 0` and\nextended to the complex plane by analytic continuation. The\nfunction has a single branch cut on the negative real axis.\n\n.. versionadded:: 0.18.0\n\nParameters\n----------\nz : array-like\n    Values in the complex plain at which to compute ``loggamma``\nout : ndarray, optional\n    Output array for computed values of ``loggamma``\n\nReturns\n-------\nloggamma : ndarray\n    Values of ``loggamma`` at z.\n\nNotes\n-----\nIt is not generally true that :math:`\\log\\Gamma(z) =\n\\log(\\Gamma(z))`, though the real parts of the functions do\nagree. The benefit of not defining `loggamma` as\n:math:`\\log(\\Gamma(z))` is that the latter function has a\ncomplicated branch cut structure whereas `loggamma` is analytic\nexcept for on the negative real axis.\n\nThe identities\n\n.. math::\n  \\exp(\\log\\Gamma(z)) &= \\Gamma(z) \\\\\n  \\log\\Gamma(z + 1) &= \\log(z) + \\log\\Gamma(z)\n\nmake `loggamma` useful for working in complex logspace.\n\nOn the real line `loggamma` is related to `gammaln` via\n``exp(loggamma(x + 0j)) = gammasgn(x)*exp(gammaln(x))``, up to\nrounding error.\n\nThe implementation here is based on [hare1997]_.\n\nSee also\n--------\ngammaln : logarithm of the absolute value of the gamma function\ngammasgn : sign of the gamma function\n\nReferences\n----------\n.. [hare1997] D.E.G. Hare,\n  *Computing the Principal Branch of log-Gamma*,\n  Journal of Algorithms, Volume 25, Issue 2, November 1997, pages 221-236."
    ...

def logit(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "logit(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nlogit(x)\n\nLogit ufunc for ndarrays.\n\nThe logit function is defined as logit(p) = log(p/(1-p)).\nNote that logit(0) = -inf, logit(1) = inf, and logit(p)\nfor p<0 or p>1 yields nan.\n\nParameters\n----------\nx : ndarray\n    The ndarray to apply logit to element-wise.\n\nReturns\n-------\nout : ndarray\n    An ndarray of the same shape as x. Its entries\n    are logit of the corresponding entry of x.\n\nSee Also\n--------\nexpit\n\nNotes\n-----\nAs a ufunc logit takes a number of optional\nkeyword arguments. For more information\nsee `ufuncs <https://docs.scipy.org/doc/numpy/reference/ufuncs.html>`_\n\n.. versionadded:: 0.10.0\n\nExamples\n--------\n>>> from scipy.special import logit, expit\n\n>>> logit([0, 0.25, 0.5, 0.75, 1])\narray([       -inf, -1.09861229,  0.        ,  1.09861229,         inf])\n\n`expit` is the inverse of `logit`:\n\n>>> expit(logit([0.1, 0.75, 0.999]))\narray([ 0.1  ,  0.75 ,  0.999])\n\nPlot logit(x) for x in [0, 1]:\n\n>>> import matplotlib.pyplot as plt\n>>> x = np.linspace(0, 1, 501)\n>>> y = logit(x)\n>>> plt.plot(x, y)\n>>> plt.grid()\n>>> plt.ylim(-6, 6)\n>>> plt.xlabel('x')\n>>> plt.title('logit(x)')\n>>> plt.show()"
    ...

def lpmv(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'lpmv(x1, x2, x3, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nlpmv(m, v, x)\n\nAssociated Legendre function of integer order and real degree.\n\nDefined as\n\n.. math::\n\n    P_v^m = (-1)^m (1 - x^2)^{m/2} \\frac{d^m}{dx^m} P_v(x)\n\nwhere\n\n.. math::\n\n    P_v = \\sum_{k = 0}^\\infty \\frac{(-v)_k (v + 1)_k}{(k!)^2}\n            \\left(\\frac{1 - x}{2}\\right)^k\n\nis the Legendre function of the first kind. Here :math:`(\\cdot)_k`\nis the Pochhammer symbol; see `poch`.\n\nParameters\n----------\nm : array_like\n    Order (int or float). If passed a float not equal to an\n    integer the function returns NaN.\nv : array_like\n    Degree (float).\nx : array_like\n    Argument (float). Must have ``|x| <= 1``.\n\nReturns\n-------\npmv : ndarray\n    Value of the associated Legendre function.\n\nSee Also\n--------\nlpmn : Compute the associated Legendre function for all orders\n       ``0, ..., m`` and degrees ``0, ..., n``.\nclpmn : Compute the associated Legendre function at complex\n        arguments.\n\nNotes\n-----\nNote that this implementation includes the Condon-Shortley phase.\n\nReferences\n----------\n.. [1] Zhang, Jin, "Computation of Special Functions", John Wiley\n       and Sons, Inc, 1996.'
    ...

def mathieu_a(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "mathieu_a(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nmathieu_a(m, q)\n\nCharacteristic value of even Mathieu functions\n\nReturns the characteristic value for the even solution,\n``ce_m(z, q)``, of Mathieu's equation."
    ...

def mathieu_b(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "mathieu_b(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nmathieu_b(m, q)\n\nCharacteristic value of odd Mathieu functions\n\nReturns the characteristic value for the odd solution,\n``se_m(z, q)``, of Mathieu's equation."
    ...

def mathieu_cem(x1, x2, x3, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "mathieu_cem(x1, x2, x3[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nmathieu_cem(m, q, x)\n\nEven Mathieu function and its derivative\n\nReturns the even Mathieu function, ``ce_m(x, q)``, of order `m` and\nparameter `q` evaluated at `x` (given in degrees).  Also returns the\nderivative with respect to `x` of ce_m(x, q)\n\nParameters\n----------\nm\n    Order of the function\nq\n    Parameter of the function\nx\n    Argument of the function, *given in degrees, not radians*\n\nReturns\n-------\ny\n    Value of the function\nyp\n    Value of the derivative vs x"
    ...

def mathieu_modcem1(x1, x2, x3, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "mathieu_modcem1(x1, x2, x3[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nmathieu_modcem1(m, q, x)\n\nEven modified Mathieu function of the first kind and its derivative\n\nEvaluates the even modified Mathieu function of the first kind,\n``Mc1m(x, q)``, and its derivative at `x` for order `m` and parameter\n`q`.\n\nReturns\n-------\ny\n    Value of the function\nyp\n    Value of the derivative vs x"
    ...

def mathieu_modcem2(x1, x2, x3, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "mathieu_modcem2(x1, x2, x3[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nmathieu_modcem2(m, q, x)\n\nEven modified Mathieu function of the second kind and its derivative\n\nEvaluates the even modified Mathieu function of the second kind,\nMc2m(x, q), and its derivative at `x` (given in degrees) for order `m`\nand parameter `q`.\n\nReturns\n-------\ny\n    Value of the function\nyp\n    Value of the derivative vs x"
    ...

def mathieu_modsem1(x1, x2, x3, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "mathieu_modsem1(x1, x2, x3[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nmathieu_modsem1(m, q, x)\n\nOdd modified Mathieu function of the first kind and its derivative\n\nEvaluates the odd modified Mathieu function of the first kind,\nMs1m(x, q), and its derivative at `x` (given in degrees) for order `m`\nand parameter `q`.\n\nReturns\n-------\ny\n    Value of the function\nyp\n    Value of the derivative vs x"
    ...

def mathieu_modsem2(x1, x2, x3, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "mathieu_modsem2(x1, x2, x3[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nmathieu_modsem2(m, q, x)\n\nOdd modified Mathieu function of the second kind and its derivative\n\nEvaluates the odd modified Mathieu function of the second kind,\nMs2m(x, q), and its derivative at `x` (given in degrees) for order `m`\nand parameter q.\n\nReturns\n-------\ny\n    Value of the function\nyp\n    Value of the derivative vs x"
    ...

def mathieu_sem(x1, x2, x3, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "mathieu_sem(x1, x2, x3[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nmathieu_sem(m, q, x)\n\nOdd Mathieu function and its derivative\n\nReturns the odd Mathieu function, se_m(x, q), of order `m` and\nparameter `q` evaluated at `x` (given in degrees).  Also returns the\nderivative with respect to `x` of se_m(x, q).\n\nParameters\n----------\nm\n    Order of the function\nq\n    Parameter of the function\nx\n    Argument of the function, *given in degrees, not radians*.\n\nReturns\n-------\ny\n    Value of the function\nyp\n    Value of the derivative vs x"
    ...

def modfresnelm(x, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "modfresnelm(x[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nmodfresnelm(x)\n\nModified Fresnel negative integrals\n\nReturns\n-------\nfm\n    Integral ``F_-(x)``: ``integral(exp(-1j*t*t), t=x..inf)``\nkm\n    Integral ``K_-(x)``: ``1/sqrt(pi)*exp(1j*(x*x+pi/4))*fp``"
    ...

def modfresnelp(x, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "modfresnelp(x[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nmodfresnelp(x)\n\nModified Fresnel positive integrals\n\nReturns\n-------\nfp\n    Integral ``F_+(x)``: ``integral(exp(1j*t*t), t=x..inf)``\nkp\n    Integral ``K_+(x)``: ``1/sqrt(pi)*exp(-1j*(x*x+pi/4))*fp``"
    ...

def modstruve(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "modstruve(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nmodstruve(v, x)\n\nModified Struve function.\n\nReturn the value of the modified Struve function of order `v` at `x`.  The\nmodified Struve function is defined as,\n\n.. math::\n    L_v(x) = -\\imath \\exp(-\\pi\\imath v/2) H_v(\\imath x),\n\nwhere :math:`H_v` is the Struve function.\n\nParameters\n----------\nv : array_like\n    Order of the modified Struve function (float).\nx : array_like\n    Argument of the Struve function (float; must be positive unless `v` is\n    an integer).\n\nReturns\n-------\nL : ndarray\n    Value of the modified Struve function of order `v` at `x`.\n\nNotes\n-----\nThree methods discussed in [1]_ are used to evaluate the function:\n\n- power series\n- expansion in Bessel functions (if :math:`|x| < |v| + 20`)\n- asymptotic large-x expansion (if :math:`x \\geq 0.7v + 12`)\n\nRounding errors are estimated based on the largest terms in the sums, and\nthe result associated with the smallest error is returned.\n\nSee also\n--------\nstruve\n\nReferences\n----------\n.. [1] NIST Digital Library of Mathematical Functions\n       https://dlmf.nist.gov/11"
    ...

def nbdtr(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "nbdtr(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nnbdtr(k, n, p)\n\nNegative binomial cumulative distribution function.\n\nReturns the sum of the terms 0 through `k` of the negative binomial\ndistribution probability mass function,\n\n.. math::\n\n    F = \\sum_{j=0}^k {{n + j - 1}\\choose{j}} p^n (1 - p)^j.\n\nIn a sequence of Bernoulli trials with individual success probabilities\n`p`, this is the probability that `k` or fewer failures precede the nth\nsuccess.\n\nParameters\n----------\nk : array_like\n    The maximum number of allowed failures (nonnegative int).\nn : array_like\n    The target number of successes (positive int).\np : array_like\n    Probability of success in a single event (float).\n\nReturns\n-------\nF : ndarray\n    The probability of `k` or fewer failures before `n` successes in a\n    sequence of events with individual success probability `p`.\n\nSee also\n--------\nnbdtrc\n\nNotes\n-----\nIf floating point values are passed for `k` or `n`, they will be truncated\nto integers.\n\nThe terms are not summed directly; instead the regularized incomplete beta\nfunction is employed, according to the formula,\n\n.. math::\n    \\mathrm{nbdtr}(k, n, p) = I_{p}(n, k + 1).\n\nWrapper for the Cephes [1]_ routine `nbdtr`.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def nbdtrc(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "nbdtrc(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nnbdtrc(k, n, p)\n\nNegative binomial survival function.\n\nReturns the sum of the terms `k + 1` to infinity of the negative binomial\ndistribution probability mass function,\n\n.. math::\n\n    F = \\sum_{j=k + 1}^\\infty {{n + j - 1}\\choose{j}} p^n (1 - p)^j.\n\nIn a sequence of Bernoulli trials with individual success probabilities\n`p`, this is the probability that more than `k` failures precede the nth\nsuccess.\n\nParameters\n----------\nk : array_like\n    The maximum number of allowed failures (nonnegative int).\nn : array_like\n    The target number of successes (positive int).\np : array_like\n    Probability of success in a single event (float).\n\nReturns\n-------\nF : ndarray\n    The probability of `k + 1` or more failures before `n` successes in a\n    sequence of events with individual success probability `p`.\n\nNotes\n-----\nIf floating point values are passed for `k` or `n`, they will be truncated\nto integers.\n\nThe terms are not summed directly; instead the regularized incomplete beta\nfunction is employed, according to the formula,\n\n.. math::\n    \\mathrm{nbdtrc}(k, n, p) = I_{1 - p}(k + 1, n).\n\nWrapper for the Cephes [1]_ routine `nbdtrc`.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def nbdtri(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "nbdtri(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nnbdtri(k, n, y)\n\nInverse of `nbdtr` vs `p`.\n\nReturns the inverse with respect to the parameter `p` of\n`y = nbdtr(k, n, p)`, the negative binomial cumulative distribution\nfunction.\n\nParameters\n----------\nk : array_like\n    The maximum number of allowed failures (nonnegative int).\nn : array_like\n    The target number of successes (positive int).\ny : array_like\n    The probability of `k` or fewer failures before `n` successes (float).\n\nReturns\n-------\np : ndarray\n    Probability of success in a single event (float) such that\n    `nbdtr(k, n, p) = y`.\n\nSee also\n--------\nnbdtr : Cumulative distribution function of the negative binomial.\nnbdtrik : Inverse with respect to `k` of `nbdtr(k, n, p)`.\nnbdtrin : Inverse with respect to `n` of `nbdtr(k, n, p)`.\n\nNotes\n-----\nWrapper for the Cephes [1]_ routine `nbdtri`.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def nbdtrik(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "nbdtrik(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nnbdtrik(y, n, p)\n\nInverse of `nbdtr` vs `k`.\n\nReturns the inverse with respect to the parameter `k` of\n`y = nbdtr(k, n, p)`, the negative binomial cumulative distribution\nfunction.\n\nParameters\n----------\ny : array_like\n    The probability of `k` or fewer failures before `n` successes (float).\nn : array_like\n    The target number of successes (positive int).\np : array_like\n    Probability of success in a single event (float).\n\nReturns\n-------\nk : ndarray\n    The maximum number of allowed failures such that `nbdtr(k, n, p) = y`.\n\nSee also\n--------\nnbdtr : Cumulative distribution function of the negative binomial.\nnbdtri : Inverse with respect to `p` of `nbdtr(k, n, p)`.\nnbdtrin : Inverse with respect to `n` of `nbdtr(k, n, p)`.\n\nNotes\n-----\nWrapper for the CDFLIB [1]_ Fortran routine `cdfnbn`.\n\nFormula 26.5.26 of [2]_,\n\n.. math::\n    \\sum_{j=k + 1}^\\infty {{n + j - 1}\\choose{j}} p^n (1 - p)^j = I_{1 - p}(k + 1, n),\n\nis used to reduce calculation of the cumulative distribution function to\nthat of a regularized incomplete beta :math:`I`.\n\nComputation of `k` involves a search for a value that produces the desired\nvalue of `y`.  The search relies on the monotonicity of `y` with `k`.\n\nReferences\n----------\n.. [1] Barry Brown, James Lovato, and Kathy Russell,\n       CDFLIB: Library of Fortran Routines for Cumulative Distribution\n       Functions, Inverses, and Other Parameters.\n.. [2] Milton Abramowitz and Irene A. Stegun, eds.\n       Handbook of Mathematical Functions with Formulas,\n       Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def nbdtrin(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "nbdtrin(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nnbdtrin(k, y, p)\n\nInverse of `nbdtr` vs `n`.\n\nReturns the inverse with respect to the parameter `n` of\n`y = nbdtr(k, n, p)`, the negative binomial cumulative distribution\nfunction.\n\nParameters\n----------\nk : array_like\n    The maximum number of allowed failures (nonnegative int).\ny : array_like\n    The probability of `k` or fewer failures before `n` successes (float).\np : array_like\n    Probability of success in a single event (float).\n\nReturns\n-------\nn : ndarray\n    The number of successes `n` such that `nbdtr(k, n, p) = y`.\n\nSee also\n--------\nnbdtr : Cumulative distribution function of the negative binomial.\nnbdtri : Inverse with respect to `p` of `nbdtr(k, n, p)`.\nnbdtrik : Inverse with respect to `k` of `nbdtr(k, n, p)`.\n\nNotes\n-----\nWrapper for the CDFLIB [1]_ Fortran routine `cdfnbn`.\n\nFormula 26.5.26 of [2]_,\n\n.. math::\n    \\sum_{j=k + 1}^\\infty {{n + j - 1}\\choose{j}} p^n (1 - p)^j = I_{1 - p}(k + 1, n),\n\nis used to reduce calculation of the cumulative distribution function to\nthat of a regularized incomplete beta :math:`I`.\n\nComputation of `n` involves a search for a value that produces the desired\nvalue of `y`.  The search relies on the monotonicity of `y` with `n`.\n\nReferences\n----------\n.. [1] Barry Brown, James Lovato, and Kathy Russell,\n       CDFLIB: Library of Fortran Routines for Cumulative Distribution\n       Functions, Inverses, and Other Parameters.\n.. [2] Milton Abramowitz and Irene A. Stegun, eds.\n       Handbook of Mathematical Functions with Formulas,\n       Graphs, and Mathematical Tables. New York: Dover, 1972."
    ...

def ncfdtr(x1, x2, x3, x4, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ncfdtr(x1, x2, x3, x4, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nncfdtr(dfn, dfd, nc, f)\n\nCumulative distribution function of the non-central F distribution.\n\nThe non-central F describes the distribution of,\n\n.. math::\n    Z = \\frac{X/d_n}{Y/d_d}\n\nwhere :math:`X` and :math:`Y` are independently distributed, with\n:math:`X` distributed non-central :math:`\\chi^2` with noncentrality\nparameter `nc` and :math:`d_n` degrees of freedom, and :math:`Y`\ndistributed :math:`\\chi^2` with :math:`d_d` degrees of freedom.\n\nParameters\n----------\ndfn : array_like\n    Degrees of freedom of the numerator sum of squares.  Range (0, inf).\ndfd : array_like\n    Degrees of freedom of the denominator sum of squares.  Range (0, inf).\nnc : array_like\n    Noncentrality parameter.  Should be in range (0, 1e4).\nf : array_like\n    Quantiles, i.e. the upper limit of integration.\n\nReturns\n-------\ncdf : float or ndarray\n    The calculated CDF.  If all inputs are scalar, the return will be a\n    float.  Otherwise it will be an array.\n\nSee Also\n--------\nncfdtri : Quantile function; inverse of `ncfdtr` with respect to `f`.\nncfdtridfd : Inverse of `ncfdtr` with respect to `dfd`.\nncfdtridfn : Inverse of `ncfdtr` with respect to `dfn`.\nncfdtrinc : Inverse of `ncfdtr` with respect to `nc`.\n\nNotes\n-----\nWrapper for the CDFLIB [1]_ Fortran routine `cdffnc`.\n\nThe cumulative distribution function is computed using Formula 26.6.20 of\n[2]_:\n\n.. math::\n    F(d_n, d_d, n_c, f) = \\sum_{j=0}^\\infty e^{-n_c/2} \\frac{(n_c/2)^j}{j!} I_{x}(\\frac{d_n}{2} + j, \\frac{d_d}{2}),\n\nwhere :math:`I` is the regularized incomplete beta function, and\n:math:`x = f d_n/(f d_n + d_d)`.\n\nThe computation time required for this routine is proportional to the\nnoncentrality parameter `nc`.  Very large values of this parameter can\nconsume immense computer resources.  This is why the search range is\nbounded by 10,000.\n\nReferences\n----------\n.. [1] Barry Brown, James Lovato, and Kathy Russell,\n       CDFLIB: Library of Fortran Routines for Cumulative Distribution\n       Functions, Inverses, and Other Parameters.\n.. [2] Milton Abramowitz and Irene A. Stegun, eds.\n       Handbook of Mathematical Functions with Formulas,\n       Graphs, and Mathematical Tables. New York: Dover, 1972.\n\nExamples\n--------\n>>> from scipy import special\n>>> from scipy import stats\n>>> import matplotlib.pyplot as plt\n\nPlot the CDF of the non-central F distribution, for nc=0.  Compare with the\nF-distribution from scipy.stats:\n\n>>> x = np.linspace(-1, 8, num=500)\n>>> dfn = 3\n>>> dfd = 2\n>>> ncf_stats = stats.f.cdf(x, dfn, dfd)\n>>> ncf_special = special.ncfdtr(dfn, dfd, 0, x)\n\n>>> fig = plt.figure()\n>>> ax = fig.add_subplot(111)\n>>> ax.plot(x, ncf_stats, 'b-', lw=3)\n>>> ax.plot(x, ncf_special, 'r-')\n>>> plt.show()"
    ...

def ncfdtri(x1, x2, x3, x4, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ncfdtri(x1, x2, x3, x4, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nncfdtri(dfn, dfd, nc, p)\n\nInverse with respect to `f` of the CDF of the non-central F distribution.\n\nSee `ncfdtr` for more details.\n\nParameters\n----------\ndfn : array_like\n    Degrees of freedom of the numerator sum of squares.  Range (0, inf).\ndfd : array_like\n    Degrees of freedom of the denominator sum of squares.  Range (0, inf).\nnc : array_like\n    Noncentrality parameter.  Should be in range (0, 1e4).\np : array_like\n    Value of the cumulative distribution function.  Must be in the\n    range [0, 1].\n\nReturns\n-------\nf : float\n    Quantiles, i.e., the upper limit of integration.\n\nSee Also\n--------\nncfdtr : CDF of the non-central F distribution.\nncfdtridfd : Inverse of `ncfdtr` with respect to `dfd`.\nncfdtridfn : Inverse of `ncfdtr` with respect to `dfn`.\nncfdtrinc : Inverse of `ncfdtr` with respect to `nc`.\n\nExamples\n--------\n>>> from scipy.special import ncfdtr, ncfdtri\n\nCompute the CDF for several values of `f`:\n\n>>> f = [0.5, 1, 1.5]\n>>> p = ncfdtr(2, 3, 1.5, f)\n>>> p\narray([ 0.20782291,  0.36107392,  0.47345752])\n\nCompute the inverse.  We recover the values of `f`, as expected:\n\n>>> ncfdtri(2, 3, 1.5, p)\narray([ 0.5,  1. ,  1.5])"
    ...

def ncfdtridfd(x1, x2, x3, x4, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ncfdtridfd(x1, x2, x3, x4, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nncfdtridfd(dfn, p, nc, f)\n\nCalculate degrees of freedom (denominator) for the noncentral F-distribution.\n\nThis is the inverse with respect to `dfd` of `ncfdtr`.\nSee `ncfdtr` for more details.\n\nParameters\n----------\ndfn : array_like\n    Degrees of freedom of the numerator sum of squares.  Range (0, inf).\np : array_like\n    Value of the cumulative distribution function.  Must be in the\n    range [0, 1].\nnc : array_like\n    Noncentrality parameter.  Should be in range (0, 1e4).\nf : array_like\n    Quantiles, i.e., the upper limit of integration.\n\nReturns\n-------\ndfd : float\n    Degrees of freedom of the denominator sum of squares.\n\nSee Also\n--------\nncfdtr : CDF of the non-central F distribution.\nncfdtri : Quantile function; inverse of `ncfdtr` with respect to `f`.\nncfdtridfn : Inverse of `ncfdtr` with respect to `dfn`.\nncfdtrinc : Inverse of `ncfdtr` with respect to `nc`.\n\nNotes\n-----\nThe value of the cumulative noncentral F distribution is not necessarily\nmonotone in either degrees of freedom. There thus may be two values that\nprovide a given CDF value. This routine assumes monotonicity and will\nfind an arbitrary one of the two values.\n\nExamples\n--------\n>>> from scipy.special import ncfdtr, ncfdtridfd\n\nCompute the CDF for several values of `dfd`:\n\n>>> dfd = [1, 2, 3]\n>>> p = ncfdtr(2, dfd, 0.25, 15)\n>>> p\narray([ 0.8097138 ,  0.93020416,  0.96787852])\n\nCompute the inverse.  We recover the values of `dfd`, as expected:\n\n>>> ncfdtridfd(2, p, 0.25, 15)\narray([ 1.,  2.,  3.])"
    ...

def ncfdtridfn(x1, x2, x3, x4, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ncfdtridfn(x1, x2, x3, x4, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nncfdtridfn(p, dfd, nc, f)\n\nCalculate degrees of freedom (numerator) for the noncentral F-distribution.\n\nThis is the inverse with respect to `dfn` of `ncfdtr`.\nSee `ncfdtr` for more details.\n\nParameters\n----------\np : array_like\n    Value of the cumulative distribution function. Must be in the\n    range [0, 1].\ndfd : array_like\n    Degrees of freedom of the denominator sum of squares. Range (0, inf).\nnc : array_like\n    Noncentrality parameter.  Should be in range (0, 1e4).\nf : float\n    Quantiles, i.e., the upper limit of integration.\n\nReturns\n-------\ndfn : float\n    Degrees of freedom of the numerator sum of squares.\n\nSee Also\n--------\nncfdtr : CDF of the non-central F distribution.\nncfdtri : Quantile function; inverse of `ncfdtr` with respect to `f`.\nncfdtridfd : Inverse of `ncfdtr` with respect to `dfd`.\nncfdtrinc : Inverse of `ncfdtr` with respect to `nc`.\n\nNotes\n-----\nThe value of the cumulative noncentral F distribution is not necessarily\nmonotone in either degrees of freedom. There thus may be two values that\nprovide a given CDF value. This routine assumes monotonicity and will\nfind an arbitrary one of the two values.\n\nExamples\n--------\n>>> from scipy.special import ncfdtr, ncfdtridfn\n\nCompute the CDF for several values of `dfn`:\n\n>>> dfn = [1, 2, 3]\n>>> p = ncfdtr(dfn, 2, 0.25, 15)\n>>> p\narray([ 0.92562363,  0.93020416,  0.93188394])\n\nCompute the inverse. We recover the values of `dfn`, as expected:\n\n>>> ncfdtridfn(p, 2, 0.25, 15)\narray([ 1.,  2.,  3.])"
    ...

def ncfdtrinc(x1, x2, x3, x4, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ncfdtrinc(x1, x2, x3, x4, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nncfdtrinc(dfn, dfd, p, f)\n\nCalculate non-centrality parameter for non-central F distribution.\n\nThis is the inverse with respect to `nc` of `ncfdtr`.\nSee `ncfdtr` for more details.\n\nParameters\n----------\ndfn : array_like\n    Degrees of freedom of the numerator sum of squares. Range (0, inf).\ndfd : array_like\n    Degrees of freedom of the denominator sum of squares. Range (0, inf).\np : array_like\n    Value of the cumulative distribution function. Must be in the\n    range [0, 1].\nf : array_like\n    Quantiles, i.e., the upper limit of integration.\n\nReturns\n-------\nnc : float\n    Noncentrality parameter.\n\nSee Also\n--------\nncfdtr : CDF of the non-central F distribution.\nncfdtri : Quantile function; inverse of `ncfdtr` with respect to `f`.\nncfdtridfd : Inverse of `ncfdtr` with respect to `dfd`.\nncfdtridfn : Inverse of `ncfdtr` with respect to `dfn`.\n\nExamples\n--------\n>>> from scipy.special import ncfdtr, ncfdtrinc\n\nCompute the CDF for several values of `nc`:\n\n>>> nc = [0.5, 1.5, 2.0]\n>>> p = ncfdtr(2, 3, nc, 15)\n>>> p\narray([ 0.96309246,  0.94327955,  0.93304098])\n\nCompute the inverse. We recover the values of `nc`, as expected:\n\n>>> ncfdtrinc(2, 3, p, 15)\narray([ 0.5,  1.5,  2. ])"
    ...

def nctdtr(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "nctdtr(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nnctdtr(df, nc, t)\n\nCumulative distribution function of the non-central `t` distribution.\n\nParameters\n----------\ndf : array_like\n    Degrees of freedom of the distribution. Should be in range (0, inf).\nnc : array_like\n    Noncentrality parameter. Should be in range (-1e6, 1e6).\nt : array_like\n    Quantiles, i.e., the upper limit of integration.\n\nReturns\n-------\ncdf : float or ndarray\n    The calculated CDF. If all inputs are scalar, the return will be a\n    float. Otherwise, it will be an array.\n\nSee Also\n--------\nnctdtrit : Inverse CDF (iCDF) of the non-central t distribution.\nnctdtridf : Calculate degrees of freedom, given CDF and iCDF values.\nnctdtrinc : Calculate non-centrality parameter, given CDF iCDF values.\n\nExamples\n--------\n>>> from scipy import special\n>>> from scipy import stats\n>>> import matplotlib.pyplot as plt\n\nPlot the CDF of the non-central t distribution, for nc=0. Compare with the\nt-distribution from scipy.stats:\n\n>>> x = np.linspace(-5, 5, num=500)\n>>> df = 3\n>>> nct_stats = stats.t.cdf(x, df)\n>>> nct_special = special.nctdtr(df, 0, x)\n\n>>> fig = plt.figure()\n>>> ax = fig.add_subplot(111)\n>>> ax.plot(x, nct_stats, 'b-', lw=3)\n>>> ax.plot(x, nct_special, 'r-')\n>>> plt.show()"
    ...

def nctdtridf(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "nctdtridf(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nnctdtridf(p, nc, t)\n\nCalculate degrees of freedom for non-central t distribution.\n\nSee `nctdtr` for more details.\n\nParameters\n----------\np : array_like\n    CDF values, in range (0, 1].\nnc : array_like\n    Noncentrality parameter. Should be in range (-1e6, 1e6).\nt : array_like\n    Quantiles, i.e., the upper limit of integration."
    ...

def nctdtrinc(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "nctdtrinc(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nnctdtrinc(df, p, t)\n\nCalculate non-centrality parameter for non-central t distribution.\n\nSee `nctdtr` for more details.\n\nParameters\n----------\ndf : array_like\n    Degrees of freedom of the distribution. Should be in range (0, inf).\np : array_like\n    CDF values, in range (0, 1].\nt : array_like\n    Quantiles, i.e., the upper limit of integration."
    ...

def nctdtrit(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "nctdtrit(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nnctdtrit(df, nc, p)\n\nInverse cumulative distribution function of the non-central t distribution.\n\nSee `nctdtr` for more details.\n\nParameters\n----------\ndf : array_like\n    Degrees of freedom of the distribution. Should be in range (0, inf).\nnc : array_like\n    Noncentrality parameter. Should be in range (-1e6, 1e6).\np : array_like\n    CDF values, in range (0, 1]."
    ...

def ndtr(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ndtr(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nndtr(x)\n\nGaussian cumulative distribution function.\n\nReturns the area under the standard Gaussian probability\ndensity function, integrated from minus infinity to `x`\n\n.. math::\n\n   \\frac{1}{\\sqrt{2\\pi}} \\int_{-\\infty}^x \\exp(-t^2/2) dt\n\nParameters\n----------\nx : array_like, real or complex\n    Argument\n\nReturns\n-------\nndarray\n    The value of the normal CDF evaluated at `x`\n\nSee Also\n--------\nerf\nerfc\nscipy.stats.norm\nlog_ndtr"
    ...

def ndtri(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "ndtri(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nndtri(y)\n\nInverse of `ndtr` vs x\n\nReturns the argument x for which the area under the Gaussian\nprobability density function (integrated from minus infinity to `x`)\nis equal to y."
    ...

def nrdtrimn(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "nrdtrimn(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nnrdtrimn(p, x, std)\n\nCalculate mean of normal distribution given other params.\n\nParameters\n----------\np : array_like\n    CDF values, in range (0, 1].\nx : array_like\n    Quantiles, i.e. the upper limit of integration.\nstd : array_like\n    Standard deviation.\n\nReturns\n-------\nmn : float or ndarray\n    The mean of the normal distribution.\n\nSee Also\n--------\nnrdtrimn, ndtr"
    ...

def nrdtrisd(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "nrdtrisd(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nnrdtrisd(p, x, mn)\n\nCalculate standard deviation of normal distribution given other params.\n\nParameters\n----------\np : array_like\n    CDF values, in range (0, 1].\nx : array_like\n    Quantiles, i.e. the upper limit of integration.\nmn : float or ndarray\n    The mean of the normal distribution.\n\nReturns\n-------\nstd : array_like\n    Standard deviation.\n\nSee Also\n--------\nndtr"
    ...

def obl_ang1(x1, x2, x3, x4, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "obl_ang1(x1, x2, x3, x4[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nobl_ang1(m, n, c, x)\n\nOblate spheroidal angular function of the first kind and its derivative\n\nComputes the oblate spheroidal angular function of the first kind\nand its derivative (with respect to `x`) for mode parameters m>=0\nand n>=m, spheroidal parameter `c` and ``|x| < 1.0``.\n\nReturns\n-------\ns\n    Value of the function\nsp\n    Value of the derivative vs x"
    ...

def obl_ang1_cv(x1, x2, x3, x4, x5, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "obl_ang1_cv(x1, x2, x3, x4, x5[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nobl_ang1_cv(m, n, c, cv, x)\n\nOblate spheroidal angular function obl_ang1 for precomputed characteristic value\n\nComputes the oblate spheroidal angular function of the first kind\nand its derivative (with respect to `x`) for mode parameters m>=0\nand n>=m, spheroidal parameter `c` and ``|x| < 1.0``. Requires\npre-computed characteristic value.\n\nReturns\n-------\ns\n    Value of the function\nsp\n    Value of the derivative vs x"
    ...

def obl_cv(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "obl_cv(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nobl_cv(m, n, c)\n\nCharacteristic value of oblate spheroidal function\n\nComputes the characteristic value of oblate spheroidal wave\nfunctions of order `m`, `n` (n>=m) and spheroidal parameter `c`."
    ...

def obl_rad1(x1, x2, x3, x4, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "obl_rad1(x1, x2, x3, x4[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nobl_rad1(m, n, c, x)\n\nOblate spheroidal radial function of the first kind and its derivative\n\nComputes the oblate spheroidal radial function of the first kind\nand its derivative (with respect to `x`) for mode parameters m>=0\nand n>=m, spheroidal parameter `c` and ``|x| < 1.0``.\n\nReturns\n-------\ns\n    Value of the function\nsp\n    Value of the derivative vs x"
    ...

def obl_rad1_cv(x1, x2, x3, x4, x5, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "obl_rad1_cv(x1, x2, x3, x4, x5[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nobl_rad1_cv(m, n, c, cv, x)\n\nOblate spheroidal radial function obl_rad1 for precomputed characteristic value\n\nComputes the oblate spheroidal radial function of the first kind\nand its derivative (with respect to `x`) for mode parameters m>=0\nand n>=m, spheroidal parameter `c` and ``|x| < 1.0``. Requires\npre-computed characteristic value.\n\nReturns\n-------\ns\n    Value of the function\nsp\n    Value of the derivative vs x"
    ...

def obl_rad2(x1, x2, x3, x4, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "obl_rad2(x1, x2, x3, x4[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nobl_rad2(m, n, c, x)\n\nOblate spheroidal radial function of the second kind and its derivative.\n\nComputes the oblate spheroidal radial function of the second kind\nand its derivative (with respect to `x`) for mode parameters m>=0\nand n>=m, spheroidal parameter `c` and ``|x| < 1.0``.\n\nReturns\n-------\ns\n    Value of the function\nsp\n    Value of the derivative vs x"
    ...

def obl_rad2_cv(x1, x2, x3, x4, x5, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "obl_rad2_cv(x1, x2, x3, x4, x5[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nobl_rad2_cv(m, n, c, cv, x)\n\nOblate spheroidal radial function obl_rad2 for precomputed characteristic value\n\nComputes the oblate spheroidal radial function of the second kind\nand its derivative (with respect to `x`) for mode parameters m>=0\nand n>=m, spheroidal parameter `c` and ``|x| < 1.0``. Requires\npre-computed characteristic value.\n\nReturns\n-------\ns\n    Value of the function\nsp\n    Value of the derivative vs x"
    ...

def owens_t(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'owens_t(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nowens_t(h, a)\n\nOwen\'s T Function.\n\nThe function T(h, a) gives the probability of the event\n(X > h and 0 < Y < a * X) where X and Y are independent\nstandard normal random variables.\n\nParameters\n----------\nh: array_like\n    Input value.\na: array_like\n    Input value.\n\nReturns\n-------\nt: scalar or ndarray\n    Probability of the event (X > h and 0 < Y < a * X),\n    where X and Y are independent standard normal random variables.\n\nExamples\n--------\n>>> from scipy import special\n>>> a = 3.5\n>>> h = 0.78\n>>> special.owens_t(h, a)\n0.10877216734852274\n\nReferences\n----------\n.. [1] M. Patefield and D. Tandy, "Fast and accurate calculation of\n       Owen\'s T Function", Statistical Software vol. 5, pp. 1-25, 2000.'
    ...

def pbdv(x1, x2, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pbdv(x1, x2[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npbdv(v, x)\n\nParabolic cylinder function D\n\nReturns (d, dp) the parabolic cylinder function Dv(x) in d and the\nderivative, Dv'(x) in dp.\n\nReturns\n-------\nd\n    Value of the function\ndp\n    Value of the derivative vs x"
    ...

def pbvv(x1, x2, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pbvv(x1, x2[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npbvv(v, x)\n\nParabolic cylinder function V\n\nReturns the parabolic cylinder function Vv(x) in v and the\nderivative, Vv'(x) in vp.\n\nReturns\n-------\nv\n    Value of the function\nvp\n    Value of the derivative vs x"
    ...

def pbwa(x1, x2, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'pbwa(x1, x2[, out1, out2], / [, out=(None, None)], *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\npbwa(a, x)\n\nParabolic cylinder function W.\n\nThe function is a particular solution to the differential equation\n\n.. math::\n\n    y\'\' + \\left(\\frac{1}{4}x^2 - a\\right)y = 0,\n\nfor a full definition see section 12.14 in [1]_.\n\nParameters\n----------\na : array_like\n    Real parameter\nx : array_like\n    Real argument\n\nReturns\n-------\nw : scalar or ndarray\n    Value of the function\nwp : scalar or ndarray\n    Value of the derivative in x\n\nNotes\n-----\nThe function is a wrapper for a Fortran routine by Zhang and Jin\n[2]_. The implementation is accurate only for ``|a|, |x| < 5`` and\nreturns NaN outside that range.\n\nReferences\n----------\n.. [1] Digital Library of Mathematical Functions, 14.30.\n       https://dlmf.nist.gov/14.30\n.. [2] Zhang, Shanjie and Jin, Jianming. "Computation of Special\n       Functions", John Wiley and Sons, 1996.\n       https://people.sc.fsu.edu/~jburkardt/f_src/special_functions/special_functions.html'
    ...

def pdtr(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pdtr(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npdtr(k, m, out=None)\n\nPoisson cumulative distribution function.\n\nDefined as the probability that a Poisson-distributed random\nvariable with event rate :math:`m` is less than or equal to\n:math:`k`. More concretely, this works out to be [1]_\n\n.. math::\n\n   \\exp(-m) \\sum_{j = 0}^{\\lfloor{k}\\rfloor} \\frac{m^j}{m!}.\n\nParameters\n----------\nk : array_like\n    Nonnegative real argument\nm : array_like\n    Nonnegative real shape parameter\nout : ndarray\n    Optional output array for the function results\n\nSee Also\n--------\npdtrc : Poisson survival function\npdtrik : inverse of `pdtr` with respect to `k`\npdtri : inverse of `pdtr` with respect to `m`\n\nReturns\n-------\nscalar or ndarray\n    Values of the Poisson cumulative distribution function\n\nReferences\n----------\n.. [1] https://en.wikipedia.org/wiki/Poisson_distribution\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is a cumulative distribution function, so it converges to 1\nmonotonically as `k` goes to infinity.\n\n>>> sc.pdtr([1, 10, 100, np.inf], 1)\narray([0.73575888, 0.99999999, 1.        , 1.        ])\n\nIt is discontinuous at integers and constant between integers.\n\n>>> sc.pdtr([1, 1.5, 1.9, 2], 1)\narray([0.73575888, 0.73575888, 0.73575888, 0.9196986 ])"
    ...

def pdtrc(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pdtrc(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npdtrc(k, m)\n\nPoisson survival function\n\nReturns the sum of the terms from k+1 to infinity of the Poisson\ndistribution: sum(exp(-m) * m**j / j!, j=k+1..inf) = gammainc(\nk+1, m). Arguments must both be non-negative doubles."
    ...

def pdtri(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pdtri(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npdtri(k, y)\n\nInverse to `pdtr` vs m\n\nReturns the Poisson variable `m` such that the sum from 0 to `k` of\nthe Poisson density is equal to the given probability `y`:\ncalculated by gammaincinv(k+1, y). `k` must be a nonnegative\ninteger and `y` between 0 and 1."
    ...

def pdtrik(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pdtrik(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npdtrik(p, m)\n\nInverse to `pdtr` vs k\n\nReturns the quantile k such that ``pdtr(k, m) = p``"
    ...

def poch(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "poch(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npoch(z, m)\n\nPochhammer symbol.\n\nThe Pochhammer symbol (rising factorial) is defined as\n\n.. math::\n\n    (z)_m = \\frac{\\Gamma(z + m)}{\\Gamma(z)}\n\nFor positive integer `m` it reads\n\n.. math::\n\n    (z)_m = z (z + 1) ... (z + m - 1)\n\nSee [dlmf]_ for more details.\n\nParameters\n----------\nz, m : array_like\n    Real-valued arguments.\n\nReturns\n-------\nscalar or ndarray\n    The value of the function.\n\nReferences\n----------\n.. [dlmf] Nist, Digital Library of Mathematical Functions\n    https://dlmf.nist.gov/5.2#iii\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is 1 when m is 0.\n\n>>> sc.poch([1, 2, 3, 4], 0)\narray([1., 1., 1., 1.])\n\nFor z equal to 1 it reduces to the factorial function.\n\n>>> sc.poch(1, 5)\n120.0\n>>> 1 * 2 * 3 * 4 * 5\n120\n\nIt can be expressed in terms of the gamma function.\n\n>>> z, m = 3.7, 2.1\n>>> sc.poch(z, m)\n20.529581933776953\n>>> sc.gamma(z + m) / sc.gamma(z)\n20.52958193377696"
    ...

def pro_ang1(x1, x2, x3, x4, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pro_ang1(x1, x2, x3, x4[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npro_ang1(m, n, c, x)\n\nProlate spheroidal angular function of the first kind and its derivative\n\nComputes the prolate spheroidal angular function of the first kind\nand its derivative (with respect to `x`) for mode parameters m>=0\nand n>=m, spheroidal parameter `c` and ``|x| < 1.0``.\n\nReturns\n-------\ns\n    Value of the function\nsp\n    Value of the derivative vs x"
    ...

def pro_ang1_cv(x1, x2, x3, x4, x5, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pro_ang1_cv(x1, x2, x3, x4, x5[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npro_ang1_cv(m, n, c, cv, x)\n\nProlate spheroidal angular function pro_ang1 for precomputed characteristic value\n\nComputes the prolate spheroidal angular function of the first kind\nand its derivative (with respect to `x`) for mode parameters m>=0\nand n>=m, spheroidal parameter `c` and ``|x| < 1.0``. Requires\npre-computed characteristic value.\n\nReturns\n-------\ns\n    Value of the function\nsp\n    Value of the derivative vs x"
    ...

def pro_cv(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pro_cv(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npro_cv(m, n, c)\n\nCharacteristic value of prolate spheroidal function\n\nComputes the characteristic value of prolate spheroidal wave\nfunctions of order `m`, `n` (n>=m) and spheroidal parameter `c`."
    ...

def pro_rad1(x1, x2, x3, x4, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pro_rad1(x1, x2, x3, x4[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npro_rad1(m, n, c, x)\n\nProlate spheroidal radial function of the first kind and its derivative\n\nComputes the prolate spheroidal radial function of the first kind\nand its derivative (with respect to `x`) for mode parameters m>=0\nand n>=m, spheroidal parameter `c` and ``|x| < 1.0``.\n\nReturns\n-------\ns\n    Value of the function\nsp\n    Value of the derivative vs x"
    ...

def pro_rad1_cv(x1, x2, x3, x4, x5, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pro_rad1_cv(x1, x2, x3, x4, x5[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npro_rad1_cv(m, n, c, cv, x)\n\nProlate spheroidal radial function pro_rad1 for precomputed characteristic value\n\nComputes the prolate spheroidal radial function of the first kind\nand its derivative (with respect to `x`) for mode parameters m>=0\nand n>=m, spheroidal parameter `c` and ``|x| < 1.0``. Requires\npre-computed characteristic value.\n\nReturns\n-------\ns\n    Value of the function\nsp\n    Value of the derivative vs x"
    ...

def pro_rad2(x1, x2, x3, x4, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pro_rad2(x1, x2, x3, x4[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npro_rad2(m, n, c, x)\n\nProlate spheroidal radial function of the second kind and its derivative\n\nComputes the prolate spheroidal radial function of the second kind\nand its derivative (with respect to `x`) for mode parameters m>=0\nand n>=m, spheroidal parameter `c` and ``|x| < 1.0``.\n\nReturns\n-------\ns\n    Value of the function\nsp\n    Value of the derivative vs x"
    ...

def pro_rad2_cv(x1, x2, x3, x4, x5, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pro_rad2_cv(x1, x2, x3, x4, x5[, out1, out2], / [, out=(None, None)], *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npro_rad2_cv(m, n, c, cv, x)\n\nProlate spheroidal radial function pro_rad2 for precomputed characteristic value\n\nComputes the prolate spheroidal radial function of the second kind\nand its derivative (with respect to `x`) for mode parameters m>=0\nand n>=m, spheroidal parameter `c` and ``|x| < 1.0``. Requires\npre-computed characteristic value.\n\nReturns\n-------\ns\n    Value of the function\nsp\n    Value of the derivative vs x"
    ...

def pseudo_huber(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "pseudo_huber(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\npseudo_huber(delta, r)\n\nPseudo-Huber loss function.\n\n.. math:: \\mathrm{pseudo\\_huber}(\\delta, r) = \\delta^2 \\left( \\sqrt{ 1 + \\left( \\frac{r}{\\delta} \\right)^2 } - 1 \\right)\n\nParameters\n----------\ndelta : ndarray\n    Input array, indicating the soft quadratic vs. linear loss changepoint.\nr : ndarray\n    Input array, possibly representing residuals.\n\nReturns\n-------\nres : ndarray\n    The computed Pseudo-Huber loss function values.\n\nNotes\n-----\nThis function is convex in :math:`r`.\n\n.. versionadded:: 0.15.0"
    ...

def psi(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'psi(x, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\npsi(z, out=None)\n\nThe digamma function.\n\nThe logarithmic derivative of the gamma function evaluated at ``z``.\n\nParameters\n----------\nz : array_like\n    Real or complex argument.\nout : ndarray, optional\n    Array for the computed values of ``psi``.\n\nReturns\n-------\ndigamma : ndarray\n    Computed values of ``psi``.\n\nNotes\n-----\nFor large values not close to the negative real axis, ``psi`` is\ncomputed using the asymptotic series (5.11.2) from [1]_. For small\narguments not close to the negative real axis, the recurrence\nrelation (5.5.2) from [1]_ is used until the argument is large\nenough to use the asymptotic series. For values close to the\nnegative real axis, the reflection formula (5.5.4) from [1]_ is\nused first. Note that ``psi`` has a family of zeros on the\nnegative real axis which occur between the poles at nonpositive\nintegers. Around the zeros the reflection formula suffers from\ncancellation and the implementation loses precision. The sole\npositive zero and the first negative zero, however, are handled\nseparately by precomputing series expansions using [2]_, so the\nfunction should maintain full accuracy around the origin.\n\nReferences\n----------\n.. [1] NIST Digital Library of Mathematical Functions\n       https://dlmf.nist.gov/5\n.. [2] Fredrik Johansson and others.\n       "mpmath: a Python library for arbitrary-precision floating-point arithmetic"\n       (Version 0.19) http://mpmath.org/'
    ...

def radian(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "radian(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nradian(d, m, s, out=None)\n\nConvert from degrees to radians.\n\nReturns the angle given in (d)egrees, (m)inutes, and (s)econds in\nradians.\n\nParameters\n----------\nd : array_like\n    Degrees, can be real-valued.\nm : array_like\n    Minutes, can be real-valued.\ns : array_like\n    Seconds, can be real-valued.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Values of the inputs in radians.\n\nExamples\n--------\n>>> import scipy.special as sc\n\nThere are many ways to specify an angle.\n\n>>> sc.radian(90, 0, 0)\n1.5707963267948966\n>>> sc.radian(0, 60 * 90, 0)\n1.5707963267948966\n>>> sc.radian(0, 0, 60**2 * 90)\n1.5707963267948966\n\nThe inputs can be real-valued.\n\n>>> sc.radian(1.5, 0, 0)\n0.02617993877991494\n>>> sc.radian(1, 30, 0)\n0.02617993877991494"
    ...

def rel_entr(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'rel_entr(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nrel_entr(x, y, out=None)\n\nElementwise function for computing relative entropy.\n\n.. math::\n\n    \\mathrm{rel\\_entr}(x, y) =\n        \\begin{cases}\n            x \\log(x / y) & x > 0, y > 0 \\\\\n            0 & x = 0, y \\ge 0 \\\\\n            \\infty & \\text{otherwise}\n        \\end{cases}\n\nParameters\n----------\nx, y : array_like\n    Input arrays\nout : ndarray, optional\n    Optional output array for the function results\n\nReturns\n-------\nscalar or ndarray\n    Relative entropy of the inputs\n\nSee Also\n--------\nentr, kl_div\n\nNotes\n-----\n.. versionadded:: 0.15.0\n\nThis function is jointly convex in x and y.\n\nThe origin of this function is in convex programming; see\n[1]_. Given two discrete probability distributions :math:`p_1,\n\\ldots, p_n` and :math:`q_1, \\ldots, q_n`, to get the relative\nentropy of statistics compute the sum\n\n.. math::\n\n    \\sum_{i = 1}^n \\mathrm{rel\\_entr}(p_i, q_i).\n\nSee [2]_ for details.\n\nReferences\n----------\n.. [1] Grant, Boyd, and Ye, "CVX: Matlab Software for Disciplined Convex\n    Programming", http://cvxr.com/cvx/\n.. [2] Kullback-Leibler divergence,\n    https://en.wikipedia.org/wiki/Kullback%E2%80%93Leibler_divergence'
    ...

def rgamma(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "rgamma(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nrgamma(z, out=None)\n\nReciprocal of the gamma function.\n\nDefined as :math:`1 / \\Gamma(z)`, where :math:`\\Gamma` is the\ngamma function. For more on the gamma function see `gamma`.\n\nParameters\n----------\nz : array_like\n    Real or complex valued input\nout : ndarray, optional\n    Optional output array for the function results\n\nReturns\n-------\nscalar or ndarray\n    Function results\n\nNotes\n-----\nThe gamma function has no zeros and has simple poles at\nnonpositive integers, so `rgamma` is an entire function with zeros\nat the nonpositive integers. See the discussion in [dlmf]_ for\nmore details.\n\nSee Also\n--------\ngamma, gammaln, loggamma\n\nReferences\n----------\n.. [dlmf] Nist, Digital Library of Mathematical functions,\n    https://dlmf.nist.gov/5.2#i\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is the reciprocal of the gamma function.\n\n>>> sc.rgamma([1, 2, 3, 4])\narray([1.        , 1.        , 0.5       , 0.16666667])\n>>> 1 / sc.gamma([1, 2, 3, 4])\narray([1.        , 1.        , 0.5       , 0.16666667])\n\nIt is zero at nonpositive integers.\n\n>>> sc.rgamma([0, -1, -2, -3])\narray([0., 0., 0., 0.])\n\nIt rapidly underflows to zero along the positive real axis.\n\n>>> sc.rgamma([10, 100, 179])\narray([2.75573192e-006, 1.07151029e-156, 0.00000000e+000])"
    ...

def round(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "round(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nround(x, out=None)\n\nRound to the nearest integer.\n\nReturns the nearest integer to `x`.  If `x` ends in 0.5 exactly,\nthe nearest even integer is chosen.\n\nParameters\n----------\nx : array_like\n    Real valued input.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    The nearest integers to the elements of `x`. The result is of\n    floating type, not integer type.\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt rounds to even.\n\n>>> sc.round([0.5, 1.5])\narray([0., 2.])"
    ...

def seterr() -> typing.Any:
    "Set how special-function errors are handled.\n\n    Parameters\n    ----------\n    all : {'ignore', 'warn' 'raise'}, optional\n        Set treatment for all type of special-function errors at\n        once. The options are:\n\n        - 'ignore' Take no action when the error occurs\n        - 'warn' Print a `SpecialFunctionWarning` when the error\n          occurs (via the Python `warnings` module)\n        - 'raise' Raise a `SpecialFunctionError` when the error\n          occurs.\n\n        The default is to not change the current behavior. If\n        behaviors for additional categories of special-function errors\n        are specified, then ``all`` is applied first, followed by the\n        additional categories.\n    singular : {'ignore', 'warn', 'raise'}, optional\n        Treatment for singularities.\n    underflow : {'ignore', 'warn', 'raise'}, optional\n        Treatment for underflow.\n    overflow : {'ignore', 'warn', 'raise'}, optional\n        Treatment for overflow.\n    slow : {'ignore', 'warn', 'raise'}, optional\n        Treatment for slow convergence.\n    loss : {'ignore', 'warn', 'raise'}, optional\n        Treatment for loss of accuracy.\n    no_result : {'ignore', 'warn', 'raise'}, optional\n        Treatment for failing to find a result.\n    domain : {'ignore', 'warn', 'raise'}, optional\n        Treatment for an invalid argument to a function.\n    arg : {'ignore', 'warn', 'raise'}, optional\n        Treatment for an invalid parameter to a function.\n    other : {'ignore', 'warn', 'raise'}, optional\n        Treatment for an unknown error.\n\n    Returns\n    -------\n    olderr : dict\n        Dictionary containing the old settings.\n\n    See Also\n    --------\n    geterr : get the current way of handling special-function errors\n    errstate : context manager for special-function error handling\n    numpy.seterr : similar numpy function for floating-point errors\n\n    Examples\n    --------\n    >>> import scipy.special as sc\n    >>> from pytest import raises\n    >>> sc.gammaln(0)\n    inf\n    >>> olderr = sc.seterr(singular='raise')\n    >>> with raises(sc.SpecialFunctionError):\n    ...     sc.gammaln(0)\n    ...\n    >>> _ = sc.seterr(**olderr)\n\n    We can also raise for every category except one.\n\n    >>> olderr = sc.seterr(all='raise', singular='ignore')\n    >>> sc.gammaln(0)\n    inf\n    >>> with raises(sc.SpecialFunctionError):\n    ...     sc.spence(-1)\n    ...\n    >>> _ = sc.seterr(**olderr)\n\n    "
    ...

def shichi(x, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'shichi(x[, out1, out2], / [, out=(None, None)], *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nshichi(x, out=None)\n\nHyperbolic sine and cosine integrals.\n\nThe hyperbolic sine integral is\n\n.. math::\n\n  \\int_0^x \\frac{\\sinh{t}}{t}dt\n\nand the hyperbolic cosine integral is\n\n.. math::\n\n  \\gamma + \\log(x) + \\int_0^x \\frac{\\cosh{t} - 1}{t} dt\n\nwhere :math:`\\gamma` is Euler\'s constant and :math:`\\log` is the\nprinciple branch of the logarithm.\n\nParameters\n----------\nx : array_like\n    Real or complex points at which to compute the hyperbolic sine\n    and cosine integrals.\n\nReturns\n-------\nsi : ndarray\n    Hyperbolic sine integral at ``x``\nci : ndarray\n    Hyperbolic cosine integral at ``x``\n\nNotes\n-----\nFor real arguments with ``x < 0``, ``chi`` is the real part of the\nhyperbolic cosine integral. For such points ``chi(x)`` and ``chi(x\n+ 0j)`` differ by a factor of ``1j*pi``.\n\nFor real arguments the function is computed by calling Cephes\'\n[1]_ *shichi* routine. For complex arguments the algorithm is based\non Mpmath\'s [2]_ *shi* and *chi* routines.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/\n.. [2] Fredrik Johansson and others.\n       "mpmath: a Python library for arbitrary-precision floating-point arithmetic"\n       (Version 0.19) http://mpmath.org/'
    ...

def sici(x, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'sici(x[, out1, out2], / [, out=(None, None)], *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nsici(x, out=None)\n\nSine and cosine integrals.\n\nThe sine integral is\n\n.. math::\n\n  \\int_0^x \\frac{\\sin{t}}{t}dt\n\nand the cosine integral is\n\n.. math::\n\n  \\gamma + \\log(x) + \\int_0^x \\frac{\\cos{t} - 1}{t}dt\n\nwhere :math:`\\gamma` is Euler\'s constant and :math:`\\log` is the\nprinciple branch of the logarithm.\n\nParameters\n----------\nx : array_like\n    Real or complex points at which to compute the sine and cosine\n    integrals.\n\nReturns\n-------\nsi : ndarray\n    Sine integral at ``x``\nci : ndarray\n    Cosine integral at ``x``\n\nNotes\n-----\nFor real arguments with ``x < 0``, ``ci`` is the real part of the\ncosine integral. For such points ``ci(x)`` and ``ci(x + 0j)``\ndiffer by a factor of ``1j*pi``.\n\nFor real arguments the function is computed by calling Cephes\'\n[1]_ *sici* routine. For complex arguments the algorithm is based\non Mpmath\'s [2]_ *si* and *ci* routines.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/\n.. [2] Fredrik Johansson and others.\n       "mpmath: a Python library for arbitrary-precision floating-point arithmetic"\n       (Version 0.19) http://mpmath.org/'
    ...

def sindg(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "sindg(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nsindg(x, out=None)\n\nSine of the angle `x` given in degrees.\n\nParameters\n----------\nx : array_like\n    Angle, given in degrees.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Sine at the input.\n\nSee Also\n--------\ncosdg, tandg, cotdg\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is more accurate than using sine directly.\n\n>>> x = 180 * np.arange(3)\n>>> sc.sindg(x)\narray([ 0., -0.,  0.])\n>>> np.sin(x * np.pi / 180)\narray([ 0.0000000e+00,  1.2246468e-16, -2.4492936e-16])"
    ...

def smirnov(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "smirnov(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nsmirnov(n, d)\n\nKolmogorov-Smirnov complementary cumulative distribution function\n\nReturns the exact Kolmogorov-Smirnov complementary cumulative\ndistribution function,(aka the Survival Function) of Dn+ (or Dn-)\nfor a one-sided test of equality between an empirical and a\ntheoretical distribution. It is equal to the probability that the\nmaximum difference between a theoretical distribution and an empirical\none based on `n` samples is greater than d.\n\nParameters\n----------\nn : int\n  Number of samples\nd : float array_like\n  Deviation between the Empirical CDF (ECDF) and the target CDF.\n\nReturns\n-------\nfloat\n    The value(s) of smirnov(n, d), Prob(Dn+ >= d) (Also Prob(Dn- >= d))\n\nNotes\n-----\n`smirnov` is used by `stats.kstest` in the application of the\nKolmogorov-Smirnov Goodness of Fit test. For historial reasons this\nfunction is exposed in `scpy.special`, but the recommended way to achieve\nthe most accurate CDF/SF/PDF/PPF/ISF computations is to use the\n`stats.ksone` distribution.\n\nSee Also\n--------\nsmirnovi : The Inverse Survival Function for the distribution\nscipy.stats.ksone : Provides the functionality as a continuous distribution\nkolmogorov, kolmogi : Functions for the two-sided distribution\n\nExamples\n--------\n>>> from scipy.special import smirnov\n\nShow the probability of a gap at least as big as 0, 0.5 and 1.0 for a sample of size 5\n\n>>> smirnov(5, [0, 0.5, 1.0])\narray([ 1.   ,  0.056,  0.   ])\n\nCompare a sample of size 5 drawn from a source N(0.5, 1) distribution against\na target N(0, 1) CDF.\n\n>>> from scipy.stats import norm\n>>> n = 5\n>>> gendist = norm(0.5, 1)       # Normal distribution, mean 0.5, stddev 1\n>>> np.random.seed(seed=233423)  # Set the seed for reproducibility\n>>> x = np.sort(gendist.rvs(size=n))\n>>> x\narray([-0.20946287,  0.71688765,  0.95164151,  1.44590852,  3.08880533])\n>>> target = norm(0, 1)\n>>> cdfs = target.cdf(x)\n>>> cdfs\narray([ 0.41704346,  0.76327829,  0.82936059,  0.92589857,  0.99899518])\n# Construct the Empirical CDF and the K-S statistics (Dn+, Dn-, Dn)\n>>> ecdfs = np.arange(n+1, dtype=float)/n\n>>> cols = np.column_stack([x, ecdfs[1:], cdfs, cdfs - ecdfs[:n], ecdfs[1:] - cdfs])\n>>> np.set_printoptions(precision=3)\n>>> cols\narray([[ -2.095e-01,   2.000e-01,   4.170e-01,   4.170e-01,  -2.170e-01],\n       [  7.169e-01,   4.000e-01,   7.633e-01,   5.633e-01,  -3.633e-01],\n       [  9.516e-01,   6.000e-01,   8.294e-01,   4.294e-01,  -2.294e-01],\n       [  1.446e+00,   8.000e-01,   9.259e-01,   3.259e-01,  -1.259e-01],\n       [  3.089e+00,   1.000e+00,   9.990e-01,   1.990e-01,   1.005e-03]])\n>>> gaps = cols[:, -2:]\n>>> Dnpm = np.max(gaps, axis=0)\n>>> print('Dn-=%f, Dn+=%f' % (Dnpm[0], Dnpm[1]))\nDn-=0.563278, Dn+=0.001005\n>>> probs = smirnov(n, Dnpm)\n>>> print(chr(10).join(['For a sample of size %d drawn from a N(0, 1) distribution:' % n,\n...      ' Smirnov n=%d: Prob(Dn- >= %f) = %.4f' % (n, Dnpm[0], probs[0]),\n...      ' Smirnov n=%d: Prob(Dn+ >= %f) = %.4f' % (n, Dnpm[1], probs[1])]))\nFor a sample of size 5 drawn from a N(0, 1) distribution:\n Smirnov n=5: Prob(Dn- >= 0.563278) = 0.0250\n Smirnov n=5: Prob(Dn+ >= 0.001005) = 0.9990\n\nPlot the Empirical CDF against the target N(0, 1) CDF\n\n>>> import matplotlib.pyplot as plt\n>>> plt.step(np.concatenate([[-3], x]), ecdfs, where='post', label='Empirical CDF')\n>>> x3 = np.linspace(-3, 3, 100)\n>>> plt.plot(x3, target.cdf(x3), label='CDF for N(0, 1)')\n>>> plt.ylim([0, 1]); plt.grid(True); plt.legend();\n# Add vertical lines marking Dn+ and Dn-\n>>> iminus, iplus = np.argmax(gaps, axis=0)\n>>> plt.vlines([x[iminus]], ecdfs[iminus], cdfs[iminus], color='r', linestyle='dashed', lw=4)\n>>> plt.vlines([x[iplus]], cdfs[iplus], ecdfs[iplus+1], color='m', linestyle='dashed', lw=4)\n>>> plt.show()"
    ...

def smirnovi(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "smirnovi(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nsmirnovi(n, p)\n\nInverse to `smirnov`\n\nReturns `d` such that ``smirnov(n, d) == p``, the critical value\ncorresponding to `p`.\n\nParameters\n----------\nn : int\n  Number of samples\np : float array_like\n    Probability\n\nReturns\n-------\nfloat\n    The value(s) of smirnovi(n, p), the critical values.\n\nNotes\n-----\n`smirnov` is used by `stats.kstest` in the application of the\nKolmogorov-Smirnov Goodness of Fit test. For historial reasons this\nfunction is exposed in `scpy.special`, but the recommended way to achieve\nthe most accurate CDF/SF/PDF/PPF/ISF computations is to use the\n`stats.ksone` distribution.\n\nSee Also\n--------\nsmirnov  : The Survival Function (SF) for the distribution\nscipy.stats.ksone : Provides the functionality as a continuous distribution\nkolmogorov, kolmogi, scipy.stats.kstwobign : Functions for the two-sided distribution"
    ...

def spence(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "spence(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nspence(z, out=None)\n\nSpence's function, also known as the dilogarithm.\n\nIt is defined to be\n\n.. math::\n  \\int_0^z \\frac{\\log(t)}{1 - t}dt\n\nfor complex :math:`z`, where the contour of integration is taken\nto avoid the branch cut of the logarithm. Spence's function is\nanalytic everywhere except the negative real axis where it has a\nbranch cut.\n\nParameters\n----------\nz : array_like\n    Points at which to evaluate Spence's function\n\nReturns\n-------\ns : ndarray\n    Computed values of Spence's function\n\nNotes\n-----\nThere is a different convention which defines Spence's function by\nthe integral\n\n.. math::\n  -\\int_0^z \\frac{\\log(1 - t)}{t}dt;\n\nthis is our ``spence(1 - z)``."
    ...

def sph_harm(x1, x2, x3, x4, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "sph_harm(x1, x2, x3, x4, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nsph_harm(m, n, theta, phi)\n\nCompute spherical harmonics.\n\nThe spherical harmonics are defined as\n\n.. math::\n\n    Y^m_n(\\theta,\\phi) = \\sqrt{\\frac{2n+1}{4\\pi} \\frac{(n-m)!}{(n+m)!}}\n      e^{i m \\theta} P^m_n(\\cos(\\phi))\n\nwhere :math:`P_n^m` are the associated Legendre functions; see `lpmv`.\n\nParameters\n----------\nm : array_like\n    Order of the harmonic (int); must have ``|m| <= n``.\nn : array_like\n   Degree of the harmonic (int); must have ``n >= 0``. This is\n   often denoted by ``l`` (lower case L) in descriptions of\n   spherical harmonics.\ntheta : array_like\n   Azimuthal (longitudinal) coordinate; must be in ``[0, 2*pi]``.\nphi : array_like\n   Polar (colatitudinal) coordinate; must be in ``[0, pi]``.\n\nReturns\n-------\ny_mn : complex float\n   The harmonic :math:`Y^m_n` sampled at ``theta`` and ``phi``.\n\nNotes\n-----\nThere are different conventions for the meanings of the input\narguments ``theta`` and ``phi``. In SciPy ``theta`` is the\nazimuthal angle and ``phi`` is the polar angle. It is common to\nsee the opposite convention, that is, ``theta`` as the polar angle\nand ``phi`` as the azimuthal angle.\n\nNote that SciPy's spherical harmonics include the Condon-Shortley\nphase [2]_ because it is part of `lpmv`.\n\nWith SciPy's conventions, the first several spherical harmonics\nare\n\n.. math::\n\n    Y_0^0(\\theta, \\phi) &= \\frac{1}{2} \\sqrt{\\frac{1}{\\pi}} \\\\\n    Y_1^{-1}(\\theta, \\phi) &= \\frac{1}{2} \\sqrt{\\frac{3}{2\\pi}}\n                                e^{-i\\theta} \\sin(\\phi) \\\\\n    Y_1^0(\\theta, \\phi) &= \\frac{1}{2} \\sqrt{\\frac{3}{\\pi}}\n                             \\cos(\\phi) \\\\\n    Y_1^1(\\theta, \\phi) &= -\\frac{1}{2} \\sqrt{\\frac{3}{2\\pi}}\n                             e^{i\\theta} \\sin(\\phi).\n\nReferences\n----------\n.. [1] Digital Library of Mathematical Functions, 14.30.\n       https://dlmf.nist.gov/14.30\n.. [2] https://en.wikipedia.org/wiki/Spherical_harmonics#Condon.E2.80.93Shortley_phase"
    ...

def stdtr(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "stdtr(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nstdtr(df, t)\n\nStudent t distribution cumulative distribution function\n\nReturns the integral from minus infinity to t of the Student t\ndistribution with df > 0 degrees of freedom::\n\n   gamma((df+1)/2)/(sqrt(df*pi)*gamma(df/2)) *\n   integral((1+x**2/df)**(-df/2-1/2), x=-inf..t)"
    ...

def stdtridf(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "stdtridf(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nstdtridf(p, t)\n\nInverse of `stdtr` vs df\n\nReturns the argument df such that stdtr(df, t) is equal to `p`."
    ...

def stdtrit(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "stdtrit(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nstdtrit(df, p)\n\nInverse of `stdtr` vs `t`\n\nReturns the argument `t` such that stdtr(df, t) is equal to `p`."
    ...

def struve(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "struve(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nstruve(v, x)\n\nStruve function.\n\nReturn the value of the Struve function of order `v` at `x`.  The Struve\nfunction is defined as,\n\n.. math::\n    H_v(x) = (z/2)^{v + 1} \\sum_{n=0}^\\infty \\frac{(-1)^n (z/2)^{2n}}{\\Gamma(n + \\frac{3}{2}) \\Gamma(n + v + \\frac{3}{2})},\n\nwhere :math:`\\Gamma` is the gamma function.\n\nParameters\n----------\nv : array_like\n    Order of the Struve function (float).\nx : array_like\n    Argument of the Struve function (float; must be positive unless `v` is\n    an integer).\n\nReturns\n-------\nH : ndarray\n    Value of the Struve function of order `v` at `x`.\n\nNotes\n-----\nThree methods discussed in [1]_ are used to evaluate the Struve function:\n\n- power series\n- expansion in Bessel functions (if :math:`|z| < |v| + 20`)\n- asymptotic large-z expansion (if :math:`z \\geq 0.7v + 12`)\n\nRounding errors are estimated based on the largest terms in the sums, and\nthe result associated with the smallest error is returned.\n\nSee also\n--------\nmodstruve\n\nReferences\n----------\n.. [1] NIST Digital Library of Mathematical Functions\n       https://dlmf.nist.gov/11"
    ...

def tandg(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "tandg(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ntandg(x, out=None)\n\nTangent of angle `x` given in degrees.\n\nParameters\n----------\nx : array_like\n    Angle, given in degrees.\nout : ndarray, optional\n    Optional output array for the function results.\n\nReturns\n-------\nscalar or ndarray\n    Tangent at the input.\n\nSee Also\n--------\nsindg, cosdg, cotdg\n\nExamples\n--------\n>>> import scipy.special as sc\n\nIt is more accurate than using tangent directly.\n\n>>> x = 180 * np.arange(3)\n>>> sc.tandg(x)\narray([0., 0., 0.])\n>>> np.tan(x * np.pi / 180)\narray([ 0.0000000e+00, -1.2246468e-16, -2.4492936e-16])"
    ...

def tklmbda(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "tklmbda(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ntklmbda(x, lmbda)\n\nTukey-Lambda cumulative distribution function"
    ...

def voigt_profile(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "voigt_profile(x1, x2, x3, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nvoigt_profile(x, sigma, gamma, out=None)\n\nVoigt profile.\n\nThe Voigt profile is a convolution of a 1-D Normal distribution with\nstandard deviation ``sigma`` and a 1-D Cauchy distribution with half-width at\nhalf-maximum ``gamma``.\n\nIf ``sigma = 0``, PDF of Cauchy distribution is returned.\nConversely, if ``gamma = 0``, PDF of Normal distribution is returned.\nIf ``sigma = gamma = 0``, the return value is ``Inf`` for ``x = 0``, and ``0`` for all other ``x``.\n\nParameters\n----------\nx : array_like\n    Real argument\nsigma : array_like\n    The standard deviation of the Normal distribution part\ngamma : array_like\n    The half-width at half-maximum of the Cauchy distribution part\nout : ndarray, optional\n    Optional output array for the function values\n\nReturns\n-------\nscalar or ndarray\n    The Voigt profile at the given arguments\n\nNotes\n-----\nIt can be expressed in terms of Faddeeva function\n\n.. math:: V(x; \\sigma, \\gamma) = \\frac{Re[w(z)]}{\\sigma\\sqrt{2\\pi}},\n.. math:: z = \\frac{x + i\\gamma}{\\sqrt{2}\\sigma}\n\nwhere :math:`w(z)` is the Faddeeva function.\n\nSee Also\n--------\nwofz : Faddeeva function\n\nReferences\n----------\n.. [1] https://en.wikipedia.org/wiki/Voigt_profile"
    ...

def wofz(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "wofz(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nwofz(z)\n\nFaddeeva function\n\nReturns the value of the Faddeeva function for complex argument::\n\n    exp(-z**2) * erfc(-i*z)\n\nSee Also\n--------\ndawsn, erf, erfc, erfcx, erfi\n\nReferences\n----------\n.. [1] Steven G. Johnson, Faddeeva W function implementation.\n   http://ab-initio.mit.edu/Faddeeva\n\nExamples\n--------\n>>> from scipy import special\n>>> import matplotlib.pyplot as plt\n\n>>> x = np.linspace(-3, 3)\n>>> z = special.wofz(x)\n\n>>> plt.plot(x, z.real, label='wofz(x).real')\n>>> plt.plot(x, z.imag, label='wofz(x).imag')\n>>> plt.xlabel('$x$')\n>>> plt.legend(framealpha=1, shadow=True)\n>>> plt.grid(alpha=0.25)\n>>> plt.show()"
    ...

def wrightomega(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'wrightomega(x, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nwrightomega(z, out=None)\n\nWright Omega function.\n\nDefined as the solution to\n\n.. math::\n\n    \\omega + \\log(\\omega) = z\n\nwhere :math:`\\log` is the principal branch of the complex logarithm.\n\nParameters\n----------\nz : array_like\n    Points at which to evaluate the Wright Omega function\n\nReturns\n-------\nomega : ndarray\n    Values of the Wright Omega function\n\nNotes\n-----\n.. versionadded:: 0.19.0\n\nThe function can also be defined as\n\n.. math::\n\n    \\omega(z) = W_{K(z)}(e^z)\n\nwhere :math:`K(z) = \\lceil (\\Im(z) - \\pi)/(2\\pi) \\rceil` is the\nunwinding number and :math:`W` is the Lambert W function.\n\nThe implementation here is taken from [1]_.\n\nSee Also\n--------\nlambertw : The Lambert W function\n\nReferences\n----------\n.. [1] Lawrence, Corless, and Jeffrey, "Algorithm 917: Complex\n       Double-Precision Evaluation of the Wright :math:`\\omega`\n       Function." ACM Transactions on Mathematical Software,\n       2012. :doi:`10.1145/2168773.2168779`.'
    ...

def xlog1py(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "xlog1py(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nxlog1py(x, y)\n\nCompute ``x*log1p(y)`` so that the result is 0 if ``x = 0``.\n\nParameters\n----------\nx : array_like\n    Multiplier\ny : array_like\n    Argument\n\nReturns\n-------\nz : array_like\n    Computed x*log1p(y)\n\nNotes\n-----\n\n.. versionadded:: 0.13.0"
    ...

def xlogy(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "xlogy(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nxlogy(x, y)\n\nCompute ``x*log(y)`` so that the result is 0 if ``x = 0``.\n\nParameters\n----------\nx : array_like\n    Multiplier\ny : array_like\n    Argument\n\nReturns\n-------\nz : array_like\n    Computed x*log(y)\n\nNotes\n-----\n\n.. versionadded:: 0.13.0"
    ...

def y0(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "y0(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ny0(x)\n\nBessel function of the second kind of order 0.\n\nParameters\n----------\nx : array_like\n    Argument (float).\n\nReturns\n-------\nY : ndarray\n    Value of the Bessel function of the second kind of order 0 at `x`.\n\nNotes\n-----\n\nThe domain is divided into the intervals [0, 5] and (5, infinity). In the\nfirst interval a rational approximation :math:`R(x)` is employed to\ncompute,\n\n.. math::\n\n    Y_0(x) = R(x) + \\frac{2 \\log(x) J_0(x)}{\\pi},\n\nwhere :math:`J_0` is the Bessel function of the first kind of order 0.\n\nIn the second interval, the Hankel asymptotic expansion is employed with\ntwo rational functions of degree 6/6 and 7/7.\n\nThis function is a wrapper for the Cephes [1]_ routine `y0`.\n\nSee also\n--------\nj0\nyv\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def y1(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "y1(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\ny1(x)\n\nBessel function of the second kind of order 1.\n\nParameters\n----------\nx : array_like\n    Argument (float).\n\nReturns\n-------\nY : ndarray\n    Value of the Bessel function of the second kind of order 1 at `x`.\n\nNotes\n-----\n\nThe domain is divided into the intervals [0, 8] and (8, infinity). In the\nfirst interval a 25 term Chebyshev expansion is used, and computing\n:math:`J_1` (the Bessel function of the first kind) is required. In the\nsecond, the asymptotic trigonometric representation is employed using two\nrational functions of degree 5/5.\n\nThis function is a wrapper for the Cephes [1]_ routine `y1`.\n\nSee also\n--------\nj1\nyn\nyv\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def yn(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "yn(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nyn(n, x)\n\nBessel function of the second kind of integer order and real argument.\n\nParameters\n----------\nn : array_like\n    Order (integer).\nz : array_like\n    Argument (float).\n\nReturns\n-------\nY : ndarray\n    Value of the Bessel function, :math:`Y_n(x)`.\n\nNotes\n-----\nWrapper for the Cephes [1]_ routine `yn`.\n\nThe function is evaluated by forward recurrence on `n`, starting with\nvalues computed by the Cephes routines `y0` and `y1`. If `n = 0` or 1,\nthe routine for `y0` or `y1` is called directly.\n\nSee also\n--------\nyv : For real order and real or complex argument.\n\nReferences\n----------\n.. [1] Cephes Mathematical Functions Library,\n       http://www.netlib.org/cephes/"
    ...

def yv(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'yv(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nyv(v, z)\n\nBessel function of the second kind of real order and complex argument.\n\nParameters\n----------\nv : array_like\n    Order (float).\nz : array_like\n    Argument (float or complex).\n\nReturns\n-------\nY : ndarray\n    Value of the Bessel function of the second kind, :math:`Y_v(x)`.\n\nNotes\n-----\nFor positive `v` values, the computation is carried out using the\nAMOS [1]_ `zbesy` routine, which exploits the connection to the Hankel\nBessel functions :math:`H_v^{(1)}` and :math:`H_v^{(2)}`,\n\n.. math:: Y_v(z) = \\frac{1}{2\\imath} (H_v^{(1)} - H_v^{(2)}).\n\nFor negative `v` values the formula,\n\n.. math:: Y_{-v}(z) = Y_v(z) \\cos(\\pi v) + J_v(z) \\sin(\\pi v)\n\nis used, where :math:`J_v(z)` is the Bessel function of the first kind,\ncomputed using the AMOS routine `zbesj`.  Note that the second term is\nexactly zero for integer `v`; to improve accuracy the second term is\nexplicitly omitted for `v` values such that `v = floor(v)`.\n\nSee also\n--------\nyve : :math:`Y_v` with leading exponential behavior stripped off.\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/'
    ...

def yve(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'yve(x1, x2, /, out=None, *, where=True, casting=\'same_kind\', order=\'K\', dtype=None, subok=True[, signature, extobj])\n\nyve(v, z)\n\nExponentially scaled Bessel function of the second kind of real order.\n\nReturns the exponentially scaled Bessel function of the second\nkind of real order `v` at complex `z`::\n\n    yve(v, z) = yv(v, z) * exp(-abs(z.imag))\n\nParameters\n----------\nv : array_like\n    Order (float).\nz : array_like\n    Argument (float or complex).\n\nReturns\n-------\nY : ndarray\n    Value of the exponentially scaled Bessel function.\n\nNotes\n-----\nFor positive `v` values, the computation is carried out using the\nAMOS [1]_ `zbesy` routine, which exploits the connection to the Hankel\nBessel functions :math:`H_v^{(1)}` and :math:`H_v^{(2)}`,\n\n.. math:: Y_v(z) = \\frac{1}{2\\imath} (H_v^{(1)} - H_v^{(2)}).\n\nFor negative `v` values the formula,\n\n.. math:: Y_{-v}(z) = Y_v(z) \\cos(\\pi v) + J_v(z) \\sin(\\pi v)\n\nis used, where :math:`J_v(z)` is the Bessel function of the first kind,\ncomputed using the AMOS routine `zbesj`.  Note that the second term is\nexactly zero for integer `v`; to improve accuracy the second term is\nexplicitly omitted for `v` values such that `v = floor(v)`.\n\nReferences\n----------\n.. [1] Donald E. Amos, "AMOS, A Portable Package for Bessel Functions\n       of a Complex Argument and Nonnegative Order",\n       http://netlib.org/amos/'
    ...

def zetac(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "zetac(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nzetac(x)\n\nRiemann zeta function minus 1.\n\nThis function is defined as\n\n.. math:: \\zeta(x) = \\sum_{k=2}^{\\infty} 1 / k^x,\n\nwhere ``x > 1``.  For ``x < 1`` the analytic continuation is\ncomputed. For more information on the Riemann zeta function, see\n[dlmf]_.\n\nParameters\n----------\nx : array_like of float\n    Values at which to compute zeta(x) - 1 (must be real).\n\nReturns\n-------\nout : array_like\n    Values of zeta(x) - 1.\n\nSee Also\n--------\nzeta\n\nExamples\n--------\n>>> from scipy.special import zetac, zeta\n\nSome special values:\n\n>>> zetac(2), np.pi**2/6 - 1\n(0.64493406684822641, 0.6449340668482264)\n\n>>> zetac(-1), -1.0/12 - 1\n(-1.0833333333333333, -1.0833333333333333)\n\nCompare ``zetac(x)`` to ``zeta(x) - 1`` for large `x`:\n\n>>> zetac(60), zeta(60) - 1\n(8.673617380119933e-19, 0.0)\n\nReferences\n----------\n.. [dlmf] NIST Digital Library of Mathematical Functions\n          https://dlmf.nist.gov/25"
    ...

def __getattr__(name) -> typing.Any:
    ...

