from vispy.scene.node import Node
from typing import Literal, Mapping
from vispy.util.event import Event
from numpy.typing import ArrayLike

# -*- coding: utf-8 -*-
# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.

from ...util import keys
from ..node import Node
from ...visuals.transforms import (
    STTransform,
    MatrixTransform,
    NullTransform,
    TransformCache,
)

def nested_getattr(obj, names): ...
def nested_setattr(obj, names, val): ...

class BaseCamera(Node):

    # These define the state of the camera
    _state_props = ...

    # The fractional zoom to apply for a single pixel of mouse motion
    zoom_factor: float = ...

    def __init__(
        self,
        interactive: bool = True,
        flip: tuple[bool, ...] | None = None,
        up: Literal["+z", "-z", "+y", "-y", "+x", "-x"] = "+z",
        parent: Node | None = None,
        name: str | None = None,
    ): ...
    @property
    def depth_value(self): ...
    @depth_value.setter
    def depth_value(self, value): ...
    def _depth_to_z(self, depth): ...
    def _viewbox_set(self, viewbox): ...
    def _viewbox_unset(self, viewbox): ...
    @property
    def viewbox(self): ...

    # Camera attributes

    @property
    def interactive(self): ...
    @interactive.setter
    def interactive(self, value): ...
    @property
    def flip(self): ...
    @flip.setter
    def flip(self, value): ...
    @property
    def up(self): ...
    @up.setter
    def up(self, value): ...
    @property
    def center(self): ...
    @center.setter
    def center(self, val): ...
    @property
    def fov(self): ...
    @fov.setter
    def fov(self, fov): ...

    # Camera methods

    def set_range(
        self,
        x: tuple | None | None = None,
        y: tuple | None | None = None,
        z: tuple | None | None = None,
        margin: float = 0.05,
    ): ...
    def _set_range(self, init): ...
    def reset(self): ...
    def set_default_state(self): ...
    def get_state(self, props: ArrayLike | None = None): ...
    def set_state(self, state: Mapping | None = None, **kwargs): ...
    def link(
        self,
        camera: BaseCamera,
        props: ArrayLike | None = None,
        axis: Literal["y", "x"] | None = None,
    ): ...

    # Event-related methods

    def view_changed(self): ...
    @property
    def pre_transform(self): ...
    @pre_transform.setter
    def pre_transform(self, tr): ...
    def viewbox_mouse_event(self, event: Event): ...
    def on_canvas_change(self, event: Event): ...
    def viewbox_key_event(self, event: Event): ...
    def viewbox_resize_event(self, event: Event): ...
    def _update_transform(self): ...
    def _set_scene_transform(self, tr): ...
