# -*- coding: utf-8 -*-
# -----------------------------------------------------------------------------
# Copyright (c) 2014, Nicolas P. Rougier
# Distributed under the (new) BSD License. See LICENSE.txt for more info.
# -----------------------------------------------------------------------------
import re
import math
import numpy as np

from . import geometry
from .geometry import epsilon
from .transformable import Transformable

# ----------------------------------------------------------------- Command ---
class Command(object):
    def __repr__(self): ...
    def origin(self, current=None, previous=None): ...

# -------------------------------------------------------------------- Line ---
class Line(Command):
    def __init__(self, x=0, y=0, relative=True): ...
    def vertices(self, current, previous=None): ...

# ------------------------------------------------------------------- VLine ---
class VLine(Command):
    def __init__(self, y=0, relative=True): ...
    def vertices(self, current, previous=None): ...

# ------------------------------------------------------------------- HLine ---
class HLine(Command):
    def __init__(self, x=0, relative=True): ...
    def vertices(self, current, previous=None): ...

# -------------------------------------------------------------------- Move ---
class Move(Command):
    def __init__(self, x=0, y=0, relative=True): ...
    def vertices(self, current, previous=None): ...

# ------------------------------------------------------------------- Close ---
class Close(Command):
    def __init__(self, relative=True): ...
    def vertices(self, current, previous=None): ...

# --------------------------------------------------------------------- Arc ---
class Arc(Command):
    def __init__(self, r1=1, r2=1, angle=..., large=True, sweep=True, x=0, y=0, relative=True): ...
    def vertices(self, current, previous=None): ...

# ------------------------------------------------------------------- Cubic ---
class Cubic(Command):
    def __init__(self, x1=0, y1=0, x2=0, y2=0, x3=0, y3=0, relative=True): ...
    def vertices(self, current, previous=None): ...

# --------------------------------------------------------------- Quadratic ---
class Quadratic(Command):
    def __init__(self, x1=0, y1=0, x2=0, y2=0, relative=True): ...
    def vertices(self, current, last_control_point=None): ...

# ------------------------------------------------------------- SmoothCubic ---
class SmoothCubic(Command):
    def __init__(self, x2=0, y2=0, x3=0, y3=0, relative=True): ...
    def vertices(self, current, previous): ...

# --------------------------------------------------------- SmoothQuadratic ---
class SmoothQuadratic(Command):
    def __init__(self, x2=0, y2=0, relative=True): ...
    def vertices(self, current, previous): ...

# -------------------------------------------------------------------- Path ---
class Path(Transformable):
    def __init__(self, content=None, parent=None): ...
    def __repr__(self): ...
    @property
    def xml(self): ...
    def _xml(self, prefix=""): ...
    @property
    def vertices(self): ...
