# -*- coding: utf-8 -*-
# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.

from .base_filter import Filter
from ..shaders import Function, Varying
from ...color import colormap, Color

class IsolineFilter(Filter):
    FRAG_SHADER: str = ...

    def __init__(self, level=2.0, width=2.0, antialias=1.0, color="black", **kwargs): ...
    @property
    def level(self): ...
    @level.setter
    def level(self, lev): ...
    @property
    def width(self): ...
    @width.setter
    def width(self, w): ...
    @property
    def color(self): ...
    @color.setter
    def color(self, c): ...
    @property
    def antialias(self): ...
    @antialias.setter
    def antialias(self, a): ...

class Alpha(Filter):
    FRAG_SHADER: str = ...

    def __init__(self, alpha=1.0, **kwargs): ...
    @property
    def alpha(self): ...
    @alpha.setter
    def alpha(self, a): ...

class ColorFilter(Filter):
    FRAG_SHADER: str = ...

    def __init__(self, filter=..., fpos: int = 8, **kwargs): ...
    @property
    def filter(self): ...
    @filter.setter
    def filter(self, f): ...

class ZColormapFilter(Filter):
    FRAG_SHADER: str = ...
    VERT_SHADER: str = ...

    def __init__(self, cmap, zrange=..., fpos: int = 3, vpos: int = 9, **kwargs): ...
    def _attach(self, visual): ...
