from numpy import dtype
from numpy.typing import NDArray, ArrayLike

# -*- coding: utf-8 -*-
# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.

import numpy as np

from ..color import Colormap

from ..gloo import Texture2D, VertexBuffer
from ..gloo.texture import should_cast_to_f32
from ..color import get_colormap
from .shaders import Function, FunctionChain
from .transforms import NullTransform
from .visual import Visual
from ..io import load_spatial_filters
from ._scalable_textures import CPUScaledTexture2D, GPUScaledTexture2D

_VERTEX_SHADER: str = ...

_FRAGMENT_SHADER: str = ...  # noqa

_INTERPOLATION_TEMPLATE: str = ...

_TEXTURE_LOOKUP: str = ...

_APPLY_CLIM_FLOAT: str = ...

_APPLY_CLIM: str = ...

_APPLY_GAMMA_FLOAT: str = ...

_APPLY_GAMMA: str = ...

_NULL_COLOR_TRANSFORM: str = ...

_C2L_RED: str = ...

_CUSTOM_FILTER: str = ...

class ImageVisual(Visual):

    _shaders: dict = ...

    _func_templates: dict = ...

    def __init__(
        self,
        data: NDArray | None = None,
        method: str = "auto",
        grid: tuple[float, float] = ...,
        cmap: str | Colormap = "viridis",
        clim: str | tuple = "auto",
        gamma: float = 1.0,
        interpolation: str = "nearest",
        texture_format: np.dtype | None | str = None,
        custom_kernel: NDArray = ...,
        **kwargs,
    ): ...
    def _init_interpolation(self, interpolation_names): ...
    def _init_texture(self, data, texture_format, **texture_kwargs): ...
    def set_data(self, image: ArrayLike): ...
    def view(self): ...
    def _init_view(self, view): ...
    @property
    def clim(self): ...
    @clim.setter
    def clim(self, clim): ...
    def _update_colortransform_clim(self): ...
    @property
    def cmap(self): ...
    @cmap.setter
    def cmap(self, cmap): ...
    @property
    def gamma(self): ...
    @gamma.setter
    def gamma(self, value): ...
    @property
    def method(self): ...
    @method.setter
    def method(self, m): ...
    @property
    def size(self): ...
    @property
    def interpolation(self): ...
    @interpolation.setter
    def interpolation(self, i): ...
    @property
    def interpolation_functions(self): ...
    @property
    def custom_kernel(self): ...
    @custom_kernel.setter
    def custom_kernel(self, value): ...

    # The interpolation code could be transferred to a dedicated filter
    # function in visuals/filters as discussed in #1051
    def _build_interpolation(self): ...
    def _build_vertex_data(self): ...
    def _update_method(self, view): ...
    def _build_texture(self): ...
    def _compute_bounds(self, axis, view): ...
    def _build_color_transform(self): ...
    def _prepare_transforms(self, view): ...
    def _prepare_draw(self, view): ...
