from vispy.util.svg.color import Color
from numpy.typing import ArrayLike

# -*- coding: utf-8 -*-
# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.

from functools import lru_cache

import numpy as np

from ... import gloo, glsl
from ...color import Color, ColorArray, get_colormap
from ..shaders import Function
from ..visual import Visual, CompoundVisual
from ...util.profiler import Profiler

from .dash_atlas import DashAtlas

joins: dict = ...

caps: dict = ...

class LineVisual(CompoundVisual):

    _join_types = ...

    _cap_types = ...

    def __init__(
        self,
        pos: ArrayLike | None = None,
        color: Color | tuple | ArrayLike = ...,
        width=1,
        connect: str | ArrayLike = "strip",
        method: str = "gl",
        antialias: bool = False,
    ): ...
    @property
    def join_types(self): ...
    @property
    def cap_types(self): ...
    @property
    def antialias(self): ...
    @antialias.setter
    def antialias(self, aa): ...
    @property
    def method(self): ...
    @method.setter
    def method(self, method): ...
    def set_data(
        self,
        pos: ArrayLike | None = None,
        color: Color | tuple | ArrayLike | None = None,
        width=None,
        connect: str | ArrayLike | None = None,
    ): ...
    @property
    def color(self): ...
    @property
    def width(self): ...
    @property
    def connect(self): ...
    @property
    def pos(self): ...
    def _interpret_connect(self): ...
    def _interpret_color(self, color_in=None): ...
    def _compute_bounds(self, axis, view): ...
    def _prepare_draw(self, view): ...

class _GLLineVisual(Visual):
    _shaders: dict = ...

    def __init__(self, parent): ...
    @staticmethod
    @lru_cache(maxsize=2)
    def _ensure_vec4_func(dims): ...
    def _prepare_transforms(self, view): ...
    def _prepare_draw(self, view): ...

class _AggLineVisual(Visual):
    _agg_vtype = ...

    _shaders: dict = ...

    def __init__(self, parent): ...
    def _prepare_transforms(self, view): ...
    def _prepare_draw(self, view): ...
    @classmethod
    def _agg_bake(cls, vertices, color, closed=False): ...
