# -*- coding: utf-8 -*-
# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.

from __future__ import division

import re

# regular expressions for parsing GLSL

re_version_pragma: str = ...

re_type: str = ...
re_identifier: str = ...

# variable qualifiers
re_qualifier: str = ...

# template variables like
#     $func_name
re_template_var = ...

# function names may be either identifier or template var
re_func_name = ...

# type and identifier like "vec4 var_name"
re_declaration = ...

# qualifier, type, and identifier like "uniform vec4 var_name"
# qualifier is optional.
# may include multiple names like "attribute float x, y, z"
re_prog_var_declaration = ...

# list of variable declarations like "vec4 var_name, float other_var_name"
re_arg_list = ...

# function declaration like "vec4 function_name(float x, float y)"
re_func_decl = ...

# anonymous variable declarations may or may not include a name:
#  "vec4" or "vec4 var_name"
re_anon_decl = ...

# list of anonymous declarations
re_anon_arg_list = ...

# function prototype declaration like
#    "vec4 function_name(float, float);"
re_func_prot = ...

def parse_function_signature(code): ...
def find_functions(code): ...
def find_prototypes(code): ...
def find_program_variables(code): ...
def find_template_variables(code): ...
