# -*- coding: utf-8 -*-
# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.
from collections import OrderedDict
from weakref import WeakKeyDictionary

from .compiler import Compiler

class ShaderObject(object):
    @classmethod
    def create(self, obj, ref=None): ...
    def __init__(self): ...
    @property
    def name(self): ...
    @property
    def version_pragma(self): ...
    def definition(self, obj_names, version, shader): ...
    def expression(self, obj_names): ...
    def dependencies(self, sort=False): ...
    def static_names(self): ...
    def _add_dep(self, dep): ...
    def _remove_dep(self, dep): ...
    def _dep_changed(self, dep, code_changed=False, value_changed=False): ...
    def changed(self, code_changed=False, value_changed=False): ...
    def compile(self): ...
    def __repr__(self): ...

from .variable import Variable  # noqa
from .expression import TextExpression  # noqa
