# -*- coding: utf-8 -*-
# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.

from __future__ import division

from ..shaders import Function
from ...util.event import EventEmitter

class BaseTransform(object):

    glsl_map: None = ...  # Must be GLSL code
    glsl_imap: None = ...

    # Flags used to describe the transformation. Subclasses should define each
    # as True or False.
    # (usually used for making optimization decisions)

    # If True, then for any 3 colinear points, the
    # transformed points will also be colinear.
    Linear: None = ...

    # The transformation's effect on one axis is independent
    # of the input position along any other axis.
    Orthogonal: None = ...

    # If True, then the distance between two points is the
    # same as the distance between the transformed points.
    NonScaling: None = ...

    # Scale factors are applied equally to all axes.
    Isometric: None = ...

    def __init__(self): ...
    def map(self, obj: tuple[float, float] | tuple[float, float, float]): ...
    def imap(self, obj: tuple[float, float] | tuple[float, float, float]): ...
    @property
    def inverse(self): ...
    @property
    def dynamic(self): ...
    @dynamic.setter
    def dynamic(self, d): ...
    def shader_map(self): ...
    def shader_imap(self): ...
    def _shader_object(self): ...
    def update(self, *args): ...
    def __mul__(self, tr): ...
    def __rmul__(self, tr): ...
    def __repr__(self): ...
    def __del__(self): ...

class InverseTransform(BaseTransform):
    def __init__(self, transform): ...
    @property
    def Linear(self): ...
    @property
    def Orthogonal(self): ...
    @property
    def NonScaling(self): ...
    @property
    def Isometric(self): ...
    @property
    def shader_map(self): ...
    @property
    def shader_imap(self): ...
    def __repr__(self): ...

# import here to avoid import cycle; needed for BaseTransform.__mul__.
from .chain import ChainTransform  # noqa
