def program(n):

    question1 = """
import numpy as np
import pandas as pd


df = pd.read_csv()
df.head()

display(df.isnull())
display(df.notnull())

df["Sat_bin"] = df['satisfaction level'].apply(lambda x: "High" if x > 0.7 else "Low")
df.head()

df["purchase"] = df['purchase history'].map({"high": 2, "mid": 1, "low": 0})
df.head()

df["z"] = (df["income"] - df['income'].mean()) / df['income'].std()
outliers = df[df['z'].abs() > 2]
display(outliers)
"""

    question2 = """
import numpy as np
import pandas as pd

df = pd.read_csv()
df.head()

df["age"].fillna(df['age'].mean(), inplace=True)

df['city'] = df['city'].fillna('Unknown')
display(df)

bins = [18, 30, 40, 50]
labels = ["one", "two", "three"]
df["age_group"] = pd.cut(df.age, bins=bins, labels=labels)
display(df)


dummies = pd.get_dummies(df["city"])
df = pd.concat([df, dummies], axis=1)
display(df)
"""

    question3 = """
left_join = df1.merge(df2, on="orderid", how="inner")
display(left_join)

right_join = df1.merge(df2, on="orderid", how="right")
display(right_join)

vertical_concat = pd.concat([df1, df2], axis=0)
display(vertical_concat)

horizontal_contcat = pd.concat([df1, df2], axis=1)
display(horizontal_contcat)

combined = df1.reset_index().merge(df2, on="orderid", how="inner")
display(combined)

pivot_table = df1.pivot_table(index="product", columns="month", values="sales", aggfunc="sum")
display(pivot_table)
"""

    question4 = """
mean_population = df["population"].mean()
print(f"The mean population is: {mean_population}")
median_population = df["population"].median()
print(f"The mean population is: {median_population}")


df['population'] = df['population'] * 1.30
display(df.head())


df_mi = df.set_index(['country', 'year'])
display(df_mi)

df_swap_sorted = df_mi.swaplevel().sort_index()
display(df_swap_sorted)


df_unstacked = df_mi.unstack(level="country")
display(df_unstacked)


df_hire = df.set_index(['country', 'year'])
china_population = df_hire.loc["china", "population"]
china_population

"""


    question6 = """
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt


df=pd.read_csv()
display(df.head())


plt.plot(df["game"], df["points scored"])
plt.show()


plt.plot(df["game"], df["attendance"])
average_attendance = df['attendance'].mean()
plt.axhline(average_attendance, color='red', linestyle='--')
plt.show()



player_points = {
    'Alice': 120,
    'Bob': 150,
    'Charlie': 100,
    'Diana': 180
}
plt.bar(player_points.keys(), player_points.values(), color='orange')
plt.show()



bins = [0,80,100,120]
labels = ["<80","80-100",">100"]
df["range"] = pd.cut(df["points scored"], bins=bins, labels=labels, include_lowest=True)
score_range_counts = df['range'].value_counts().sort_index()
plt.bar(score_range_counts.index, score_range_counts.values, color='skyblue')
plt.show()




points_vs_opponent = df.groupby('opponent points')['points scored'].mean()
points_vs_opponent.plot(kind='bar', color='cornflowerblue')
plt.show()



attendance_vs_opponent = df.groupby('opponent points')['attendance'].mean()
attendance_vs_opponent.plot(kind='bar', color='mediumseagreen')
plt.show()




df['Result'] = df.apply(lambda row: 'Win' if row['points scored'] > row['opponent points'] else 'Loss', axis=1)
avg_points = df.groupby('Result')['points scored'].mean()
win_loss_counts = df['Result'].value_counts()
summary = pd.DataFrame({
    'Games': win_loss_counts,
    'Average Points Scored': avg_points
})
summary.plot(kind='bar', figsize=(8,5))
plt.show()

"""

    question5 = """

import pandas as pd
df = pd.read_csv()
display(df.head())



p1 = df.pivot_table(index="salesperson", columns="date", values="revenue", aggfunc="sum")



p2 = df.groupby("products")["revenue"].mean()


p3 = df.groupby("salesperson")["units sold"].max()



p4 = (df.groupby("region")["revenue"].sum() / df["revenue"].sum()) * 100


p5 = df["salesperson"].value_counts().idxmax()



p6 = df.pivot_table(index="salesperson", columns="products",
                    values=["revenue","units sold"], aggfunc="sum")



p7 = df.pivot_table(index="region", columns="date", values="units sold", aggfunc="sum")
display(df.head())

"""

    question7 = """
df["Date/Time"] = pd.to_datetime(df["Date, Time"])
df["hour"] = df["Date/Time"].dt.hour
df["day"] = df["Date/Time"].dt.day_name()
df["month"] = df["Date/Time"].dt.month



pivot_heat = df.groupby(["day","hour"]).size().unstack(fill_value=0)
plt.figure(figsize=(6,4))
sns.heatmap(pivot_heat, cmap="YlGnBu", linewidths = .5)
plt.show()




daily_counts = df.groupby(df["Date"].dt.date).size()
plt.plot(daily_counts.index, daily_counts.values)
plt.show()



region_counts = df["PuFrom"].value_counts()
plt.scatter(region_counts.index, region_counts.values, s=region_counts.values*50)
plt.show()
"""

    question8 = """
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns


survival_rate = df.groupby("Pclass")["Survived"].mean()
plt.bar(survival_rate.index, survival_rate.values)
plt.show()


counts = df["Survived"].value_counts()
plt.pie(counts.values, labels=["Non-survived","Survived"])
plt.show()


grouped = df.groupby(['Pclass', 'Sex', 'Survived']).size().unstack(fill_value=0)
grouped.plot(kind='bar', stacked=True)
plt.show()
"""


    question9 = """
plt.scatter(df["GrLivArea"], df["SalePrice"])
plt.show()


corr = df["GrLivArea","OverallQual","TotalBsmtSF","SalePrice"].corr()
sns.heatmap(corr, annot=True, cmap="coolwarm")
plt.show()


plt.scatter(df["GrLivArea"], df["SalePrice"],c=df["YearBuilt"], s=df["OverallQual"]*20)
plt.show()
"""


    question10 = """
import squarify
df=pd.read_csv())
df.head()


pos_counts = df["player_positions"].str.split(",").str[0].value_counts()
plt.bar(pos_counts.index, pos_counts.values)
plt.show()



pos_rating = df.groupby(df['player_positions'].str.split(',').str[0])['overall'].mean()
plt.pie(pos_rating, labels=pos_rating.index, autopct='%1.1f%%', wedgeprops={'width':0.4})
plt.title("Average Overall Rating by Position (Donut Chart)")
plt.show()


tree_sizes = df.groupby("Position")["overall"].sum()
squarify.plot(sizes=tree_sizes.values, label=tree_sizes.index)
plt.show()

"""

    questions = {
        1: question1,
        2: question2,
        3: question3,
        4: question4,
        5: question5,
        6: question6,
        7: question7,
        8: question8,
        9: question9,
        10: question10,
    }

    snippet = questions.get(n)
    if snippet is None:
        print(f"Invalid option: {n}. Please choose an integer between 1 and 10.")
    else:
        print(snippet)