"""
An object-oriented plotting library.

A procedural interface is provided by the companion pyplot module,
which may be imported directly, e.g.::

    import matplotlib.pyplot as plt

or using ipython::

    ipython

at your terminal, followed by::

    In [1]: %matplotlib
    In [2]: import matplotlib.pyplot as plt

at the ipython shell prompt.

For the most part, direct use of the explicit object-oriented library is
encouraged when programming; the implicit pyplot interface is primarily for
working interactively. The exceptions to this suggestion are the pyplot
functions `.pyplot.figure`, `.pyplot.subplot`, `.pyplot.subplots`, and
`.pyplot.savefig`, which can greatly simplify scripting.  See
:ref:`api_interfaces` for an explanation of the tradeoffs between the implicit
and explicit interfaces.

Modules include:

:mod:`matplotlib.axes`
    The `~.axes.Axes` class.  Most pyplot functions are wrappers for
    `~.axes.Axes` methods.  The axes module is the highest level of OO
    access to the library.

:mod:`matplotlib.figure`
    The `.Figure` class.

:mod:`matplotlib.artist`
    The `.Artist` base class for all classes that draw things.

:mod:`matplotlib.lines`
    The `.Line2D` class for drawing lines and markers.

:mod:`matplotlib.patches`
    Classes for drawing polygons.

:mod:`matplotlib.text`
    The `.Text` and `.Annotation` classes.

:mod:`matplotlib.image`
    The `.AxesImage` and `.FigureImage` classes.

:mod:`matplotlib.collections`
    Classes for efficient drawing of groups of lines or polygons.

:mod:`matplotlib.colors`
    Color specifications and making colormaps.

:mod:`matplotlib.cm`
    Colormaps, and the `.ScalarMappable` mixin class for providing color
    mapping functionality to other classes.

:mod:`matplotlib.ticker`
    Calculation of tick mark locations and formatting of tick labels.

:mod:`matplotlib.backends`
    A subpackage with modules for various GUI libraries and output formats.

The base matplotlib namespace includes:

`~matplotlib.rcParams`
    Default configuration settings; their defaults may be overridden using
    a :file:`matplotlibrc` file.

`~matplotlib.use`
    Setting the Matplotlib backend.  This should be called before any
    figure is created, because it is not possible to switch between
    different GUI backends after that.

The following environment variables can be used to customize the behavior:

:envvar:`MPLBACKEND`
    This optional variable can be set to choose the Matplotlib backend. See
    :ref:`what-is-a-backend`.

:envvar:`MPLCONFIGDIR`
    This is the directory used to store user customizations to
    Matplotlib, as well as some caches to improve performance. If
    :envvar:`MPLCONFIGDIR` is not defined, :file:`{HOME}/.config/matplotlib`
    and :file:`{HOME}/.cache/matplotlib` are used on Linux, and
    :file:`{HOME}/.matplotlib` on other platforms, if they are
    writable. Otherwise, the Python standard library's `tempfile.gettempdir`
    is used to find a base directory in which the :file:`matplotlib`
    subdirectory is created.

Matplotlib was initially written by John D. Hunter (1968-2012) and is now
developed and maintained by a host of others.

Occasionally the internal documentation (python docstrings) will refer
to MATLAB®, a registered trademark of The MathWorks, Inc.

"""



"""
Occasionally the internal documentation (python docstrings) will refer
to MATLAB®, a registered trademark of The MathWorks, Inc.
"""
# #Импорт
# import psycopg2
# import pandas as pd
# import seaborn as sns
# import matplotlib.pyplot as plt
# from sklearn.preprocessing import StandardScaler
# from sklearn.cluster import KMeans
# import scipy.stats as stats
# from scipy.stats import skew
# import numpy as np
#
# #Подключение к БД
# try:
#     conn = psycopg2.connect(
#         dbname = 'table_name',
#         user='postgres',
#         password='6dead6add',
#         host='localhost',
#         port='5432'
#     )
#
#     cur = conn.cursor()
#     conn.commit()
#     print('Подключение успешно')
#
# except Exception as e:
#     print(f'Ваша ошибка {e}')
#
#
# # Функция для содержания таблиц в актулаьном состоянии
# def update_database():
#     # Загрузка новых данных
#     new_stations_df = pd.read_csv('new_stations.csv', sep=';')
#     new_trips_df = pd.read_csv('new_trips.csv', sep=';')
#
#     # Обновление таблиц в базе данных
#     for index, row in new_stations_df.iterrows():
#         cur.execute("""
#             INSERT INTO station(station_id, station_name, locations, capacity)
#             VALUES (%s, %s, %s, %s)
#             ON CONFLICT (station_id) DO UPDATE
#             SET station_name = EXCLUDED.station_name,
#                 locations = EXCLUDED.locations,
#                 capacity = EXCLUDED.capacity;
#         """, (row['station_id'], row['station_name'], row['locations'], row['capacity']))
#
#     for index, row in new_trips_df.iterrows():
#         cur.execute("""
#             INSERT INTO trips(trip_id, train_id, station_from_id, station_to_id, departure_time, arrival_time, passengers_count)
#             VALUES (%s, %s, %s, %s, %s, %s, %s)
#             ON CONFLICT (trip_id) DO UPDATE
#             SET train_id = EXCLUDED.train_id,
#                 station_from_id = EXCLUDED.station_from_id,
#                 station_to_id = EXCLUDED.station_to_id,
#                 departure_time = EXCLUDED.departure_time,
#                 arrival_time = EXCLUDED.arrival_time,
#                 passengers_count = EXCLUDED.passengers_count;
#         """, (row['trip_id'], row['train_id'], row['station_from_id'], row['station_to_id'], row['departure_time'],
#               row['arrival_time'], row['passengers_count']))
#
#     conn.commit()
#     print("База данных успешно обновлена.")
#
# #Загрузкка CSV
# stations_df = pd.read_csv('stations.csv', sep=';')
# trains_df = pd.read_csv('trains.csv', sep=';')
# passengers_df = pd.read_csv('passengers.csv', sep=';')
# trips_df = pd.read_csv('trips.csv', sep=';')
# equipment_df = pd.read_csv('equipment.csv', sep=';')
# #Для каждого атрибута присутствует информация о количестве пустых значений
# print(stations_df.isnull().sum())
# print(trains_df.isnull().sum())
# print(passengers_df.isnull().sum())
# print(trips_df.isnull().sum())
# print(equipment_df.isnull().sum())
#
# # Загруска данных CSV в бдшку
# try:
#     for index, row in stations_df.iterrows():
#         cur.execute("""
#             INSERT INTO station(station_id, station_name, locations, capacity)
#             VALUES (%s, %s, %s, %s);
#         """, (row['station_id'], row['station_name'], row['locations'], row['capacity']))
#
#     for index, row in trains_df.iterrows():
#         cur.execute("""
#             INSERT INTO trains(trains_id, train_number, capacity)
#             VALUES (%s, %s, %s);
#         """, (row['trains_id'], row['train_number'], row['capacity']))
#
#     for index, row in passengers_df.iterrows():
#         cur.execute("""
#             INSERT INTO passengers(passanger_id, name_passengers, age)
#             VALUES (%s, %s, %s);
#         """, (row['passanger_id'], row['name_passengers'], row['age']))
#     for index, row in trips_df.iterrows():
#         cur.execute("""
#             INSERT INTO trips(trip_id, train_id, station_from_id, station_to_id, departure_time, arrival_time, passengers_count)
#             VALUES (%s, %s, %s, %s, %s, %s, %s);
#         """, (row['trip_id'], row['train_id'], row['station_from_id'], row['station_to_id'], row['departure_time'],
#               row['arrival_time'], row['passengers_count']))
#     for index, row in equipment_df.iterrows():
#         cur.execute("""
#             INSERT INTO equipment(equipment_id, station_id, equipment_type, direction, count)
#             VALUES (%s, %s, %s, %s, %s);
#         """, (row['equipment_id'], row['station_id'], row['equipment_type'], row['direction'], row['count']))
#     conn.commit()
# except Exception as e:
#     print(e)
#
# #Проверка работы
# query = pd.read_sql('select * from equipment', conn)
# query
#
#
# #Преобразование дат
# trips_df['departure_time'] = pd.to_datetime(trips_df['departure_time'], format='%d.%m.%Y %H:%M')
# trips_df['arrival_time'] = pd.to_datetime(trips_df['arrival_time'], format='%d.%m.%Y %H:%M')
# trips_df['departure_unix'] = trips_df['departure_time'].astype('int64') / 10**9
# trips_df['arrival_unix'] = trips_df['arrival_time'].astype('int64') / 10**9
#
#
# #Вычисление корреляции
# corr = trips_df[['train_id', 'station_from_id', 'station_to_id', 'passengers_count', 'departure_unix', 'arrival_unix']].corr()
# sns.heatmap(corr, annot=True, cmap='coolwarm')
# plt.show()
#
# #Нормализация данных
# scaler = StandardScaler()
# trips_scaled = scaler.fit_transform(trips_df[['train_id', 'station_from_id', 'station_to_id', 'passengers_count', 'departure_unix', 'arrival_unix']])
#
# #Кластеризация
# kmeans = KMeans(n_clusters=3)
# trips_df['cluster'] = kmeans.fit_predict(trips_scaled)
#
# #Визуализация кластеров
# sns.scatterplot(x='departure_unix', y='passengers_count', hue='cluster', data=trips_df)
# plt.show()
#
# #Графики для stations_df['capacity']
# #Гистограмма
# sns.histplot(stations_df['capacity'], kde=True)
# plt.title('Распределение пропускной спообной станций')
# plt.show()
# # Q-Q plot
# stats.probplot(stations_df['capacity'], dist="norm", plot=plt)
# plt.title('Q-Q plot для пропускной способносности станций')
# plt.show()
# #Тест Шапиро-Уилка
# stat, p = stats.shapiro(stations_df['capacity'])
# print(f'Тест Шапиро-Уилка: статистика - {stat}, р-значение = {p}')
# if p > 0.05:
#     print('Распределение нормальное')
# else:
#     print('Распределение не нормальное')
# #Построение плотности распределения
# density = stats.gaussian_kde(stations_df['capacity'])
# x = np.linspace(min(stations_df['capacity']), max(stations_df['capacity']), 1000) # Создаем диапазон значений для построения кривой
# y = density(x) # Рассчитываем значения плотности для каждого x
#
# #Построение графика
# fig, ax = plt.subplots(figsize=(12, 6))
# ax.plot(x, y, label='Плотность распределения')
# ax.set_xlabel('Capacity')
# ax.set_ylabel('Density')
# ax.legend()
# plt.title('Плотность распределения значений Capacity')
# plt.show()
#
# #Графики для trains_df['capacity']
# #Гистограмма
# sns.histplot(trains_df['capacity'], kde=True)
# plt.title('Распределение пропускной спообной станций')
# plt.show()
#
# stats.probplot(trains_df['capacity'], dist="norm", plot=plt)
# plt.title('Q-Q plot для пропускной способносности станций')
# plt.show()
#
# stat, p = stats.shapiro(trains_df['capacity'])
# print(f'Тест Шапиро-Уилка: статистика - {stat}, р-значение = {p}')
# if p > 0.05:
#     print('Распределение нормальное')
# else:
#     print('Распределение не нормальное')
#
# #Построение плотности распределения
# density = stats.gaussian_kde(trains_df['capacity'])
# x = np.linspace(min(trains_df['capacity']), max(trains_df['capacity']), 1000) # Создаем диапазон значений для построения кривой
# y = density(x) # Рассчитываем значения плотности для каждого x
#
# #Построение графика
# fig, ax = plt.subplots(figsize=(12, 6))
# ax.plot(x, y, label='Плотность распределения')
# ax.set_xlabel('Capacity')
# ax.set_ylabel('Density')
# ax.legend()
# plt.title('Плотность распределения значений Capacity')
# plt.show()
#
# #Графики для passengers_df['age']
# #Гистограмма
# sns.histplot(passengers_df['age'], kde=True)
# plt.title('Распределение пропускной спообной станций')
# plt.show()
#
# stats.probplot(passengers_df['age'], dist="norm", plot=plt)
# plt.title('Q-Q plot для пропускной способносности станций')
# plt.show()
#
# stat, p = stats.shapiro(passengers_df['age'])
# print(f'Тест Шапиро-Уилка: статистика - {stat}, р-значение = {p}')
# if p > 0.05:
#     print('Распределение нормальное')
# else:
#     print('Распределение не нормальное')
#
# #Построение плотности распределения
# density = stats.gaussian_kde(passengers_df['age'])
# x = np.linspace(min(passengers_df['age']), max(passengers_df['age']), 1000) # Создаем диапазон значений для построения кривой
# y = density(x) # Рассчитываем значения плотности для каждого x
#
# #Построение графика
# fig, ax = plt.subplots(figsize=(12, 6))
# ax.plot(x, y, label='Плотность распределения')
# ax.set_xlabel('age')
# ax.set_ylabel('Density')
# ax.legend()
# plt.title('Плотность распределения значений age')
# plt.show()
#
# #Графики для trips_df['passengers_count']
# #Гистограмма
# sns.histplot(trips_df['passengers_count'], kde=True)
# plt.title('Распределение пропускной способносности станций')
# plt.show()
#
# stats.probplot(trips_df['passengers_count'], dist="norm", plot=plt)
# plt.title('Q-Q plot для пропускной способносности станций')
# plt.show()
#
# stat, p = stats.shapiro(trips_df['passengers_count'])
# print(f'Тест Шапиро-Уилка: статистика - {stat}, р-значение = {p}')
# if p > 0.05:
#     print('Распределение нормальное')
# else:
#     print('Распределение не нормальное')
#
# #Построение плотности распределения
# density = stats.gaussian_kde(trips_df['passengers_count'])
# x = np.linspace(min(trips_df['passengers_count']), max(trips_df['passengers_count']), 1000) # Создаем диапазон значений для построения кривой
# y = density(x) # Рассчитываем значения плотности для каждого x
#
# #Построение графика
# fig, ax = plt.subplots(figsize=(12, 6))
# ax.plot(x, y, label='Плотность распределения')
# ax.set_xlabel('passengers_count')
# ax.set_ylabel('Density')
# ax.legend()
# plt.title('Плотность распределения значений passengers_count')
# plt.show()
#
# #Скошенность для stations_df['capacity']
# skewneas = skew(stations_df['capacity'])
# print(f'Скошенность распределения: {skewneas}')
#
# if skewneas > 0:
#     print('Распределение скошено вправо')
# elif skewneas < 0:
#     print('Распределение скошено влево')
# else:
#     print('Распределение симметрично')
#
# #Скошенность для trains_df['capacity']
# skewneas = skew(trains_df['capacity'])
# print(f'Скошенность распределения: {skewneas}')
#
# if skewneas > 0:
#     print('Распределение скошено вправо')
# elif skewneas < 0:
#     print('Распределение скошено влево')
# else:
#     print('Распределение симметрично')
#
# #Скошенность для passengers_df['age']
# skewneas = skew(passengers_df['age'])
# print(f'Скошенность распределения: {skewneas}')
#
# if skewneas > 0:
#     print('Распределение скошено вправо')
# elif skewneas < 0:
#     print('Распределение скошено влево')
# else:
#     print('Распределение симметрично')
#
# #Скошенность для trips_df['passengers_count']
# skewneas = skew(trips_df['passengers_count'])
# print(f'Скошенность распределения: {skewneas}')
#
# if skewneas > 0:
#     print('Распределение скошено вправо')
# elif skewneas < 0:
#     print('Распределение скошено влево')
# else:
#     print('Распределение симметрично')
#
# #Общая загруженность станции
# station_load = pd.read_sql("SELECT station_from_id, sum(passengers_count) AS total_passengers FROM trips GROUP BY station_from_id", conn)
# print(station_load)
#
# stations_capacity = pd.read_sql("SELECT station_id, capacity FROM station;", conn)
# merged_data = station_load.merge(stations_capacity, left_on="station_from_id", right_on="station_id")
# merged_data["load_percentage"] = (merged_data["total_passengers"] / merged_data["capacity"]) * 100
# print(merged_data[["station_from_id", "total_passengers", "capacity", "load_percentage"]])
#
# #Количественные характеристики
# equipment_count = pd.read_sql("SELECT station_id, COUNT(*) as equipment_count FROM equipment GROUP BY station_id;", conn)
# print(equipment_count)
#
# #Временные интервалы поездки
# trips_df['duration'] = (trips_df['arrival_time'] - trips_df['departure_time']).dt.total_seconds() / 60
# print(trips_df['duration'].describe())
#
# #Продолжительность поездки
# avarege_duration = trips_df['duration'].mean()
# print(f'Средняя продолжительность поездки: {avarege_duration} минут')
#
# #Добавление дополнительных характеристик
# try:
#   final_dataset = trips_df.merge(stations_capacity, left_on='station_from_id', right_on='station_id')
#   final_dataset['load_percentage'] = (final_dataset['passengers_count'] / final_dataset['capacity']) * 100
#
#   #Сохранение итогового набора данных
#   final_dataset.to_csv('final_dataset.csv', index=False)
#   print('Датасет создался успешно')
# except Exception as e:
#   print(f'Ошибка: {e}')

"""
Occasionally the internal documentation (python docstrings) will refer
to MATLAB®, a registered trademark of The MathWorks, Inc.
"""

# # Импорт библиотек
# import psycopg2
# import pandas as pd
# import dash
# from dash import dcc, html
# from dash.dependencies import Input, Output
# import plotly.express as px
# from sklearn.cluster import KMeans, DBSCAN, AgglomerativeClustering
# from sklearn.preprocessing import StandardScaler
# from sklearn.metrics import silhouette_score
#
# # Подключение к БД
# def connect_to_db():
#     try:
#         conn = psycopg2.connect(
#             dbname='table_name',
#             user='postgres',
#             password='6dead6add',
#             host='localhost',
#             port='5432'
#         )
#         return conn
#     except Exception as e:
#         print(f"Ошибка подключения к базе данных: {e}")
#         return None
#
# # Загруженность станции в процентах относительно максимальной загруженности
# def calculate_load_percentage(conn, station_id, start_time, end_time):
#     query = """
#         SELECT
#             station_from_id AS station_id,
#             COALESCE(SUM(passengers_count) * 100.0 / MAX(s.capacity), 0) AS load_percentage
#         FROM trips t
#         JOIN station s ON t.station_from_id = s.station_id
#         WHERE
#             EXTRACT(HOUR FROM departure_time) BETWEEN %s AND %s
#             AND station_from_id = %s
#         GROUP BY station_from_id;
#     """
#     return pd.read_sql(query, conn, params=(start_time, end_time, station_id))
#
# # Реальная пропускная способность станций
# def calculate_real_capacity(conn, station_id, start_time, end_time):
#     query = """
#         SELECT
#             station_from_id AS station_id,
#             COALESCE(SUM(passengers_count) * 0.8, 0) AS real_capacity
#         FROM trips
#         WHERE
#             EXTRACT(HOUR FROM departure_time) BETWEEN %s AND %s
#             AND station_from_id = %s
#         GROUP BY station_from_id;
#     """
#     return pd.read_sql(query, conn, params=(start_time, end_time, station_id))
#
# # Топ загруженных станций
# def calculate_top_stations(conn, start_time, end_time):
#     query = """
#         SELECT
#             station_from_id AS station_id,
#             COALESCE(SUM(passengers_count), 0) AS total_passengers
#         FROM trips
#         WHERE
#             EXTRACT(HOUR FROM departure_time) BETWEEN %s AND %s
#         GROUP BY station_from_id
#         ORDER BY total_passengers DESC
#     """
#     return pd.read_sql(query, conn, params=(start_time, end_time))
#
#
# # Среднее количество пассажиров на станциях
# def calculate_avg_passengers(conn, start_time, end_time):
#     query = """
#         SELECT
#             COALESCE(AVG(total_passengers), 0) AS avg_passengers
#         FROM (
#             SELECT
#                 station_from_id,
#                 COALESCE(SUM(passengers_count), 0) AS total_passengers
#             FROM trips
#             WHERE
#                 EXTRACT(HOUR FROM departure_time) BETWEEN %s AND %s
#             GROUP BY station_from_id
#         ) AS station_loads;
#     """
#     return pd.read_sql(query, conn, params=(start_time, end_time))
#
# # Количество станций без инфраструктуры для маломобильных граждан
# def calculate_stations_without_ramp(conn):
#     query = """
#         SELECT
#             COALESCE(COUNT(DISTINCT station_id), 0) AS stations_without_ramp
#         FROM equipment
#         WHERE
#             equipment_type != 'wheelchair_ramp';
#     """
#     return pd.read_sql(query, conn)
#
# # Функция для подготовки данных для кластеризации
# def prepare_clustering_data(conn):
#     query = """
#         SELECT
#             EXTRACT(HOUR FROM departure_time) AS departure_hour,
#             EXTRACT(HOUR FROM arrival_time) AS arrival_hour,
#             passengers_count,
#             EXTRACT(EPOCH FROM (arrival_time - departure_time)) / 60 AS duration
#         FROM trips;
#     """
#     trips_df = pd.read_sql(query, conn)
#     return trips_df
#
#
# # Функция для кластеризации данных
# def perform_clustering(data):
#     # Нормализация данных
#     scaler = StandardScaler()
#     scaled_data = scaler.fit_transform(data)
#
#     # Кластеризация K-Means
#     kmeans = KMeans(n_clusters=3, random_state=42)
#     kmeans_clusters = kmeans.fit_predict(scaled_data)
#     kmeans_score = silhouette_score(scaled_data, kmeans_clusters)
#
#     # Кластеризация DBSCAN
#     dbscan = DBSCAN(eps=0.5, min_samples=5)
#     dbscan_clusters = dbscan.fit_predict(scaled_data)
#     if len(set(dbscan_clusters)) > 1:  # DBSCAN может вернуть только один кластер
#         dbscan_score = silhouette_score(scaled_data, dbscan_clusters)
#     else:
#         dbscan_score = -1  # Невозможно вычислить
#
#     # Кластеризация Agglomerative Clustering
#     agglo = AgglomerativeClustering(n_clusters=3)
#     agglo_clusters = agglo.fit_predict(scaled_data)
#     agglo_score = silhouette_score(scaled_data, agglo_clusters)
#
#     # Сравнение алгоритмов
#     scores = {
#         "K-Means": kmeans_score,
#         "DBSCAN": dbscan_score,
#         "Agglomerative": agglo_score
#     }
#     best_algorithm = max(scores, key=scores.get)
#
#     return kmeans_clusters, dbscan_clusters, agglo_clusters, scores, best_algorithm
#
#
# # Функция для наименования кластеров
# def name_clusters(data, clusters):
#     data['cluster'] = clusters
#
#     # Вычисляем средние значения для каждого кластера
#     cluster_stats = data.groupby('cluster').agg({
#         'passengers_count': 'mean',
#         'duration': 'mean'
#     }).reset_index()
#
#     # Присваиваем имена кластерам
#     cluster_names = {}
#     for _, row in cluster_stats.iterrows():
#         if row['passengers_count'] < 50 and row['duration'] < 30:
#             cluster_names[row['cluster']] = "Оптимальные"
#         elif row['passengers_count'] > 100 and row['duration'] > 60:
#             cluster_names[row['cluster']] = "Нерекомендуемые"
#         else:
#             cluster_names[row['cluster']] = "Нежелательные"
#
#     # Применяем имена к данным
#     data['cluster_name'] = data['cluster'].map(cluster_names)
#     return data
#
# # Функция для визуализации кластеров
# def visualize_clusters(data, clusters):
#     data['кластер'] = clusters
#     fig = px.scatter(
#         data,
#         x='departure_hour',
#         y='passengers_count',
#         color='кластер',
#         title='Кластеризация поездок',
#         labels={'departure_hour': 'Час отправления', 'passengers_count': 'Количество пассажиров'}
#     )
#     return fig
#
#
# # Функция для построения графика Silhouette Score
# def plot_silhouette_scores(data, max_clusters=10):
#     scaler = StandardScaler()
#     scaled_data = scaler.fit_transform(data)
#
#     silhouette_scores = []
#     n_samples = len(data)
#
#     # Убедимся, что количество кластеров меньше количества образцов
#     max_clusters = min(max_clusters, n_samples - 1)
#
#     for n_clusters in range(2, max_clusters + 1):
#         kmeans = KMeans(n_clusters=n_clusters, random_state=42)
#         clusters = kmeans.fit_predict(scaled_data)
#         score = silhouette_score(scaled_data, clusters)
#         silhouette_scores.append(score)
#
#     # Создаем график
#     fig = px.line(
#         x=list(range(2, max_clusters + 1)),
#         y=silhouette_scores,
#         labels={'x': 'Number of Clusters', 'y': 'Silhouette Score'},
#         title='Silhouette Score for Different Number of Clusters'
#     )
#
#     return fig
#
# # Создание дешборда
# app = dash.Dash(__name__)
#
# # Создание макета
# app.layout = html.Div([
#     html.H1("Аналитический дашборд для пассажирских перевозок", style={'textAlign': 'center', 'marginBottom': '20px'}),
#
#     # Выбор станции и временного интервала
#     html.Div([
#         # Выбор станции
#         html.Div([
#             html.Label("Выберите станцию:", style={'marginRight': '10px'}),
#             dcc.Dropdown(
#                 id='station-dropdown',
#                 options=[],
#                 value=None,
#                 style={'width': '200px', 'marginRight': '20px'}
#             )
#         ], style={'display': 'inline-block', 'marginRight': '40px'}),
#
#         # Выбор временного интервала
#         html.Div([
#             html.Label("Выберите временной интервал:", style={'marginRight': '10px'}),
#             dcc.RangeSlider(
#                 id='time-slider',
#                 min=0,
#                 max=24,
#                 step=1,
#                 value=[8, 18],
#                 marks={i: f"{i}:00" for i in range(0, 25, 2)},
#                 tooltip={"placement": "bottom", "always_visible": True}
#             )
#         ], style={'display': 'inline-block', 'width': '60%'})
#     ], style={'marginBottom': '20px', 'textAlign': 'center'}),
#
#     # График загруженности станции и таблица с метриками
#     html.Div([
#         # График загруженности станции
#         html.Div(
#             dcc.Graph(id='station-load-graph', style={'height': '350px'}),
#             style={'width': '50%', 'display': 'inline-block'}
#         ),
#         # Таблица с ключевыми метриками
#         html.Div(
#             id='metrics-table',
#             style={'width': '50%', 'display': 'inline-block', 'paddingLeft': '20px'}
#         )
#     ], style={'display': 'flex', 'alignItems': 'center', 'justifyContent': 'center', 'marginBottom': '20px'}),
#
#     # Три графика в одной строке: топ-5, кластеризация, оценка
#     html.Div([
#         # График топ-5 самых загруженных станций
#         html.Div(
#             dcc.Graph(id='top-stations-graph', style={'height': '350px'}),
#             style={'width': '33%', 'display': 'inline-block'}
#         ),
#         # График кластеризации
#         html.Div(
#             dcc.Graph(id='clustering-graph', style={'height': '350px'}),
#             style={'width': '33%', 'display': 'inline-block'}
#         ),
#         # График Silhouette Score
#         html.Div(
#             dcc.Graph(id='silhouette-graph', style={'height': '350px'}),
#             style={'width': '33%', 'display': 'inline-block'}
#         )
#     ], style={'display': 'flex', 'alignItems': 'center', 'justifyContent': 'center'})
# ])
#
#
# # Callback для обработки данных
# @app.callback(
#     [Output('station-load-graph', 'figure'),
#      Output('top-stations-graph', 'figure'),
#      Output('metrics-table', 'children')],
#     [Input('station-dropdown', 'value'),
#      Input('time-slider', 'value')]
# )
# def update_dashboard(selected_station, time_range):
#     conn = connect_to_db()
#     if not conn:
#         return {}, {}, html.Div("Ошибка подключения к базе данных")
#
#     # Если станция не выбрана, показываем сообщение
#     if selected_station is None:
#         return {}, {}, html.Div("Выберите станцию для отображения данных")
#
#     start_time, end_time = time_range
#
#     # Вычисляем метрики
#     load_percentage = calculate_load_percentage(conn, selected_station, start_time, end_time)
#     real_capacity = calculate_real_capacity(conn, selected_station, start_time, end_time)
#     top_stations = calculate_top_stations(conn, start_time, end_time)
#     avg_passengers = calculate_avg_passengers(conn, start_time, end_time)
#     stations_without_ramp = calculate_stations_without_ramp(conn)
#
#     # Проверяем, есть ли данные
#     if load_percentage.empty or real_capacity.empty or avg_passengers.empty or stations_without_ramp.empty:
#         return {}, {}, html.Div("Нет данных для выбранной станции и временного интервала")
#
#     # Создаем график загруженности станции
#     load_fig = px.bar(
#         x=['Загруженность'],
#         y=[load_percentage['load_percentage'].values[0]],
#         labels={'x': 'Метрика', 'y': 'Загруженность (%)'},
#         title=f"Загруженность станции {selected_station} с {start_time}:00 до {end_time}:00"
#     )
#
#     # Создаем график топ-5 самых загруженных станций
#     top_stations_fig = px.bar(
#         top_stations,
#         x='station_id',
#         y='total_passengers',
#         labels={'x': 'Станция', 'y': 'Количество пассажиров'},
#         title="Топ-5 самых загруженных станций"
#     )
#
#     # Создаем таблицу с ключевыми метриками
#     metrics_table = html.Table([
#         html.Tr([html.Th("Метрика"), html.Th("Значение")]),
#         html.Tr([html.Td("Загруженность (%)"), html.Td(f"{load_percentage['load_percentage'].values[0]:.2f}")]),
#         html.Tr(
#             [html.Td("Реальная пропускная способность"), html.Td(f"{real_capacity['real_capacity'].values[0]:.2f}")]),
#         html.Tr(
#             [html.Td("Среднее количество пассажиров"), html.Td(f"{avg_passengers['avg_passengers'].values[0]:.2f}")]),
#         html.Tr([html.Td("Станций без инфраструктуры для маломобильных граждан"),
#                  html.Td(stations_without_ramp['stations_without_ramp'].values[0])])
#     ])
#
#     conn.close()
#     return load_fig, top_stations_fig, metrics_table
#
#
# # Callback для заполнения выпадающего списка
# @app.callback(
#     Output('station-dropdown', 'options'),
#     [Input('time-slider', 'value')]
# )
# def update_station_dropdown(time_range):
#     conn = connect_to_db()
#     if not conn:
#         return []
#
#     # Загружаем данные о станциях
#     stations_df = pd.read_sql("SELECT * FROM station;", conn)
#
#     # Формируем список опций
#     options = [{'label': row['station_name'], 'value': row['station_id']} for _, row in stations_df.iterrows()]
#
#     conn.close()
#     return options
#
#
# # Callback для обновления кластеризации и Silhouette Score
# @app.callback(
#     [Output('clustering-graph', 'figure'),
#      Output('silhouette-graph', 'figure')],
#     [Input('time-slider', 'value')]
# )
# def update_clustering(time_range):
#     conn = connect_to_db()
#     if not conn:
#         return {}, {}
#
#     # Подготовка данных
#     data = prepare_clustering_data(conn)
#
#     # Кластеризация
#     kmeans_clusters, dbscan_clusters, agglo_clusters, scores, best_algorithm = perform_clustering(data)
#
#     # Визуализация всех кластеров
#     fig = visualize_clusters(data, kmeans_clusters)
#
#     # Визуализация Silhouette Score
#     silhouette_fig = plot_silhouette_scores(data)
#
#     # Вывод лучшего алгоритма
#     print(f"Лучший алгоритм кластеризации: {best_algorithm} с Silhouette Score = {scores[best_algorithm]:.2f}")
#
#     conn.close()
#     return fig, silhouette_fig
# # Запуск приложения
# if __name__ == '__main__':
#     app.run_server(debug=True)

"""
Occasionally the internal documentation (python docstrings) will refer
to MATLAB®, a registered trademark of The MathWorks, Inc.
"""

# # Импорт библиотек
# import pandas as pd
# import numpy as np
# from sklearn.cluster import KMeans, DBSCAN, AgglomerativeClustering, MiniBatchKMeans
# from sklearn.preprocessing import StandardScaler
# from sklearn.model_selection import train_test_split
# from sklearn.metrics import silhouette_score, davies_bouldin_score, calinski_harabasz_score
# from imblearn.over_sampling import SMOTE
# from prophet import Prophet
# import joblib
# import matplotlib.pyplot as plt
# import logging
# from sklearn.linear_model import LinearRegression
# from sklearn.ensemble import RandomForestRegressor
# from sklearn.metrics import mean_absolute_error, mean_squared_error
# import psycopg2
#
# # Настройка логирования
# logging.basicConfig(level=logging.INFO, format='%(asctime)s - %(levelname)s - %(message)s')
#
#
# # Подключение к БД
# def connect_to_db():
#     try:
#         conn = psycopg2.connect(
#             dbname='table_name',
#             user='postgres',
#             password='6dead6add',
#             host='localhost',
#             port='5432'
#         )
#         return conn
#     except Exception as e:
#         print(f"Ошибка подключения к базе данных: {e}")
#         return None
#
#
# # Загрузка данных из базы данных
# def load_data(conn):
#     query = """
#         SELECT
#             station_from_id AS station_id,
#             departure_time,
#             arrival_time,
#             passengers_count
#         FROM trips;
#     """
#     data = pd.read_sql(query, conn)
#     logging.info(f"Загружено {len(data)} записей из базы данных.")
#     return data
#
#
# # Подготовка данных для кластеризации
# def prepare_data_for_clustering(data):
#     # Преобразуем departure_time и arrival_time в datetime
#     data['departure_time'] = pd.to_datetime(data['departure_time'])
#     data['arrival_time'] = pd.to_datetime(data['arrival_time'])
#
#     # Извлекаем час отправления и прибытия
#     data['departure_hour'] = data['departure_time'].dt.hour
#     data['arrival_hour'] = data['arrival_time'].dt.hour
#
#     # Вычисляем продолжительность поездки в минутах
#     data['duration'] = (data['arrival_time'] - data['departure_time']).dt.total_seconds() / 60
#
#     # Оставляем только нужные столбцы
#     data = data[['station_id', 'departure_hour', 'arrival_hour', 'passengers_count', 'duration']]
#     logging.info("Данные подготовлены для кластеризации.")
#     return data
#
#
# # Проверка сбалансированности данных и устранение дисбаланса
# def balance_data(data):
#     # Проверяем сбалансированность по passengers_count (пример)
#     if 'passengers_count' in data.columns:
#         class_counts = data['passengers_count'].value_counts()
#         logging.info(f"Распределение классов до балансировки:\n{class_counts}")
#
#         if class_counts.min() / class_counts.max() < 0.5:
#             logging.info("Данные несбалансированы. Применяем SMOTE.")
#             X = data[['departure_hour', 'arrival_hour', 'passengers_count', 'duration']]
#             y = data['passengers_count']
#             smote = SMOTE(random_state=42)
#             X_resampled, y_resampled = smote.fit_resample(X, y)
#             data = pd.concat([pd.DataFrame(X_resampled), pd.Series(y_resampled, name='passengers_count')], axis=1)
#             logging.info(f"Распределение классов после балансировки:\n{data['passengers_count'].value_counts()}")
#         else:
#             logging.info("Данные сбалансированы.")
#     else:
#         logging.warning("Целевой признак для балансировки не найден.")
#     return data
#
#
# # Кластеризация данных
# def perform_clustering(data):
#     scaler = StandardScaler()
#     scaled_data = scaler.fit_transform(data[['departure_hour', 'arrival_hour', 'passengers_count', 'duration']])
#
#     # KMeans
#     kmeans = KMeans(n_clusters=3, random_state=42)
#     kmeans_clusters = kmeans.fit_predict(scaled_data)
#     kmeans_silhouette = silhouette_score(scaled_data, kmeans_clusters)
#     kmeans_davies = davies_bouldin_score(scaled_data, kmeans_clusters)
#     kmeans_calinski = calinski_harabasz_score(scaled_data, kmeans_clusters)
#
#     # DBSCAN
#     dbscan = DBSCAN(eps=0.5, min_samples=5)
#     dbscan_clusters = dbscan.fit_predict(scaled_data)
#     dbscan_silhouette = silhouette_score(scaled_data, dbscan_clusters) if len(set(dbscan_clusters)) > 1 else -1
#     dbscan_davies = davies_bouldin_score(scaled_data, dbscan_clusters) if len(set(dbscan_clusters)) > 1 else -1
#     dbscan_calinski = calinski_harabasz_score(scaled_data, dbscan_clusters) if len(set(dbscan_clusters)) > 1 else -1
#
#     # Agglomerative Clustering
#     agglo = AgglomerativeClustering(n_clusters=3)
#     agglo_clusters = agglo.fit_predict(scaled_data)
#     agglo_silhouette = silhouette_score(scaled_data, agglo_clusters)
#     agglo_davies = davies_bouldin_score(scaled_data, agglo_clusters)
#     agglo_calinski = calinski_harabasz_score(scaled_data, agglo_clusters)
#
#     # Выбор лучшей модели
#     scores = {
#         "K-Means": {"Silhouette": kmeans_silhouette, "Davies-Bouldin": kmeans_davies,
#                     "Calinski-Harabasz": kmeans_calinski},
#         "DBSCAN": {"Silhouette": dbscan_silhouette, "Davies-Bouldin": dbscan_davies,
#                    "Calinski-Harabasz": dbscan_calinski},
#         "Agglomerative": {"Silhouette": agglo_silhouette, "Davies-Bouldin": agglo_davies,
#                           "Calinski-Harabasz": agglo_calinski}
#     }
#     best_algorithm = max(scores, key=lambda x: scores[x]["Silhouette"])
#     logging.info(
#         f"Лучший алгоритм кластеризации: {best_algorithm} с Silhouette Score = {scores[best_algorithm]['Silhouette']:.2f}")
#
#     # Сохранение лучшей модели
#     if best_algorithm == "K-Means":
#         joblib.dump(kmeans, 'best_model.pkl')
#     elif best_algorithm == "DBSCAN":
#         joblib.dump(dbscan, 'best_model.pkl')
#     else:
#         joblib.dump(agglo, 'best_model.pkl')
#     logging.info("Лучшая модель сохранена в файл 'best_model.pkl'.")
#
#     # Добавляем кластеры в данные
#     data['cluster'] = kmeans_clusters
#     return data, scores, best_algorithm
#
#
# # Непрерывное обучение модели
# def update_model(conn, model_path='best_model.pkl'):
#     try:
#         model = joblib.load(model_path)
#         logging.info("Текущая модель загружена.")
#     except FileNotFoundError:
#         logging.error("Файл модели не найден. Сначала обучите модель.")
#         return
#
#     # Загрузка новых данных
#     new_data = load_data(conn)
#     if not new_data.empty:
#         # Подготовка новых данных
#         new_data = prepare_data_for_clustering(new_data)
#
#         # Нормализация данных
#         scaler = StandardScaler()
#         new_X = new_data[['departure_hour', 'arrival_hour', 'passengers_count', 'duration']]
#         new_X_scaled = scaler.fit_transform(new_X)
#
#         # Оценка исходной модели
#         if isinstance(model, AgglomerativeClustering):
#             original_clusters = model.fit_predict(new_X_scaled)  # Используем fit_predict для AgglomerativeClustering
#         else:
#             original_clusters = model.predict(new_X_scaled)  # Для KMeans и других моделей
#         original_silhouette = silhouette_score(new_X_scaled, original_clusters)
#         logging.info(f"Silhouette Score исходной модели: {original_silhouette:.2f}")
#
#         # Дообучение модели (используем MiniBatchKMeans для непрерывного обучения)
#         if isinstance(model, KMeans):
#             model = MiniBatchKMeans(n_clusters=3, random_state=42)
#             model.partial_fit(new_X_scaled)
#             logging.info("Модель дообучена с использованием MiniBatchKMeans.")
#         else:
#             logging.warning("Модель не поддерживает дообучение. Обучаем с нуля.")
#             model.fit(new_X_scaled)
#
#         # Оценка дообученной модели
#         if isinstance(model, AgglomerativeClustering):
#             updated_clusters = model.fit_predict(new_X_scaled)  # Используем fit_predict для AgglomerativeClustering
#         else:
#             updated_clusters = model.predict(new_X_scaled)  # Для KMeans и других моделей
#         updated_silhouette = silhouette_score(new_X_scaled, updated_clusters)
#         logging.info(f"Silhouette Score дообученной модели: {updated_silhouette:.2f}")
#
#         # Сравнение моделей
#         if updated_silhouette > original_silhouette:
#             logging.info("Дообученная модель улучшила качество.")
#         else:
#             logging.info("Дообученная модель не улучшила качество.")
#
#         # Сохранение обновлённой модели
#         joblib.dump(model, 'updated_model.pkl')
#         logging.info("Модель успешно дообучена и сохранена в файл 'updated_model.pkl'.")
#     else:
#         logging.warning("Новых данных для обучения нет.")
#
#
# def evaluate_regression_models(data, station_id):
#     # Фильтруем данные для конкретной станции
#     station_data = data[data['station_id'] == station_id]
#
#     # Проверяем, достаточно ли данных для обучения
#     if len(station_data) < 2:
#         logging.warning(f"Недостаточно данных для станции {station_id}. Пропускаем.")
#         return {}, None  # Возвращаем пустой словарь и None для лучшей модели
#
#     # Подготовка данных
#     X = station_data[['departure_hour', 'arrival_hour', 'duration']]
#     y = station_data['passengers_count']
#
#     # Разделение на обучающую и тестовую выборки
#     X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.2, random_state=42)
#
#     # Модели
#     models = {
#         "Linear Regression": LinearRegression(),
#         "Random Forest": RandomForestRegressor(random_state=42),
#         "Prophet": Prophet()
#     }
#
#     # Оценка моделей
#     results = {}
#     for name, model in models.items():
#         if name == "Prophet":
#             # Подготовка данных для Prophet
#             prophet_data = station_data.rename(columns={'departure_time': 'ds', 'passengers_count': 'y'})
#             model.fit(prophet_data)
#             future = model.make_future_dataframe(periods=730)
#             forecast = model.predict(future)
#             y_pred = forecast['yhat'][-len(y_test):].values
#         else:
#             # Обучение и предсказание для других моделей
#             model.fit(X_train, y_train)
#             y_pred = model.predict(X_test)
#
#         # Оценка качества
#         mae = mean_absolute_error(y_test, y_pred)
#         mse = mean_squared_error(y_test, y_pred)
#         rmse = np.sqrt(mse)
#
#         results[name] = {"MAE": mae, "MSE": mse, "RMSE": rmse}
#         logging.info(f"{name}: MAE = {mae:.2f}, MSE = {mse:.2f}, RMSE = {rmse:.2f}")
#
#     # Выбор лучшей модели
#     best_model = min(results, key=lambda x: results[x]["MAE"])
#     logging.info(f"Лучшая модель: {best_model} с MAE = {results[best_model]['MAE']:.2f}")
#
#     return results, best_model
#
#
# # Визуализация прогноза
# def plot_forecast(forecast, station_id):
#     plt.figure(figsize=(12, 6))
#     plt.plot(forecast['ds'], forecast['yhat'], label='Прогноз')
#     plt.fill_between(forecast['ds'], forecast['yhat_lower'], forecast['yhat_upper'], alpha=0.2,
#                      label='Доверительный интервал')
#     plt.title(f'Прогноз загруженности станции {station_id} на 2 года вперёд')
#     plt.xlabel('Дата')
#     plt.ylabel('Количество пассажиров')
#     plt.legend()
#     plt.show()
#
#
# def forecast_station_load(data, station_id, periods=730):
#     """
#     Прогнозирует загруженность станции на определённый период времени с использованием Prophet.
#
#     Параметры:
#         data (pd.DataFrame): Исходные данные.
#         station_id (int): Идентификатор станции.
#         periods (int): Количество дней для прогноза (по умолчанию 730 дней).
#
#     Возвращает:
#         forecast (pd.DataFrame): Прогноз с доверительными интервалами.
#         model (Prophet): Обученная модель Prophet.
#     """
#     try:
#         # Фильтруем данные для конкретной станции
#         station_data = data[data['station_id'] == station_id]
#
#         # Проверяем, достаточно ли данных для обучения
#         if len(station_data) < 2:
#             logging.warning(f"Недостаточно данных для станции {station_id}. Пропускаем.")
#             return None, None
#
#         # Подготовка данных для Prophet
#         prophet_data = station_data.rename(columns={'departure_time': 'ds', 'passengers_count': 'y'})
#         prophet_data = prophet_data[['ds', 'y']].dropna()  # Убираем пропущенные значения
#
#         # Инициализация и обучение модели Prophet
#         model = Prophet()
#         model.fit(prophet_data)
#
#         # Создание данных для прогноза
#         future = model.make_future_dataframe(periods=periods)
#
#         # Прогнозирование
#         forecast = model.predict(future)
#
#         logging.info(f"Прогноз для станции {station_id} успешно выполнен.")
#         return forecast, model
#
#     except Exception as e:
#         logging.error(f"Ошибка при прогнозировании для станции {station_id}: {e}")
#         return None, None
#
#
# # Основной блок
# if __name__ == '__main__':
#     # Подключение к базе данных
#     conn = connect_to_db()
#     if conn:
#         # Загрузка данных
#         data = load_data(conn)
#
#         # Подготовка данных для кластеризации
#         clustering_data = prepare_data_for_clustering(data)
#
#         # Проверка сбалансированности данных
#         clustering_data = balance_data(clustering_data)
#
#         # Кластеризация данных
#         data, scores, best_algorithm = perform_clustering(clustering_data)
#
#         # Непрерывное обучение модели
#         update_model(conn)
#
#         # Прогнозирование для каждой станции
#         for station_id in data['station_id'].unique():
#             logging.info(f"Прогнозирование для станции {station_id}...")
#             results, best_model = evaluate_regression_models(data, station_id)
#
#             # Проверяем, есть ли результаты
#             if results:  # Если results не пустой
#                 logging.info(f"Лучшая модель для станции {station_id}: {best_model}")
#                 if best_model == "Prophet":
#                     forecast, model = forecast_station_load(data, station_id)
#                     if forecast is not None:
#                         plot_forecast(forecast, station_id)
#             else:
#                 logging.warning(f"Для станции {station_id} недостаточно данных для прогнозирования.")
#
#         # Закрытие соединения с базой данных
#         conn.close()

"""
Occasionally the internal documentation (python docstrings) will refer
to MATLAB®, a registered trademark of The MathWorks, Inc.
"""

# from fastapi import FastAPI, HTTPException
# from pydantic import BaseModel
# import joblib
# import pandas as pd
# from datetime import datetime
#
# # Загрузка модели и scaler
# model = joblib.load('best_model.pkl')
# scaler = joblib.load('scaler.pkl')
#
# # Создание FastAPI приложения
# app = FastAPI()
#
#
# # Модель для входных данных (Pydantic)
# class TripRequest(BaseModel):
#     trip_id: int
#     train_id: int
#     station_from_id: int
#     station_to_id: int
#     departure_time: str  # Время в формате "YYYY-MM-DD HH:MM:SS"
#     passengers_count: int
#
#
# class StationRequest(BaseModel):
#     station_id: int
#     start_time: str  # Время в формате "YYYY-MM-DD HH:MM:SS"
#     end_time: str    # Время в формате "YYYY-MM-DD HH:MM:SS"
#
#
# # Эндпоинт для корневого пути
# @app.get("/")
# def home():
#     return {"message": "API работает!"}
#
#
# # Эндпоинт для предсказания удобства поездки
# @app.post("/predict_trip_convenience")
# def predict_trip_convenience(trip: TripRequest):
#     try:
#         # Преобразуем время в Unix-время
#         departure_time = datetime.strptime(trip.departure_time, "%Y-%m-%d %H:%M:%S")
#         departure_unix = departure_time.timestamp()
#
#         # Создаем DataFrame с входными данными
#         input_data = pd.DataFrame({
#             'trip_id': [trip.trip_id],
#             'train_id': [trip.train_id],
#             'station_from_id': [trip.station_from_id],
#             'station_to_id': [trip.station_to_id],
#             'departure_unix': [departure_unix],
#             'passengers_count': [trip.passengers_count]
#         })
#
#         # Масштабируем данные
#         input_data_scaled = scaler.transform(input_data)
#
#         # Предсказываем кластер (удобство поездки)
#         cluster = model.predict(input_data_scaled)[0]
#
#         # Возвращаем результат
#         return {
#             "trip_id": trip.trip_id,
#             "convenience_cluster": int(cluster)
#         }
#
#     except Exception as e:
#         raise HTTPException(status_code=400, detail=str(e))
#
#
# # Эндпоинт для прогнозирования загруженности станций
# @app.post("/predict_station_load")
# def predict_station_load(station: StationRequest):
#     try:
#         # Здесь можно добавить логику для прогнозирования загруженности
#         # Например, использовать исторические данные или другую модель
#
#         # Временный пример
#         load_percentage = 75  # Пример значения загруженности
#
#         # Возвращаем результат
#         return {
#             "station_id": station.station_id,
#             "start_time": station.start_time,
#             "end_time": station.end_time,
#             "load_percentage": load_percentage
#         }
#
#     except Exception as e:
#         raise HTTPException(status_code=400, detail=str(e))
#
#
# # Запуск приложения
# if __name__ == "__main__":
#     import uvicorn
#     uvicorn.run(app, host="0.0.0.0", port=5000)
#
# curl -X POST "http://127.0.0.1:5000/predict_trip_convenience" \
# -H "Content-Type: application/json" \
# -d '{
#   "trip_id": 1,
#   "train_id": 1,
#   "station_from_id": 1,
#   "station_to_id": 2,
#   "departure_time": "2023-10-01 08:00:00",
#   "passengers_count": 150
# }'
#
#
# curl -X POST "http://127.0.0.1:5000/predict_station_load" \
# -H "Content-Type: application/json" \
# -d '{
#   "station_id": 1,
#   "start_time": "2023-10-01 08:00:00",
#   "end_time": "2023-10-01 09:00:00"
# }'
