# #Импорт
# import psycopg2
# import pandas as pd
# import seaborn as sns
# import matplotlib.pyplot as plt
# from sklearn.preprocessing import StandardScaler
# from sklearn.cluster import KMeans
# import scipy.stats as stats
# from scipy.stats import skew
# import numpy as np
#
# #Подключение к БД
# try:
#     conn = psycopg2.connect(
#         dbname = 'table_name',
#         user='postgres',
#         password='6dead6add',
#         host='localhost',
#         port='5432'
#     )
#
#     cur = conn.cursor()
#     conn.commit()
#     print('Подключение успешно')
#
# except Exception as e:
#     print(f'Ваша ошибка {e}')
#
#
# # Функция для содержания таблиц в актулаьном состоянии
# def update_database():
#     # Загрузка новых данных
#     new_stations_df = pd.read_csv('new_stations.csv', sep=';')
#     new_trips_df = pd.read_csv('new_trips.csv', sep=';')
#
#     # Обновление таблиц в базе данных
#     for index, row in new_stations_df.iterrows():
#         cur.execute("""
#             INSERT INTO station(station_id, station_name, locations, capacity)
#             VALUES (%s, %s, %s, %s)
#             ON CONFLICT (station_id) DO UPDATE
#             SET station_name = EXCLUDED.station_name,
#                 locations = EXCLUDED.locations,
#                 capacity = EXCLUDED.capacity;
#         """, (row['station_id'], row['station_name'], row['locations'], row['capacity']))
#
#     for index, row in new_trips_df.iterrows():
#         cur.execute("""
#             INSERT INTO trips(trip_id, train_id, station_from_id, station_to_id, departure_time, arrival_time, passengers_count)
#             VALUES (%s, %s, %s, %s, %s, %s, %s)
#             ON CONFLICT (trip_id) DO UPDATE
#             SET train_id = EXCLUDED.train_id,
#                 station_from_id = EXCLUDED.station_from_id,
#                 station_to_id = EXCLUDED.station_to_id,
#                 departure_time = EXCLUDED.departure_time,
#                 arrival_time = EXCLUDED.arrival_time,
#                 passengers_count = EXCLUDED.passengers_count;
#         """, (row['trip_id'], row['train_id'], row['station_from_id'], row['station_to_id'], row['departure_time'],
#               row['arrival_time'], row['passengers_count']))
#
#     conn.commit()
#     print("База данных успешно обновлена.")
#
# #Загрузкка CSV
# stations_df = pd.read_csv('stations.csv', sep=';')
# trains_df = pd.read_csv('trains.csv', sep=';')
# passengers_df = pd.read_csv('passengers.csv', sep=';')
# trips_df = pd.read_csv('trips.csv', sep=';')
# equipment_df = pd.read_csv('equipment.csv', sep=';')
# #Для каждого атрибута присутствует информация о количестве пустых значений
# print(stations_df.isnull().sum())
# print(trains_df.isnull().sum())
# print(passengers_df.isnull().sum())
# print(trips_df.isnull().sum())
# print(equipment_df.isnull().sum())
#
# # Загруска данных CSV в бдшку
# try:
#     for index, row in stations_df.iterrows():
#         cur.execute("""
#             INSERT INTO station(station_id, station_name, locations, capacity)
#             VALUES (%s, %s, %s, %s);
#         """, (row['station_id'], row['station_name'], row['locations'], row['capacity']))
#
#     for index, row in trains_df.iterrows():
#         cur.execute("""
#             INSERT INTO trains(trains_id, train_number, capacity)
#             VALUES (%s, %s, %s);
#         """, (row['trains_id'], row['train_number'], row['capacity']))
#
#     for index, row in passengers_df.iterrows():
#         cur.execute("""
#             INSERT INTO passengers(passanger_id, name_passengers, age)
#             VALUES (%s, %s, %s);
#         """, (row['passanger_id'], row['name_passengers'], row['age']))
#     for index, row in trips_df.iterrows():
#         cur.execute("""
#             INSERT INTO trips(trip_id, train_id, station_from_id, station_to_id, departure_time, arrival_time, passengers_count)
#             VALUES (%s, %s, %s, %s, %s, %s, %s);
#         """, (row['trip_id'], row['train_id'], row['station_from_id'], row['station_to_id'], row['departure_time'],
#               row['arrival_time'], row['passengers_count']))
#     for index, row in equipment_df.iterrows():
#         cur.execute("""
#             INSERT INTO equipment(equipment_id, station_id, equipment_type, direction, count)
#             VALUES (%s, %s, %s, %s, %s);
#         """, (row['equipment_id'], row['station_id'], row['equipment_type'], row['direction'], row['count']))
#     conn.commit()
# except Exception as e:
#     print(e)
#
# #Проверка работы
# query = pd.read_sql('select * from equipment', conn)
# query
#
#
# #Преобразование дат
# trips_df['departure_time'] = pd.to_datetime(trips_df['departure_time'], format='%d.%m.%Y %H:%M')
# trips_df['arrival_time'] = pd.to_datetime(trips_df['arrival_time'], format='%d.%m.%Y %H:%M')
# trips_df['departure_unix'] = trips_df['departure_time'].astype('int64') / 10**9
# trips_df['arrival_unix'] = trips_df['arrival_time'].astype('int64') / 10**9
#
#
# #Вычисление корреляции
# corr = trips_df[['train_id', 'station_from_id', 'station_to_id', 'passengers_count', 'departure_unix', 'arrival_unix']].corr()
# sns.heatmap(corr, annot=True, cmap='coolwarm')
# plt.show()
#
# #Нормализация данных
# scaler = StandardScaler()
# trips_scaled = scaler.fit_transform(trips_df[['train_id', 'station_from_id', 'station_to_id', 'passengers_count', 'departure_unix', 'arrival_unix']])
#
# #Кластеризация
# kmeans = KMeans(n_clusters=3)
# trips_df['cluster'] = kmeans.fit_predict(trips_scaled)
#
# #Визуализация кластеров
# sns.scatterplot(x='departure_unix', y='passengers_count', hue='cluster', data=trips_df)
# plt.show()
#
# #Графики для stations_df['capacity']
# #Гистограмма
# sns.histplot(stations_df['capacity'], kde=True)
# plt.title('Распределение пропускной спообной станций')
# plt.show()
# # Q-Q plot
# stats.probplot(stations_df['capacity'], dist="norm", plot=plt)
# plt.title('Q-Q plot для пропускной способносности станций')
# plt.show()
# #Тест Шапиро-Уилка
# stat, p = stats.shapiro(stations_df['capacity'])
# print(f'Тест Шапиро-Уилка: статистика - {stat}, р-значение = {p}')
# if p > 0.05:
#     print('Распределение нормальное')
# else:
#     print('Распределение не нормальное')
# #Построение плотности распределения
# density = stats.gaussian_kde(stations_df['capacity'])
# x = np.linspace(min(stations_df['capacity']), max(stations_df['capacity']), 1000) # Создаем диапазон значений для построения кривой
# y = density(x) # Рассчитываем значения плотности для каждого x
#
# #Построение графика
# fig, ax = plt.subplots(figsize=(12, 6))
# ax.plot(x, y, label='Плотность распределения')
# ax.set_xlabel('Capacity')
# ax.set_ylabel('Density')
# ax.legend()
# plt.title('Плотность распределения значений Capacity')
# plt.show()
#
# #Графики для trains_df['capacity']
# #Гистограмма
# sns.histplot(trains_df['capacity'], kde=True)
# plt.title('Распределение пропускной спообной станций')
# plt.show()
#
# stats.probplot(trains_df['capacity'], dist="norm", plot=plt)
# plt.title('Q-Q plot для пропускной способносности станций')
# plt.show()
#
# stat, p = stats.shapiro(trains_df['capacity'])
# print(f'Тест Шапиро-Уилка: статистика - {stat}, р-значение = {p}')
# if p > 0.05:
#     print('Распределение нормальное')
# else:
#     print('Распределение не нормальное')
#
# #Построение плотности распределения
# density = stats.gaussian_kde(trains_df['capacity'])
# x = np.linspace(min(trains_df['capacity']), max(trains_df['capacity']), 1000) # Создаем диапазон значений для построения кривой
# y = density(x) # Рассчитываем значения плотности для каждого x
#
# #Построение графика
# fig, ax = plt.subplots(figsize=(12, 6))
# ax.plot(x, y, label='Плотность распределения')
# ax.set_xlabel('Capacity')
# ax.set_ylabel('Density')
# ax.legend()
# plt.title('Плотность распределения значений Capacity')
# plt.show()
#
# #Графики для passengers_df['age']
# #Гистограмма
# sns.histplot(passengers_df['age'], kde=True)
# plt.title('Распределение пропускной спообной станций')
# plt.show()
#
# stats.probplot(passengers_df['age'], dist="norm", plot=plt)
# plt.title('Q-Q plot для пропускной способносности станций')
# plt.show()
#
# stat, p = stats.shapiro(passengers_df['age'])
# print(f'Тест Шапиро-Уилка: статистика - {stat}, р-значение = {p}')
# if p > 0.05:
#     print('Распределение нормальное')
# else:
#     print('Распределение не нормальное')
#
# #Построение плотности распределения
# density = stats.gaussian_kde(passengers_df['age'])
# x = np.linspace(min(passengers_df['age']), max(passengers_df['age']), 1000) # Создаем диапазон значений для построения кривой
# y = density(x) # Рассчитываем значения плотности для каждого x
#
# #Построение графика
# fig, ax = plt.subplots(figsize=(12, 6))
# ax.plot(x, y, label='Плотность распределения')
# ax.set_xlabel('age')
# ax.set_ylabel('Density')
# ax.legend()
# plt.title('Плотность распределения значений age')
# plt.show()
#
# #Графики для trips_df['passengers_count']
# #Гистограмма
# sns.histplot(trips_df['passengers_count'], kde=True)
# plt.title('Распределение пропускной способносности станций')
# plt.show()
#
# stats.probplot(trips_df['passengers_count'], dist="norm", plot=plt)
# plt.title('Q-Q plot для пропускной способносности станций')
# plt.show()
#
# stat, p = stats.shapiro(trips_df['passengers_count'])
# print(f'Тест Шапиро-Уилка: статистика - {stat}, р-значение = {p}')
# if p > 0.05:
#     print('Распределение нормальное')
# else:
#     print('Распределение не нормальное')
#
# #Построение плотности распределения
# density = stats.gaussian_kde(trips_df['passengers_count'])
# x = np.linspace(min(trips_df['passengers_count']), max(trips_df['passengers_count']), 1000) # Создаем диапазон значений для построения кривой
# y = density(x) # Рассчитываем значения плотности для каждого x
#
# #Построение графика
# fig, ax = plt.subplots(figsize=(12, 6))
# ax.plot(x, y, label='Плотность распределения')
# ax.set_xlabel('passengers_count')
# ax.set_ylabel('Density')
# ax.legend()
# plt.title('Плотность распределения значений passengers_count')
# plt.show()
#
# #Скошенность для stations_df['capacity']
# skewneas = skew(stations_df['capacity'])
# print(f'Скошенность распределения: {skewneas}')
#
# if skewneas > 0:
#     print('Распределение скошено вправо')
# elif skewneas < 0:
#     print('Распределение скошено влево')
# else:
#     print('Распределение симметрично')
#
# #Скошенность для trains_df['capacity']
# skewneas = skew(trains_df['capacity'])
# print(f'Скошенность распределения: {skewneas}')
#
# if skewneas > 0:
#     print('Распределение скошено вправо')
# elif skewneas < 0:
#     print('Распределение скошено влево')
# else:
#     print('Распределение симметрично')
#
# #Скошенность для passengers_df['age']
# skewneas = skew(passengers_df['age'])
# print(f'Скошенность распределения: {skewneas}')
#
# if skewneas > 0:
#     print('Распределение скошено вправо')
# elif skewneas < 0:
#     print('Распределение скошено влево')
# else:
#     print('Распределение симметрично')
#
# #Скошенность для trips_df['passengers_count']
# skewneas = skew(trips_df['passengers_count'])
# print(f'Скошенность распределения: {skewneas}')
#
# if skewneas > 0:
#     print('Распределение скошено вправо')
# elif skewneas < 0:
#     print('Распределение скошено влево')
# else:
#     print('Распределение симметрично')
#
# #Общая загруженность станции
# station_load = pd.read_sql("SELECT station_from_id, sum(passengers_count) AS total_passengers FROM trips GROUP BY station_from_id", conn)
# print(station_load)
#
# stations_capacity = pd.read_sql("SELECT station_id, capacity FROM station;", conn)
# merged_data = station_load.merge(stations_capacity, left_on="station_from_id", right_on="station_id")
# merged_data["load_percentage"] = (merged_data["total_passengers"] / merged_data["capacity"]) * 100
# print(merged_data[["station_from_id", "total_passengers", "capacity", "load_percentage"]])
#
# #Количественные характеристики
# equipment_count = pd.read_sql("SELECT station_id, COUNT(*) as equipment_count FROM equipment GROUP BY station_id;", conn)
# print(equipment_count)
#
# #Временные интервалы поездки
# trips_df['duration'] = (trips_df['arrival_time'] - trips_df['departure_time']).dt.total_seconds() / 60
# print(trips_df['duration'].describe())
#
# #Продолжительность поездки
# avarege_duration = trips_df['duration'].mean()
# print(f'Средняя продолжительность поездки: {avarege_duration} минут')
#
# #Добавление дополнительных характеристик
# try:
#   final_dataset = trips_df.merge(stations_capacity, left_on='station_from_id', right_on='station_id')
#   final_dataset['load_percentage'] = (final_dataset['passengers_count'] / final_dataset['capacity']) * 100
#
#   #Сохранение итогового набора данных
#   final_dataset.to_csv('final_dataset.csv', index=False)
#   print('Датасет создался успешно')
# except Exception as e:
#   print(f'Ошибка: {e}')