# from fastapi import FastAPI, HTTPException
# from pydantic import BaseModel
# import joblib
# import pandas as pd
# from datetime import datetime
#
# # Загрузка модели и scaler
# model = joblib.load('best_model.pkl')
# scaler = joblib.load('scaler.pkl')
#
# # Создание FastAPI приложения
# app = FastAPI()
#
#
# # Модель для входных данных (Pydantic)
# class TripRequest(BaseModel):
#     trip_id: int
#     train_id: int
#     station_from_id: int
#     station_to_id: int
#     departure_time: str  # Время в формате "YYYY-MM-DD HH:MM:SS"
#     passengers_count: int
#
#
# class StationRequest(BaseModel):
#     station_id: int
#     start_time: str  # Время в формате "YYYY-MM-DD HH:MM:SS"
#     end_time: str    # Время в формате "YYYY-MM-DD HH:MM:SS"
#
#
# # Эндпоинт для корневого пути
# @app.get("/")
# def home():
#     return {"message": "API работает!"}
#
#
# # Эндпоинт для предсказания удобства поездки
# @app.post("/predict_trip_convenience")
# def predict_trip_convenience(trip: TripRequest):
#     try:
#         # Преобразуем время в Unix-время
#         departure_time = datetime.strptime(trip.departure_time, "%Y-%m-%d %H:%M:%S")
#         departure_unix = departure_time.timestamp()
#
#         # Создаем DataFrame с входными данными
#         input_data = pd.DataFrame({
#             'trip_id': [trip.trip_id],
#             'train_id': [trip.train_id],
#             'station_from_id': [trip.station_from_id],
#             'station_to_id': [trip.station_to_id],
#             'departure_unix': [departure_unix],
#             'passengers_count': [trip.passengers_count]
#         })
#
#         # Масштабируем данные
#         input_data_scaled = scaler.transform(input_data)
#
#         # Предсказываем кластер (удобство поездки)
#         cluster = model.predict(input_data_scaled)[0]
#
#         # Возвращаем результат
#         return {
#             "trip_id": trip.trip_id,
#             "convenience_cluster": int(cluster)
#         }
#
#     except Exception as e:
#         raise HTTPException(status_code=400, detail=str(e))
#
#
# # Эндпоинт для прогнозирования загруженности станций
# @app.post("/predict_station_load")
# def predict_station_load(station: StationRequest):
#     try:
#         # Здесь можно добавить логику для прогнозирования загруженности
#         # Например, использовать исторические данные или другую модель
#
#         # Временный пример
#         load_percentage = 75  # Пример значения загруженности
#
#         # Возвращаем результат
#         return {
#             "station_id": station.station_id,
#             "start_time": station.start_time,
#             "end_time": station.end_time,
#             "load_percentage": load_percentage
#         }
#
#     except Exception as e:
#         raise HTTPException(status_code=400, detail=str(e))
#
#
# # Запуск приложения
# if __name__ == "__main__":
#     import uvicorn
#     uvicorn.run(app, host="0.0.0.0", port=5000)
#
# curl -X POST "http://127.0.0.1:5000/predict_trip_convenience" \
# -H "Content-Type: application/json" \
# -d '{
#   "trip_id": 1,
#   "train_id": 1,
#   "station_from_id": 1,
#   "station_to_id": 2,
#   "departure_time": "2023-10-01 08:00:00",
#   "passengers_count": 150
# }'
#
#
# curl -X POST "http://127.0.0.1:5000/predict_station_load" \
# -H "Content-Type: application/json" \
# -d '{
#   "station_id": 1,
#   "start_time": "2023-10-01 08:00:00",
#   "end_time": "2023-10-01 09:00:00"
# }'