# # Импорт библиотек
# import pandas as pd
# import numpy as np
# from sklearn.cluster import KMeans, DBSCAN, AgglomerativeClustering, MiniBatchKMeans
# from sklearn.preprocessing import StandardScaler
# from sklearn.model_selection import train_test_split
# from sklearn.metrics import silhouette_score, davies_bouldin_score, calinski_harabasz_score
# from imblearn.over_sampling import SMOTE
# from prophet import Prophet
# import joblib
# import matplotlib.pyplot as plt
# import logging
# from sklearn.linear_model import LinearRegression
# from sklearn.ensemble import RandomForestRegressor
# from sklearn.metrics import mean_absolute_error, mean_squared_error
# import psycopg2
#
# # Настройка логирования
# logging.basicConfig(level=logging.INFO, format='%(asctime)s - %(levelname)s - %(message)s')
#
#
# # Подключение к БД
# def connect_to_db():
#     try:
#         conn = psycopg2.connect(
#             dbname='table_name',
#             user='postgres',
#             password='6dead6add',
#             host='localhost',
#             port='5432'
#         )
#         return conn
#     except Exception as e:
#         print(f"Ошибка подключения к базе данных: {e}")
#         return None
#
#
# # Загрузка данных из базы данных
# def load_data(conn):
#     query = """
#         SELECT
#             station_from_id AS station_id,
#             departure_time,
#             arrival_time,
#             passengers_count
#         FROM trips;
#     """
#     data = pd.read_sql(query, conn)
#     logging.info(f"Загружено {len(data)} записей из базы данных.")
#     return data
#
#
# # Подготовка данных для кластеризации
# def prepare_data_for_clustering(data):
#     # Преобразуем departure_time и arrival_time в datetime
#     data['departure_time'] = pd.to_datetime(data['departure_time'])
#     data['arrival_time'] = pd.to_datetime(data['arrival_time'])
#
#     # Извлекаем час отправления и прибытия
#     data['departure_hour'] = data['departure_time'].dt.hour
#     data['arrival_hour'] = data['arrival_time'].dt.hour
#
#     # Вычисляем продолжительность поездки в минутах
#     data['duration'] = (data['arrival_time'] - data['departure_time']).dt.total_seconds() / 60
#
#     # Оставляем только нужные столбцы
#     data = data[['station_id', 'departure_hour', 'arrival_hour', 'passengers_count', 'duration']]
#     logging.info("Данные подготовлены для кластеризации.")
#     return data
#
#
# # Проверка сбалансированности данных и устранение дисбаланса
# def balance_data(data):
#     # Проверяем сбалансированность по passengers_count (пример)
#     if 'passengers_count' in data.columns:
#         class_counts = data['passengers_count'].value_counts()
#         logging.info(f"Распределение классов до балансировки:\n{class_counts}")
#
#         if class_counts.min() / class_counts.max() < 0.5:
#             logging.info("Данные несбалансированы. Применяем SMOTE.")
#             X = data[['departure_hour', 'arrival_hour', 'passengers_count', 'duration']]
#             y = data['passengers_count']
#             smote = SMOTE(random_state=42)
#             X_resampled, y_resampled = smote.fit_resample(X, y)
#             data = pd.concat([pd.DataFrame(X_resampled), pd.Series(y_resampled, name='passengers_count')], axis=1)
#             logging.info(f"Распределение классов после балансировки:\n{data['passengers_count'].value_counts()}")
#         else:
#             logging.info("Данные сбалансированы.")
#     else:
#         logging.warning("Целевой признак для балансировки не найден.")
#     return data
#
#
# # Кластеризация данных
# def perform_clustering(data):
#     scaler = StandardScaler()
#     scaled_data = scaler.fit_transform(data[['departure_hour', 'arrival_hour', 'passengers_count', 'duration']])
#
#     # KMeans
#     kmeans = KMeans(n_clusters=3, random_state=42)
#     kmeans_clusters = kmeans.fit_predict(scaled_data)
#     kmeans_silhouette = silhouette_score(scaled_data, kmeans_clusters)
#     kmeans_davies = davies_bouldin_score(scaled_data, kmeans_clusters)
#     kmeans_calinski = calinski_harabasz_score(scaled_data, kmeans_clusters)
#
#     # DBSCAN
#     dbscan = DBSCAN(eps=0.5, min_samples=5)
#     dbscan_clusters = dbscan.fit_predict(scaled_data)
#     dbscan_silhouette = silhouette_score(scaled_data, dbscan_clusters) if len(set(dbscan_clusters)) > 1 else -1
#     dbscan_davies = davies_bouldin_score(scaled_data, dbscan_clusters) if len(set(dbscan_clusters)) > 1 else -1
#     dbscan_calinski = calinski_harabasz_score(scaled_data, dbscan_clusters) if len(set(dbscan_clusters)) > 1 else -1
#
#     # Agglomerative Clustering
#     agglo = AgglomerativeClustering(n_clusters=3)
#     agglo_clusters = agglo.fit_predict(scaled_data)
#     agglo_silhouette = silhouette_score(scaled_data, agglo_clusters)
#     agglo_davies = davies_bouldin_score(scaled_data, agglo_clusters)
#     agglo_calinski = calinski_harabasz_score(scaled_data, agglo_clusters)
#
#     # Выбор лучшей модели
#     scores = {
#         "K-Means": {"Silhouette": kmeans_silhouette, "Davies-Bouldin": kmeans_davies,
#                     "Calinski-Harabasz": kmeans_calinski},
#         "DBSCAN": {"Silhouette": dbscan_silhouette, "Davies-Bouldin": dbscan_davies,
#                    "Calinski-Harabasz": dbscan_calinski},
#         "Agglomerative": {"Silhouette": agglo_silhouette, "Davies-Bouldin": agglo_davies,
#                           "Calinski-Harabasz": agglo_calinski}
#     }
#     best_algorithm = max(scores, key=lambda x: scores[x]["Silhouette"])
#     logging.info(
#         f"Лучший алгоритм кластеризации: {best_algorithm} с Silhouette Score = {scores[best_algorithm]['Silhouette']:.2f}")
#
#     # Сохранение лучшей модели
#     if best_algorithm == "K-Means":
#         joblib.dump(kmeans, 'best_model.pkl')
#     elif best_algorithm == "DBSCAN":
#         joblib.dump(dbscan, 'best_model.pkl')
#     else:
#         joblib.dump(agglo, 'best_model.pkl')
#     logging.info("Лучшая модель сохранена в файл 'best_model.pkl'.")
#
#     # Добавляем кластеры в данные
#     data['cluster'] = kmeans_clusters
#     return data, scores, best_algorithm
#
#
# # Непрерывное обучение модели
# def update_model(conn, model_path='best_model.pkl'):
#     try:
#         model = joblib.load(model_path)
#         logging.info("Текущая модель загружена.")
#     except FileNotFoundError:
#         logging.error("Файл модели не найден. Сначала обучите модель.")
#         return
#
#     # Загрузка новых данных
#     new_data = load_data(conn)
#     if not new_data.empty:
#         # Подготовка новых данных
#         new_data = prepare_data_for_clustering(new_data)
#
#         # Нормализация данных
#         scaler = StandardScaler()
#         new_X = new_data[['departure_hour', 'arrival_hour', 'passengers_count', 'duration']]
#         new_X_scaled = scaler.fit_transform(new_X)
#
#         # Оценка исходной модели
#         if isinstance(model, AgglomerativeClustering):
#             original_clusters = model.fit_predict(new_X_scaled)  # Используем fit_predict для AgglomerativeClustering
#         else:
#             original_clusters = model.predict(new_X_scaled)  # Для KMeans и других моделей
#         original_silhouette = silhouette_score(new_X_scaled, original_clusters)
#         logging.info(f"Silhouette Score исходной модели: {original_silhouette:.2f}")
#
#         # Дообучение модели (используем MiniBatchKMeans для непрерывного обучения)
#         if isinstance(model, KMeans):
#             model = MiniBatchKMeans(n_clusters=3, random_state=42)
#             model.partial_fit(new_X_scaled)
#             logging.info("Модель дообучена с использованием MiniBatchKMeans.")
#         else:
#             logging.warning("Модель не поддерживает дообучение. Обучаем с нуля.")
#             model.fit(new_X_scaled)
#
#         # Оценка дообученной модели
#         if isinstance(model, AgglomerativeClustering):
#             updated_clusters = model.fit_predict(new_X_scaled)  # Используем fit_predict для AgglomerativeClustering
#         else:
#             updated_clusters = model.predict(new_X_scaled)  # Для KMeans и других моделей
#         updated_silhouette = silhouette_score(new_X_scaled, updated_clusters)
#         logging.info(f"Silhouette Score дообученной модели: {updated_silhouette:.2f}")
#
#         # Сравнение моделей
#         if updated_silhouette > original_silhouette:
#             logging.info("Дообученная модель улучшила качество.")
#         else:
#             logging.info("Дообученная модель не улучшила качество.")
#
#         # Сохранение обновлённой модели
#         joblib.dump(model, 'updated_model.pkl')
#         logging.info("Модель успешно дообучена и сохранена в файл 'updated_model.pkl'.")
#     else:
#         logging.warning("Новых данных для обучения нет.")
#
#
# def evaluate_regression_models(data, station_id):
#     # Фильтруем данные для конкретной станции
#     station_data = data[data['station_id'] == station_id]
#
#     # Проверяем, достаточно ли данных для обучения
#     if len(station_data) < 2:
#         logging.warning(f"Недостаточно данных для станции {station_id}. Пропускаем.")
#         return {}, None  # Возвращаем пустой словарь и None для лучшей модели
#
#     # Подготовка данных
#     X = station_data[['departure_hour', 'arrival_hour', 'duration']]
#     y = station_data['passengers_count']
#
#     # Разделение на обучающую и тестовую выборки
#     X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.2, random_state=42)
#
#     # Модели
#     models = {
#         "Linear Regression": LinearRegression(),
#         "Random Forest": RandomForestRegressor(random_state=42),
#         "Prophet": Prophet()
#     }
#
#     # Оценка моделей
#     results = {}
#     for name, model in models.items():
#         if name == "Prophet":
#             # Подготовка данных для Prophet
#             prophet_data = station_data.rename(columns={'departure_time': 'ds', 'passengers_count': 'y'})
#             model.fit(prophet_data)
#             future = model.make_future_dataframe(periods=730)
#             forecast = model.predict(future)
#             y_pred = forecast['yhat'][-len(y_test):].values
#         else:
#             # Обучение и предсказание для других моделей
#             model.fit(X_train, y_train)
#             y_pred = model.predict(X_test)
#
#         # Оценка качества
#         mae = mean_absolute_error(y_test, y_pred)
#         mse = mean_squared_error(y_test, y_pred)
#         rmse = np.sqrt(mse)
#
#         results[name] = {"MAE": mae, "MSE": mse, "RMSE": rmse}
#         logging.info(f"{name}: MAE = {mae:.2f}, MSE = {mse:.2f}, RMSE = {rmse:.2f}")
#
#     # Выбор лучшей модели
#     best_model = min(results, key=lambda x: results[x]["MAE"])
#     logging.info(f"Лучшая модель: {best_model} с MAE = {results[best_model]['MAE']:.2f}")
#
#     return results, best_model
#
#
# # Визуализация прогноза
# def plot_forecast(forecast, station_id):
#     plt.figure(figsize=(12, 6))
#     plt.plot(forecast['ds'], forecast['yhat'], label='Прогноз')
#     plt.fill_between(forecast['ds'], forecast['yhat_lower'], forecast['yhat_upper'], alpha=0.2,
#                      label='Доверительный интервал')
#     plt.title(f'Прогноз загруженности станции {station_id} на 2 года вперёд')
#     plt.xlabel('Дата')
#     plt.ylabel('Количество пассажиров')
#     plt.legend()
#     plt.show()
#
#
# def forecast_station_load(data, station_id, periods=730):
#     """
#     Прогнозирует загруженность станции на определённый период времени с использованием Prophet.
#
#     Параметры:
#         data (pd.DataFrame): Исходные данные.
#         station_id (int): Идентификатор станции.
#         periods (int): Количество дней для прогноза (по умолчанию 730 дней).
#
#     Возвращает:
#         forecast (pd.DataFrame): Прогноз с доверительными интервалами.
#         model (Prophet): Обученная модель Prophet.
#     """
#     try:
#         # Фильтруем данные для конкретной станции
#         station_data = data[data['station_id'] == station_id]
#
#         # Проверяем, достаточно ли данных для обучения
#         if len(station_data) < 2:
#             logging.warning(f"Недостаточно данных для станции {station_id}. Пропускаем.")
#             return None, None
#
#         # Подготовка данных для Prophet
#         prophet_data = station_data.rename(columns={'departure_time': 'ds', 'passengers_count': 'y'})
#         prophet_data = prophet_data[['ds', 'y']].dropna()  # Убираем пропущенные значения
#
#         # Инициализация и обучение модели Prophet
#         model = Prophet()
#         model.fit(prophet_data)
#
#         # Создание данных для прогноза
#         future = model.make_future_dataframe(periods=periods)
#
#         # Прогнозирование
#         forecast = model.predict(future)
#
#         logging.info(f"Прогноз для станции {station_id} успешно выполнен.")
#         return forecast, model
#
#     except Exception as e:
#         logging.error(f"Ошибка при прогнозировании для станции {station_id}: {e}")
#         return None, None
#
#
# # Основной блок
# if __name__ == '__main__':
#     # Подключение к базе данных
#     conn = connect_to_db()
#     if conn:
#         # Загрузка данных
#         data = load_data(conn)
#
#         # Подготовка данных для кластеризации
#         clustering_data = prepare_data_for_clustering(data)
#
#         # Проверка сбалансированности данных
#         clustering_data = balance_data(clustering_data)
#
#         # Кластеризация данных
#         data, scores, best_algorithm = perform_clustering(clustering_data)
#
#         # Непрерывное обучение модели
#         update_model(conn)
#
#         # Прогнозирование для каждой станции
#         for station_id in data['station_id'].unique():
#             logging.info(f"Прогнозирование для станции {station_id}...")
#             results, best_model = evaluate_regression_models(data, station_id)
#
#             # Проверяем, есть ли результаты
#             if results:  # Если results не пустой
#                 logging.info(f"Лучшая модель для станции {station_id}: {best_model}")
#                 if best_model == "Prophet":
#                     forecast, model = forecast_station_load(data, station_id)
#                     if forecast is not None:
#                         plot_forecast(forecast, station_id)
#             else:
#                 logging.warning(f"Для станции {station_id} недостаточно данных для прогнозирования.")
#
#         # Закрытие соединения с базой данных
#         conn.close()