# # Импорт библиотек
# import psycopg2
# import pandas as pd
# import dash
# from dash import dcc, html
# from dash.dependencies import Input, Output
# import plotly.express as px
# from sklearn.cluster import KMeans, DBSCAN, AgglomerativeClustering
# from sklearn.preprocessing import StandardScaler
# from sklearn.metrics import silhouette_score
#
# # Подключение к БД
# def connect_to_db():
#     try:
#         conn = psycopg2.connect(
#             dbname='table_name',
#             user='postgres',
#             password='6dead6add',
#             host='localhost',
#             port='5432'
#         )
#         return conn
#     except Exception as e:
#         print(f"Ошибка подключения к базе данных: {e}")
#         return None
#
# # Загруженность станции в процентах относительно максимальной загруженности
# def calculate_load_percentage(conn, station_id, start_time, end_time):
#     query = """
#         SELECT
#             station_from_id AS station_id,
#             COALESCE(SUM(passengers_count) * 100.0 / MAX(s.capacity), 0) AS load_percentage
#         FROM trips t
#         JOIN station s ON t.station_from_id = s.station_id
#         WHERE
#             EXTRACT(HOUR FROM departure_time) BETWEEN %s AND %s
#             AND station_from_id = %s
#         GROUP BY station_from_id;
#     """
#     return pd.read_sql(query, conn, params=(start_time, end_time, station_id))
#
# # Реальная пропускная способность станций
# def calculate_real_capacity(conn, station_id, start_time, end_time):
#     query = """
#         SELECT
#             station_from_id AS station_id,
#             COALESCE(SUM(passengers_count) * 0.8, 0) AS real_capacity
#         FROM trips
#         WHERE
#             EXTRACT(HOUR FROM departure_time) BETWEEN %s AND %s
#             AND station_from_id = %s
#         GROUP BY station_from_id;
#     """
#     return pd.read_sql(query, conn, params=(start_time, end_time, station_id))
#
# # Топ загруженных станций
# def calculate_top_stations(conn, start_time, end_time):
#     query = """
#         SELECT
#             station_from_id AS station_id,
#             COALESCE(SUM(passengers_count), 0) AS total_passengers
#         FROM trips
#         WHERE
#             EXTRACT(HOUR FROM departure_time) BETWEEN %s AND %s
#         GROUP BY station_from_id
#         ORDER BY total_passengers DESC
#     """
#     return pd.read_sql(query, conn, params=(start_time, end_time))
#
#
# # Среднее количество пассажиров на станциях
# def calculate_avg_passengers(conn, start_time, end_time):
#     query = """
#         SELECT
#             COALESCE(AVG(total_passengers), 0) AS avg_passengers
#         FROM (
#             SELECT
#                 station_from_id,
#                 COALESCE(SUM(passengers_count), 0) AS total_passengers
#             FROM trips
#             WHERE
#                 EXTRACT(HOUR FROM departure_time) BETWEEN %s AND %s
#             GROUP BY station_from_id
#         ) AS station_loads;
#     """
#     return pd.read_sql(query, conn, params=(start_time, end_time))
#
# # Количество станций без инфраструктуры для маломобильных граждан
# def calculate_stations_without_ramp(conn):
#     query = """
#         SELECT
#             COALESCE(COUNT(DISTINCT station_id), 0) AS stations_without_ramp
#         FROM equipment
#         WHERE
#             equipment_type != 'wheelchair_ramp';
#     """
#     return pd.read_sql(query, conn)
#
# # Функция для подготовки данных для кластеризации
# def prepare_clustering_data(conn):
#     query = """
#         SELECT
#             EXTRACT(HOUR FROM departure_time) AS departure_hour,
#             EXTRACT(HOUR FROM arrival_time) AS arrival_hour,
#             passengers_count,
#             EXTRACT(EPOCH FROM (arrival_time - departure_time)) / 60 AS duration
#         FROM trips;
#     """
#     trips_df = pd.read_sql(query, conn)
#     return trips_df
#
#
# # Функция для кластеризации данных
# def perform_clustering(data):
#     # Нормализация данных
#     scaler = StandardScaler()
#     scaled_data = scaler.fit_transform(data)
#
#     # Кластеризация K-Means
#     kmeans = KMeans(n_clusters=3, random_state=42)
#     kmeans_clusters = kmeans.fit_predict(scaled_data)
#     kmeans_score = silhouette_score(scaled_data, kmeans_clusters)
#
#     # Кластеризация DBSCAN
#     dbscan = DBSCAN(eps=0.5, min_samples=5)
#     dbscan_clusters = dbscan.fit_predict(scaled_data)
#     if len(set(dbscan_clusters)) > 1:  # DBSCAN может вернуть только один кластер
#         dbscan_score = silhouette_score(scaled_data, dbscan_clusters)
#     else:
#         dbscan_score = -1  # Невозможно вычислить
#
#     # Кластеризация Agglomerative Clustering
#     agglo = AgglomerativeClustering(n_clusters=3)
#     agglo_clusters = agglo.fit_predict(scaled_data)
#     agglo_score = silhouette_score(scaled_data, agglo_clusters)
#
#     # Сравнение алгоритмов
#     scores = {
#         "K-Means": kmeans_score,
#         "DBSCAN": dbscan_score,
#         "Agglomerative": agglo_score
#     }
#     best_algorithm = max(scores, key=scores.get)
#
#     return kmeans_clusters, dbscan_clusters, agglo_clusters, scores, best_algorithm
#
#
# # Функция для наименования кластеров
# def name_clusters(data, clusters):
#     data['cluster'] = clusters
#
#     # Вычисляем средние значения для каждого кластера
#     cluster_stats = data.groupby('cluster').agg({
#         'passengers_count': 'mean',
#         'duration': 'mean'
#     }).reset_index()
#
#     # Присваиваем имена кластерам
#     cluster_names = {}
#     for _, row in cluster_stats.iterrows():
#         if row['passengers_count'] < 50 and row['duration'] < 30:
#             cluster_names[row['cluster']] = "Оптимальные"
#         elif row['passengers_count'] > 100 and row['duration'] > 60:
#             cluster_names[row['cluster']] = "Нерекомендуемые"
#         else:
#             cluster_names[row['cluster']] = "Нежелательные"
#
#     # Применяем имена к данным
#     data['cluster_name'] = data['cluster'].map(cluster_names)
#     return data
#
# # Функция для визуализации кластеров
# def visualize_clusters(data, clusters):
#     data['кластер'] = clusters
#     fig = px.scatter(
#         data,
#         x='departure_hour',
#         y='passengers_count',
#         color='кластер',
#         title='Кластеризация поездок',
#         labels={'departure_hour': 'Час отправления', 'passengers_count': 'Количество пассажиров'}
#     )
#     return fig
#
#
# # Функция для построения графика Silhouette Score
# def plot_silhouette_scores(data, max_clusters=10):
#     scaler = StandardScaler()
#     scaled_data = scaler.fit_transform(data)
#
#     silhouette_scores = []
#     n_samples = len(data)
#
#     # Убедимся, что количество кластеров меньше количества образцов
#     max_clusters = min(max_clusters, n_samples - 1)
#
#     for n_clusters in range(2, max_clusters + 1):
#         kmeans = KMeans(n_clusters=n_clusters, random_state=42)
#         clusters = kmeans.fit_predict(scaled_data)
#         score = silhouette_score(scaled_data, clusters)
#         silhouette_scores.append(score)
#
#     # Создаем график
#     fig = px.line(
#         x=list(range(2, max_clusters + 1)),
#         y=silhouette_scores,
#         labels={'x': 'Number of Clusters', 'y': 'Silhouette Score'},
#         title='Silhouette Score for Different Number of Clusters'
#     )
#
#     return fig
#
# # Создание дешборда
# app = dash.Dash(__name__)
#
# # Создание макета
# app.layout = html.Div([
#     html.H1("Аналитический дашборд для пассажирских перевозок", style={'textAlign': 'center', 'marginBottom': '20px'}),
#
#     # Выбор станции и временного интервала
#     html.Div([
#         # Выбор станции
#         html.Div([
#             html.Label("Выберите станцию:", style={'marginRight': '10px'}),
#             dcc.Dropdown(
#                 id='station-dropdown',
#                 options=[],
#                 value=None,
#                 style={'width': '200px', 'marginRight': '20px'}
#             )
#         ], style={'display': 'inline-block', 'marginRight': '40px'}),
#
#         # Выбор временного интервала
#         html.Div([
#             html.Label("Выберите временной интервал:", style={'marginRight': '10px'}),
#             dcc.RangeSlider(
#                 id='time-slider',
#                 min=0,
#                 max=24,
#                 step=1,
#                 value=[8, 18],
#                 marks={i: f"{i}:00" for i in range(0, 25, 2)},
#                 tooltip={"placement": "bottom", "always_visible": True}
#             )
#         ], style={'display': 'inline-block', 'width': '60%'})
#     ], style={'marginBottom': '20px', 'textAlign': 'center'}),
#
#     # График загруженности станции и таблица с метриками
#     html.Div([
#         # График загруженности станции
#         html.Div(
#             dcc.Graph(id='station-load-graph', style={'height': '350px'}),
#             style={'width': '50%', 'display': 'inline-block'}
#         ),
#         # Таблица с ключевыми метриками
#         html.Div(
#             id='metrics-table',
#             style={'width': '50%', 'display': 'inline-block', 'paddingLeft': '20px'}
#         )
#     ], style={'display': 'flex', 'alignItems': 'center', 'justifyContent': 'center', 'marginBottom': '20px'}),
#
#     # Три графика в одной строке: топ-5, кластеризация, оценка
#     html.Div([
#         # График топ-5 самых загруженных станций
#         html.Div(
#             dcc.Graph(id='top-stations-graph', style={'height': '350px'}),
#             style={'width': '33%', 'display': 'inline-block'}
#         ),
#         # График кластеризации
#         html.Div(
#             dcc.Graph(id='clustering-graph', style={'height': '350px'}),
#             style={'width': '33%', 'display': 'inline-block'}
#         ),
#         # График Silhouette Score
#         html.Div(
#             dcc.Graph(id='silhouette-graph', style={'height': '350px'}),
#             style={'width': '33%', 'display': 'inline-block'}
#         )
#     ], style={'display': 'flex', 'alignItems': 'center', 'justifyContent': 'center'})
# ])
#
#
# # Callback для обработки данных
# @app.callback(
#     [Output('station-load-graph', 'figure'),
#      Output('top-stations-graph', 'figure'),
#      Output('metrics-table', 'children')],
#     [Input('station-dropdown', 'value'),
#      Input('time-slider', 'value')]
# )
# def update_dashboard(selected_station, time_range):
#     conn = connect_to_db()
#     if not conn:
#         return {}, {}, html.Div("Ошибка подключения к базе данных")
#
#     # Если станция не выбрана, показываем сообщение
#     if selected_station is None:
#         return {}, {}, html.Div("Выберите станцию для отображения данных")
#
#     start_time, end_time = time_range
#
#     # Вычисляем метрики
#     load_percentage = calculate_load_percentage(conn, selected_station, start_time, end_time)
#     real_capacity = calculate_real_capacity(conn, selected_station, start_time, end_time)
#     top_stations = calculate_top_stations(conn, start_time, end_time)
#     avg_passengers = calculate_avg_passengers(conn, start_time, end_time)
#     stations_without_ramp = calculate_stations_without_ramp(conn)
#
#     # Проверяем, есть ли данные
#     if load_percentage.empty or real_capacity.empty or avg_passengers.empty or stations_without_ramp.empty:
#         return {}, {}, html.Div("Нет данных для выбранной станции и временного интервала")
#
#     # Создаем график загруженности станции
#     load_fig = px.bar(
#         x=['Загруженность'],
#         y=[load_percentage['load_percentage'].values[0]],
#         labels={'x': 'Метрика', 'y': 'Загруженность (%)'},
#         title=f"Загруженность станции {selected_station} с {start_time}:00 до {end_time}:00"
#     )
#
#     # Создаем график топ-5 самых загруженных станций
#     top_stations_fig = px.bar(
#         top_stations,
#         x='station_id',
#         y='total_passengers',
#         labels={'x': 'Станция', 'y': 'Количество пассажиров'},
#         title="Топ-5 самых загруженных станций"
#     )
#
#     # Создаем таблицу с ключевыми метриками
#     metrics_table = html.Table([
#         html.Tr([html.Th("Метрика"), html.Th("Значение")]),
#         html.Tr([html.Td("Загруженность (%)"), html.Td(f"{load_percentage['load_percentage'].values[0]:.2f}")]),
#         html.Tr(
#             [html.Td("Реальная пропускная способность"), html.Td(f"{real_capacity['real_capacity'].values[0]:.2f}")]),
#         html.Tr(
#             [html.Td("Среднее количество пассажиров"), html.Td(f"{avg_passengers['avg_passengers'].values[0]:.2f}")]),
#         html.Tr([html.Td("Станций без инфраструктуры для маломобильных граждан"),
#                  html.Td(stations_without_ramp['stations_without_ramp'].values[0])])
#     ])
#
#     conn.close()
#     return load_fig, top_stations_fig, metrics_table
#
#
# # Callback для заполнения выпадающего списка
# @app.callback(
#     Output('station-dropdown', 'options'),
#     [Input('time-slider', 'value')]
# )
# def update_station_dropdown(time_range):
#     conn = connect_to_db()
#     if not conn:
#         return []
#
#     # Загружаем данные о станциях
#     stations_df = pd.read_sql("SELECT * FROM station;", conn)
#
#     # Формируем список опций
#     options = [{'label': row['station_name'], 'value': row['station_id']} for _, row in stations_df.iterrows()]
#
#     conn.close()
#     return options
#
#
# # Callback для обновления кластеризации и Silhouette Score
# @app.callback(
#     [Output('clustering-graph', 'figure'),
#      Output('silhouette-graph', 'figure')],
#     [Input('time-slider', 'value')]
# )
# def update_clustering(time_range):
#     conn = connect_to_db()
#     if not conn:
#         return {}, {}
#
#     # Подготовка данных
#     data = prepare_clustering_data(conn)
#
#     # Кластеризация
#     kmeans_clusters, dbscan_clusters, agglo_clusters, scores, best_algorithm = perform_clustering(data)
#
#     # Визуализация всех кластеров
#     fig = visualize_clusters(data, kmeans_clusters)
#
#     # Визуализация Silhouette Score
#     silhouette_fig = plot_silhouette_scores(data)
#
#     # Вывод лучшего алгоритма
#     print(f"Лучший алгоритм кластеризации: {best_algorithm} с Silhouette Score = {scores[best_algorithm]:.2f}")
#
#     conn.close()
#     return fig, silhouette_fig
# # Запуск приложения
# if __name__ == '__main__':
#     app.run_server(debug=True)
