"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const index_1 = require("../lib/index");
const core_1 = require("@aws-cdk/core");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
require("@aws-cdk/assert/jest");
test('Is still a Function', () => {
    const mockApp = new core_1.App();
    const stack = new core_1.Stack(mockApp, 'testing-stack');
    const thing = new index_1.NodejsFunction(stack, 'test-handler', { entry: './test/index.test-handler.ts' });
    expect(thing).toBeInstanceOf(aws_lambda_nodejs_1.NodejsFunction);
});
test('Environment variable is set', () => {
    const mockApp = new core_1.App();
    const stack = new core_1.Stack(mockApp, 'testing-stack');
    const thing = new index_1.NodejsFunction(stack, 'test-handler', { entry: './test/index.test-handler.ts' });
    // @ts-ignore
    expect(thing.environment["AWS_NODEJS_CONNECTION_REUSE_ENABLED"]).toBe("1");
});
//# sourceMappingURL=data:application/json;base64,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