#!/usr/bin/env python
"""
Stuart Semple's Freetone colors - Pantone-ish colour palette

https://culturehustle.com/products/freetone

.. moduleauthor:: Matthias Cuntz

History
   * Written Dec 2024, Matthias Cuntz

"""


__all__ = ['freetone_colors']


freetone_colors = {
    'freetone:IKB - incredibly kleinish blue': (
        0.0, 0.047500011287629595, 0.8360000018924475),
    'freetone:PINKEST PINK': (
        0.9800000004470348, 0.2842000211581588, 0.7644000015169382),
    'freetone:TIFF': (
        0.036500008165836206, 0.7299999892711639, 0.7080999900825322),
    'freetone:BLACKEST BLACK 3.0': (
        0.0, 0.0, 0.0),
    'freetone:Red 032': (
        1.0, 0.11535823345184326, 0.32175177335739136),
    'freetone:Rubine Red': (
        0.8820775146466175, 0.0, 0.6331041468008749),
    'freetone:Yellow': (
        0.9642938897013664, 0.9137865304946899, 0.0),
    'freetone:Yellow 012': (
        0.9734095150566212, 0.8743990826111155, 0.0),
    'freetone:Orange 021': (
        1.0, 0.22491800785064697, 0.0),
    'freetone:Rhodamine Red': (
        0.8802166804671288, 0.08725112676620483, 1.0),
    'freetone:Purple': (
        0.5347219109535217, 0.16314947605133057, 1.0),
    'freetone:Violet': (
        0.056517600835886694, 0.0, 0.9956664377823472),
    'freetone:Blue 072': (
        0.0, 0.09679855589704611, 0.8627178525201665),
    'freetone:Reflex Blue': (
        0.0, 0.1028927398222077, 0.6487844129319762),
    'freetone:Process Blue': (
        0.0, 0.7152157698421902, 0.9309697244648804),
    'freetone:Green': (
        0.0, 1.0, 0.40195316076278687),
    'freetone:Black': (
        0.0875860479344226, 0.10341057849912261, 0.10192224277697903),
    'freetone:Yellow 0131': (
        0.9177233576774597, 1.0, 0.5278248488903046),
    'freetone:Red 0331': (
        1.0, 0.5695124864578247, 0.8609292805194855),
    'freetone:Magenta 0521': (
        0.9535515382885933, 0.6021362841129303, 1.0),
    'freetone:Violet 0631': (
        0.6839856803417206, 0.5524223744869232, 1.0),
    'freetone:Blue 0821': (
        0.45246052742004395, 1.0, 0.9190966710448265),
    'freetone:Green 0921': (
        0.581384003162384, 1.0, 0.7646448463201523),
    'freetone:Black 0961': (
        0.542594338996889, 0.5770840083906172, 0.5339193531725472),
    'freetone:801': (
        0.03293739189461481, 0.9022548954300627, 0.8970398113583133),
    'freetone:802': (
        0.3281300663948059, 1.0, 0.011688411235809326),
    'freetone:803': (
        1.0, 0.9430228136479855, 0.09091329574584961),
    'freetone:804': (
        1.0, 0.5342641472816467, 0.3301442265510559),
    'freetone:805': (
        1.0, 0.2983139157295227, 0.6129701733589172),
    'freetone:806': (
        1.0, 0.20273137092590332, 1.0),
    'freetone:807': (
        0.7253986597061157, 0.18490886688232422, 1.0),
    'freetone:871': (
        0.4179786076948959, 0.4252411390602475, 0.2281355084521941),
    'freetone:872': (
        0.4482934580650433, 0.39827649865832093, 0.2194986196231241),
    'freetone:873': (
        0.4409913026817005, 0.3712890278300538, 0.22591568129361939),
    'freetone:874': (
        0.445575740014581, 0.37529313593308977, 0.22939202627954813),
    'freetone:875': (
        0.4658442027954095, 0.35954049634117524, 0.2541584843305458),
    'freetone:876': (
        0.5022255578893535, 0.3378233544633247, 0.2520224173249872),
    'freetone:877': (
        0.46470390932404193, 0.5648405444368265, 0.5642880386659428),
    'freetone:Medium Yellow': (
        0.9732734623716385, 0.8908973815642793, 0.0),
    'freetone:Bright Orange': (
        1.0, 0.28067445755004883, 0.0001831650733947754),
    'freetone:Bright Red': (
        1.0, 0.15121692419052124, 0.1570153832435608),
    'freetone:Strong Red': (
        0.878222394904588, 0.0, 0.5953316740990661),
    'freetone:Pink': (
        0.8356908559799194, 0.11242848634719849, 1.0),
    'freetone:Medium Purple': (
        0.10207627754049814, 0.0, 0.9512775237213974),
    'freetone:Dark Blue': (
        0.0, 0.13952452257309644, 0.8309901083570379),
    'freetone:Medium Blue': (
        0.0, 0.7139629899340312, 0.9381210136560817),
    'freetone:Bright Green': (
        0.03360038995742798, 1.0, 0.4227359890937805),
    'freetone:Neutral Black': (
        0.05760819703111153, 0.07891931751008485, 0.08964574961933636),
    'freetone:100': (
        0.9217212200164795, 1.0, 0.2872053384780884),
    'freetone:101': (
        0.9228503853082657, 1.0, 0.21484708786010742),
    'freetone:102': (
        0.9416495002806187, 0.9602655097842216, 0.0),
    'freetone:103': (
        0.7020261859361954, 0.6937516070909169, 0.0),
    'freetone:104': (
        0.6080413964393876, 0.6116929728047009, 0.0),
    'freetone:105': (
        0.43684980922955674, 0.46591139641634527, 0.05078348935739996),
    'freetone:7401': (
        0.9503776617348194, 0.881223775446415, 0.5685359239578247),
    'freetone:7559': (
        0.47096280369167687, 0.351512417501354, 0.07846022580739742),
    'freetone:7558': (
        0.5024044822379867, 0.3889730095036672, 0.05740498437835306),
    'freetone:7557': (
        0.5434087692512044, 0.45050987011376087, 0.04289105624471645),
    'freetone:7556': (
        0.6510611895411405, 0.5158306132964245, 0.034653693354779413),
    'freetone:7555': (
        0.7874735535745678, 0.6007469317256309, 0.017882385736562867),
    'freetone:7554': (
        0.18032176723745863, 0.16597482307668088, 0.10681400943389718),
    'freetone:7553': (
        0.24210326567087215, 0.19814571721436636, 0.06730042752453258),
    'freetone:7552': (
        0.34792071346089415, 0.2541918380614838, 0.040734680012622704),
    'freetone:7551': (
        0.6430085821343452, 0.4506640861531901, 0.0),
    'freetone:7550': (
        0.7979961070928732, 0.5303528034808758, 0.0),
    'freetone:7549': (
        1.0, 0.677088588476181, 0.0),
    'freetone:7548': (
        1.0, 0.7590295374393463, 0.0),
    'freetone:126': (
        0.5243165014699773, 0.4202238291871332, 0.0),
    'freetone:125': (
        0.6491577183596702, 0.4798947926614727, 0.0),
    'freetone:124': (
        0.9248025477416486, 0.6332018517739373, 0.0),
    'freetone:123': (
        1.0, 0.7457846999168396, 0.13412684202194214),
    'freetone:122': (
        1.0, 0.8142366707324982, 0.19638365507125854),
    'freetone:121': (
        0.9848630502820015, 0.84841687977314, 0.2577553987503052),
    'freetone:120': (
        0.980285344645381, 0.8622110337018967, 0.3025254011154175),
    'freetone:1265': (
        0.4380009612832545, 0.3667975635105041, 0.057709626140340475),
    'freetone:1255': (
        0.6104432967440063, 0.4828321511669862, 0.04195573479208026),
    'freetone:1245': (
        0.7430799999965088, 0.5410806689074077, 0.01572822615352809),
    'freetone:E 1235': (
        1.0, 0.6650950014591217, 0.11538875102996826),
    'freetone:1225': (
        1.0, 0.7541771680116653, 0.20788896083831787),
    'freetone:1215': (
        0.9848976420550467, 0.8366206874773459, 0.36150900622643245),
    'freetone:1205': (
        0.9541313834488392, 0.8874494582414627, 0.46262305974960327),
    'freetone:133': (
        0.3184530806779904, 0.2762629508242753, 0.028521750858786277),
    'freetone:132': (
        0.5558718161007792, 0.40237752078780753, 0.0),
    'freetone:131': (
        0.7892387789964728, 0.4960473096884461, 0.0),
    'freetone:130': (
        0.9852395489224388, 0.6123687376145404, 0.0),
    'freetone:129': (
        0.9432399562702053, 0.8200290797249096, 0.17012370703580948),
    'freetone:128': (
        0.9444313493127876, 0.8542168396921357, 0.21907067332453298),
    'freetone:127': (
        0.9276310123014372, 0.8927279556755179, 0.32837554256223467),
    'freetone:119': (
        0.43581394141835794, 0.42353810266254754, 0.029653896654838974),
    'freetone:118': (
        0.600590977021731, 0.48641695228806014, 0.0),
    'freetone:117': (
        0.7538069810362746, 0.5734328126467925, 0.0),
    'freetone:116': (
        1.0, 0.8023346364498138, 0.043640851974487305),
    'freetone:115': (
        0.981109332293272, 0.8752422407269478, 0.11969178915023804),
    'freetone:114': (
        0.9671625867486, 0.8981002569198608, 0.18411540985107422),
    'freetone:113': (
        0.9629816152155399, 0.9110704213380814, 0.2371862530708313),
    'freetone:112': (
        0.5169107776011046, 0.5011648670949471, 0.0),
    'freetone:111': (
        0.5864927488995346, 0.522745990951393, 0.0),
    'freetone:110': (
        0.8205353075748237, 0.6625786392171711, 0.0),
    'freetone:109': (
        0.9995422293432057, 0.8285496383905411, 0.0),
    'freetone:108': (
        0.9801632724702358, 0.8907759264111519, 0.0025330185890197754),
    'freetone:107': (
        0.9632257595658302, 0.9246814697980881, 0.10949879884719849),
    'freetone:106': (
        0.9449149332940578, 0.948393989354372, 0.19699400663375854),
    'freetone:7407': (
        0.7599504849433141, 0.5943919392477555, 0.24545005488100102),
    'freetone:7406': (
        0.9369737187176225, 0.7758236725737027, 0.0),
    'freetone:7405': (
        0.9205535009643007, 0.8348491572740384, 0.0),
    'freetone:7404': (
        0.9342979729234678, 0.8919914041899363, 0.1801156065498253),
    'freetone:7403': (
        0.9230264986457096, 0.8328304539892117, 0.4321196800816016),
    'freetone:7402': (
        0.9029712235423912, 0.8608961541951163, 0.5219530160560766),
    'freetone:7560': (
        0.3905986474917995, 0.32565314540415624, 0.09786678520386438),
    'freetone:7561': (
        0.30963214332919886, 0.31165663045744907, 0.12920973778683198),
    'freetone:134': (
        1.0, 0.8024872243404388, 0.3482719659805298),
    'freetone:135': (
        1.0, 0.7318989932537079, 0.27365535497665405),
    'freetone:136': (
        1.0, 0.6983291506767273, 0.19351494312286377),
    'freetone:137': (
        1.0, 0.5630426704883575, 0.06414896249771118),
    'freetone:138': (
        0.9010501369579592, 0.4144110632733822, 0.0),
    'freetone:139': (
        0.6396078232352642, 0.3623215329972007, 0.0),
    'freetone:140': (
        0.348474768054416, 0.25435568302632916, 0.033084313860797465),
    'freetone:1345': (
        1.0, 0.7791714370250702, 0.4553292393684387),
    'freetone:1355': (
        1.0, 0.7230487763881683, 0.36807817220687866),
    'freetone:1365': (
        1.0, 0.641718178987503, 0.24069583415985107),
    'freetone:1375': (
        1.0, 0.5334096550941467, 0.11383235454559326),
    'freetone:1385': (
        0.846923823525778, 0.4020013737543311, 0.0),
    'freetone:1395': (
        0.5321739721062251, 0.29846145924588896, 0.009280751472928728),
    'freetone:1405': (
        0.32707428553527507, 0.21925577205203517, 0.04925371850016269),
    'freetone:141': (
        0.9547187008378817, 0.7594176686449622, 0.28476447241166636),
    'freetone:142': (
        0.9557112020107309, 0.7176330294792701, 0.2146697008138363),
    'freetone:143': (
        0.9727683828088849, 0.6626461574304353, 0.1457300467177457),
    'freetone:144': (
        0.9933800544412185, 0.46433086037558235, 0.0),
    'freetone:145': (
        0.8239861667505637, 0.432157601244763, 0.0),
    'freetone:146': (
        0.6054172018204129, 0.3559933137186988, 0.0),
    'freetone:147': (
        0.33752782918847757, 0.2960793830900421, 0.0824897076641129),
    'freetone:7408': (
        0.9708531195558899, 0.727655854505549, 0.038170124148043605),
    'freetone:7409': (
        0.9678293162448373, 0.660003539774686, 0.09681496058922337),
    'freetone:7410': (
        1.0, 0.5984130799770355, 0.4432135820388794),
    'freetone:7411': (
        0.9268835439853629, 0.5871574544917603, 0.3153492752110034),
    'freetone:7412': (
        0.8284639618515885, 0.4431658989302738, 0.13164512213175383),
    'freetone:7413': (
        0.8977890002363975, 0.4413524472055483, 0.13417235423490043),
    'freetone:7414': (
        0.7431170423046276, 0.34814459249099405, 0.0008976101252478053),
    'freetone:7562': (
        0.6803580776923717, 0.5774789876439073, 0.30005051562737606),
    'freetone:7563': (
        0.8230961573941431, 0.5651483147042777, 0.08865765509210277),
    'freetone:7564': (
        0.8734249241500857, 0.4822088156182125, 0.000239706364465464),
    'freetone:7565': (
        0.7932745441181321, 0.40976407020659433, 0.051608296960059974),
    'freetone:7566': (
        0.6422915651523811, 0.3112569683420059, 0.13494767720992407),
    'freetone:7567': (
        0.4537531509249959, 0.24232351306203626, 0.12876655992668518),
    'freetone:7568': (
        0.36501296878785006, 0.2326325383548884, 0.15467311289265595),
    'freetone:7569': (
        0.8563320945404124, 0.4702063300557846, 0.07040269872738758),
    'freetone:7570': (
        0.8382278063128383, 0.44891571128418284, 0.09399080596610809),
    'freetone:7571': (
        0.7649770225373524, 0.4217723592438265, 0.11510914089730306),
    'freetone:7572': (
        0.683134583966807, 0.3716648591565819, 0.12729719004627693),
    'freetone:7573': (
        0.5998370556154153, 0.3229521762890597, 0.08894893234308032),
    'freetone:7574': (
        0.5539841537651307, 0.3403876218056556, 0.15327188289238247),
    'freetone:7575': (
        0.41648976914434144, 0.28917358415189653, 0.13151092836794476),
    'freetone:712': (
        1.0, 0.7287556529045105, 0.5710383951663971),
    'freetone:713': (
        1.0, 0.6754406094551086, 0.4864271283149719),
    'freetone:714': (
        1.0, 0.581353485584259, 0.346196711063385),
    'freetone:715': (
        1.0, 0.46182960271835327, 0.13092243671417236),
    'freetone:716': (
        0.981656158730025, 0.38095712939158194, 0.0),
    'freetone:717': (
        0.8595850084905325, 0.28522492387044385, 0.0),
    'freetone:718': (
        0.7502692029334522, 0.21434663251953445, 0.0),
    'freetone:148': (
        1.0, 0.7486839294433594, 0.4927749037742615),
    'freetone:149': (
        1.0, 0.6938430070877075, 0.43274587392807007),
    'freetone:174': (
        0.5421658342908398, 0.11943241904396373, 0.06789698394446475),
    'freetone:173': (
        0.8643383472131438, 0.16676787863349896, 0.034361813701047295),
    'freetone:172': (
        1.0, 0.18579387664794922, 0.11145192384719849),
    'freetone:171': (
        1.0, 0.2529640793800354, 0.24612808227539062),
    'freetone:170': (
        1.0, 0.3937438130378723, 0.5176928639411926),
    'freetone:169': (
        1.0, 0.5987487733364105, 0.7331502437591553),
    'freetone:1685': (
        0.4436307486558304, 0.13083790722435573, 0.0712452734111455),
    'freetone:1675': (
        0.640964738236768, 0.16671141351774388, 0.0336643912916923),
    'freetone:1665': (
        0.954254821913054, 0.1649947448329248, 0.0),
    'freetone:1655': (
        1.0, 0.20926225185394287, 0.059571266174316406),
    'freetone:1645': (
        1.0, 0.31091785430908203, 0.23971927165985107),
    'freetone:1635': (
        1.0, 0.43271535634994507, 0.4578927755355835),
    'freetone:1625': (
        1.0, 0.5269092917442322, 0.5772030353546143),
    'freetone:7582': (
        0.29690496347704176, 0.19415669856088513, 0.1587139789690042),
    'freetone:7581': (
        0.44457342872934547, 0.19292228462070682, 0.1659862891875079),
    'freetone:7580': (
        0.7591315214579571, 0.21615354858818314, 0.14289271073463894),
    'freetone:7579': (
        0.9256287883284743, 0.2440408640992721, 0.10892790271110606),
    'freetone:7578': (
        0.9076022042870678, 0.32023579174226985, 0.12659218156806967),
    'freetone:7577': (
        0.9284180648880381, 0.40356354945946027, 0.1948804403841059),
    'freetone:7576': (
        0.8922944121216465, 0.44068354526811726, 0.2777822319088692),
    'freetone:168': (
        0.3559561511483391, 0.13324888829375325, 0.05570784854686295),
    'freetone:167': (
        0.7509381053479844, 0.23055357192170378, 0.014267136690650162),
    'freetone:166': (
        0.9759234796008944, 0.22232847285611823, 0.0),
    'freetone:165': (
        1.0, 0.2980087399482727, 0.13058674335479736),
    'freetone:164': (
        1.0, 0.382238507270813, 0.2642557621002197),
    'freetone:163': (
        1.0, 0.5043259561061859, 0.43646907806396484),
    'freetone:162': (
        1.0, 0.6611886918544769, 0.6281681656837463),
    'freetone:1615': (
        0.47521800265669434, 0.18957122349385713, 0.05347363626729518),
    'freetone:1605': (
        0.6064010814849317, 0.2448534164313525, 0.05206270053152284),
    'freetone:1595': (
        0.8968494795151967, 0.27627331439183145, 0.01496380681698728),
    'freetone:1585': (
        1.0, 0.32065314054489136, 0.09463649988174438),
    'freetone:1575': (
        1.0, 0.38489359617233276, 0.19974064826965332),
    'freetone:1565': (
        1.0, 0.5255970358848572, 0.4088502526283264),
    'freetone:1555': (
        1.0, 0.6398565769195557, 0.5570001006126404),
    'freetone:1545': (
        0.29412087694332634, 0.13476987037117993, 0.04311203047959111),
    'freetone:1535': (
        0.5211450274896858, 0.18329251267377877, 0.0),
    'freetone:1525': (
        0.7276047336799145, 0.18641423355303743, 0.0),
    'freetone:1505': (
        1.0, 0.32330816984176636, 0.0),
    'freetone:1495': (
        1.0, 0.46256202459335327, 0.13003742694854736),
    'freetone:1485': (
        1.0, 0.5856260061264038, 0.3622797131538391),
    'freetone:161': (
        0.27017021309390543, 0.15252518031741857, 0.07805566278373988),
    'freetone:160': (
        0.5882537638404246, 0.24314768899560502, 0.018520206496111413),
    'freetone:159': (
        0.8357626552713914, 0.27478831413336835, 0.0),
    'freetone:158': (
        0.9990234225988388, 0.3639277219772339, 0.08645766973495483),
    'freetone:157': (
        0.9718766929295446, 0.5522882827602985, 0.28479914567817244),
    'freetone:156': (
        0.9475425981004414, 0.6941025806583134, 0.4319910493161687),
    'freetone:155': (
        0.9409451414022307, 0.7976476670414699, 0.5738138616170465),
    'freetone:154': (
        0.5451389014827477, 0.27157018550653333, 0.007046897360190485),
    'freetone:153': (
        0.730432645445476, 0.33949160682142576, 0.0),
    'freetone:152': (
        0.9630296654719541, 0.3600000284690816, 0.0),
    'freetone:151': (
        1.0, 0.4135195016860962, 0.05517667531967163),
    'freetone:150': (
        1.0, 0.6217593848705292, 0.3181506395339966),
    'freetone:175': (
        0.3196155595765049, 0.11972587694890535, 0.12511415475682952),
    'freetone:7583': (
        0.7853920814622084, 0.28331568460745427, 0.11251377822170472),
    'freetone:7584': (
        0.7376271634879517, 0.24279837712788854, 0.08240400936708525),
    'freetone:7585': (
        0.6657028443496085, 0.263002199316805, 0.17588045396483487),
    'freetone:7586': (
        0.5770467621582398, 0.2281685721655169, 0.13860552673959958),
    'freetone:7587': (
        0.5083993475199833, 0.20085725353760608, 0.1315235848021814),
    'freetone:7588': (
        0.3926471027372287, 0.21016192318805338, 0.17251071601234003),
    'freetone:7589': (
        0.2534141506198253, 0.19460976811596709, 0.16551990682914663),
    'freetone:7590': (
        0.8047570239754849, 0.6686760024876564, 0.609692892291526),
    'freetone:7591': (
        0.7371086010108653, 0.4071892953650993, 0.3253987405025698),
    'freetone:7592': (
        0.6848838770855209, 0.23010323830088275, 0.16046670993913326),
    'freetone:7593': (
        0.5865802588939104, 0.15115832117358252, 0.1268151948817291),
    'freetone:7594': (
        0.4056875967879314, 0.12892597468960787, 0.14636565755406572),
    'freetone:7595': (
        0.3214283708809562, 0.14851959537867998, 0.15038089883087302),
    'freetone:7596': (
        0.24999093011513196, 0.15175474088867702, 0.1525518813734692),
    'freetone:7597': (
        0.884438539013323, 0.14876415819933098, 0.07093154246461586),
    'freetone:7598': (
        0.7652482407812682, 0.17026351667801842, 0.10281726554081017),
    'freetone:7599': (
        0.7075127935752479, 0.13105458094451627, 0.08070120604575237),
    'freetone:7600': (
        0.4890377576375595, 0.14784004192018507, 0.13278365336797648),
    'freetone:7601': (
        0.43091299940799743, 0.1627634159956557, 0.13217895996801587),
    'freetone:7602': (
        0.3850605438785628, 0.202748032060434, 0.1481997925412415),
    'freetone:7603': (
        0.29583025116462025, 0.16911040604802352, 0.14255528546072682),
    'freetone:7604': (
        0.8875363751701274, 0.8128378304036737, 0.8510854355255646),
    'freetone:7605': (
        0.8871160848302464, 0.66950930241968, 0.7411975894266727),
    'freetone:7606': (
        0.8580553825889962, 0.4786928294613313, 0.5953380924120228),
    'freetone:7607': (
        0.7643225146287203, 0.3220993357496993, 0.4105981713843554),
    'freetone:7608': (
        0.617760355099854, 0.17842159811510783, 0.23669496825705494),
    'freetone:7609': (
        0.4437332539137584, 0.1281972385562895, 0.19855317656529792),
    'freetone:7610': (
        0.3083313956023588, 0.11161753783113681, 0.180314306350283),
    'freetone:7611': (
        0.8602815423033761, 0.6896456935697542, 0.7065831533218603),
    'freetone:7612': (
        0.7661012522449879, 0.5347108030727794, 0.5768859824813826),
    'freetone:7613': (
        0.7020824396669578, 0.46399314929253066, 0.5202737832750408),
    'freetone:7614': (
        0.5651469525446258, 0.4265060118713695, 0.44421365665933354),
    'freetone:7615': (
        0.43565165186478083, 0.3285876353183639, 0.3591315314428698),
    'freetone:7616': (
        0.31318482720424967, 0.21517266638559107, 0.2736750243355779),
    'freetone:7617': (
        0.23183657725424922, 0.15504372565767355, 0.20726786616957327),
    'freetone:7520': (
        0.926097286753321, 0.6889818646956946, 0.708564108023212),
    'freetone:7521': (
        0.7181309882926827, 0.5575741027069818, 0.4920457748276015),
    'freetone:7522': (
        0.688617059956245, 0.3196972717913895, 0.33034216448622544),
    'freetone:7523': (
        0.6314183004053056, 0.266873031381353, 0.3612151238843557),
    'freetone:7524': (
        0.6001669835264121, 0.22313790868284755, 0.28379195562845183),
    'freetone:7525': (
        0.5410324147775825, 0.3278627121973088, 0.2804505716330752),
    'freetone:7526': (
        0.4749619947037562, 0.13302842422432626, 0.029084586068243823),
    'freetone:489': (
        0.9434418373091001, 0.700126501163239, 0.7231279835923031),
    'freetone:488': (
        0.9563592001795769, 0.6523995101451874, 0.6903029084205627),
    'freetone:487': (
        0.9660095318349505, 0.5626507658854231, 0.6142594597689043),
    'freetone:486': (
        0.9720670242844044, 0.45893214646443437, 0.5168246604012591),
    'freetone:485': (
        0.9758072591008204, 0.05472106288301626, 0.055207734783050966),
    'freetone:484': (
        0.5753616730878335, 0.08873499119472683, 0.08661156707915296),
    'freetone:483': (
        0.2968214456829088, 0.09810459083865908, 0.11825122143903855),
    'freetone:176': (
        1.0, 0.581170380115509, 0.8344091027975082),
    'freetone:177': (
        1.0, 0.37412071228027344, 0.675989955663681),
    'freetone:178': (
        1.0, 0.23416495323181152, 0.4576486349105835),
    'freetone:202': (
        0.4691532077022238, 0.04161414843225053, 0.2209122042203866),
    'freetone:201': (
        0.6011085129027891, 0.026537903322298995, 0.24369693195456055),
    'freetone:200': (
        0.781639158729136, 0.0, 0.21248142683576665),
    'freetone:199': (
        0.9366624919413237, 0.0, 0.24088159728504754),
    'freetone:198': (
        0.9770559744738434, 0.15169867759913402, 0.5315098089544373),
    'freetone:': (
        0.9652767937694776, 0.49863457028178715, 0.8258958962218305),
    'freetone:196': (
        0.9355153739452362, 0.7148088812828064, 0.873533234000206),
    'freetone:188': (
        0.381370520237283, 0.04736160016034319, 0.19802015487238123),
    'freetone:187': (
        0.6518737036414306, 2.560066317336407e-05, 0.18394276105369478),
    'freetone:': (
        0.8564430724061469, 0.0, 0.17981443114657125),
    'freetone:185': (
        1.0, 0.0, 0.187869131565094),
    'freetone:183': (
        1.0, 0.4776379466056824, 0.8706035017967224),
    'freetone:182': (
        1.0, 0.6307011544704437, 0.9137560129165649),
    'freetone:7421': (
        0.30649778637752867, 0.02839451393589343, 0.23548273190726832),
    'freetone:7420': (
        0.5817765639951498, 0.029062115007757683, 0.34023800060938925),
    'freetone:7419': (
        0.6616119021083993, 0.18885565107129487, 0.43419718621366155),
    'freetone:7418': (
        0.8407019078495335, 0.21880533869920704, 0.4228441233473035),
    'freetone:7417': (
        0.986799333195339, 0.18332827389995435, 0.22207291309523045),
    'freetone:7416': (
        0.9816224321823541, 0.29214790644768085, 0.34364789668154083),
    'freetone:7415': (
        0.915764293433183, 0.6645988659821671, 0.6700932753902062),
    'freetone:7631': (
        0.23124298928501474, 0.09376130005181338, 0.1503987160822895),
    'freetone:7630': (
        0.2833575889960471, 0.10855698171516792, 0.1721409403693599),
    'freetone:7629': (
        0.33032021036513104, 0.10985031419890845, 0.18508875432136662),
    'freetone:7628': (
        0.5967626979691454, 0.05690933524788111, 0.14352935817371293),
    'freetone:7627': (
        0.644778066549458, 0.06221580857592812, 0.13263861890961692),
    'freetone:7626': (
        0.8225103726394951, 0.10483448593365186, 0.08824473843379543),
    'freetone:7625': (
        0.9865876291972918, 0.1999113275956821, 0.2522436206825584),
    'freetone:7624': (
        0.44280653582529617, 0.07859073496484825, 0.1672159751171094),
    'freetone:7623': (
        0.49270753995247674, 0.060719057736434934, 0.15964452463708767),
    'freetone:7622': (
        0.5361443285657472, 0.04721374949393464, 0.17227420018370765),
    'freetone:7621': (
        0.6870036360260385, 0.01888735714938683, 0.13817159629306364),
    'freetone:7620': (
        0.7447914528661936, 0.07317545579662266, 0.14688075607809026),
    'freetone:7619': (
        0.7855885173439019, 0.1870058438629134, 0.19903364900765874),
    'freetone:7618': (
        0.7839308453115984, 0.3307233315896356, 0.29510517924033053),
    'freetone:1817': (
        0.2851264759553942, 0.11126344021707979, 0.19088875125209626),
    'freetone:1807': (
        0.6232625897391886, 0.09541353942229769, 0.24579546250023565),
    'freetone:1797': (
        0.8532063054195002, 0.09027053197442836, 0.24955748133437816),
    'freetone:1787': (
        1.0, 0.1265278458595276, 0.38712143898010254),
    'freetone:1777': (
        1.0, 0.2652628421783447, 0.686793327331543),
    'freetone:1767': (
        1.0, 0.5740596652030945, 0.8889448419213295),
    'freetone:1815': (
        0.4178752508488506, 0.051054518869275256, 0.15458171570465495),
    'freetone:1805': (
        0.6856785093395894, 0.053266922672207784, 0.17186819211694981),
    'freetone:1795': (
        0.910682998814168, 0.05454534359741914, 0.18017757851969407),
    'freetone:1788': (
        1.0, 0.08361947536468506, 0.2621805667877197),
    'freetone:1785': (
        1.0, 0.18072789907455444, 0.49704742431640625),
    'freetone:1775': (
        1.0, 0.4249332547187805, 0.7899443060159683),
    'freetone:1765': (
        1.0, 0.5157702267169952, 0.8551308512687683),
    'freetone:181': (
        0.4319327929183032, 0.10233522544899643, 0.16718566288375314),
    'freetone:180': (
        0.7675655238110967, 0.12392997842235554, 0.18659244426273425),
    'freetone:179': (
        0.9796749837696552, 0.13260090351104736, 0.1721828579902649),
    'freetone:189': (
        1.0, 0.5108568072319031, 0.9074082598090172),
    'freetone:190': (
        1.0, 0.3281605839729309, 0.8324864655733109),
    'freetone:191': (
        1.0, 0.15600824356079102, 0.6481574773788452),
    'freetone:192': (
        1.0, 0.015289545059204102, 0.3976196050643921),
    'freetone:193': (
        0.7962498815723349, 0.0, 0.3108256285946127),
    'freetone:194': (
        0.5800699458044702, 0.05186512026785728, 0.3414312738140781),
    'freetone:195': (
        0.38471240436389564, 0.09402543072439329, 0.28360047161907076),
    'freetone:1895': (
        1.0, 0.6061036288738251, 0.9528496228158474),
    'freetone:1915': (
        1.0, 0.18460369110107422, 0.778286412358284),
    'freetone:1925': (
        1.0, 0.0, 0.4733349084854126),
    'freetone:1935': (
        0.8305271012907444, 0.0, 0.34411689948541246),
    'freetone:1945': (
        0.6466999828640221, 0.0, 0.33230569647339436),
    'freetone:1955': (
        0.49061044830125233, 0.0, 0.28539807003819817),
    'freetone:705': (
        0.9765011072158813, 0.8011749535799026, 0.9266346246004105),
    'freetone:706': (
        0.9878843370825052, 0.7333638668060303, 0.9207751601934433),
    'freetone:707': (
        1.0, 0.6050660014152527, 0.8891279473900795),
    'freetone:708': (
        1.0, 0.4425727128982544, 0.8016021996736526),
    'freetone:709': (
        1.0, 0.2569009065628052, 0.6397345066070557),
    'freetone:710': (
        0.9831399578014024, 0.13264623050099178, 0.4222973525293236),
    'freetone:711': (
        0.8591912574313751, 0.06766152823050486, 0.17200774787334883),
    'freetone:698': (
        0.9645990692079067, 0.7771877646446228, 0.8882734477519989),
    'freetone:699': (
        0.9887083237990737, 0.6750133633613586, 0.8782635256648064),
    'freetone:7636': (
        0.7819218371843508, 0.020602101142793927, 0.4177279456063845),
    'freetone:7637': (
        0.5221156797656956, 0.07584308399101403, 0.3511931631740772),
    'freetone:7638': (
        0.4264877690612803, 0.07572504282859427, 0.3141869225453249),
    'freetone:217': (
        0.9396047927439213, 0.6583505272865295, 1.0),
    'freetone:218': (
        0.9268787726759911, 0.30566877126693726, 1.0),
    'freetone:219': (
        0.9474270076620734, 0.04149696207286796, 0.9998168917372823),
    'freetone:220': (
        0.6341829508359189, 0.0, 0.5295329709458745),
    'freetone:221': (
        0.5263088770044666, 0.0, 0.4482415548734142),
    'freetone:222': (
        0.3309958369390955, 0.026749634419445556, 0.379349583205034),
    'freetone:7639': (
        0.4923566998186719, 0.3469613094199353, 0.47961532781797134),
    'freetone:7640': (
        0.5225352901793592, 0.14163338410964244, 0.4137350374970987),
    'freetone:7641': (
        0.5057408067379985, 0.07034292089923255, 0.3775421880642451),
    'freetone:7642': (
        0.3563600698911982, 0.08487746557697484, 0.367883949887454),
    'freetone:7643': (
        0.299144076970407, 0.08868708591210428, 0.3169660464857893),
    'freetone:7644': (
        0.2346243695087864, 0.09149003762634322, 0.2696505991010234),
    'freetone:7645': (
        0.20201260468849114, 0.08761331285020901, 0.22828126561131512),
    'freetone:223': (
        0.9260242655873299, 0.4769360423088074, 1.0),
    'freetone:224': (
        0.8937056586146355, 0.3283131718635559, 1.0),
    'freetone:225': (
        0.8960250318050385, 0.09274435043334961, 1.0),
    'freetone:226': (
        0.872224964295413, 0.0, 0.8487778155098892),
    'freetone:227': (
        0.6553502936452675, 0.0, 0.6990951758668336),
    'freetone:228': (
        0.4742763230233038, 0.0, 0.5614888941007945),
    'freetone:229': (
        0.2969578737672407, 0.039820488392876996, 0.3610645419137768),
    'freetone:230': (
        0.9558403939008713, 0.546044111251831, 1.0),
    'freetone:231': (
        0.9024338200688362, 0.3640497922897339, 1.0),
    'freetone:232': (
        0.868436723947525, 0.18612957000732422, 1.0),
    'freetone:233': (
        0.8074213183672296, 0.0, 0.975749797069663),
    'freetone:234': (
        0.6010102086742983, 0.0, 0.7120941310906823),
    'freetone:235': (
        0.4458551722897246, 0.0, 0.5319496414136635),
    'freetone:670': (
        0.9255054593086243, 0.7796902507543564, 0.9601129181683064),
    'freetone:671': (
        0.9144884422421455, 0.6554818153381348, 0.9914549477398396),
    'freetone:672': (
        0.8952315598726273, 0.5262989401817322, 1.0),
    'freetone:673': (
        0.8725261390209198, 0.4100404381752014, 1.0),
    'freetone:674': (
        0.8023406674130357, 0.22216458597927, 0.9835512763973214),
    'freetone:675': (
        0.6751434105722112, 0.04589274701483248, 0.7906313350004339),
    'freetone:676': (
        0.5478640539223214, 0.0, 0.511472765963064),
    'freetone:677': (
        0.896910049021244, 0.7611963152885437, 0.9392080567777157),
    'freetone:678': (
        0.8918745741248131, 0.7300373911857605, 0.9308766350150108),
    'freetone:679': (
        0.8668192625045776, 0.6879225075244904, 0.9358510747551918),
    'freetone:680': (
        0.7778441738332552, 0.5047918099507118, 0.8831761269497701),
    'freetone:681': (
        0.6552699471978413, 0.3264884740835694, 0.8058946543850969),
    'freetone:682': (
        0.5426774627827611, 0.17887204981582183, 0.6985080792451606),
    'freetone:683': (
        0.40441847319276913, 0.05717742175046503, 0.48387112295806833),
    'freetone:684': (
        0.8845232488730382, 0.7246746390819274, 0.9112562412289413),
    'freetone:685': (
        0.8581429456295502, 0.6507267599740499, 0.895239289152082),
    'freetone:686': (
        0.8121959195617456, 0.5591487282907324, 0.8677621706239185),
    'freetone:687': (
        0.7211308636753533, 0.4408527717669124, 0.8207832950831901),
    'freetone:688': (
        0.609035723827332, 0.29936759991451845, 0.731888848398245),
    'freetone:689': (
        0.46040050917359787, 0.1327366296621495, 0.5788957364394309),
    'freetone:690': (
        0.2751600299585357, 0.049852532323033216, 0.3143365236990556),
    'freetone:510': (
        0.9320404614655057, 0.6734463476135251, 0.8772028863851933),
    'freetone:2405': (
        0.6149538457393646, 0.030243396759033203, 1.0),
    'freetone:2395': (
        0.6757763028144836, 0.09292745590209961, 1.0),
    'freetone:2385': (
        0.6928358972072601, 0.189120352268219, 1.0),
    'freetone:2375': (
        0.8005035519599915, 0.381567120552063, 1.0),
    'freetone:2365': (
        0.9420462362468243, 0.6387274265289307, 1.0),
    'freetone:242': (
        0.4147632199450184, 0.029831526331715708, 0.5913030275898716),
    'freetone:241': (
        0.6720100283409676, 0.022543212099063736, 0.999572747386992),
    'freetone:240': (
        0.721767008304596, 0.1255207657814026, 1.0),
    'freetone:239': (
        0.7582971006631851, 0.19363701343536377, 1.0),
    'freetone:238': (
        0.8099641501903534, 0.2837567925453186, 1.0),
    'freetone:237': (
        0.8765545189380646, 0.4228885769844055, 1.0),
    'freetone:236': (
        0.9183947518467903, 0.5618219375610352, 1.0),
    'freetone:4975': (
        0.13818177539584475, 0.061144708448139795, 0.10380881770533534),
    'freetone:4985': (
        0.44596466660009426, 0.199055801864354, 0.3470636277132293),
    'freetone:4995': (
        0.5330567997563129, 0.28974525232702497, 0.44613556959199663),
    'freetone:5005': (
        0.6347458164478037, 0.40091860663943546, 0.5552718308100602),
    'freetone:5015': (
        0.7728832711789886, 0.5727211708631696, 0.7126494389760276),
    'freetone:5025': (
        0.8429777441282296, 0.6650038851919596, 0.7918479639630429),
    'freetone:5035': (
        0.8621739593025278, 0.7198429869902493, 0.8023598340711733),
    'freetone:497': (
        0.2001330269752799, 0.10878065807276016, 0.1409047991421275),
    'freetone:498': (
        0.30496523804183084, 0.13151235192881927, 0.18177917148658196),
    'freetone:499': (
        0.37403540473092356, 0.15673997029021258, 0.2049144162791503),
    'freetone:500': (
        0.7531056174953854, 0.4441778915347092, 0.6351083034224694),
    'freetone:was 501': (
        0.8534230049131029, 0.5755545557720443, 0.7546514564299903),
    'freetone:502': (
        0.8948726320843591, 0.6714929515786183, 0.8273597573875193),
    'freetone:503': (
        0.9146105200052261, 0.711665540933609, 0.8329442292451859),
    'freetone:490': (
        0.25246521916052167, 0.08067313249641117, 0.15479810016202933),
    'freetone:491': (
        0.4159802822781842, 0.09749670704651336, 0.20780044378030027),
    'freetone:492': (
        0.5085467217949855, 0.09489563462722295, 0.2222941702579444),
    'freetone:493': (
        0.8806108216376941, 0.4253819835288445, 0.7298804209727776),
    'freetone:494': (
        0.9460811859136713, 0.535327970846551, 0.8196603718398643),
    'freetone:495': (
        0.9789425507187843, 0.6549019813537598, 0.8708171248435974),
    'freetone:496': (
        0.9645075164735317, 0.7021133899688721, 0.8878461942076683),
    'freetone:697': (
        0.46335380528738135, 0.1367990290586043, 0.3036702326236558),
    'freetone:NE 696': (
        0.5356709020936057, 0.17912583854427844, 0.3994482506389052),
    'freetone:695': (
        0.6762148242059507, 0.32122008239650635, 0.5691958548750495),
    'freetone:694': (
        0.7545018189764434, 0.43441060699913336, 0.6595079414783749),
    'freetone:693': (
        0.8487956414777298, 0.5633046790062112, 0.7630940518313453),
    'freetone:692': (
        0.8948786905252064, 0.6867546371221896, 0.8300167583428009),
    'freetone:691': (
        0.9159788674080632, 0.7598046841063592, 0.8561512440775618),
    'freetone:7435': (
        0.46104224011855877, 0.051139660457693026, 0.44673321571991664),
    'freetone:7434': (
        0.5697163491522668, 0.08612763175808702, 0.5021629476675047),
    'freetone:7433': (
        0.6393981379384486, 0.11195011832865198, 0.581560769792778),
    'freetone:7432': (
        0.7009084682652601, 0.25205121095790095, 0.702348273207045),
    'freetone:7431': (
        0.7912896470940103, 0.4014389155451614, 0.8033750130764169),
    'freetone:7430': (
        0.8738653272188435, 0.5804054945996379, 0.8845443467672482),
    'freetone:7429': (
        0.8936769832484761, 0.6691022275982966, 0.892273580724727),
    'freetone:504': (
        0.22256770471652132, 0.08243379232357029, 0.1840601615217281),
    'freetone:505': (
        0.3325623267710611, 0.08874889324483348, 0.2749993387339247),
    'freetone:506': (
        0.4415032194852131, 0.11098268325520166, 0.37886944088764096),
    'freetone:507': (
        0.8359071054037203, 0.4825092352378566, 0.8150234741187861),
    'freetone:508': (
        0.9059343749700212, 0.5796803325859239, 0.8431838378444958),
    'freetone:509': (
        0.9331756633079801, 0.6238309576899601, 0.8834998673586553),
    'freetone:2415': (
        0.5512149687221455, 0.0, 0.9647658536698631),
    'freetone:2425': (
        0.41771550406012636, 0.0, 0.6867039010710023),
    'freetone:243': (
        0.908964678645134, 0.6394598484039307, 1.0),
    'freetone:244': (
        0.8514381647109985, 0.5240406095981598, 1.0),
    'freetone:245': (
        0.7801480144262314, 0.41568630933761597, 1.0),
    'freetone:246': (
        0.6221561133861542, 0.1566491723060608, 1.0),
    'freetone:247': (
        0.6071717441082001, 0.11355769634246826, 1.0),
    'freetone:248': (
        0.5672541558742523, 0.05490201711654663, 1.0),
    'freetone:249': (
        0.41051066079813125, 0.03509855995147504, 0.7034303540829097),
    'freetone:7646': (
        0.5986404744585521, 0.34449132538880933, 0.6638061964831481),
    'freetone:7647': (
        0.6338021581092761, 0.1237902881783155, 0.7095628048851284),
    'freetone:7648': (
        0.5557600873718478, 0.017691909640419112, 0.6652962913871026),
    'freetone:7649': (
        0.47266091076352623, 0.0024316431607349642, 0.6335791378180877),
    'freetone:7650': (
        0.35029773361914707, 0.023646364437469813, 0.5214868661755752),
    'freetone:7651': (
        0.3071307379034467, 0.054601546365886655, 0.5290227633473741),
    'freetone:7652': (
        0.2545541020066189, 0.04898135168623696, 0.4398570242382327),
    'freetone:250': (
        0.8884870707988739, 0.6535896956920624, 1.0),
    'freetone:251': (
        0.8023041188716888, 0.5365529954433441, 1.0),
    'freetone:252': (
        0.6383306682109833, 0.32623791694641113, 1.0),
    'freetone:253': (
        0.5079881250858307, 0.1280232071876526, 1.0),
    'freetone:254': (
        0.4761730432510376, 0.07922488451004028, 1.0),
    'freetone:255': (
        0.33879505212688343, 0.0044370712783505795, 0.7298499532765511),
    'freetone:517': (
        0.9289539977908134, 0.7029068470001221, 0.9924925612285733),
    'freetone:516': (
        0.908812090754509, 0.6715953350067139, 1.0),
    'freetone:515': (
        0.8834821134805679, 0.5921568870544434, 1.0),
    'freetone:514': (
        0.8008087426424026, 0.4569466710090637, 1.0),
    'freetone:513': (
        0.4864970047714597, 0.1043626458301054, 0.9993286030367017),
    'freetone:512': (
        0.415610512289899, 0.08150695622831661, 0.7703351365859834),
    'freetone:511': (
        0.2642886327879186, 0.08251961991365064, 0.40956942687176845),
    'freetone:7436': (
        0.9414358772337437, 0.8095979392528534, 0.9884031433612108),
    'freetone:7437': (
        0.7847562432289124, 0.6216678321361542, 0.9735103379935026),
    'freetone:7438': (
        0.7966277599334717, 0.5446402728557587, 1.0),
    'freetone:7439': (
        0.6631113290786743, 0.46836042404174805, 0.968841077759862),
    'freetone:7440': (
        0.583847475425157, 0.39852398495191743, 0.8910715395459881),
    'freetone:7441': (
        0.4759289026260376, 0.29657435417175293, 1.0),
    'freetone:7442': (
        0.380773663520813, 0.190951406955719, 1.0),
    'freetone:2562': (
        0.8010834008455276, 0.5925536155700684, 1.0),
    'freetone:2572': (
        0.6913405060768127, 0.4770886301994324, 1.0),
    'freetone:2582': (
        0.4896315336227417, 0.2533608078956604, 1.0),
    'freetone:2592': (
        0.39969485998153687, 0.14953845739364624, 1.0),
    'freetone:2602': (
        0.37146568298339844, 0.07650876045227051, 1.0),
    'freetone:2612': (
        0.35752359884563234, 0.02113622837086543, 0.9752562285456549),
    'freetone:2622': (
        0.27754936307818046, 0.07716376350116061, 0.5937931017785072),
    'freetone:7653': (
        0.5071439531565591, 0.49922640660651707, 0.6340421728254726),
    'freetone:7654': (
        0.5802149989791512, 0.40120919700557334, 0.783000224593147),
    'freetone:7655': (
        0.5829680495364953, 0.2605952229673819, 0.8988723813490103),
    'freetone:7656': (
        0.4839415822537839, 0.11964346790502489, 0.8436621389043746),
    'freetone:7657': (
        0.3158349866826189, 0.05802379526044099, 0.5976771481777563),
    'freetone:7658': (
        0.305853873977604, 0.10257464029199514, 0.519510598645823),
    'freetone:7659': (
        0.24734463121512995, 0.12475491841935238, 0.4021662713075216),
    'freetone:524': (
        0.8164034485816956, 0.7311055362224579, 0.9373769760131836),
    'freetone:523': (
        0.7657435089349747, 0.6525520980358124, 0.9487602077424526),
    'freetone:2617': (
        0.10231792185123378, 0.0, 0.6258558097062101),
    'freetone:2607': (
        0.1261810090507538, 0.0, 0.7674555499555851),
    'freetone:2597': (
        0.1683923486552913, 0.0, 0.9945718125736969),
    'freetone:2587': (
        0.35162895917892456, 0.21109336614608765, 1.0),
    'freetone:2577': (
        0.5730220675468445, 0.4252689480781555, 1.0),
    'freetone:2567': (
        0.7158159911632538, 0.5725337862968445, 1.0),
    'freetone:7666': (
        0.25314886776980217, 0.2429597322728938, 0.43563364550815553),
    'freetone:7665': (
        0.24516238335022678, 0.10742469738639215, 0.6632754439502309),
    'freetone:7664': (
        0.2699160167089172, 0.07183252077449964, 0.7908103443333854),
    'freetone:7663': (
        0.2923726948523395, 0.0685518104375169, 0.7736579788578581),
    'freetone:7662': (
        0.3757156122060099, 0.15647881567377553, 0.8310090249696733),
    'freetone:7661': (
        0.47691499597294773, 0.3726711056212999, 0.7793462985582136),
    'freetone:7660': (
        0.5293412084481991, 0.5470141088603897, 0.7179479595019791),
    'freetone:2623': (
        0.23472745957178454, 0.0, 0.659396362702148),
    'freetone:2613': (
        0.26318372252842215, 0.0, 0.8265443244705953),
    'freetone:2603': (
        0.30786771309385275, 0.0011542417177806963, 0.9755571825127807),
    'freetone:2593': (
        0.382055401802063, 0.12286567687988281, 1.0),
    'freetone:2583': (
        0.5256275534629822, 0.29132527112960815, 1.0),
    'freetone:2573': (
        0.6635690927505493, 0.44724196195602417, 1.0),
    'freetone:2563': (
        0.7635461986064911, 0.5743953883647919, 1.0),
    'freetone:262': (
        0.1964968506496234, 0.059594756753377, 0.4096559296957487),
    'freetone:261': (
        0.2392735175151719, 0.0422738846195454, 0.5618415519790503),
    'freetone:260': (
        0.2692726771715126, 0.021955858745970502, 0.6528594152743259),
    'freetone:259': (
        0.2967104031931498, 0.0, 0.8479612663085268),
    'freetone:258': (
        0.4603646993637085, 0.188510000705719, 1.0),
    'freetone:257': (
        0.7571984529495239, 0.5659418702125549, 1.0),
    'freetone:256': (
        0.8312657475471497, 0.6949111223220825, 1.0),
    'freetone:525': (
        0.2081821261496808, 0.060521922376270965, 0.5528531264798442),
    'freetone:526': (
        0.3181506395339966, 0.07278555631637573, 1.0),
    'freetone:527': (
        0.3318837285041809, 0.1415732502937317, 1.0),
    'freetone:2705': (
        0.6014648675918579, 0.6339055597782135, 1.0),
    'freetone:528': (
        0.6292363107204437, 0.4401312470436096, 1.0),
    'freetone:529': (
        0.747707337141037, 0.5765316486358643, 1.0),
    'freetone:530': (
        0.8261081874370575, 0.6643015444278717, 1.0),
    'freetone:531': (
        0.8647440373897552, 0.7347677052021027, 1.0),
    'freetone:5115': (
        0.1999274644008331, 0.08333114291375843, 0.3131203799984039),
    'freetone:5125': (
        0.3069216483335282, 0.14024796216883573, 0.47903399911918676),
    'freetone:5135': (
        0.3965940090794007, 0.2487461134990987, 0.5853099712080945),
    'freetone:5145': (
        0.5406918688060234, 0.40882033529336326, 0.7067269477465723),
    'freetone:5155': (
        0.7081274398092008, 0.6085585559169022, 0.8192475493075805),
    'freetone:2685': (
        0.017214220492896004, 0.0, 0.6428293470635884),
    'freetone:5165': (
        0.803515610915537, 0.7265688835329782, 0.8753528423800221),
    'freetone:5175': (
        0.828316480720292, 0.7550023128342145, 0.8668725101445793),
    'freetone:5185': (
        0.17842031326674856, 0.1121884207341921, 0.2601956591988319),
    'freetone:5195': (
        0.2892247185060093, 0.18885312702773405, 0.3963863053728929),
    'freetone:5205': (
        0.43255757525468663, 0.32561184430182344, 0.5557422980887301),
    'freetone:5215': (
        0.6245483166815907, 0.5505090846006194, 0.7333595889525777),
    'freetone:5225': (
        0.736352493487864, 0.659526400194681, 0.8056248682696621),
    'freetone:5235': (
        0.7877358770683807, 0.7242153807780314, 0.8350891760941437),
    'freetone:5245': (
        0.8358422908099489, 0.7850092056051088, 0.8670961167924246),
    'freetone:518': (
        0.17505789135172023, 0.10367344854966021, 0.321573714557978),
    'freetone:519': (
        0.22450795258720646, 0.09351407185781113, 0.524659750348202),
    'freetone:520': (
        0.2606218262458331, 0.06442519061119123, 0.6716807412642947),
    'freetone:521': (
        0.591969364648256, 0.4358876598466348, 0.9498084996354546),
    'freetone:522': (
        0.6921645104885101, 0.5595941245555878, 0.9682917557656765),
    'freetone:2627': (
        0.07324879438581178, 0.0, 0.45773607368619906),
    'freetone:263': (
        0.8293736279010773, 0.7291523814201355, 1.0),
    'freetone:264': (
        0.712886244058609, 0.6100404560565948, 1.0),
    'freetone:265': (
        0.4089723229408264, 0.34161901473999023, 1.0),
    'freetone:266': (
        0.2630655765533447, 0.19464409351348877, 1.0),
    'freetone:267': (
        0.20083928108215332, 0.09375149011611938, 1.0),
    'freetone:268': (
        0.18930351727375588, 0.03744899475709762, 0.9487729597853686),
    'freetone:269': (
        0.16614831530633012, 0.04691248920285496, 0.6944157652403007),
    'freetone:2635': (
        0.7319600284099579, 0.6739452481269836, 1.0),
    'freetone:2645': (
        0.6196536421775818, 0.546623945236206, 1.0),
    'freetone:2655': (
        0.4767224192619324, 0.43247121572494507, 1.0),
    'freetone:2665': (
        0.3182421922683716, 0.2860151529312134, 1.0),
    'freetone:2695': (
        0.039708851443961635, 0.0, 0.3637744458280814),
    'freetone:270': (
        0.6625314950942993, 0.7057145237922668, 1.0),
    'freetone:271': (
        0.5255360007286072, 0.5790646374225616, 1.0),
    'freetone:272': (
        0.3669184446334839, 0.43628597259521484, 1.0),
    'freetone:273': (
        0.0, 0.002238195022782996, 0.5235085562171271),
    'freetone:274': (
        0.0, 0.0, 0.4295647160414777),
    'freetone:275': (
        0.0, 0.0, 0.36347352817502543),
    'freetone:276': (
        0.031177630790232058, 0.039059541008427345, 0.21865971700988496),
    'freetone:2715': (
        0.4599984884262085, 0.49893951416015625, 1.0),
    'freetone:2725': (
        0.2542458772659302, 0.32266730070114136, 1.0),
    'freetone:2735': (
        0.0, 0.011897671075773886, 0.7911779091206134),
    'freetone:2745': (
        0.0, 0.007295812875368846, 0.6297519635044542),
    'freetone:2755': (
        0.0, 0.003650957865870552, 0.525037869036209),
    'freetone:2765': (
        0.0, 0.0, 0.3560882499408704),
    'freetone:7667': (
        0.35246732487953514, 0.495225317981981, 0.7679483167860934),
    'freetone:7668': (
        0.31806030867705404, 0.42473072848325344, 0.834379281737382),
    'freetone:7669': (
        0.2818297321861929, 0.3322247322690532, 0.8999345308157991),
    'freetone:7670': (
        0.22061967582067935, 0.26845717118795875, 0.9088974653662432),
    'freetone:7671': (
        0.19221280003537577, 0.1967329772614992, 0.8455594928431504),
    'freetone:7672': (
        0.1584935474804261, 0.1734373125408306, 0.8388380704018941),
    'freetone:7673': (
        0.21088963403176786, 0.28318226306069616, 0.7377680850958259),
    'freetone:7443': (
        0.843717098236084, 0.8560769110918045, 0.9616388194262981),
    'freetone:7444': (
        0.6708934307098389, 0.7292134165763855, 0.9957274738699198),
    'freetone:7445': (
        0.5970489129164012, 0.6334226323414288, 0.8881298310789578),
    'freetone:7446': (
        0.4697642922401428, 0.5093614161014557, 1.0),
    'freetone:7447': (
        0.2524812804325194, 0.20513093360293055, 0.644710630429497),
    'freetone:7448': (
        0.17588856502931094, 0.14286026591355494, 0.3194418678868942),
    'freetone:7449': (
        0.14611896909068633, 0.08150009730650254, 0.2455882417500419),
    'freetone:7674': (
        0.4620812282496478, 0.5494557210917432, 0.8670381108742342),
    'freetone:7675': (
        0.4106037914559657, 0.4935448766832451, 0.8493622595455408),
    'freetone:7676': (
        0.36410460784803234, 0.3559327665543459, 0.9076696006209386),
    'freetone:7677': (
        0.3275334576147767, 0.24613515566224287, 0.8876052681376414),
    'freetone:7678': (
        0.2910787477008586, 0.20270690494990987, 0.9047282018250735),
    'freetone:7679': (
        0.1999809987466168, 0.14312336901464429, 0.829495228550431),
    'freetone:7680': (
        0.17360925816358952, 0.07312765389339226, 0.7949040909589339),
    'freetone:663': (
        0.8759136348962784, 0.8872053101658821, 0.9231555685400963),
    'freetone:664': (
        0.856142335239512, 0.8546775212929713, 0.9182446576483875),
    'freetone:665': (
        0.7372938769243667, 0.7252862554145616, 0.9021697331569835),
    'freetone:655': (
        0.0, 0.08295951238643795, 0.3747909310541253),
    'freetone:654': (
        0.0, 0.1683840940271395, 0.5660579387537048),
    'freetone:653': (
        0.1369900768463037, 0.3937840715973826, 0.7816879133302823),
    'freetone:652': (
        0.4311034213995901, 0.6660155800393659, 0.8683930481316745),
    'freetone:651': (
        0.6040088355966257, 0.7914750833549401, 0.9127552674128778),
    'freetone:650': (
        0.7708400189876556, 0.8903486728668213, 0.9324635714292526),
    'freetone:649': (
        0.8281529098749161, 0.9082017242908478, 0.93450827896595),
    'freetone:648': (
        0.0, 0.11833253290524937, 0.42088704364383744),
    'freetone:647': (
        0.10740058323330026, 0.3991774972150983, 0.7596785572278941),
    'freetone:646': (
        0.30948937190471926, 0.605990725520148, 0.8452398477047729),
    'freetone:645': (
        0.43303366520174524, 0.6990863099971311, 0.8763437587795047),
    'freetone:644': (
        0.555226508873324, 0.7868973833067666, 0.9053550467082283),
    'freetone:643': (
        0.7279011309146881, 0.8795452862977982, 0.9191882237792015),
    'freetone:642': (
        0.7906462252140045, 0.8977645561099052, 0.9236743748188019),
    'freetone:5395': (
        0.0, 0.07515147616840068, 0.15324441128514366),
    'freetone:5405': (
        0.24063623011562107, 0.48855217214619806, 0.5886718272464098),
    'freetone:5415': (
        0.2921325424462289, 0.5366374510695118, 0.6421229384488929),
    'freetone:5425': (
        0.410757117197889, 0.6483063255738997, 0.7165219189361041),
    'freetone:5435': (
        0.5935827041402899, 0.792432980062822, 0.8247359877588252),
    'freetone:5445': (
        0.6676915036453857, 0.8383779451269998, 0.8598276831776261),
    'freetone:5455': (
        0.6944287527786208, 0.8578237385644498, 0.8573365302478512),
    'freetone:546': (
        0.014100023321272914, 0.12160894564798852, 0.14416698655397298),
    'freetone:547': (
        0.0, 0.15176730599645083, 0.20002764016257402),
    'freetone:548': (
        0.0, 0.2207561552431372, 0.2814279001543092),
    'freetone:549': (
        0.37808424609684144, 0.7568966512632592, 0.7670918506254661),
    'freetone:550': (
        0.5031540424340971, 0.8331308215008285, 0.8189024605920391),
    'freetone:551': (
        0.5847364467080698, 0.8744316188851216, 0.844852856553652),
    'freetone:552': (
        0.677485316991806, 0.8995040878653526, 0.8751201704144478),
    'freetone:7547': (
        0.020695122174917202, 0.06935129126202, 0.1346115959976153),
    'freetone:7546': (
        0.060691110978950746, 0.16484561448351087, 0.2599844317946918),
    'freetone:7545': (
        0.16340579155816215, 0.30313048453823654, 0.4014080451447377),
    'freetone:7544': (
        0.37438068130220437, 0.5441813494912795, 0.5974105902700133),
    'freetone:7543': (
        0.5234947264594878, 0.6786437294713459, 0.7096908017520506),
    'freetone:7542': (
        0.5857839032600605, 0.806104641642136, 0.7811303491717368),
    'freetone:7541': (
        0.8173495084047318, 0.9097886681556702, 0.8901960849761963),
    'freetone:532': (
        0.03572512604962341, 0.0692168631958765, 0.14014961322972752),
    'freetone:533': (
        0.022494025204489176, 0.08968627531547924, 0.305794727278772),
    'freetone:534': (
        0.003501541481877979, 0.134685421424507, 0.4763946370156322),
    'freetone:535': (
        0.4891682479356713, 0.6606480574700926, 0.842377828439573),
    'freetone:536': (
        0.5768528322883677, 0.7412795212008731, 0.8572814338315625),
    'freetone:537': (
        0.6835294356859408, 0.8243434030285085, 0.8914614845604053),
    'freetone:538': (
        0.7276264727115631, 0.8533913195133209, 0.8889448419213295),
    'freetone:5255': (
        0.015661742178441074, 0.029013101480490633, 0.2234531127768946),
    'freetone:5265': (
        0.11927056643708767, 0.150786605805596, 0.4852367629871601),
    'freetone:5275': (
        0.23961288632383138, 0.27931941920561876, 0.5908938536755661),
    'freetone:5285': (
        0.47292097631429897, 0.5276785486271747, 0.7442997150189603),
    'freetone:5295': (
        0.6467973637892532, 0.6960490133773132, 0.8458536453570247),
    'freetone:5305': (
        0.7384277692588184, 0.7769152559996404, 0.8814552441038727),
    'freetone:5315': (
        0.8219272196292877, 0.8516518026590347, 0.908934161067009),
    'freetone:669': (
        0.10416245740463381, 0.06668344370917367, 0.4636625219052313),
    'freetone:668': (
        0.26527670674957093, 0.22767374258958029, 0.6468655495717179),
    'freetone:667': (
        0.39182953579608903, 0.3733138196952468, 0.7335482945584497),
    'freetone:666': (
        0.5722484602131406, 0.5526743615076324, 0.8431492078311198),
    'freetone:656': (
        0.8371557295322418, 0.9151598438620567, 0.9431143663823605),
    'freetone:657': (
        0.7494163513183594, 0.8883955180644989, 0.9719539191573858),
    'freetone:658': (
        0.651911199092865, 0.8457313030958176, 0.9910582136362791),
    'freetone:659': (
        0.43741512298583984, 0.7075761258602142, 1.0),
    'freetone:660': (
        0.23117423057556152, 0.5345388054847717, 1.0),
    'freetone:661': (
        0.0, 0.18404318080327675, 0.7712527892030591),
    'freetone:662': (
        0.0, 0.0831188543087924, 0.5385282484202403),
    'freetone:7450': (
        0.6986313931673103, 0.7960665888250603, 0.9255427845966879),
    'freetone:7451': (
        0.4874342083930969, 0.7201495468616486, 1.0),
    'freetone:7452': (
        0.4435187578201294, 0.6016480028629303, 1.0),
    'freetone:7453': (
        0.4406805634498596, 0.711238294839859, 1.0),
    'freetone:7454': (
        0.32670734927541556, 0.625885318239563, 0.827418550426118),
    'freetone:7455': (
        0.15152209997177124, 0.3610284924507141, 1.0),
    'freetone:7456': (
        0.29123371839523315, 0.4260319471359253, 1.0),
    'freetone:2706': (
        0.7589990198612213, 0.8460669964551926, 0.9839475098997355),
    'freetone:2716': (
        0.5729610323905945, 0.7065995335578918, 1.0),
    'freetone:2726': (
        0.17819488048553467, 0.34164953231811523, 1.0),
    'freetone:2736': (
        0.0025615020803108624, 0.1468278077990145, 0.9992065308615565),
    'freetone:2746': (
        0.0, 0.08916192122534916, 0.7884932011060036),
    'freetone:2756': (
        0.0, 0.06545046059297199, 0.55565134746272),
    'freetone:2766': (
        0.0, 0.0439335151720357, 0.3680439404154079),
    'freetone:2708': (
        0.676783412694931, 0.8451819717884064, 1.0),
    'freetone:2718': (
        0.3144884705543518, 0.5632257759571075, 1.0),
    'freetone:2728': (
        0.04287785291671753, 0.2853132486343384, 1.0),
    'freetone:2738': (
        0.0, 0.08390648611462481, 0.692270008847775),
    'freetone:2748': (
        0.0, 0.08193659275006304, 0.5274772007143911),
    'freetone:2758': (
        0.0, 0.07544945095268929, 0.45128618877875226),
    'freetone:2768': (
        0.0, 0.05808953770264225, 0.32392394480052644),
    'freetone:2707': (
        0.721095621585846, 0.8894026130437851, 0.9780575279146433),
    'freetone:2717': (
        0.6095521748065948, 0.8438391834497452, 1.0),
    'freetone:2727': (
        0.21344321966171265, 0.5086900293827057, 1.0),
    'freetone:2747': (
        0.0, 0.08259030944405588, 0.5377055606204815),
    'freetone:2757': (
        0.0, 0.07915480228324867, 0.4381925246659186),
    'freetone:2767': (
        0.0, 0.08478829602333349, 0.34782734135920634),
    'freetone:277': (
        0.6289311349391937, 0.8616617172956467, 0.9784237444400787),
    'freetone:278': (
        0.5067673921585083, 0.8093537837266922, 1.0),
    'freetone:279': (
        0.2658732533454895, 0.625452071428299, 1.0),
    'freetone:280': (
        0.0, 0.08163628751025342, 0.5106950665071803),
    'freetone:281': (
        0.0, 0.08234569451948381, 0.4033113837930724),
    'freetone:282': (
        0.0, 0.062051126035267856, 0.27404774608539206),
    'freetone:283': (
        0.5343862175941467, 0.8522621542215347, 1.0),
    'freetone:284': (
        0.40213626623153687, 0.7794461101293564, 1.0),
    'freetone:285': (
        0.08938735723495483, 0.5054245889186859, 1.0),
    'freetone:286': (
        0.0, 0.20401371899917464, 0.8151513299537338),
    'freetone:287': (
        0.0, 0.15258752186596913, 0.6604022341059634),
    'freetone:288': (
        0.0, 0.13133497245663683, 0.546535478535767),
    'freetone:289': (
        0.0, 0.07046847835445647, 0.2654140078905556),
    'freetone:7681': (
        0.522260023884397, 0.7005964445472246, 0.9164035876671955),
    'freetone:7682': (
        0.3465212868811607, 0.5672049758202977, 0.9014026459299855),
    'freetone:7683': (
        0.2002504212657532, 0.44911088804178667, 0.914632927360747),
    'freetone:7684': (
        0.13583126977285698, 0.3687755888572397, 0.8951631241523732),
    'freetone:7457': (
        0.6838330924510956, 0.9632257595658302, 0.9012741297483444),
    'freetone:7701': (
        0.017455244641372047, 0.36668327324425576, 0.5454014995182837),
    'freetone:7700': (
        0.0814836517675257, 0.37078395132004793, 0.5829263781928775),
    'freetone:7699': (
        0.15073576672338618, 0.4206662610157901, 0.5456623963424008),
    'freetone:7698': (
        0.20634562457253658, 0.5028402189116745, 0.6065809688045509),
    'freetone:7697': (
        0.2671017879877682, 0.6050378466074373, 0.6778736124372131),
    'freetone:7696': (
        0.33769083121911225, 0.7004437303047758, 0.7252294358541753),
    'freetone:7695': (
        0.4288058430699825, 0.7428627075557439, 0.7767040727637453),
    'freetone:3035': (
        0.0, 0.21998247866073584, 0.31742208927383064),
    'freetone:3125': (
        0.09115743637084961, 1.0, 0.7652857303619385),
    'freetone:3025': (
        0.0, 0.32069149577043987, 0.5098258970783442),
    'freetone:3015': (
        0.0, 0.45851933886219576, 0.7729248011822588),
    'freetone:3005': (
        0.0, 0.5966701180501337, 0.9990234225988388),
    'freetone:2995': (
        0.19330132007598877, 0.9216296672821045, 0.9856870379298925),
    'freetone:2985': (
        0.3777218461036682, 0.9812619220465422, 0.9613641574978828),
    'freetone:2975': (
        0.5535210371017456, 1.0, 0.9165331572294235),
    'freetone:7694': (
        0.0, 0.21704438682921268, 0.5284143110908923),
    'freetone:7693': (
        0.0, 0.26116772367889673, 0.6082450932122363),
    'freetone:7692': (
        0.013762476018834846, 0.3414953027959746, 0.7103885965024941),
    'freetone:7691': (
        0.005734017850092865, 0.43116670464172935, 0.7979215319588553),
    'freetone:7690': (
        0.09907058845341798, 0.5649616679631948, 0.8282259404829492),
    'freetone:7689': (
        0.21754918016601366, 0.6823132999187407, 0.907419856981991),
    'freetone:7688': (
        0.28148694293518484, 0.7163777648245595, 0.937593903955311),
    'freetone:303': (
        0.0, 0.11349860300402526, 0.2059361331331111),
    'freetone:302': (
        0.0, 0.1915321511790946, 0.4002183525100733),
    'freetone:301': (
        0.0, 0.2904605755655876, 0.6615538095771312),
    'freetone:300': (
        0.0, 0.4309227915858871, 0.9492895233700573),
    'freetone:299': (
        0.19226372241973877, 0.8458533734083176, 1.0),
    'freetone:298': (
        0.32236212491989136, 0.9219043329358101, 0.9801327548921108),
    'freetone:297': (
        0.4292973279953003, 0.967254139482975, 0.9575799219310284),
    'freetone:2965': (
        0.0, 0.09320738359387803, 0.23241733489875926),
    'freetone:2955': (
        0.0, 0.1732139681866478, 0.4511327192228807),
    'freetone:2945': (
        0.0, 0.30518645250456555, 0.7784840175981212),
    'freetone:2935': (
        0.0, 0.3801172230768258, 0.991647824011809),
    'freetone:2925': (
        0.22549784183502197, 0.7633325755596161, 1.0),
    'freetone:2915': (
        0.382177472114563, 0.8650797307491302, 0.9931334401480854),
    'freetone:2905': (
        0.5216602087020874, 0.9141222313046455, 0.9630121327936649),
    'freetone:296': (
        0.0, 0.06016987862103207, 0.15438921460194166),
    'freetone:295': (
        0.0, 0.10615599164642298, 0.35626971019739084),
    'freetone:294': (
        0.0, 0.13250927903804666, 0.50730162741214),
    'freetone:293': (
        0.0, 0.250848213332614, 0.8676921692647169),
    'freetone:292': (
        0.39890140295028687, 0.8365453630685806, 1.0),
    'freetone:291': (
        0.5604791343212128, 0.9147936254739761, 0.9798275735229254),
    'freetone:290': (
        0.677546352148056, 0.9353017508983612, 0.9410086236894131),
    'freetone:539': (
        0.0, 0.09259848301373097, 0.2098056004661295),
    'freetone:540': (
        0.0, 0.13485711294460145, 0.36357694233716487),
    'freetone:541': (
        0.0, 0.19388718584565368, 0.5223002626456963),
    'freetone:542': (
        0.44054667801534186, 0.78534552529103, 0.923490527521437),
    'freetone:543': (
        0.5914063862603058, 0.8746662229533806, 0.9433907582950671),
    'freetone:544': (
        0.6963454782962799, 0.8970931619405746, 0.936736099421978),
    'freetone:545': (
        0.7305257022380829, 0.9190051183104515, 0.9274280965328217),
    'freetone:7687': (
        0.005297285532353757, 0.20322174108721097, 0.8602160302719222),
    'freetone:7686': (
        0.039397658940163116, 0.28671878876412926, 0.8554376099703251),
    'freetone:7685': (
        0.09566881755718626, 0.3227766773589025, 0.8809703529444279),
    'freetone:7458': (
        0.4129932685890145, 0.8387511542372805, 0.8175626713365526),
    'freetone:7459': (
        0.2646914135318359, 0.725525089874513, 0.758718178818474),
    'freetone:7460': (
        0.0, 0.7391130150111307, 0.8477753452592164),
    'freetone:7461': (
        0.06817643522373268, 0.6312410106666679, 0.925666814460799),
    'freetone:7462': (
        0.0, 0.3415673003716502, 0.7492930967673594),
    'freetone:7463': (
        0.0, 0.10895911939790892, 0.2975942522157844),
    'freetone:304': (
        0.5639887154102325, 1.0, 0.8973067849874496),
    'freetone:305': (
        0.38687729835510254, 1.0, 0.9097276329994202),
    'freetone:306': (
        0.19775694608688354, 1.0, 0.9331349730491638),
    'freetone:307': (
        0.0, 0.5417306383744025, 0.7849490332428821),
    'freetone:308': (
        0.0, 0.3983807327990898, 0.5548098454416648),
    'freetone:309': (
        0.0, 0.21367794969588694, 0.2649884741520676),
    'freetone:635': (
        0.5967956185340881, 1.0, 0.8931868523359299),
    'freetone:636': (
        0.5109483599662781, 1.0, 0.8989242389798164),
    'freetone:637': (
        0.3611200451850891, 1.0, 0.8914168030023575),
    'freetone:638': (
        0.19378960132598877, 0.9781185630708933, 0.8932478874921799),
    'freetone:639': (
        0.015317728656426444, 0.8725480690579607, 0.8859206823647902),
    'freetone:640': (
        0.0, 0.7137235383912884, 0.8491127050109136),
    'freetone:641': (
        0.0, 0.5095447079806754, 0.7590115105398505),
    'freetone:7702': (
        0.3064246873459428, 0.8457983612781288, 0.8251917454743058),
    'freetone:7703': (
        0.18993670878972702, 0.8125872042846313, 0.8055056424562085),
    'freetone:7704': (
        0.0693013946480574, 0.6991431252263096, 0.7600001933419653),
    'freetone:7705': (
        0.018267944147707382, 0.5532781599226211, 0.68841055078888),
    'freetone:7706': (
        0.023841023743887302, 0.5139682782778525, 0.6525289011046009),
    'freetone:7707': (
        0.020775452783051485, 0.4388651418611418, 0.561251286352896),
    'freetone:7708': (
        0.00398002677093956, 0.3673330881094792, 0.4787845316194641),
    'freetone:628': (
        0.6725719273090363, 0.982787823304534, 0.8706950545310974),
    'freetone:629': (
        0.5573357939720154, 0.9831845592707396, 0.8541237562894821),
    'freetone:630': (
        0.4396429657936096, 0.9656061679124832, 0.8370641767978668),
    'freetone:631': (
        0.2983235077035239, 0.923969849181892, 0.8027549733127569),
    'freetone:632': (
        0.10626877112602617, 0.7972387548530305, 0.7472264335839557),
    'freetone:633': (
        0.0, 0.6036508758542025, 0.6587745631788469),
    'freetone:634': (
        0.0, 0.448396301684606, 0.5769015764041097),
    'freetone:310': (
        0.4230716824531555, 1.0, 0.864194706082344),
    'freetone:311': (
        0.29553675651550293, 1.0, 0.8598001152276993),
    'freetone:312': (
        0.07199209928512573, 1.0, 0.833615630865097),
    'freetone:313': (
        0.0, 0.8572200829248783, 0.7971755311700323),
    'freetone:314': (
        0.0, 0.7101331070901906, 0.6928247082417034),
    'freetone:315': (
        0.0, 0.518461859865333, 0.518317009983825),
    'freetone:316': (
        0.008789807532316729, 0.28451783113136386, 0.27017487397076323),
    'freetone:3105': (
        0.41766995191574097, 1.0, 0.8366063982248306),
    'freetone:3115': (
        0.2541238069534302, 1.0, 0.8065156042575836),
    'freetone:3135': (
        0.0, 0.8382782706509382, 0.6841403011021789),
    'freetone:3145': (
        0.0, 0.6507170894124821, 0.5597106651532489),
    'freetone:3155': (
        0.0, 0.48360888711726346, 0.43002838241994823),
    'freetone:3165': (
        0.0, 0.3430640388111694, 0.3100371252661649),
    'freetone:7709': (
        0.37074572623646596, 0.8757357729318839, 0.7318447811432744),
    'freetone:7710': (
        0.20161990967680454, 0.9140925286581096, 0.6999953441242297),
    'freetone:7711': (
        0.06541625363894693, 0.8813954792308354, 0.6625852542013394),
    'freetone:7712': (
        0.02026817423468419, 0.7302912688884213, 0.6247834981410614),
    'freetone:7713': (
        0.0016283184303480525, 0.678983476316422, 0.5334414852648077),
    'freetone:3255': (
        0.34174108505249023, 1.0, 0.6709544658660889),
    'freetone:3245': (
        0.4858167767524719, 1.0, 0.7485923767089844),
    'freetone:3302': (
        0.03225350649651659, 0.3165045468922578, 0.1921683788366444),
    'freetone:3292': (
        0.0, 0.41422179969623585, 0.23278933524772327),
    'freetone:3282': (
        0.0, 0.7906096605451308, 0.41205015372117826),
    'freetone:3272': (
        0.0, 1.0, 0.5191271901130676),
    'freetone:3262': (
        0.15378046035766602, 1.0, 0.6066224277019501),
    'freetone:3252': (
        0.3320974111557007, 1.0, 0.7000076472759247),
    'freetone:3242': (
        0.4561226963996887, 1.0, 0.7600366324186325),
    'freetone:330': (
        0.03964227227094952, 0.3538884768083763, 0.22273499971201183),
    'freetone:329': (
        0.0, 0.5319155676880221, 0.29011702387683425),
    'freetone:328': (
        0.0, 0.6310876700630192, 0.32068482782184926),
    'freetone:327': (
        0.0, 0.8133190481648399, 0.37398922187414607),
    'freetone:326': (
        0.1751430630683899, 1.0, 0.5951171219348907),
    'freetone:325': (
        0.4095826745033264, 1.0, 0.7299153208732605),
    'freetone:324': (
        0.5658503174781799, 1.0, 0.8068818300962448),
    'freetone:7722': (
        0.03974945530870855, 0.33301054933897944, 0.2544784929767161),
    'freetone:7721': (
        0.04135316844860881, 0.42427420471986466, 0.3094413641517235),
    'freetone:7720': (
        0.029064339056983357, 0.47293711230918767, 0.2912689476060635),
    'freetone:7719': (
        0.03235660981460775, 0.543345905756718, 0.34227619332528825),
    'freetone:7718': (
        0.008303056783508289, 0.6300833397507279, 0.3985715066168458),
    'freetone:7717': (
        0.05691666901549297, 0.7255531819242611, 0.43782047147664827),
    'freetone:7716': (
        0.15221700230381874, 0.8166276551518521, 0.517141399929856),
    'freetone:5463': (
        0.009798783844182424, 0.10478363767753507, 0.13259019732697652),
    'freetone:5473': (
        0.08142051281908635, 0.4030366728240118, 0.37497919217686615),
    'freetone:5483': (
        0.25619174144664747, 0.6095324171952576, 0.5496722841687651),
    'freetone:5493': (
        0.4320584201797917, 0.7625210807759957, 0.6800050321405601),
    'freetone:5503': (
        0.5149133696621147, 0.8213510709520123, 0.7375639884860021),
    'freetone:5513': (
        0.6137662423129766, 0.8652467550356594, 0.7887329959773637),
    'freetone:5523': (
        0.6637449504161502, 0.8900565881510646, 0.8159194869327075),
    'freetone:7477': (
        0.08694472132782849, 0.28369955465676, 0.3399485549743009),
    'freetone:7476': (
        0.05882057029810639, 0.3317063614465603, 0.2937914777427304),
    'freetone:7475': (
        0.2202522569665053, 0.5430493736436697, 0.45379018208437305),
    'freetone:7474': (
        0.04384857300171596, 0.6019943149431497, 0.4931678855430559),
    'freetone:7473': (
        0.20190592731474333, 0.8155271860350284, 0.47941079756048555),
    'freetone:7472': (
        0.35230034589767456, 0.9514457955956459, 0.65108722448349),
    'freetone:7471': (
        0.4869154095649719, 1.0, 0.7574120759963989),
    'freetone:7470': (
        0.013813320127784579, 0.3930157012721569, 0.45740283556495953),
    'freetone:7469': (
        0.0, 0.4338921515881644, 0.6259104637496691),
    'freetone:7468': (
        0.06098397095475949, 0.5654758546202914, 0.6904859140471131),
    'freetone:7467': (
        0.0010986924171447754, 1.0, 0.6456244885921478),
    'freetone:7466': (
        0.09225606918334961, 1.0, 0.6839856803417206),
    'freetone:7465': (
        0.32071417570114136, 1.0, 0.590081661939621),
    'freetone:7464': (
        0.5772030353546143, 0.9659113474190235, 0.7606164664030075),
    'freetone:323': (
        0.0, 0.4554739011081388, 0.33399406778347185),
    'freetone:322': (
        0.0, 0.6076253101835567, 0.43544453564966545),
    'freetone:321': (
        0.0, 0.8404324517689763, 0.5609177212404992),
    'freetone:320': (
        0.0, 0.9945983062498271, 0.6258373688734433),
    'freetone:319': (
        0.3301137089729309, 1.0, 0.7704432755708694),
    'freetone:318': (
        0.5120165050029755, 1.0, 0.8209201246500015),
    'freetone:317': (
        0.6457770764827728, 1.0, 0.8519264608621597),
    'freetone:7715': (
        0.021622218420489503, 0.46338379082572434, 0.36819017755531647),
    'freetone:7714': (
        0.010108275436692793, 0.6283601151262204, 0.48151799181366783),
    'freetone:3265': (
        0.19934391975402832, 1.0, 0.5848935842514038),
    'freetone:3275': (
        0.043305158615112305, 1.0, 0.4884413480758667),
    'freetone:3285': (
        0.017168345244557154, 0.9240706967568705, 0.42138196476835266),
    'freetone:3295': (
        0.0, 0.6540666936165893, 0.3045862321610535),
    'freetone:3305': (
        0.038500643011621705, 0.3193502603943186, 0.17779906956171132),
    'freetone:3248': (
        0.4235599637031555, 1.0, 0.641046792268753),
    'freetone:3258': (
        0.344792902469635, 1.0, 0.6106508076190948),
    'freetone:3268': (
        0.13449305295944214, 1.0, 0.4544747471809387),
    'freetone:3278': (
        0.01917652260605504, 0.9824687838971936, 0.346122439528717),
    'freetone:3288': (
        0.0, 0.7588850865728948, 0.28445203571706346),
    'freetone:3298': (
        0.007923052161276978, 0.5335194966274579, 0.2191339180087457),
    'freetone:3308': (
        0.03831722602829046, 0.26162010574298833, 0.13214778755936862),
    'freetone:566': (
        0.6591439843177795, 0.9815365839749575, 0.7812466621398926),
    'freetone:565': (
        0.5698786973953247, 1.0, 0.7395590245723724),
    'freetone:564': (
        0.4706187844276428, 0.9911192497238517, 0.6812390387058258),
    'freetone:563': (
        0.3847292667387706, 0.9586798292969124, 0.6286067449219841),
    'freetone:562': (
        0.05896166778515166, 0.5510449196586893, 0.30789462588581884),
    'freetone:561': (
        0.05581403865604884, 0.3950542063121869, 0.22057555290687603),
    'freetone:560': (
        0.05847092122293063, 0.20369020658060677, 0.12991006265432148),
    'freetone:573': (
        0.6539559066295624, 1.0, 0.7977874428033829),
    'freetone:572': (
        0.591302365064621, 1.0, 0.7611047625541687),
    'freetone:571': (
        0.545281171798706, 1.0, 0.7433432638645172),
    'freetone:570': (
        0.4137331247329712, 1.0, 0.6533455550670624),
    'freetone:569': (
        0.036543286658422325, 0.717587864839158, 0.34246001511431245),
    'freetone:568': (
        0.06098125906024521, 0.5289382253352617, 0.2676320469865985),
    'freetone:567': (
        0.052406463380805235, 0.2148069923998719, 0.13115848308345335),
    'freetone:559': (
        0.6266796041259054, 0.8965589539081441, 0.6842108595318042),
    'freetone:558': (
        0.5431522723990917, 0.8660297352836542, 0.6257686118820379),
    'freetone:557': (
        0.4594075399830704, 0.8222863631277308, 0.5495459788109157),
    'freetone:556': (
        0.37691898469215745, 0.7662587719061443, 0.4707885896467685),
    'freetone:555': (
        0.14062058088279805, 0.5335288581968443, 0.20359938965230118),
    'freetone:554': (
        0.09434156909333602, 0.39087251243362786, 0.1490438002744856),
    'freetone:553': (
        0.09254903092178779, 0.2507064808155093, 0.12026668098673099),
    'freetone:5595': (
        0.6876733495809515, 0.8738572174775684, 0.7428097291458144),
    'freetone:5585': (
        0.5870050150609668, 0.8264841596202274, 0.6645268778775028),
    'freetone:5575': (
        0.49546521458176906, 0.7518285217996068, 0.604792342649441),
    'freetone:5565': (
        0.4187274479220715, 0.6947558165719026, 0.5374991685199448),
    'freetone:5555': (
        0.27657906153684486, 0.5568789418161333, 0.3843197986150315),
    'freetone:5545': (
        0.18809874613029365, 0.4425744163135228, 0.2851203799620876),
    'freetone:5535': (
        0.04558301434011369, 0.1462251775464729, 0.09979007006761265),
    'freetone:5665': (
        0.6750011689030799, 0.824487887119344, 0.7117651161158123),
    'freetone:5655': (
        0.6288076411696379, 0.7967809670502302, 0.6611776568669321),
    'freetone:5645': (
        0.5729552597532613, 0.7553275831227633, 0.6145243413352858),
    'freetone:5635': (
        0.5032521487590562, 0.7012855983617441, 0.5576332155727022),
    'freetone:5625': (
        0.34987444097456244, 0.5548718579825795, 0.3907705071673373),
    'freetone:5615': (
        0.2742455745286101, 0.46853327333707195, 0.31294115597919614),
    'freetone:5605': (
        0.06919741462473183, 0.17185255285976098, 0.10246230122390187),
    'freetone:5527': (
        0.6807307517958266, 0.8420466325829001, 0.7659485281071567),
    'freetone:5517': (
        0.6314546340736515, 0.8133836668359751, 0.7294418181919315),
    'freetone:5507': (
        0.5407232816760643, 0.7420962911770801, 0.6623229389924462),
    'freetone:5497': (
        0.4336441600153993, 0.6411424339065499, 0.5641355809785267),
    'freetone:5487': (
        0.2827135020771223, 0.4930411833218553, 0.42398721048978416),
    'freetone:5477': (
        0.16537658366334718, 0.35363821287383335, 0.28985253290311164),
    'freetone:7480': (
        0.17065691947937012, 1.0, 0.2834821343421936),
    'freetone:7479': (
        0.3013046979904175, 1.0, 0.3291371464729309),
    'freetone:7478': (
        0.5572747588157654, 1.0, 0.6484932005405426),
    'freetone:357': (
        0.0766472668783944, 0.3702701433558664, 0.07308829583674203),
    'freetone:356': (
        0.04034462628975355, 0.6725405935381678, 0.0),
    'freetone:355': (
        0.03708546522911832, 0.9579746065875192, 0.0),
    'freetone:354': (
        0.09570461511611938, 1.0, 0.04846268892288208),
    'freetone:353': (
        0.4749828577041626, 1.0, 0.5323415100574493),
    'freetone:352': (
        0.52083620429039, 1.0, 0.5780880451202393),
    'freetone:351': (
        0.590051144361496, 1.0, 0.6318608522415161),
    'freetone:350': (
        0.1003481352611324, 0.32242341363023286, 0.1042986868858975),
    'freetone:349': (
        0.07450112091844652, 0.5136003792944752, 0.05543140413363279),
    'freetone:348': (
        0.05337538888768645, 0.755430360251067, 0.03307330885662374),
    'freetone:347': (
        0.06507576660008343, 0.9751465405460039, 0.04439893249082638),
    'freetone:346': (
        0.41553372144699097, 1.0, 0.48059821128845215),
    'freetone:345': (
        0.5246204435825348, 1.0, 0.580895721912384),
    'freetone:344': (
        0.5717402994632721, 1.0, 0.6148012578487396),
    'freetone:3435': (
        0.05376800583502117, 0.2707801431119403, 0.11083062624932438),
    'freetone:3425': (
        0.02764487166054863, 0.4792321798031054, 0.1251752698637283),
    'freetone:3415': (
        0.0016714162614972494, 0.6542961088341281, 0.13893761020351558),
    'freetone:3405': (
        0.045960187911987305, 1.0, 0.24917984008789062),
    'freetone:3395': (
        0.17630279064178467, 1.0, 0.3983520269393921),
    'freetone:3385': (
        0.3620966076850891, 1.0, 0.5544670820236206),
    'freetone:3375': (
        0.4742809534072876, 1.0, 0.6450141370296478),
    'freetone:7729': (
        0.03475859345994259, 0.3944585222200159, 0.16825274545555047),
    'freetone:7728': (
        0.040685673786811094, 0.5110994139453169, 0.14455085599502127),
    'freetone:7727': (
        0.01913969945659133, 0.577975650571604, 0.13215241362191676),
    'freetone:7726': (
        0.007136349050995694, 0.6926446882351067, 0.14234318230977427),
    'freetone:7725': (
        0.03591787817619352, 0.783587160112734, 0.1868484029412545),
    'freetone:7724': (
        0.15319565204541785, 0.8386733665395663, 0.3110144803478624),
    'freetone:7723': (
        0.29541820082009074, 0.8750054689222977, 0.43414020407412934),
    'freetone:343': (
        0.063956818358605, 0.3680997459209223, 0.15049091172122786),
    'freetone:342': (
        0.034086609205523644, 0.5058256314322103, 0.1608234959073087),
    'freetone:341': (
        0.033602697342566046, 0.6623590983687144, 0.19043312827417935),
    'freetone:340': (
        0.019572911122816283, 0.9479266630349321, 0.21017951802171125),
    'freetone:339': (
        0.19769591093063354, 1.0, 0.41721218824386597),
    'freetone:338': (
        0.4236515164375305, 1.0, 0.6041504740715027),
    'freetone:337': (
        0.5192492604255676, 1.0, 0.6616769731044769),
    'freetone:336': (
        0.02082225735726695, 0.4975351736928202, 0.21190468674370244),
    'freetone:335': (
        0.0, 0.6928207534878056, 0.268520022765105),
    'freetone:334': (
        0.0, 0.9734918376358223, 0.3566493926811585),
    'freetone:333': (
        0.3663080930709839, 1.0, 0.651422917842865),
    'freetone:332': (
        0.5236438810825348, 1.0, 0.7286946177482605),
    'freetone:331': (
        0.616327166557312, 1.0, 0.78237584233284),
    'freetone:627': (
        0.04034758684117179, 0.15663151087970562, 0.10606567531389999),
    'freetone:626': (
        0.10559002758991021, 0.38991473889834705, 0.22430138360210883),
    'freetone:625': (
        0.24475850286579615, 0.5749338971871953, 0.38051339608797363),
    'freetone:624': (
        0.39845680351357204, 0.7220462674268848, 0.5311268901448429),
    'freetone:623': (
        0.538474809874615, 0.8326891115361921, 0.6503629376351197),
    'freetone:622': (
        0.6586058841170033, 0.8889378139375435, 0.7396187790238908),
    'freetone:621': (
        0.7673304378986359, 0.9465629085898399, 0.8204013258218765),
    'freetone:5467': (
        0.052718791160817347, 0.15604642872359165, 0.12257848696015117),
    'freetone:7481': (
        0.1414206624031067, 1.0, 0.13449305295944214),
    'freetone:7482': (
        0.07853192209952384, 0.9997253376059234, 0.10754658470276734),
    'freetone:7483': (
        0.09684755720712701, 0.40998996088546846, 0.10083282321488696),
    'freetone:7484': (
        0.04737047440021769, 0.38249589575219023, 0.14507206870123746),
    'freetone:7730': (
        0.2576510370780727, 0.7643978655468325, 0.26171658929533326),
    'freetone:7731': (
        0.15209524183323708, 0.7232535455655036, 0.12268581990939254),
    'freetone:7732': (
        0.07167127854258304, 0.6470717719566959, 0.06309725094891494),
    'freetone:7733': (
        0.07179409911981605, 0.5606270860895761, 0.11594127759414441),
    'freetone:7734': (
        0.1107202293265317, 0.42857539365478203, 0.1435515301494732),
    'freetone:7735': (
        0.1354307975687341, 0.341561386992991, 0.1414895091243764),
    'freetone:7736': (
        0.13681208147827562, 0.3263442879368412, 0.1751222483238628),
    'freetone:7737': (
        0.3542113066902064, 0.8628459988305538, 0.04826585133622496),
    'freetone:7738': (
        0.2541997817451654, 0.8977966704810998, 0.05791355078255564),
    'freetone:7739': (
        0.20106613023235842, 0.8714326369626096, 0.05630337786267153),
    'freetone:7740': (
        0.19697030691601491, 0.7806298751447913, 0.057570556144572294),
    'freetone:7741': (
        0.21130623937995674, 0.6964092732778908, 0.07392501342657587),
    'freetone:7742': (
        0.2065462023744562, 0.5526870793871255, 0.08119984246891399),
    'freetone:7743': (
        0.1736601695345641, 0.4597178072670367, 0.11633183567787597),
    'freetone:358': (
        0.6009765863418579, 1.0, 0.45081257820129395),
    'freetone:359': (
        0.5643244087696075, 1.0, 0.3976806402206421),
    'freetone:360': (
        0.38364237546920776, 1.0, 0.1426413655281067),
    'freetone:361': (
        0.2677653431892395, 1.0, 0.0),
    'freetone:362': (
        0.26286298485044507, 0.8619532570647787, 0.0),
    'freetone:363': (
        0.2369482222477295, 0.7170025642873874, 0.0),
    'freetone:364': (
        0.20700048960821782, 0.5527639744180002, 0.0),
    'freetone:7485': (
        0.7631494700908661, 0.9497062638401985, 0.6712596416473389),
    'freetone:7486': (
        0.6622873544692993, 1.0, 0.4700084328651428),
    'freetone:7487': (
        0.4909743070602417, 1.0, 0.2558022737503052),
    'freetone:7488': (
        0.41611355543136597, 1.0, 0.14520490169525146),
    'freetone:7489': (
        0.377038346840336, 0.8769506830198559, 0.16286162151924466),
    'freetone:7490': (
        0.36217797331870627, 0.7357838009909358, 0.14866419252710128),
    'freetone:7491': (
        0.3698779489613191, 0.5738275099366064, 0.10421396737072541),
    'freetone:365': (
        0.6835889220237732, 1.0, 0.4231022000312805),
    'freetone:366': (
        0.6334477961063385, 1.0, 0.3598077893257141),
    'freetone:367': (
        0.5579156279563904, 1.0, 0.2534828782081604),
    'freetone:368': (
        0.40003055334091187, 1.0, 0.0),
    'freetone:369': (
        0.3274579604624785, 0.9104138160870752, 0.0),
    'freetone:370': (
        0.3058359363865075, 0.683714044452403, 0.0),
    'freetone:371': (
        0.224386409658635, 0.38578559496011255, 0.0),
    'freetone:372': (
        0.7555504739284515, 1.0, 0.44733351469039917),
    'freetone:373': (
        0.7200274765491486, 1.0, 0.38812851905822754),
    'freetone:374': (
        0.6801098883152008, 1.0, 0.30716413259506226),
    'freetone:375': (
        0.49768829345703125, 1.0, 0.0),
    'freetone:376': (
        0.4272221326828003, 1.0, 0.0),
    'freetone:377': (
        0.38215176453449295, 0.7497176218974302, 0.0),
    'freetone:378': (
        0.23923937383242588, 0.3801656505412119, 0.0),
    'freetone:580': (
        0.7066300511360168, 0.9391470216214657, 0.5602655112743378),
    'freetone:579': (
        0.6790773986524681, 0.9270906592172063, 0.5210871526244476),
    'freetone:578': (
        0.65200275182724, 0.9325856417417526, 0.4930495619773865),
    'freetone:577': (
        0.5926226113883013, 0.9033578315442217, 0.38736868930246204),
    'freetone:576': (
        0.3869742866391561, 0.7492742633057643, 0.1461283420191659),
    'freetone:575': (
        0.3137121119327446, 0.5797144081025865, 0.09382885166258692),
    'freetone:574': (
        0.1986673626999007, 0.33978860848785786, 0.08604888457853832),
    'freetone:584': (
        0.7586938291788101, 0.959899291396141, 0.22290384769439697),
    'freetone:585': (
        0.8063324987888336, 0.9679865725338459, 0.3284962773323059),
    'freetone:586': (
        0.8312352299690247, 0.9743648432195187, 0.37036699056625366),
    'freetone:587': (
        0.8374914228916168, 0.9728999771177769, 0.4411993622779846),
    'freetone:392': (
        0.401758796769367, 0.48575076274660267, 0.0),
    'freetone:391': (
        0.5030866216594145, 0.6415540512062041, 0.0),
    'freetone:390': (
        0.6219521372477833, 0.888795089951671, 0.0),
    'freetone:389': (
        0.7060502171516418, 1.0, 0.0),
    'freetone:388': (
        0.7889372110366821, 1.0, 0.12268257141113281),
    'freetone:387': (
        0.803372249007225, 1.0, 0.16134893894195557),
    'freetone:386': (
        0.8588845729827881, 1.0, 0.32596325874328613),
    'freetone:385': (
        0.3603919395629198, 0.4334189698808686, 0.00924780494174371),
    'freetone:384': (
        0.48521476964712784, 0.6386461958431731, 0.0),
    'freetone:383': (
        0.5742400088048927, 0.7886413417504219, 0.0),
    'freetone:382': (
        0.6705577373504639, 1.0, 0.0),
    'freetone:381': (
        0.710994154214859, 1.0, 0.015411615371704102),
    'freetone:380': (
        0.773311972618103, 1.0, 0.191103994846344),
    'freetone:379': (
        0.8160372376441956, 1.0, 0.3002975583076477),
    'freetone:7750': (
        0.28509974594842546, 0.3850727948920607, 0.10793104843262569),
    'freetone:7749': (
        0.3400023304769917, 0.4555624090468271, 0.09736088668132936),
    'freetone:7748': (
        0.38277684342528673, 0.5287901486046689, 0.08108188903208458),
    'freetone:7747': (
        0.43799754084283826, 0.5986266444625077, 0.06504515807783662),
    'freetone:7746': (
        0.5110945761016479, 0.6736245055603127, 0.06743297369040668),
    'freetone:7745': (
        0.5813006772750153, 0.7697454868295704, 0.021754859353889877),
    'freetone:7744': (
        0.646501117303466, 0.8500556418793446, 0.017445842929175837),
    'freetone:7498': (
        0.24890628065486986, 0.36729276491407603, 0.10811022454445407),
    'freetone:7497': (
        0.3713441200132124, 0.4143932173621323, 0.2745962747358277),
    'freetone:7496': (
        0.3627437610114015, 0.6114766685324735, 0.0),
    'freetone:7495': (
        0.46609068246891616, 0.6775799978204833, 0.11576201104849249),
    'freetone:7494': (
        0.5319106355405349, 0.7714813963906229, 0.46146854918824887),
    'freetone:7493': (
        0.66687555436529, 0.848998890233168, 0.4923997710964443),
    'freetone:7492': (
        0.6896293842368799, 0.9015371395393971, 0.39618467440417426),
    'freetone:5743': (
        0.1466987687238408, 0.23823161529770154, 0.06720950111729351),
    'freetone:5753': (
        0.2635981415269786, 0.3982383048641367, 0.11555242836613822),
    'freetone:5763': (
        0.35255385203844725, 0.49606852555255543, 0.20723478288379482),
    'freetone:5773': (
        0.4419482109752999, 0.5984093642839436, 0.3091363264760112),
    'freetone:5783': (
        0.5640875251150135, 0.717062330262479, 0.4456235640503792),
    'freetone:5793': (
        0.6356050624427176, 0.7777142026450203, 0.5257626745934232),
    'freetone:5803': (
        0.7094581326295575, 0.8288738005198173, 0.6090349607209273),
    'freetone:5815': (
        0.2230384612497005, 0.2615049350361325, 0.055556629062564866),
    'freetone:5825': (
        0.4408550230694175, 0.5013857696449264, 0.12894651861515172),
    'freetone:5835': (
        0.5422702706817031, 0.6253309407183121, 0.2503364111851001),
    'freetone:5845': (
        0.6106269635956434, 0.698409773543671, 0.3446675869000302),
    'freetone:5855': (
        0.6840717666532621, 0.7730003672728701, 0.44954758232755765),
    'freetone:5865': (
        0.7422270087487559, 0.8226173570167755, 0.5064711728940572),
    'freetone:5875': (
        0.7798853836200497, 0.8428778019598686, 0.5568198747592762),
    'freetone:5747': (
        0.13737292177358995, 0.2196289746375939, 0.023339479523414752),
    'freetone:5757': (
        0.31246250424705835, 0.44990746854502817, 0.05627024677099257),
    'freetone:5767': (
        0.4454198106444811, 0.5852030081368484, 0.1827377010036102),
    'freetone:5777': (
        0.5484758241369647, 0.7013869562361297, 0.3085362304324928),
    'freetone:5787': (
        0.6574204795289811, 0.8016355545098, 0.4627717398659872),
    'freetone:5797': (
        0.717013523101791, 0.8446259198055563, 0.5409662857595888),
    'freetone:5807': (
        0.7620004590280671, 0.8720643197408207, 0.6082628677863688),
    'freetone:583': (
        0.6402538174464106, 0.8787515693546541, 0.011100664428344953),
    'freetone:582': (
        0.46389175148597905, 0.5880130519930926, 0.0),
    'freetone:581': (
        0.2763674352275789, 0.3301273323739631, 0.02273089591744437),
    'freetone:393': (
        0.8902876377105713, 1.0, 0.35529106855392456),
    'freetone:394': (
        0.8609597980976105, 1.0, 0.1750820279121399),
    'freetone:395': (
        0.848447397351265, 1.0, 0.10952931642532349),
    'freetone:396': (
        0.7985198795795441, 1.0, 0.0),
    'freetone:397': (
        0.6697575280115853, 0.8210635918194719, 0.0),
    'freetone:398': (
        0.5894841509129267, 0.7101360494873976, 0.0),
    'freetone:399': (
        0.5364340599520636, 0.6003262332239929, 0.0),
    'freetone:3935': (
        0.9097276329994202, 0.9910887312144041, 0.2680705189704895),
    'freetone:3945': (
        0.8954451829195023, 0.997985809110105, 0.04080265760421753),
    'freetone:3955': (
        0.8864291525136605, 0.9658249846379346, 0.0),
    'freetone:3965': (
        0.8708353094653175, 0.9555724777457699, 0.0),
    'freetone:3975': (
        0.663708213596665, 0.6890406918888914, 0.0),
    'freetone:3985': (
        0.5041184484712713, 0.5272813505313039, 0.0),
    'freetone:3995': (
        0.2985528919013811, 0.3166367010984894, 0.02816420887178772),
    'freetone:600': (
        0.908781573176384, 0.9763790350407362, 0.5046616494655609),
    'freetone:601': (
        0.901701383292675, 0.9657282382249832, 0.45288777351379395),
    'freetone:602': (
        0.899046316742897, 0.9698176551610231, 0.3752499222755432),
    'freetone:603': (
        0.8880598172545433, 0.9566033445298672, 0.2042878270149231),
    'freetone:604': (
        0.8774046547298074, 0.9303116351234627, 0.10724804014129485),
    'freetone:605': (
        0.8251451528060119, 0.8713988727231268, 0.0),
    'freetone:607': (
        0.8879682645201683, 0.9444876797497272, 0.5027390122413635),
    'freetone:608': (
        0.868314653635025, 0.9388723596930504, 0.42029452323913574),
    'freetone:606': (
        0.7502593431172392, 0.7495895557191257, 0.0),
    'freetone:609': (
        0.8618616709033556, 0.9285964800837994, 0.3637307272647272),
    'freetone:610': (
        0.8291791268469421, 0.8973437377264459, 0.23495818939183757),
    'freetone:611': (
        0.7825726516931044, 0.8571764444066388, 0.08392927047481025),
    'freetone:612': (
        0.7051987624756813, 0.7429337043766546, 0.0),
    'freetone:461': (
        0.8886091411113739, 0.9105821326375008, 0.5030136704444885),
    'freetone:460': (
        0.8627295586767183, 0.8866710211006781, 0.39924763725245893),
    'freetone:459': (
        0.8208627710225962, 0.8477852020298547, 0.2881574463944786),
    'freetone:458': (
        0.8056763179621307, 0.817321762295532, 0.24027342237359361),
    'freetone:457': (
        0.6534804506529615, 0.6221227227881438, 0.01855426226969481),
    'freetone:456': (
        0.5521475067795913, 0.5477140984539339, 0.061211178538266964),
    'freetone:455': (
        0.30442753146698465, 0.3010868826474802, 0.05332795083430142),
    'freetone:614': (
        0.8124801082331765, 0.8797047531397141, 0.5181672875675605),
    'freetone:615': (
        0.7872292676777699, 0.8533233810521033, 0.4689664865565496),
    'freetone:616': (
        0.7623327487544461, 0.826046365990475, 0.4134797775819439),
    'freetone:617': (
        0.6805020581989152, 0.7528009536895606, 0.2805615950125233),
    'freetone:618': (
        0.5960909184214396, 0.6480067171182338, 0.129325996584571),
    'freetone:619': (
        0.5279772160481286, 0.583457231578167, 0.056151576489713584),
    'freetone:620': (
        0.4412900222860716, 0.46822552563602793, 0.0),
    'freetone:7751': (
        0.7309828648632666, 0.7400615987786979, 0.1983108402168443),
    'freetone:7752': (
        0.7652960056270617, 0.7009208703423417, 0.06489502277637493),
    'freetone:7753': (
        0.6996834989398577, 0.6303206579879408, 0.047193374901066676),
    'freetone:7754': (
        0.5437492197034155, 0.4975393561394337, 0.05825408709153823),
    'freetone:7755': (
        0.4409800941644235, 0.43289541941360543, 0.09292976502903194),
    'freetone:7756': (
        0.3397374898511547, 0.36561266819830074, 0.12040930217429491),
    'freetone:7758': (
        0.7724725109829533, 0.8305167157173226, 0.028349295457555712),
    'freetone:723': (
        0.6548374697773309, 0.3419464658439342, 0.03644013371779842),
    'freetone:722': (
        0.7669868083275899, 0.44830187051162484, 0.1981990538969769),
    'freetone:721': (
        0.8618220901722955, 0.5870542699914871, 0.3806797917558029),
    'freetone:720': (
        0.90402639255023, 0.673342668064506, 0.5057076157348503),
    'freetone:719': (
        0.9199893788562873, 0.7446536275964473, 0.6017211423036127),
    'freetone:7512': (
        0.5920121716355862, 0.3164875239542013, 0.016394933315318383),
    'freetone:7511': (
        0.681137926876128, 0.4017375596085211, 0.06439782386373993),
    'freetone:7510': (
        0.7472525448845457, 0.48792727204282094, 0.16832359343729975),
    'freetone:7509': (
        0.8186435455912949, 0.6072317999489412, 0.31763213759758147),
    'freetone:7508': (
        0.8570695214353347, 0.6877781002055157, 0.43515447474091884),
    'freetone:7507': (
        1.0, 0.7843900322914124, 0.5489738583564758),
    'freetone:7506': (
        0.9363088458776474, 0.8472266793251038, 0.6476081609725952),
    'freetone:462': (
        0.2511172585233794, 0.1947952820121941, 0.10925742168028663),
    'freetone:463': (
        0.35800066575954403, 0.22233628888583112, 0.0979850625296379),
    'freetone:464': (
        0.46853064217912976, 0.27229795148214997, 0.0890352748758012),
    'freetone:465': (
        0.678438529172477, 0.5467869134852941, 0.28883550684144055),
    'freetone:466': (
        0.7382967362270547, 0.6432430452537645, 0.40806171535450586),
    'freetone:467': (
        0.792844567878432, 0.7173788485705793, 0.4909523439998005),
    'freetone:468': (
        0.8356375797284619, 0.7902070165354114, 0.5913920719822358),
    'freetone:7505': (
        0.40709070620996357, 0.303744119551979, 0.1892531780768465),
    'freetone:7504': (
        0.4937174755079283, 0.41052920441769203, 0.31590032636133003),
    'freetone:7503': (
        0.5856419775326516, 0.5839354472013394, 0.32936048213621216),
    'freetone:7502': (
        0.770022271542697, 0.7125420811294491, 0.46751717451121566),
    'freetone:7501': (
        0.8129092365467747, 0.7863989038799777, 0.5676288757800421),
    'freetone:7500': (
        0.8439704487744126, 0.8270436623107595, 0.5939911806614718),
    'freetone:7499': (
        0.9212873874071816, 0.9128974879777506, 0.6241018518372794),
    'freetone:448': (
        0.1831377029567811, 0.18682438719806527, 0.09934076036719475),
    'freetone:449': (
        0.213397446473369, 0.20385113131899502, 0.08244415639603986),
    'freetone:450': (
        0.24119845284268138, 0.21978887814540826, 0.07727712023566369),
    'freetone:451': (
        0.5294977975071049, 0.5698079148459243, 0.28240226190115436),
    'freetone:452': (
        0.6212058422317552, 0.6685577719313578, 0.42630655318438215),
    'freetone:453': (
        0.7019256512597305, 0.7488284783551058, 0.5475541521063403),
    'freetone:454': (
        0.7503943813793478, 0.7930579033969098, 0.6102100117101545),
    'freetone:4485': (
        0.2732773195346212, 0.23958685963474657, 0.0799489258593713),
    'freetone:4495': (
        0.45331536879648393, 0.4295945387490434, 0.10063114222983671),
    'freetone:4505': (
        0.5060431425238683, 0.4999318874922416, 0.16767455834305878),
    'freetone:4515': (
        0.6331325055695989, 0.6376761038910195, 0.32987544330281926),
    'freetone:4525': (
        0.7200443638231746, 0.7328984231553237, 0.4463890250690805),
    'freetone:4535': (
        0.765981634819764, 0.7915287155497215, 0.5107485001490052),
    'freetone:4545': (
        0.789942191706726, 0.816012393777129, 0.5635808970309601),
    'freetone:7771': (
        0.19660318162148016, 0.23262867519590813, 0.13077195028202482),
    'freetone:7770': (
        0.2716396492043245, 0.3020677778363847, 0.1396309325127092),
    'freetone:7769': (
        0.3300725677131364, 0.3305005863671564, 0.11852576548477955),
    'freetone:7768': (
        0.45257094597435765, 0.48441726802133367, 0.10236657533171734),
    'freetone:7767': (
        0.5819350857323666, 0.649435040767881, 0.07351996729324739),
    'freetone:7766': (
        0.6260821736156323, 0.7208728473396224, 0.028903762856735682),
    'freetone:7765': (
        0.6546110165203225, 0.778223523375793, 0.037733165537286784),
    'freetone:7764': (
        0.21681947976205684, 0.28568232895696166, 0.12367779636944753),
    'freetone:7763': (
        0.24044118944379989, 0.32731440465751405, 0.148222654479099),
    'freetone:7762': (
        0.2566097084503234, 0.3768738167831618, 0.12286846583890032),
    'freetone:7761': (
        0.3466360859528166, 0.4385893930257563, 0.10096836981894874),
    'freetone:7760': (
        0.47535305311895826, 0.515859564954031, 0.06454441950122813),
    'freetone:7759': (
        0.6988803158804743, 0.754714165647535, 0.0),
    'freetone:724': (
        0.504534147534641, 0.2224099928589851, 0.0),
    'freetone:725': (
        0.3987311357231391, 0.16216207083121503, 0.01367305545642239),
    'freetone:475': (
        0.9558709114789963, 0.7743801027536392, 0.6852369010448456),
    'freetone:474': (
        0.9526632143108734, 0.7266855581195211, 0.6360689525971908),
    'freetone:473': (
        0.9645991274156316, 0.687405151805585, 0.5851382040529387),
    'freetone:472': (
        0.9162300182690684, 0.5514416282073962, 0.39598068957206667),
    'freetone:471': (
        0.7038844976502769, 0.29656636772509515, 0.06362601432556048),
    'freetone:470': (
        0.5907377884717313, 0.2668833667838655, 0.08943354851018981),
    'freetone:469': (
        0.30565723211872786, 0.16274628497193788, 0.0888383651553788),
    'freetone:726': (
        0.8583666382020532, 0.7313032838689065, 0.5874059745847962),
    'freetone:727': (
        0.8308045721722943, 0.6643564330630742, 0.5202948354135084),
    'freetone:728': (
        0.7649964173988311, 0.5838352233715227, 0.4147923706101686),
    'freetone:729': (
        0.6537200729173143, 0.4442774444383186, 0.2537644334244433),
    'freetone:730': (
        0.5504417796962642, 0.32566476804842637, 0.10101605673483505),
    'freetone:731': (
        0.36930979202044245, 0.17614064057343448, 0.0028679842936263356),
    'freetone:732': (
        0.276297752713095, 0.12223205873114651, 0.02253325927616956),
    'freetone:4685': (
        0.8532886882586327, 0.7494582889554097, 0.6571079837395982),
    'freetone:4675': (
        0.8388536325599698, 0.7221552506017678, 0.6293154442967681),
    'freetone:4665': (
        0.7684642016689835, 0.6172142072191225, 0.5043436635462787),
    'freetone:4655': (
        0.701229767600803, 0.5255907236850552, 0.41812052891653195),
    'freetone:4645': (
        0.6182047223019662, 0.4191121901962971, 0.29811973014727045),
    'freetone:4625': (
        0.1967698063916714, 0.09254928884917035, 0.08021839348018034),
    'freetone:7513': (
        0.8693371883480272, 0.6632185363100424, 0.6568588952734411),
    'freetone:7514': (
        0.82234453329976, 0.5784680310523393, 0.5131108840074614),
    'freetone:7515': (
        0.7443439336092306, 0.4832623158496161, 0.3741177687190378),
    'freetone:7516': (
        0.5355916766541364, 0.24690487243932147, 0.10694725397904925),
    'freetone:7518': (
        0.3226370412827606, 0.2235300300189067, 0.24228677336640203),
    'freetone:7517': (
        0.4497616749917732, 0.1710161499871532, 0.04480035786013303),
    'freetone:7519': (
        0.25693404666338715, 0.21766335316919694, 0.1820438656020933),
    'freetone:4745': (
        0.7675282813348834, 0.6784512291022495, 0.6581998195833564),
    'freetone:4755': (
        0.822658393174047, 0.737973185973086, 0.7178839579920449),
    'freetone:4735': (
        0.7052478540516749, 0.5898671529001076, 0.5628004922618512),
    'freetone:4725': (
        0.6214974298077633, 0.4714396081137129, 0.45697093424987134),
    'freetone:4715': (
        0.511622203525306, 0.338389120079583, 0.31838648514735723),
    'freetone:4705': (
        0.402811176637929, 0.20884936157825607, 0.19575938817002125),
    'freetone:4695': (
        0.2463775168276463, 0.11575884257394264, 0.11864256344848556),
    'freetone:482': (
        0.8390782473399381, 0.7601435529753974, 0.7109367330777014),
    'freetone:481': (
        0.8000181147833949, 0.6990348068853439, 0.6494413792193338),
    'freetone:480': (
        0.7412415951706828, 0.6158986367873593, 0.557465744495377),
    'freetone:479': (
        0.609193897882164, 0.42974766352646254, 0.36996160986827586),
    'freetone:478': (
        0.35379872508333143, 0.15027582319916633, 0.12501216083417432),
    'freetone:477': (
        0.28217872442968606, 0.14134341822551733, 0.12782711374794076),
    'freetone:476': (
        0.19781840230008108, 0.12855744327990948, 0.11540081412009329),
    'freetone:7527': (
        0.8027332051118252, 0.8371039314280048, 0.7547831578891255),
    'freetone:7528': (
        0.722404258003198, 0.7226368426021597, 0.6645770461402691),
    'freetone:7529': (
        0.6487723770637421, 0.6506371840363645, 0.5777148300041679),
    'freetone:7530': (
        0.561434615685608, 0.5519783801312239, 0.4844191638161872),
    'freetone:7531': (
        0.37652797547501393, 0.34385434664218906, 0.28418053354019435),
    'freetone:7532': (
        0.2790283221607952, 0.2441196771903389, 0.1799430949589702),
    'freetone:7533': (
        0.16662061993049093, 0.13937670642373945, 0.10612918297331575),
    'freetone:7534': (
        0.7772332645721381, 0.8158134698791863, 0.7232510353638533),
    'freetone:7535': (
        0.6507594532969172, 0.7015397115376043, 0.5840302214240563),
    'freetone:439': (
        0.15463167426998936, 0.1392530298620187, 0.1633802623168812),
    'freetone:438': (
        0.2268706154323965, 0.19753989753825607, 0.2359222334025617),
    'freetone:437': (
        0.37494267880778587, 0.3358370850316561, 0.4119048007228976),
    'freetone:436': (
        0.5925256128279024, 0.5710243974574043, 0.6423455073602744),
    'freetone:435': (
        0.6983517197003328, 0.6919503575495021, 0.743102599140857),
    'freetone:434': (
        0.7751257496305971, 0.7677085616285463, 0.7999297761993612),
    'freetone:412': (
        0.11983706371107417, 0.1185627009131629, 0.13041616178055548),
    'freetone:411': (
        0.26155193470748017, 0.2477254216582736, 0.26458664877668525),
    'freetone:410': (
        0.3492923484574373, 0.3462575290438119, 0.34779491403179374),
    'freetone:409': (
        0.427488810468617, 0.425524979734746, 0.43746785361008733),
    'freetone:408': (
        0.5077032566378108, 0.5157646461471685, 0.5165985949065544),
    'freetone:407': (
        0.626518180722061, 0.6448378274811184, 0.6316364725604562),
    'freetone:406': (
        0.7215153693803755, 0.7313161289357346, 0.715353204959352),
    'freetone:405': (
        0.29818448861524693, 0.3294338115170783, 0.2964988674332645),
    'freetone:404': (
        0.3591719255939152, 0.3914882959620014, 0.34647544997622237),
    'freetone:403': (
        0.45281167747724993, 0.4889537935564121, 0.45001856935150286),
    'freetone:402': (
        0.5371994879615367, 0.5729700065763028, 0.5302339280554462),
    'freetone:401': (
        0.6180524983626747, 0.6658009781360068, 0.6090523469560782),
    'freetone:400': (
        0.716042392933891, 0.75615903363417, 0.7060795596327804),
    'freetone:419': (
        0.05522178553678714, 0.08096575177926724, 0.08873163301444364),
    'freetone:418': (
        0.21312287122762896, 0.2779817325007894, 0.22983005662725375),
    'freetone:417': (
        0.28982529406204094, 0.3716393449148967, 0.31339221914433324),
    'freetone:416': (
        0.3942971383358471, 0.4868752553722926, 0.4103657703239585),
    'freetone:415': (
        0.478720646452766, 0.5762100508090917, 0.5054343564243968),
    'freetone:414': (
        0.5917937298394855, 0.6725752839912951, 0.604695190348483),
    'freetone:413': (
        0.6699442668570175, 0.7489264863300349, 0.6764407821547831),
    'freetone:447': (
        0.11900525143460072, 0.1647398573720693, 0.15366642698040778),
    'freetone:446': (
        0.14221315919792232, 0.22125168228481584, 0.2080434491121821),
    'freetone:445': (
        0.20510839727666408, 0.3107468167466205, 0.30486942212546),
    'freetone:444': (
        0.33998461173195604, 0.491665743100167, 0.46400630620123673),
    'freetone:443': (
        0.4821681571658243, 0.6503505151099049, 0.6114621687828947),
    'freetone:442': (
        0.5518031951865998, 0.7202503367973168, 0.6628777350825059),
    'freetone:441': (
        0.6839475439120114, 0.8262729005412858, 0.7650741980451395),
    'freetone:426': (
        0.06577713936272289, 0.10056065997574137, 0.11868222283433738),
    'freetone:425': (
        0.22569952601711663, 0.2995221677929294, 0.31773970320483613),
    'freetone:424': (
        0.33562264869617664, 0.42500064356011613, 0.4188358579197482),
    'freetone:423': (
        0.4465017885635767, 0.5455951130860406, 0.5455692540543744),
    'freetone:422': (
        0.5481138794128204, 0.6466879623019506, 0.6390816851216452),
    'freetone:421': (
        0.6335999070354585, 0.7272255669324219, 0.7056645286442693),
    'freetone:420': (
        0.7407828512130734, 0.8054093565417331, 0.7953302759511081),
    'freetone:433': (
        0.04384290349806008, 0.09135549668987153, 0.13567783441889247),
    'freetone:432': (
        0.10602871555566473, 0.19478022930724848, 0.2563568467658177),
    'freetone:431': (
        0.26048697541899735, 0.38394356256416984, 0.4351212940319691),
    'freetone:430': (
        0.3933131474947018, 0.5353069999526592, 0.5547970946895404),
    'freetone:429': (
        0.5680037900441204, 0.6905496574822045, 0.6914409910277008),
    'freetone:428': (
        0.7137612303916482, 0.8048988924387059, 0.8043268297287882),
    'freetone:427': (
        0.7733614710725512, 0.8527024112646755, 0.8384149561226497),
    'freetone:7540': (
        0.18837495696301865, 0.2637668040825698, 0.3029715880259829),
    'freetone:7539': (
        0.4672580642489379, 0.5549517920614306, 0.5160597523076547),
    'freetone:7538': (
        0.49509558898299844, 0.6285175184877545, 0.5411181517728778),
    'freetone:7537': (
        0.5851833877634349, 0.700204204505269, 0.6083073143721078),
    'freetone:7536': (
        0.577777439877611, 0.6258883587056481, 0.49484158294290026),
    'freetone:440': (
        0.11687387776188984, 0.11571598259630633, 0.12727655524869164),
    'freetone:Warm Gray 1': (
        0.806349498702925, 0.8310122141451506, 0.7919452651822179),
    'freetone:Warm Gray 2': (
        0.7538983667856702, 0.7719053761001651, 0.7349091574915778),
    'freetone:Warm Gray 3': (
        0.6945928140664581, 0.7245363106077013, 0.6853973682889924),
    'freetone:Warm Gray 4': (
        0.6463569781634488, 0.679746844417878, 0.6430321942290802),
    'freetone:Warm Gray 5': (
        0.6044820265035935, 0.6202219635439066, 0.5872638999340474),
    'freetone:Warm Gray 6': (
        0.5766334246541049, 0.5942949241997564, 0.5734344570724748),
    'freetone:Warm Gray 7': (
        0.49784033162192287, 0.5173610288757793, 0.4897025474070853),
    'freetone:Warm Gray 8': (
        0.4557370775658427, 0.47608792348252393, 0.448373599714472),
    'freetone:Warm Gray 9': (
        0.4199227564675967, 0.42558476694328107, 0.4097670294185507),
    'freetone:Warm Gray 10': (
        0.37554024157643084, 0.38343709320920993, 0.364564232693283),
    'freetone:Warm Gray 11': (
        0.32468844943039077, 0.3283900003941227, 0.3051892225663604),
    'freetone:Cool Gray 1': (
        0.8206746731234269, 0.8704909615124824, 0.8490845722678901),
    'freetone:Cool Gray 2': (
        0.7781123344433939, 0.8328208810256879, 0.813585041617923),
    'freetone:Cool Gray 3': (
        0.7407828512130734, 0.8054093565417331, 0.7953302759511081),
    'freetone:Cool Gray 4': (
        0.6770456572664922, 0.7518614035810575, 0.7409120316312553),
    'freetone:Cool Gray 5': (
        0.6369739009349112, 0.7132044250248981, 0.7053866607322035),
    'freetone:Cool Gray 6': (
        0.5873988783252242, 0.6700149701708622, 0.674252412060955),
    'freetone:Cool Gray 7': (
        0.518462233455006, 0.6028734969003526, 0.6099259215395261),
    'freetone:Cool Gray 8': (
        0.447567552245109, 0.5383671099671821, 0.5561181586666137),
    'freetone:Cool Gray 9': (
        0.3619530791854517, 0.44782846553157984, 0.4708398252522188),
    'freetone:Cool Gray 10': (
        0.2848837920003362, 0.3633528114945328, 0.3999358413868084),
    'freetone:Cool Gray 11': (
        0.22433579546533977, 0.2935711569577357, 0.328743119300416),
    'freetone:Black 2': (
        0.10348346820581611, 0.11879564608801019, 0.07521953643632173),
    'freetone:Black 3': (
        0.05823217931288838, 0.09851697642595525, 0.07967114371133732),
    'freetone:Black 5': (
        0.13774886512861428, 0.09984110969153193, 0.15545986529878775),
    'freetone:Black 4': (
        0.09300062495459827, 0.08471644895869446, 0.0710427187608289),
    'freetone:Black 6': (
        0.0159414806715219, 0.05244731493423416, 0.09780345922226985),
    'freetone:Black 7': (
        0.13399099210666066, 0.15766597501784219, 0.1538316032998921),
    'freetone:1905': (
        1.0, 0.4762645959854126, 0.9378957822918892),
}


if __name__ == '__main__':
    import doctest
    doctest.testmod(optionflags=doctest.NORMALIZE_WHITESPACE)
