# MCSimPython

[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)    

Vessel simulator used in master project and master thesis of M. Kongshaug, H. Mo and J. Hygen. The project is developed at Norwegian University of Science and Technology, Institue of Marine Technology. 

The python package is not complete and there is no guarantee for the validity of the vessel models.

The complete documentation can be found at: https://wave-model.readthedocs.io/en/latest/index.html

## How to use MCSimPython

### PyPi
The `MCSimPython` package can be installed from PyPi using `pip`:

`pip install MCSimPython`

### From GitHub:
Install from GitHub in the following way when developing the package.
- Clone the GitHub repository to your local computer.
- Create a virtual environment `py -m venv name-of-venv`
- Activate virtual environment `name-of-venv\scripts\activate`
- Update pip and setuptools: `py -m pip install --upgrade pip setuptools`
- Install the python package locally as an editable: `pip install -e .`
- Verify that the python package `MCSimPython` has been installed properly by running a demo script, or simply
```
(venv) C:\path\to\dir> python
>>> import MCSimPython
>>>
```

## Structure
All code implementation is found in the `src` directory. The python package is structured as follows:

- `src/MCSimPython/simulator/` Simulation Models. *Python Path*:= `MCSimPython.simulator`
    - `csad.py`: Simulation models for C/S Arctic Drillship
    - `gunnerus.py`: Simulation models for R/V Gunnerus
- `src/MCSimPython/waves/` Wave kinematics, wave spectra, and wave loads. *Python Path* := `MCSimPython.waves`
- `src/MCSimPython/guidance/` Reference Models. *Python path*:= `MCSimPython.guidance` *(in development)*
    - `filter.py`: A third order reference filter.
    - `path_param`: Waypoint path parameterization.
- `src/MCSimPython/observers/` Observers : `MCSimPython.observer` *(in development)*
    - `nonlinobs.py`: Nonlinear observers *(only 3DOF nonlinobs w/ wavefiltering atm)*
- `src/MCSimPython/control` Controllers : `MCSimPython.control` *(in development)*
    - `basic.py`: Simple PD and PID controllers
    - `backstepping.py`: A simple backstepping controller (no bias compensation).


## Demos

Demonstration of how the individual components of the python package can be used is given in `demos`. Some demos of combination of the different components are also given here. 

## Visualization

### RVG 6DOF model in beam sea
![6DOF RVG 2D Visualization](https://github.com/janerikhy/Wave-Model/blob/main/demos/animations/wave_motion1d.gif)

### RVG 6DOF model in multidirectional sea
![6DOF RVG 3D Visualization](https://github.com/janerikhy/Wave-Model/blob/main/demos/animations/vessel_motion3d__rvg2.gif)


### CSAD 6DOF model in multidirectional sea
![6DOF CSAD 2D Visualisation](https://github.com/janerikhy/Wave-Model/blob/main/demos/animations/vessel_motion3d_22.gif)

