% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.interprete.R
\name{lgb.interprete}
\alias{lgb.interprete}
\title{Compute feature contribution of prediction}
\usage{
lgb.interprete(model, data, idxset, num_iteration = NULL)
}
\arguments{
\item{model}{object of class \code{lgb.Booster}.}

\item{data}{a matrix object or a dgCMatrix object.}

\item{idxset}{a integer vector of indices of rows needed.}

\item{num_iteration}{number of iteration want to predict with, NULL or <= 0 means use best iteration.}
}
\value{
For regression, binary classification and lambdarank model, a \code{list} of \code{data.table} with the following columns:
\itemize{
  \item \code{Feature} Feature names in the model.
  \item \code{Contribution} The total contribution of this feature's splits.
}
For multiclass classification, a \code{list} of \code{data.table} with the Feature column and Contribution columns to each class.
}
\description{
Computes feature contribution components of rawscore prediction.
}
\examples{
Sigmoid <- function(x) 1 / (1 + exp(-x))
Logit <- function(x) log(x / (1 - x))
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)
setinfo(dtrain, "init_score", rep(Logit(mean(train$label)), length(train$label)))
data(agaricus.test, package = "lightgbm")
test <- agaricus.test

params <- list(
    objective = "binary"
    , learning_rate = 0.01
    , num_leaves = 63
    , max_depth = -1
    , min_data_in_leaf = 1
    , min_sum_hessian_in_leaf = 1
)
model <- lgb.train(params, dtrain, 20)

tree_interpretation <- lgb.interprete(model, test$data, 1:5)

}
