#ifndef __PROBADJUSTPOSTPROCESSOR_H__
#define __PROBADJUSTPOSTPROCESSOR_H__

#include <MedAlgo/MedAlgo/MedAlgo.h>
#include "PostProcessor.h"
#include <Logger/Logger/Logger.h>

// A post-processor to adjust probability to fit given priors.
// Priors are determined according to INTEGER features generated by a model (according to priorsJson)
// the odds of the intial predictor can be learned or externally supplied, and is used in the Bayesian adjustment

class ProbAdjustPostProcessor : public PostProcessor {
public:
	vector<string> names;
	vector<string> resolvedNames;
	vector<int> min, max, factors;
	vector<float> probs;
	vector<float> odds ; ///< over all odds. learn if not given
	MedModel *priorsModel; ///< model for generating features for priors
	MedPidRepository *p_rep; ///< required for building priors matrix
	bool model_initiated = false;

	/// Parameters
	string priorsFile;
	string priorsJson;

	int inherited_verbosity = 0; // for priorsModel
	// Functions
	ProbAdjustPostProcessor() { processor_type = PostProcessorTypes::FTR_POSTPROCESS_ADJUST; };
	~ProbAdjustPostProcessor() { delete priorsModel; };
	void init_post_processor(MedModel& mdl) { p_rep = mdl.p_rep; inherited_verbosity = mdl.verbosity; }

	void get_input_fields(vector<Effected_Field> &fields) const;
	void get_output_fields(vector<Effected_Field> &fields) const;

	/// Global init for general args in all explainers
	int init(map<string, string> &mapper);

	///Learns from predictor and train_matrix (PostProcessor API)
	void Learn(const MedFeatures &matrix);
	void Apply(MedFeatures &matrix);

	// Helper functions
	void readPriors();
	void getOdds(const MedFeatures &matrix);

	void set_model_initiated(bool val) { model_initiated = val; }

	ADD_CLASS_NAME(ProbAdjustPostProcessor)
	ADD_SERIALIZATION_FUNCS(processor_type, names,resolvedNames,min,max,factors,probs, priorsFile, odds, priorsModel, priorsJson)
};

MEDSERIALIZE_SUPPORT(ProbAdjustPostProcessor)

#endif