% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.plot.importance.R
\name{lgb.plot.importance}
\alias{lgb.plot.importance}
\title{Plot feature importance as a bar graph}
\usage{
lgb.plot.importance(tree_imp, top_n = 10, measure = "Gain",
  left_margin = 10, cex = NULL)
}
\arguments{
\item{tree_imp}{a \code{data.table} returned by \code{\link{lgb.importance}}.}

\item{top_n}{maximal number of top features to include into the plot.}

\item{measure}{the name of importance measure to plot, can be "Gain", "Cover" or "Frequency".}

\item{left_margin}{(base R barplot) allows to adjust the left margin size to fit feature names.}

\item{cex}{(base R barplot) passed as \code{cex.names} parameter to \code{barplot}.}
}
\value{
The \code{lgb.plot.importance} function creates a \code{barplot}
and silently returns a processed data.table with \code{top_n} features sorted by defined importance.
}
\description{
Plot previously calculated feature importance: Gain, Cover and Frequency, as a bar graph.
}
\details{
The graph represents each feature as a horizontal bar of length proportional to the defined importance of a feature.
Features are shown ranked in a decreasing importance order.
}
\examples{
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)

params <- list(
    objective = "binary"
    , learning_rate = 0.01
    , num_leaves = 63
    , max_depth = -1
    , min_data_in_leaf = 1
    , min_sum_hessian_in_leaf = 1
)

model <- lgb.train(params, dtrain, 20)

tree_imp <- lgb.importance(model, percentage = TRUE)
lgb.plot.importance(tree_imp, top_n = 10, measure = "Gain")
}
