% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.Dataset.R
\name{lgb.Dataset.set.reference}
\alias{lgb.Dataset.set.reference}
\title{Set reference of \code{lgb.Dataset}}
\usage{
lgb.Dataset.set.reference(dataset, reference)
}
\arguments{
\item{dataset}{object of class \code{lgb.Dataset}}

\item{reference}{object of class \code{lgb.Dataset}}
}
\value{
passed dataset
}
\description{
If you want to use validation data, you should set reference to training data
}
\examples{
library(lightgbm)
data(agaricus.train, package ="lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)
data(agaricus.test, package = "lightgbm")
test <- agaricus.test
dtest <- lgb.Dataset(test$data, test = train$label)
lgb.Dataset.set.reference(dtest, dtrain)

}
