% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readRDS.lgb.Booster.R
\name{readRDS.lgb.Booster}
\alias{readRDS.lgb.Booster}
\title{readRDS for lgb.Booster models}
\usage{
readRDS.lgb.Booster(file = "", refhook = NULL)
}
\arguments{
\item{file}{a connection or the name of the file where the R object is saved to or read from.}

\item{refhook}{a hook function for handling reference objects.}
}
\value{
lgb.Booster.
}
\description{
Attempts to load a model using RDS.
}
\examples{
library(lightgbm)
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)
data(agaricus.test, package = "lightgbm")
test <- agaricus.test
dtest <- lgb.Dataset.create.valid(dtrain, test$data, label = test$label)
params <- list(objective = "regression", metric = "l2")
valids <- list(test = dtest)
model <- lgb.train(params,
                   dtrain,
                   100,
                   valids,
                   min_data = 1,
                   learning_rate = 1,
                   early_stopping_rounds = 10)
saveRDS.lgb.Booster(model, "model.rds")
new_model <- readRDS.lgb.Booster("model.rds")

}
