# metafab_python
 Complete MetaFab API references and guides can be found at: https://trymetafab.com

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://trymetafab.com](https://trymetafab.com)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import metafab_python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import metafab_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import metafab_python
from pprint import pprint
from metafab_python.api import contracts_api
from metafab_python.model.contract_model import ContractModel
from metafab_python.model.create_contract_request import CreateContractRequest
from metafab_python.model.transaction_model import TransactionModel
from metafab_python.model.write_contract_request import WriteContractRequest
# Defining the host is optional and defaults to https://api.trymetafab.com
# See configuration.py for a list of all supported configuration parameters.
configuration = metafab_python.Configuration(
    host = "https://api.trymetafab.com"
)



# Enter a context with an instance of the API client
with metafab_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = contracts_api.ContractsApi(api_client)
    x_authorization = "game_sk_02z4Mv3c85Ig0gNowY9Dq0N2kjb1xwzr27ArLE0669RrRI6dLf822iPO26K1p1FP" # str | The `secretKey` of the authenticating game.
    create_contract_request = CreateContractRequest(
        address="address_example",
        abi="abi_example",
        chain="MATIC",
    ) # CreateContractRequest | 

    try:
        # Create custom contract
        api_response = api_instance.create_contract(x_authorization, create_contract_request)
        pprint(api_response)
    except metafab_python.ApiException as e:
        print("Exception when calling ContractsApi->create_contract: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.trymetafab.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContractsApi* | [**create_contract**](docs/ContractsApi.md#create_contract) | **POST** /v1/contracts | Create custom contract
*ContractsApi* | [**get_contracts**](docs/ContractsApi.md#get_contracts) | **GET** /v1/contracts | Get contracts
*ContractsApi* | [**read_contract**](docs/ContractsApi.md#read_contract) | **GET** /v1/contracts/{contractId}/reads | Read contract data
*ContractsApi* | [**write_contract**](docs/ContractsApi.md#write_contract) | **POST** /v1/contracts/{contractId}/writes | Write contract data
*CurrenciesApi* | [**batch_transfer_currency**](docs/CurrenciesApi.md#batch_transfer_currency) | **POST** /v1/currencies/{currencyId}/batchTransfers | Batch transfer currency
*CurrenciesApi* | [**burn_currency**](docs/CurrenciesApi.md#burn_currency) | **POST** /v1/currencies/{currencyId}/burns | Burn currency
*CurrenciesApi* | [**create_currency**](docs/CurrenciesApi.md#create_currency) | **POST** /v1/currencies | Create currency
*CurrenciesApi* | [**get_currencies**](docs/CurrenciesApi.md#get_currencies) | **GET** /v1/currencies | Get currencies
*CurrenciesApi* | [**get_currency_balances**](docs/CurrenciesApi.md#get_currency_balances) | **GET** /v1/currencies/{currencyId}/balances | Get currency balance
*CurrenciesApi* | [**get_currency_fees**](docs/CurrenciesApi.md#get_currency_fees) | **GET** /v1/currencies/{currencyId}/fees | Get currency fees
*CurrenciesApi* | [**mint_currency**](docs/CurrenciesApi.md#mint_currency) | **POST** /v1/currencies/{currencyId}/mints | Mint currency
*CurrenciesApi* | [**set_currency_fees**](docs/CurrenciesApi.md#set_currency_fees) | **POST** /v1/currencies/{currencyId}/fees | Set currency fees
*CurrenciesApi* | [**transfer_currency**](docs/CurrenciesApi.md#transfer_currency) | **POST** /v1/currencies/{currencyId}/transfers | Transfer currency
*GamesApi* | [**auth_game**](docs/GamesApi.md#auth_game) | **GET** /v1/games | Authenticate game
*GamesApi* | [**create_game**](docs/GamesApi.md#create_game) | **POST** /v1/games | Create game
*GamesApi* | [**update_game**](docs/GamesApi.md#update_game) | **PATCH** /v1/games/{gameId} | Update game
*PlayersApi* | [**auth_player**](docs/PlayersApi.md#auth_player) | **GET** /v1/players | Authenticate player
*PlayersApi* | [**create_player**](docs/PlayersApi.md#create_player) | **POST** /v1/players | Create player
*PlayersApi* | [**update_player**](docs/PlayersApi.md#update_player) | **PATCH** /v1/players/{playerId} | Update player
*TransactionsApi* | [**get_transaction**](docs/TransactionsApi.md#get_transaction) | **GET** /v1/transactions/{transactionId} | Get transaction
*WalletsApi* | [**get_wallet_balances**](docs/WalletsApi.md#get_wallet_balances) | **GET** /v1/wallets/{walletId}/balances | Get wallet balances
*WalletsApi* | [**get_wallet_transactions**](docs/WalletsApi.md#get_wallet_transactions) | **GET** /v1/wallets/{walletId}/transactions | Get wallet transactions


## Documentation For Models

 - [AuthGame200Response](docs/AuthGame200Response.md)
 - [AuthGame200ResponseAllOf](docs/AuthGame200ResponseAllOf.md)
 - [AuthGame200ResponseAllOf1](docs/AuthGame200ResponseAllOf1.md)
 - [AuthPlayer200Response](docs/AuthPlayer200Response.md)
 - [BatchTransferCurrencyRequest](docs/BatchTransferCurrencyRequest.md)
 - [BurnCurrencyRequest](docs/BurnCurrencyRequest.md)
 - [ContractModel](docs/ContractModel.md)
 - [CreateContractRequest](docs/CreateContractRequest.md)
 - [CreateCurrency200Response](docs/CreateCurrency200Response.md)
 - [CreateCurrency200ResponseAllOf](docs/CreateCurrency200ResponseAllOf.md)
 - [CreateCurrency200ResponseAllOfContract](docs/CreateCurrency200ResponseAllOfContract.md)
 - [CreateCurrency200ResponseAllOfContractAllOf](docs/CreateCurrency200ResponseAllOfContractAllOf.md)
 - [CreateCurrencyRequest](docs/CreateCurrencyRequest.md)
 - [CreateGameRequest](docs/CreateGameRequest.md)
 - [CreatePlayerRequest](docs/CreatePlayerRequest.md)
 - [CurrencyModel](docs/CurrencyModel.md)
 - [GameModel](docs/GameModel.md)
 - [GetCurrencies200ResponseInner](docs/GetCurrencies200ResponseInner.md)
 - [GetCurrencies200ResponseInnerAllOf](docs/GetCurrencies200ResponseInnerAllOf.md)
 - [GetCurrencyFees200Response](docs/GetCurrencyFees200Response.md)
 - [MintCurrencyRequest](docs/MintCurrencyRequest.md)
 - [PlayerModel](docs/PlayerModel.md)
 - [SetCurrencyFeesRequest](docs/SetCurrencyFeesRequest.md)
 - [TransactionModel](docs/TransactionModel.md)
 - [TransferCurrencyRequest](docs/TransferCurrencyRequest.md)
 - [UpdateGameRequest](docs/UpdateGameRequest.md)
 - [UpdatePlayerRequest](docs/UpdatePlayerRequest.md)
 - [WalletModel](docs/WalletModel.md)
 - [WriteContractRequest](docs/WriteContractRequest.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## Author

metafabproject@gmail.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in metafab_python.apis and metafab_python.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from metafab_python.api.default_api import DefaultApi`
- `from metafab_python.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import metafab_python
from metafab_python.apis import *
from metafab_python.models import *
```

